<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="no"/>
	<xsl:template match="/">
		<html>
		<head>
			<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
			<title></title>
		</head>
		<body>
		
		<xsl:for-each select="Obiekty/Dane/Osoba">
			<h3>Osoba: <xsl:value-of select="Pesel"/></h3>
			Kod systemu: <xsl:value-of select="KodSystemu"/><br/>
			IdWSystDziedzinowym: <xsl:value-of select="IdWSystDziedzinowym"/><br/>
			Nazwisko: <xsl:value-of select="Nazwisko"/><br/>
			ImiePierwsze: <xsl:value-of select="ImiePierwsze"/><br/>
			ImieDrugie: <xsl:value-of select="ImieDrugie"/><br/>
			Pesel: <xsl:value-of select="Pesel"/><br/>
			Nip: <xsl:value-of select="Nip"/><br/>
			NazwiskoRodowe: <xsl:value-of select="NazwiskoRodowe"/><br/>
			ImieOjca: <xsl:value-of select="ImieOjca"/><br/>
			ImieMatki: <xsl:value-of select="ImieMatki"/><br/>
			DataUrodzenia: <xsl:value-of select="DataUrodzenia"/><br/>
			DataZgonu: <xsl:value-of select="DataZgonu"/><br/>
			MiejsceUrodzenia: <xsl:value-of select="MiejsceUrodzenia"/><br/>
			RodzajDokumentuTozsamosci: <xsl:value-of select="RodzajDokumentuTozsamosci"/><br/>
			NumerDokumentuTozsamosci: <xsl:value-of select="NumerDokumentuTozsamosci"/><br/>
			NrTelefonu: <xsl:value-of select="NrTelefonu"/><br/>
			DataAktywnosciDo: <xsl:value-of select="DataAktywnosciDo"/><br/>
			Plec: <xsl:value-of select="Plec"/><br/>
			StanCywilny: <xsl:value-of select="StanCywilny"/><br/>
			Bezdomny: <xsl:value-of select="Bezdomny"/><br/>
			Niepelnosprawnosc: <xsl:value-of select="Niepelnosprawnosc"/><br/>
			Email: <xsl:value-of select="Email"/><br/>
			MiejsceZgonu: <xsl:value-of select="MiejsceZgonu"/><br/>
			NrKonta: <xsl:value-of select="NrKonta"/><br/>
			FormaPlatnosci: <xsl:value-of select="FormaPlatnosci"/><br/>
			<br/>
		
			Adres:	
			<table border="1">
			  <tr>
				<th>RodzajAdresu</th>
				<th>Wojewodztwo</th>
				<th>Powiat</th>
				<th>Gmina</th>
				<th>Poczta</th>
				<th>KodPocztowy</th>
				<th>Miejscowosc</th>
				<th>Ulica</th>
				<th>NrDomu</th>
				<th>NrLokalu</th>
				<th>Kraj</th>
				<th>KodWojewodztwa</th>
				<th>KodPowiatu</th>
				<th>KodGminy</th>
				<th>KodMiejscowosci</th>
				<th>Od</th>
				<th>Do</th>
			  </tr>
			  <xsl:for-each select="Adres">
			  <tr>
				<td><xsl:value-of select="RodzajAdresu"/></td>
				<td><xsl:value-of select="Wojewodztwo"/></td>
				<td><xsl:value-of select="Powiat"/></td>
				<td><xsl:value-of select="Gmina"/></td>
				<td><xsl:value-of select="Poczta"/></td>
				<td><xsl:value-of select="KodPocztowy"/></td>
				<td><xsl:value-of select="Miejscowosc"/></td>
				<td><xsl:value-of select="Ulica"/></td>
				<td><xsl:value-of select="NrDomu"/></td>
				<td><xsl:value-of select="NrLokalu"/></td>
				<td><xsl:value-of select="Kraj"/></td>
				<td><xsl:value-of select="KodWojewodztwa"/></td>
				<td><xsl:value-of select="KodPowiatu"/></td>
				<td><xsl:value-of select="KodGminy"/></td>
				<td><xsl:value-of select="KodMiejscowosci"/></td>
				<td><xsl:value-of select="Od"/></td>
				<td><xsl:value-of select="Do"/></td>
			  </tr>
			  </xsl:for-each>
			</table>
			<br/>
			
			CzlonekRodziny:	
			<table border="1">
			  <tr>
				<th>Nazwisko</th>
				<th>Imie</th>
				<th>StopienPokrewienstwa</th>
				<th>Imie2</th>
				<th>NazwiskoRodowe</th>
				<th>DataUrodzenia</th>
				<th>Pesel</th>
				<th>StopienNiepelnospr</th>
				<th>ZgloszonyDoUbezp</th>
				<th>DataZglDoUbezp</th>
			  </tr>
			  <xsl:for-each select="CzlonekRodziny">
			  <tr>
				<td><xsl:value-of select="Nazwisko"/></td>
				<td><xsl:value-of select="Imie"/></td>
				<td><xsl:value-of select="StopienPokrewienstwa"/></td>
				<td><xsl:value-of select="Imie2"/></td>
				<td><xsl:value-of select="NazwiskoRodowe"/></td>
				<td><xsl:value-of select="DataUrodzenia"/></td>
				<td><xsl:value-of select="Pesel"/></td>
				<td>
					<table border="1">
						<tr>
							<th>Opis</th>
							<th>DataPocz</th>
							<th>DataKonc</th>
						</tr>
						<xsl:for-each select="StopienNiepelnospr">
							<tr>
								<td><xsl:value-of select="Opis"/></td>
								<td><xsl:value-of select="DataPocz"/></td>
								<td><xsl:value-of select="DataKonc"/></td>
							</tr>
						</xsl:for-each>
					</table>
				</td>
				<td><xsl:value-of select="ZgloszonyDoUbezp"/></td>
				<td><xsl:value-of select="DataZglDoUbezp"/></td>
			  </tr>
			  </xsl:for-each>
			</table>
			<br/>
			
			Wywiad:	
			<table border="1">
				<tr>
					<th>DataWywiadu</th>
					<th>DochodDataPocz</th>
					<th>DochodDataKonc</th>
					<th>DochodBrutto</th>
					<th>DochodNetto</th>
					<th>CzlonekRodziny</th>
					<th>Dysfunkcja</th>
				</tr>
				<xsl:for-each select="Wywiad">
					<tr>
						<td><xsl:value-of select="DataWywiadu"/></td>
						<td><xsl:value-of select="DochodDataPocz"/></td>
						<td><xsl:value-of select="DochodDataKonc"/></td>
						<td><xsl:value-of select="DochodBrutto"/></td>
						<td><xsl:value-of select="DochodNetto"/></td>
						<td>
							<table border="1">
							  <tr>
								<th>Nazwisko</th>
								<th>Imie</th>
								<th>StopienPokrewienstwa</th>
								<th>Imie2</th>
								<th>NazwiskoRodowe</th>
								<th>DataUrodzenia</th>
								<th>Pesel</th>
								<th>StopienNiepelnospr</th>
								<th>ZgloszonyDoUbezp</th>
								<th>DataZglDoUbezp</th>
							  </tr>
							  <xsl:for-each select="CzlonekRodziny">
							  <tr>
								<td><xsl:value-of select="Nazwisko"/></td>
								<td><xsl:value-of select="Imie"/></td>
								<td><xsl:value-of select="StopienPokrewienstwa"/></td>
								<td><xsl:value-of select="Imie2"/></td>
								<td><xsl:value-of select="NazwiskoRodowe"/></td>
								<td><xsl:value-of select="DataUrodzenia"/></td>
								<td><xsl:value-of select="Pesel"/></td>
								<td>
									<table border="1">
										<tr>
											<th>Opis</th>
											<th>DataPocz</th>
											<th>DataKonc</th>
										</tr>
										<xsl:for-each select="StopienNiepelnospr">
											<tr>
												<td><xsl:value-of select="Opis"/></td>
												<td><xsl:value-of select="DataPocz"/></td>
												<td><xsl:value-of select="DataKonc"/></td>
											</tr>
										</xsl:for-each>
									</table>
								</td>
								<td><xsl:value-of select="ZgloszonyDoUbezp"/></td>
								<td><xsl:value-of select="DataZglDoUbezp"/></td>
							  </tr>
							  </xsl:for-each>
							</table>
						</td>
						<td>
							<table border="1">
								<tr>
									<th>DataPocz</th>
									<th>DataKonc</th>
									<th>RodzajDysfunkcji</th>
								</tr>
								<xsl:for-each select="Dysfunkcja">
									<tr>
										<td><xsl:value-of select="DataPocz"/></td>
										<td><xsl:value-of select="DataKonc"/></td>
										<td><xsl:value-of select="RodzajDysfunkcji"/></td>
									</tr>
								</xsl:for-each>
							</table>
						</td>
					</tr>
				</xsl:for-each>
			</table>
			<br/>
			
			OswiadczenieMajatkowe:	
			<table border="1">
				<tr>
					<th>DataZlozenia</th>
					<th>Skladowa</th>
					<th>Wartosc</th>
					<th>Jednostka</th>
				</tr>
				<xsl:for-each select="OswiadczenieMajatkowe">
					<tr>
						<td><xsl:value-of select="DataZlozenia"/></td>
						<td><xsl:value-of select="Skladowa"/></td>
						<td><xsl:value-of select="Wartosc"/></td>
						<td><xsl:value-of select="Jednostka"/></td>
					</tr>
				</xsl:for-each>
			</table>    
			<br/>
			
			Info:	
			<table border="1">
				<tr>
					<th>DataAktOd</th>
					<th>DataAktDo</th>
					<th>OstatniTyp</th>
					<th>OstatniRodzaj</th>
					<th>OstatniStatus</th>
				</tr>
				<xsl:for-each select="Info">
					<tr>
						<td><xsl:value-of select="DataAktOd"/></td>
						<td><xsl:value-of select="DataAktDo"/></td>
						<td><xsl:value-of select="OstatniTyp"/></td>
						<td><xsl:value-of select="OstatniRodzaj"/></td>
						<td><xsl:value-of select="OstatniStatus"/></td>
					</tr>
				</xsl:for-each>
			</table>    
			<br/>
			
			Propozycja:	
			<table border="1">
				<tr>
					<th>RodzajPropozycji</th>
					<th>DataPrzedlozenia</th>
					<th>SzczegolyPrzyjecia</th>
					<th>OpisPropozycji</th>
				</tr>
				<xsl:for-each select="Propozycja">
					<tr>
						<td><xsl:value-of select="RodzajPropozycji"/></td>
						<td><xsl:value-of select="DataPrzedlozenia"/></td>
						<td><xsl:value-of select="SzczegolyPrzyjecia"/></td>
						<td><xsl:value-of select="OpisPropozycji"/></td>
					</tr>
				</xsl:for-each>
			</table>       
			<br/>
			
			Szkolenie:	
			<table border="1">
				<tr>
					<th>DataSkierowania</th>
					<th>ZakresTematyczny</th>
					<th>SposobZakonczenia</th>
					<th>DataRozpoczecia</th>
					<th>DataZakonczenia</th>
				</tr>
				<xsl:for-each select="Szkolenie">
					<tr>
						<td><xsl:value-of select="DataSkierowania"/></td>
						<td><xsl:value-of select="ZakresTematyczny"/></td>
						<td><xsl:value-of select="SposobZakonczenia"/></td>
						<td><xsl:value-of select="DataRozpoczecia"/></td>
						<td><xsl:value-of select="DataZakonczenia"/></td>
					</tr>
				</xsl:for-each>
			</table>    
			<br/>
			
			KlubyPracy:	
			<table border="1">
				<tr>
					<th>DataPocz</th>
					<th>DataKonc</th>
					<th>ProfilTematyczny</th>
					<th>LiczbaOpuszczonychGodzin</th>
					<th>SzczegolyPrzyjeciaSzkolenia</th>
					<th>TypZajec</th>
				</tr>
				<xsl:for-each select="KlubyPracy">
					<tr>
						<td><xsl:value-of select="DataPocz"/></td>
						<td><xsl:value-of select="DataKonc"/></td>
						<td><xsl:value-of select="ProfilTematyczny"/></td>
						<td><xsl:value-of select="LiczbaOpuszczonychGodzin"/></td>
						<td><xsl:value-of select="SzczegolyPrzyjeciaSzkolenia"/></td>
						<td><xsl:value-of select="TypZajec"/></td>
					</tr>
				</xsl:for-each>
			</table>
			<br/>
			
			OkresRejestracji:	
			<table border="1">
				<tr>
					<th>DataPocz</th>
					<th>DataKonc</th>
					<th>Status</th>
					<th>KodStatusu</th>
				</tr>
				<xsl:for-each select="OkresRejestracji">
					<tr>
						<td><xsl:value-of select="DataPocz"/></td>
						<td><xsl:value-of select="DataKonc"/></td>
						<td><xsl:value-of select="Status"/></td>
						<td><xsl:value-of select="KodStatusu"/></td>
					</tr>
				</xsl:for-each>
			</table>         
			<br/>
			
			PobranyZasSw:	
			<table border="1">
			  <tr>
				<th>Rodzaj</th>
				<th>DataPocz</th>
				<th>DataKonc</th>
				<th>KwotaBrutto</th>
				<th>KwotaNetto</th>
				<th>DataWyplaty</th>
				<th>NazwaSwiadczenia</th>
				<th>Typ</th>
				<th>SklEmer</th>
				<th>SklRent</th>
				<th>SklZdr</th>
				<th>SklWyp</th>
				<th>Podatek</th>
			  </tr>
			  <xsl:for-each select="PobranyZasSw">
			  <tr>
				<td><xsl:value-of select="Rodzaj"/></td>
				<td><xsl:value-of select="DataPocz"/></td>
				<td><xsl:value-of select="DataKonc"/></td>
				<td><xsl:value-of select="KwotaBrutto"/></td>
				<td><xsl:value-of select="KwotaNetto"/></td>
				<td><xsl:value-of select="DataWyplaty"/></td>
				<td><xsl:value-of select="NazwaSwiadczenia"/></td>
				<td><xsl:value-of select="Typ"/></td>
				<td><xsl:value-of select="SklEmer"/></td>
				<td><xsl:value-of select="SklRent"/></td>
				<td><xsl:value-of select="SklZdr"/></td>
				<td><xsl:value-of select="SklWyp"/></td>
				<td><xsl:value-of select="Podatek"/></td>
			  </tr>
			  </xsl:for-each>
			</table>    
			<br/>
			
			Dzialalnosc:	
			<table border="1">
				<tr>
					<th>NazwaDzialalnosci</th>
					<th>DataRozpDzial</th>
					<th>DataZakDzial</th>
				</tr>
				<xsl:for-each select="Dzialalnosc">
					<tr>
						<td><xsl:value-of select="NazwaDzialalnosci"/></td>
						<td><xsl:value-of select="DataRozpDzial"/></td>
						<td><xsl:value-of select="DataZakDzial"/></td>
					</tr>
				</xsl:for-each>
			</table>            
			<br/>
			
			PrzyznanyZasSw:	
			<table border="1">
			  <tr>
				<th>NazwaSwiadczenia</th>
				<th>DataPocz</th>
				<th>DataKon</th>
				<th>KodRodzajuDecyzjiSwiadczenia</th>
				<th>Typ</th>
				<th>KodSwiadczenia</th>
				<th>CzyKwota</th>
				<th>KwotaProcent</th>
				<th>Parametr</th>
			  </tr>
			  <xsl:for-each select="PrzyznanyZasSw">
			  <tr>
				<td><xsl:value-of select="NazwaSwiadczenia"/></td>
				<td><xsl:value-of select="DataPocz"/></td>
				<td><xsl:value-of select="DataKon"/></td>
				<td><xsl:value-of select="KodRodzajuDecyzjiSwiadczenia"/></td>
				<td><xsl:value-of select="Typ"/></td>
				<td><xsl:value-of select="KodSwiadczenia"/></td>
				<td><xsl:value-of select="CzyKwota"/></td>
				<td><xsl:value-of select="KwotaProcent"/></td>
				<td><xsl:value-of select="Parametr"/></td>
			  </tr>
			  </xsl:for-each>
			</table>      
			<br/>
			
			Kwalifikacje - Zawody:
			<table border="1">
				<tr>
					<th>TypKwalifikacji</th>
					<th>TypZawodu</th>
					<th>NazwaZawodu</th>
					<th>KodZawodu</th>
					<th>CzyWykonywany</th>
					<th>CzyWyuczony</th>
					<th>CzyZakazany</th>
					<th>StazZawodu</th>
				</tr>
				<xsl:for-each select="Kwalifikacje/Zawody/Zawod">
					<tr>
						<td><xsl:value-of select="TypKwalifikacji"/></td>
						<td><xsl:value-of select="TypZawodu"/></td>
						<td><xsl:value-of select="NazwaZawodu"/></td>
						<td><xsl:value-of select="KodZawodu"/></td>
						<td><xsl:value-of select="CzyWykonywany"/></td>
						<td><xsl:value-of select="CzyWyuczony"/></td>
						<td><xsl:value-of select="CzyZakazany"/></td>
						<td><xsl:value-of select="StazZawodu"/></td>
					</tr>
				</xsl:for-each>
			</table>          
			<br/>
			
			Kwalifikacje - Wyksztalcenie:
			<table border="1">
				<tr>
					<th>TypKwalifikacji</th>
					<th>RodzajWyksztalcenia</th>
					<th>KodPoziomuWykszt</th>
					<th>KodTypuWykszt</th>
					<th>TypWyksztalcenia</th>
					<th>KodStopniaNaukowego</th>
					<th>StopienNaukowy</th>
					<th>KierunekWyksztalcenia</th>
					<th>Specjalizacja</th>
					<th>KodSzkoly</th>
					<th>NazwaSzkoly</th>
					<th>MiejscowoscSzkoly</th>
					<th>TypSzkoly</th>
					<th>DataUkonczeniaSzkoly</th>
				</tr>
				<xsl:for-each select="Kwalifikacje/Wyksztalcenia/Wyksztalcenie">
					<tr>
						<td><xsl:value-of select="TypKwalifikacji"/></td>
						<td><xsl:value-of select="RodzajWyksztalcenia"/></td>
						<td><xsl:value-of select="KodPoziomuWykszt"/></td>
						<td><xsl:value-of select="KodTypuWykszt"/></td>
						<td><xsl:value-of select="TypWyksztalcenia"/></td>
						<td><xsl:value-of select="KodStopniaNaukowego"/></td>
						<td><xsl:value-of select="StopienNaukowy"/></td>
						<td><xsl:value-of select="KierunekWyksztalcenia"/></td>
						<td><xsl:value-of select="Specjalizacja"/></td>
						<td><xsl:value-of select="KodSzkoly"/></td>
						<td><xsl:value-of select="NazwaSzkoly"/></td>
						<td><xsl:value-of select="MiejscowoscSzkoly"/></td>
						<td><xsl:value-of select="TypSzkoly"/></td>
						<td><xsl:value-of select="DataUkonczeniaSzkoly"/></td>
					</tr>
				</xsl:for-each>
			</table>    			
			<br/>
			
			Kwalifikacje - Uprawnienia:
			<table border="1">
				<tr>
					<th>TypKwalifikacji</th>
					<th>NazwaUprawnienia</th>
					<th>KodRodzajuUprawnienia</th>
					<th>StazUprawnienia</th>
					<th>DataWaznosciOd</th>
					<th>DataWaznosciDo</th>
				</tr>
				<xsl:for-each select="Kwalifikacje/Uprawnienia/Uprawnienie">
					<tr>
						<td><xsl:value-of select="TypKwalifikacji"/></td>
						<td><xsl:value-of select="NazwaUprawnienia"/></td>
						<td><xsl:value-of select="KodRodzajuUprawnienia"/></td>
						<td><xsl:value-of select="StazUprawnienia"/></td>
						<td><xsl:value-of select="DataWaznosciOd"/></td>
						<td><xsl:value-of select="DataWaznosciDo"/></td>
					</tr>
				</xsl:for-each>
			</table>    			
			<br/>
			
			Kwalifikacje - JezykiObce:
			<table border="1">
				<tr>
					<th>TypKwalifikacji</th>
					<th>NazwaJezyka</th>
					<th>KodJezyka</th>
					<th>ZnajWMowie</th>
					<th>ZnajWCzyt</th>
					<th>ZnajWPis</th>
					<th>KodZnajWMowie</th>
					<th>KodZnajWPismie</th>
				</tr>
				<xsl:for-each select="Kwalifikacje/JezykiObce/JezykObcy">
					<tr>
						<td><xsl:value-of select="TypKwalifikacji"/></td>
						<td><xsl:value-of select="NazwaJezyka"/></td>
						<td><xsl:value-of select="KodJezyka"/></td>
						<td><xsl:value-of select="ZnajWMowie"/></td>
						<td><xsl:value-of select="ZnajWCzyt"/></td>
						<td><xsl:value-of select="ZnajWPis"/></td>
						<td><xsl:value-of select="KodZnajWMowie"/></td>
						<td><xsl:value-of select="KodZnajWPismie"/></td>
					</tr>
				</xsl:for-each>
			</table>  			
			<br/>
			
			Kwalifikacje - Umiejetnosci:
			<table border="1">
				<tr>
					<th>TypKwalifikacji</th>
					<th>KodUmiejetnosci</th>
					<th>NazwaUmiejetnosci</th>
				</tr>
				<xsl:for-each select="Kwalifikacje/Umiejetnosci/Umiejetnosc">
					<tr>
						<td><xsl:value-of select="TypKwalifikacji"/></td>
						<td><xsl:value-of select="KodUmiejetnosci"/></td>
						<td><xsl:value-of select="NazwaUmiejetnosci"/></td>
					</tr>
				</xsl:for-each>
			</table>  			
			<br/>
			
			HistoriaKontaktow:	
			<table border="1">
				<tr>
					<th>RodzajWizyty</th>
					<th>MiejsceWUrzedzie</th>
					<th>PlanDataWizyty</th>
					<th>FaktycznaDataWizyty</th>
					<th>Uwagi</th>
				</tr>
				<xsl:for-each select="HistoriaKontaktow/Wizyta">
					<tr>
						<td><xsl:value-of select="RodzajWizyty"/></td>
						<td><xsl:value-of select="MiejsceWUrzedzie"/></td>
						<td><xsl:value-of select="PlanDataWizyty"/></td>
						<td><xsl:value-of select="FaktycznaDataWizyty"/></td>
						<td><xsl:value-of select="Uwagi"/></td>
					</tr>
				</xsl:for-each>
			</table>
			<br/>
			
			HistoriaZatrudnienia:	
			<table border="1">
				<tr>
					<th>Rodzaj</th>
					<th>DataPocz</th>
					<th>DataKon</th>
					<th>NazwaPracodawcy</th>
					<th>Zawod</th>
					<th>Stanowisko</th>
				</tr>
				<xsl:for-each select="HistoriaZatrudnienia/Zatrudnienie">
					<tr>
						<td><xsl:value-of select="Rodzaj"/></td>
						<td><xsl:value-of select="DataPocz"/></td>
						<td><xsl:value-of select="DataKon"/></td>
						<td><xsl:value-of select="NazwaPracodawcy"/></td>
						<td><xsl:value-of select="Zawod"/></td>
						<td><xsl:value-of select="Stanowisko"/></td>
					</tr>
				</xsl:for-each>
			</table>	
			<br/>
			
			KolejneZdarzenia:	
			<table border="1">
				<tr>
					<th>RodzZdarz1</th>
					<th>TypZdarz1</th>
					<th>OpisZdarz1</th>
					<th>DataZdarz1</th>
					<th>RodzZdarz2</th>
					<th>TypZdarz2</th>
					<th>OpisZdarz2</th>
					<th>DataZdarz2</th>
				</tr>
				<xsl:for-each select="KolejneZdarzenia/KolejneZdarzenie">
					<tr>
						<td><xsl:value-of select="RodzZdarz1"/></td>
						<td><xsl:value-of select="TypZdarz1"/></td>
						<td><xsl:value-of select="OpisZdarz1"/></td>
						<td><xsl:value-of select="DataZdarz1"/></td>
						<td><xsl:value-of select="RodzZdarz2"/></td>
						<td><xsl:value-of select="TypZdarz2"/></td>
						<td><xsl:value-of select="OpisZdarz2"/></td>
						<td><xsl:value-of select="DataZdarz2"/></td>
					</tr>
				</xsl:for-each>
			</table>	
			<br/>
			
			PoradnictwoZawodowe:	
			<table border="1">
				<tr>
					<th>DataPocz</th>
					<th>DataKonc</th>
					<th>RodzajUslugi</th>
					<th>Temat</th>
					<th>Wynik</th>
				</tr>
				<xsl:for-each select="PoradnictwoZawodowe/PoradaInformacjaZawodowa">
					<tr>
						<td><xsl:value-of select="DataPocz"/></td>
						<td><xsl:value-of select="DataKonc"/></td>
						<td><xsl:value-of select="RodzajUslugi"/></td>
						<td><xsl:value-of select="Temat"/></td>
						<td><xsl:value-of select="Wynik"/></td>
					</tr>
				</xsl:for-each>
			</table>	
			<br/>
			
			SkladkiZdrowotne:	
			<table border="1">
				<tr>
					<th>DataPocz</th>
					<th>DataKonc</th>
					<th>KwotaSkladki</th>
					<th>DataWyplaty</th>
				</tr>
				<xsl:for-each select="SkladkiZdrowotne/SkladkaZdrowotna">
					<tr>
						<td><xsl:value-of select="DataPocz"/></td>
						<td><xsl:value-of select="DataKonc"/></td>
						<td><xsl:value-of select="KwotaSkladki"/></td>
						<td><xsl:value-of select="DataWyplaty"/></td>
					</tr>
				</xsl:for-each>
			</table>		
			<br/>
			
			DokumentyZrodlowe:	
			<table border="1">
				<tr>
					<th>Numer</th>
					<th>Typ</th>
				</tr>
				<xsl:for-each select="DokumentyZrodlowe/DokumentZrodlowy">
					<tr>
						<td><xsl:value-of select="Numer"/></td>
						<td><xsl:value-of select="Typ"/></td>
					</tr>
				</xsl:for-each>
			</table>	
			<br/>
			
			InformacjeOBezdomnosci:	
			<table border="1">
				<tr>
					<th>AdresMiejscaNoclegowego</th>
					<th>DataPocz</th>
					<th>DataKonc</th>
				</tr>
				<xsl:for-each select="InformacjeOBezdomnosci/InformacjaOBezdomnosci">
					<tr>
						<td><xsl:value-of select="AdresMiejscaNoclegowego"/></td>
						<td><xsl:value-of select="DataPocz"/></td>
						<td><xsl:value-of select="DataKonc"/></td>
					</tr>
				</xsl:for-each>
			</table>		
			<br/>
			
			OkresyPrzynaleznosciNfz:	
			<table border="1">
				<tr>
					<th>DataPocz</th>
					<th>DataKonc</th>
					<th>NazwaOddzialu</th>
				</tr>
				<xsl:for-each select="OkresyPrzynaleznosciNfz">
					<tr>
						<td><xsl:value-of select="DataPocz"/></td>
						<td><xsl:value-of select="DataKonc"/></td>
						<td><xsl:value-of select="NazwaOddzialu"/></td>
					</tr>
				</xsl:for-each>
			</table>   	
			
        </xsl:for-each>
		
		</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
