package pl.gov.pup.pomost.xml;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class LocalDateAdapter extends XmlAdapter<String, LocalDate> {
	@Override
	public LocalDate unmarshal(String v) throws Exception {
		return v == null ? null : LocalDate.parse(v, DateTimeFormatter.ISO_LOCAL_DATE);
	}

	@Override
	public String marshal(LocalDate v) throws Exception {
		return v == null ? null : DateTimeFormatter.ISO_LOCAL_DATE.format(v);
	}
}
