package pl.gov.pup.pomost.xml;

import static java.time.temporal.ChronoField.DAY_OF_MONTH;
import static java.time.temporal.ChronoField.MONTH_OF_YEAR;
import static java.time.temporal.ChronoField.YEAR;
import static java.time.temporal.ChronoField.HOUR_OF_DAY;
import static java.time.temporal.ChronoField.MINUTE_OF_HOUR;
import static java.time.temporal.ChronoField.SECOND_OF_MINUTE;

import java.time.LocalDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;

import javax.xml.bind.annotation.adapters.XmlAdapter;

public class LocalDateTimeAdapter extends XmlAdapter<String, LocalDateTime> {
	public static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder()
		.appendValue(YEAR, 4, 4, SignStyle.NOT_NEGATIVE)
		.appendLiteral('-')
		.appendValue(MONTH_OF_YEAR, 2)
		.appendLiteral('-')
		.appendValue(DAY_OF_MONTH, 2)
		.appendLiteral(' ')
		.appendValue(HOUR_OF_DAY, 2)
		.appendLiteral(':')
		.appendValue(MINUTE_OF_HOUR, 2)
		.appendLiteral(':')
		.appendValue(SECOND_OF_MINUTE, 2)
		.toFormatter()
		.withResolverStyle(ResolverStyle.STRICT)
		.withChronology(IsoChronology.INSTANCE);

	@Override
	public LocalDateTime unmarshal(String v) throws Exception {
		return v == null ? null : LocalDateTime.parse(v, FORMATTER);
	}

	@Override
	public String marshal(LocalDateTime v) throws Exception {
		return v == null ? null : FORMATTER.format(v);
	}
}
