/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.slownikicentralne;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.io.MoreFiles;
import com.ibm.icu.text.Transliterator;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.validation.constraints.NotNull;
import pl.gov.mpips.slownikicentralne.model.Pozycja;
import pl.gov.mpips.slownikicentralne.model.Slownik;
import pl.topteam.common.util.ExtraLocales;

public final class GeneratorSlownikow {
    private static final Transliterator transliterator = Transliterator.getInstance((String)"Latin-ASCII");

    private GeneratorSlownikow() {
    }

    public static void main(String[] args) throws IOException {
        Path wejscie = Paths.get(args[0], new String[0]);
        Path wyjscie = Paths.get(args[1], new String[0]);
        ImmutableListMultimap<Slownik, Pozycja> slowniki = GeneratorSlownikow.slowniki(wejscie);
        for (Slownik slownik : slowniki.keySet()) {
            TypeSpec.Builder enumeracja = TypeSpec.enumBuilder((String)GeneratorSlownikow.nazwa(slownik)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(slownik.opis() + " [" + slownik.kod() + "]", new Object[0]);
            for (Pozycja pozycja : slowniki.get((Object)slownik)) {
                enumeracja.addEnumConstant(GeneratorSlownikow.nazwa(pozycja), TypeSpec.anonymousClassBuilder((String)"$S, $S", (Object[])new Object[]{pozycja.kod(), pozycja.opis()}).addJavadoc(pozycja.opis() + " [" + pozycja.kod() + "]", new Object[0]).build());
            }
            enumeracja.addField(FieldSpec.builder(String.class, (String)"kod", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addAnnotation(NotNull.class).build());
            enumeracja.addField(FieldSpec.builder(String.class, (String)"opis", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addAnnotation(NotNull.class).build());
            MethodSpec.Builder konstruktor = MethodSpec.constructorBuilder();
            konstruktor.addParameter(String.class, "kod", new Modifier[0]);
            konstruktor.addParameter(String.class, "opis", new Modifier[0]);
            for (String parametr : ImmutableList.of((Object)"kod", (Object)"opis")) {
                konstruktor.addStatement("this.$L = $L", new Object[]{parametr, parametr});
            }
            enumeracja.addMethod(konstruktor.build());
            enumeracja.addMethod(MethodSpec.methodBuilder((String)"kod").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $L", new Object[]{"kod"}).build());
            enumeracja.addMethod(MethodSpec.methodBuilder((String)"opis").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $L", new Object[]{"opis"}).build());
            JavaFile.builder((String)"pl.gov.mpips.slownikicentralne", (TypeSpec)enumeracja.build()).build().writeTo(wyjscie);
        }
    }

    private static String nazwa(Slownik slownik) {
        return GeneratorSlownikow.identyfikator(transliterator.transliterate(slownik.opis()));
    }

    private static String nazwa(Pozycja pozycja) {
        return GeneratorSlownikow.identyfikator(transliterator.transliterate(pozycja.opis())).toUpperCase(ExtraLocales.PL);
    }

    private static String identyfikator(String nazwa) {
        StringBuilder identyfikator = new StringBuilder();
        for (int kod : nazwa.codePoints().toArray()) {
            if (Character.isJavaIdentifierPart(kod)) {
                identyfikator.appendCodePoint(kod);
                continue;
            }
            identyfikator.append("_");
        }
        return identyfikator.toString();
    }

    private static ImmutableListMultimap<Slownik, Pozycja> slowniki(Path katalog) throws IOException {
        ImmutableListMultimap.Builder slowniki = ImmutableListMultimap.builder();
        for (Path plik : MoreFiles.listFiles((Path)katalog)) {
            if (!MoreFiles.getFileExtension((Path)plik).equals("txt")) continue;
            Path txt = katalog.resolve(MoreFiles.getNameWithoutExtension((Path)plik) + ".txt");
            Path csv = katalog.resolve(MoreFiles.getNameWithoutExtension((Path)plik) + ".csv");
            Slownik slownik = Slownik.slownik(MoreFiles.getNameWithoutExtension((Path)txt), MoreFiles.asCharSource((Path)txt, (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]).readFirstLine());
            for (String rekord : MoreFiles.asCharSource((Path)csv, (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]).readLines()) {
                List pola = Splitter.on((String)";").limit(2).splitToList((CharSequence)rekord);
                Pozycja pozycja = Pozycja.pozycja((String)pola.get(0), (String)pola.get(1));
                slowniki.put((Object)slownik, (Object)pozycja);
            }
        }
        return slowniki.build();
    }
}

