<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema">
	<xsl:output version="1.0" method="html" indent="no" encoding="UTF-8"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:template match="/">
		<html>
			<head>
				<title/>
			</head>
			<body>
				<xsl:for-each select="$XML">
					<a>
						<xsl:attribute name="name">
							<xsl:text>top</xsl:text>
						</xsl:attribute>
					</a>
					<br/>
					<h1 align="center">
						<span style="font-weight:bold; ">
							<xsl:text>Zestaw słowników</xsl:text>
						</span>
					</h1>
					<table style="font-style:italic; " border="0" width="100%">
						<tbody>
							<tr>
								<td align="right" width="10%">
									<span>
										<xsl:text>Numer zestawu:</xsl:text>
									</span>
								</td>
								<td width="100%">
									<xsl:for-each select="P_SLOCEN">
										<xsl:for-each select="Metryczka">
											<xsl:for-each select="Nr_Zestawu">
												<xsl:apply-templates/>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td align="right" width="10%">
									<span>
										<xsl:text>Data utworzenia:</xsl:text>
									</span>
								</td>
								<td width="100%">
									<xsl:for-each select="P_SLOCEN">
										<xsl:for-each select="Metryczka">
											<xsl:for-each select="Data_Utworzenia">
												<xsl:apply-templates/>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</td>
							</tr>
							<tr>
								<td align="right" width="10%">
									<span>
										<xsl:text>Opis:</xsl:text>
									</span>
								</td>
								<td width="100%">
									<xsl:for-each select="P_SLOCEN">
										<xsl:for-each select="Metryczka">
											<xsl:for-each select="Opis">
												<xsl:apply-templates/>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</td>
							</tr>
						</tbody>
					</table>
					<br/>
					<br/>
					<a>
						<xsl:choose>
							<xsl:when test="substring(string('#end'), 1, 1) = '#'">
								<xsl:attribute name="href">
									<xsl:value-of select="'#end'"/>
								</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="href">
									<xsl:if test="substring(string('#end'), 2, 1) = ':'">
										<xsl:text>file:///</xsl:text>
									</xsl:if>
									<xsl:value-of select="translate(string('#end'), '&#x5c;', '/')"/>
								</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<span>
							<xsl:text>Przejdź na koniec</xsl:text>
						</span>
					</a>
					<br/>
					<a>
						<xsl:choose>
							<xsl:when test="substring(string('#parametry'), 1, 1) = '#'">
								<xsl:attribute name="href">
									<xsl:value-of select="'#parametry'"/>
								</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="href">
									<xsl:if test="substring(string('#parametry'), 2, 1) = ':'">
										<xsl:text>file:///</xsl:text>
									</xsl:if>
									<xsl:value-of select="translate(string('#parametry'), '&#x5c;', '/')"/>
								</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<span>
							<xsl:text>Przejdź do listy parametrów</xsl:text>
						</span>
					</a>
					<br/>
					<hr style="vertical-align:baseline; width:inherit; " align="center" color="blue" size="4"/>
					<h2>
						<span style="font-weight:bold; ">
							<xsl:text>Lista słowników</xsl:text>
						</span>
					</h2>
					<xsl:for-each select="P_SLOCEN">
						<br/>
						<xsl:for-each select="Słowniki">
							<br/>
							<xsl:for-each select="Słownik">
								<br/>
								<br/>
								<h3>
									<xsl:for-each select="Nazwa">
										<xsl:apply-templates/>
									</xsl:for-each>
								</h3>
								<table border="0" cellpadding="4" cellspacing="2" width="100%">
									<tbody>
										<tr>
											<td align="right" width="10%">
												<span>
													<xsl:text>Kod:</xsl:text>
												</span>
											</td>
											<td align="left" width="100%">
												<xsl:for-each select="Kod">
													<xsl:apply-templates/>
												</xsl:for-each>
											</td>
										</tr>
										<tr>
											<td align="right" width="10%">
												<span>
													<xsl:text>Opis:</xsl:text>
												</span>
											</td>
											<td align="left" width="100%">
												<xsl:for-each select="Opis">
													<xsl:apply-templates/>
												</xsl:for-each>
											</td>
										</tr>
										<tr>
											<td align="right" width="10%">
												<span>
													<xsl:text>Wersja:</xsl:text>
												</span>
											</td>
											<td align="left" width="100%">
												<xsl:for-each select="Wersja">
													<xsl:for-each select="Nr_Wersji">
														<xsl:apply-templates/>
													</xsl:for-each>
												</xsl:for-each>
											</td>
										</tr>
									</tbody>
								</table>
								<br/>
								<h3>
									<span>
										<xsl:text>Pozycje słownika </xsl:text>
									</span>
									<xsl:for-each select="Nazwa">
										<xsl:apply-templates/>
									</xsl:for-each>
								</h3>
								<table border="1" cellpadding="3" cellspacing="0" width="100%">
									<thead>
										<tr bgcolor="#D2C8AE">
											<th>
												<span style="color:#606060; font-weight:bold; ">
													<xsl:text>Kod</xsl:text>
												</span>
											</th>
											<th>
												<span style="color:#606060; ">
													<xsl:text>Kod Spr</xsl:text>
												</span>
											</th>
											<th>
												<span style="color:#606060; ">
													<xsl:text>Opis</xsl:text>
												</span>
											</th>
											<th align="center" width="100">
												<span style="color:#606060; ">
													<xsl:text>Data od</xsl:text>
												</span>
											</th>
											<th align="center" width="100">
												<span style="color:#606060; ">
													<xsl:text>Data do</xsl:text>
												</span>
											</th>
										</tr>
									</thead>
									<tbody>
										<xsl:for-each select="Pozycje">
											<xsl:for-each select="Pozycja">
												<tr>
													<td>
														<xsl:for-each select="Kod">
															<span style="font-weight:10; ">
																<xsl:apply-templates/>
															</span>
														</xsl:for-each>
													</td>
													<td>
														<xsl:for-each select="Kod_Spr">
															<xsl:apply-templates/>
														</xsl:for-each>
													</td>
													<td>
														<xsl:for-each select="Opis">
															<xsl:apply-templates/>
														</xsl:for-each>
													</td>
													<td align="center" width="100">
														<xsl:for-each select="Data_Od">
															<xsl:apply-templates/>
														</xsl:for-each>
													</td>
													<td align="center" width="100">
														<xsl:choose>
															<xsl:when test="count(Data_Do) &gt; 0">
																<xsl:for-each select="Data_Do">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:when>
															<xsl:when test="count(Data_Do) = 0">
																<span>
																	<xsl:text>-</xsl:text>
																</span>
															</xsl:when>
														</xsl:choose>
													</td>
												</tr>
											</xsl:for-each>
										</xsl:for-each>
									</tbody>
								</table>
								<br/>
								<br/>
								<xsl:if test="not(Słownik)"/>
								<hr style="vertical-align:baseline; width:inherit; " align="center" color="blue" size="3"/>
								<br/>
							</xsl:for-each>
							<br/>
						</xsl:for-each>
						<br/>
						<a>
							<xsl:choose>
								<xsl:when test="substring(string('#top'), 1, 1) = '#'">
									<xsl:attribute name="href">
										<xsl:value-of select="'#top'"/>
									</xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="href">
										<xsl:if test="substring(string('#top'), 2, 1) = ':'">
											<xsl:text>file:///</xsl:text>
										</xsl:if>
										<xsl:value-of select="translate(string('#top'), '&#x5c;', '/')"/>
									</xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
							<span>
								<xsl:text>Przejdź na początek</xsl:text>
							</span>
						</a>
						<br/>
						<a>
							<xsl:choose>
								<xsl:when test="substring(string('#end'), 1, 1) = '#'">
									<xsl:attribute name="href">
										<xsl:value-of select="'#end'"/>
									</xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="href">
										<xsl:if test="substring(string('#end'), 2, 1) = ':'">
											<xsl:text>file:///</xsl:text>
										</xsl:if>
										<xsl:value-of select="translate(string('#end'), '&#x5c;', '/')"/>
									</xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
							<span>
								<xsl:text>Przejdź na koniec</xsl:text>
							</span>
						</a>
						<br/>
						<hr style="vertical-align:baseline; width:inherit; " align="center" color="blue" size="4"/>
						<br/>
						<a>
							<xsl:attribute name="name">
								<xsl:text>parametry</xsl:text>
							</xsl:attribute>
						</a>
						<h2>
							<span>
								<xsl:text>Lista parametrów</xsl:text>
							</span>
						</h2>
						<xsl:for-each select="Parametry">
							<br/>
							<xsl:for-each select="Parametr">
								<br/>
								<h3>
									<xsl:for-each select="Nazwa">
										<xsl:apply-templates/>
									</xsl:for-each>
								</h3>
								<table border="0" cellpadding="4" cellspacing="2" width="100%">
									<tbody>
										<tr>
											<td align="right" width="10%">
												<span>
													<xsl:text>Kod:</xsl:text>
												</span>
											</td>
											<td width="100%">
												<xsl:for-each select="Kod">
													<xsl:apply-templates/>
												</xsl:for-each>
											</td>
										</tr>
										<tr>
											<td align="right" width="10%">
												<span>
													<xsl:text>Opis:</xsl:text>
												</span>
											</td>
											<td width="100%">
												<xsl:for-each select="Opis">
													<xsl:apply-templates/>
												</xsl:for-each>
											</td>
										</tr>
									</tbody>
								</table>
								<h3>
									<span>
										<xsl:text>Wartości parametru </xsl:text>
									</span>
									<xsl:for-each select="Nazwa">
										<xsl:apply-templates/>
									</xsl:for-each>
								</h3>
								<table border="1" cellpadding="3" cellspacing="0" width="100%">
									<thead>
										<tr bgcolor="#D2C8AE">
											<th align="center">
												<span style="color:#606060; font-weight:bold; ">
													<xsl:text>Data od</xsl:text>
												</span>
											</th>
											<th align="center">
												<span style="color:#606060; font-weight:bold; ">
													<xsl:text>Data do</xsl:text>
												</span>
											</th>
											<th>
												<span style="color:#606060; font-weight:bold; ">
													<xsl:text>Wartość</xsl:text>
												</span>
											</th>
										</tr>
									</thead>
									<tbody>
										<xsl:for-each select="Wartości">
											<xsl:for-each select="Wartość">
												<tr>
													<td align="center">
														<xsl:for-each select="Data_Od">
															<xsl:apply-templates/>
														</xsl:for-each>
													</td>
													<td align="center">
														<xsl:choose>
															<xsl:when test="count(Data_Do) &gt; 0">
																<xsl:for-each select="Data_Do">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:when>
															<xsl:when test="count(Data_Do) = 0">
																<span>
																	<xsl:text>-</xsl:text>
																</span>
															</xsl:when>
														</xsl:choose>
													</td>
													<td>
														<xsl:choose>
															<xsl:when test="count( War_Całk ) &gt; 0">
																<xsl:for-each select="War_Całk">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:when>
															<xsl:when test="count( War_Dat ) &gt; 0">
																<xsl:for-each select="War_Dat">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:when>
															<xsl:when test="count( War_Log ) &gt; 0">
																<xsl:for-each select="War_Log">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:when>
															<xsl:when test="count( War_Rzecz ) &gt; 0">
																<xsl:for-each select="War_Rzecz">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:when>
															<xsl:when test="count( War_Tekst ) &gt; 0">
																<xsl:for-each select="War_Tekst">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:when>
														</xsl:choose>
													</td>
												</tr>
											</xsl:for-each>
										</xsl:for-each>
									</tbody>
								</table>
								<br/>
								<br/>
								<hr style="vertical-align:baseline; width:inherit; " align="center" color="blue" size="3"/>
							</xsl:for-each>
							<br/>
							<br/>
						</xsl:for-each>
						<br/>
					</xsl:for-each>
					<br/>
					<a>
						<xsl:attribute name="name">
							<xsl:text>end</xsl:text>
						</xsl:attribute>
					</a>
					<br/>
					<a>
						<xsl:choose>
							<xsl:when test="substring(string('#top'), 1, 1) = '#'">
								<xsl:attribute name="href">
									<xsl:value-of select="'#top'"/>
								</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="href">
									<xsl:if test="substring(string('#top'), 2, 1) = ':'">
										<xsl:text>file:///</xsl:text>
									</xsl:if>
									<xsl:value-of select="translate(string('#top'), '&#x5c;', '/')"/>
								</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<span>
							<xsl:text>Przejdź na początek</xsl:text>
						</span>
					</a>
					<br/>
					<a>
						<xsl:choose>
							<xsl:when test="substring(string('#parametry'), 1, 1) = '#'">
								<xsl:attribute name="href">
									<xsl:value-of select="'#parametry'"/>
								</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="href">
									<xsl:if test="substring(string('#parametry'), 2, 1) = ':'">
										<xsl:text>file:///</xsl:text>
									</xsl:if>
									<xsl:value-of select="translate(string('#parametry'), '&#x5c;', '/')"/>
								</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<span>
							<xsl:text>Przejdź do listy parametrów</xsl:text>
						</span>
					</a>
					<br/>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
