package pl.gov.mpips.slownikicentralne;

import java.time.LocalDate;
import java.util.NavigableMap;

import javax.annotation.Nonnull;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;

public final class Wymagania {
	private Wymagania() { }

	/**
	 * Aktualizacja słowników centralnych powinna być przeprowadzana bez potrzeby zmian w programie!
	 *
	 * Ta stała NIE POWINNA warunkować jakiegokolwiek działania programu. Ma służyć jedynie
	 * celom informacyjnym dla użytkowników.
	 */
	public static final int WERSJA_SLOWNIKOW_CENTRALNYCH = 74;

	public static final LocalDate DATA_SLOWNIKOW_CENTRALNYCH = LocalDate.parse("2022-12-21");

	private static final NavigableMap<LocalDate, String> KOD_APLIKACJI = ImmutableSortedMap.<LocalDate, String>of(
		LocalDate.of(1900, 1, 1), "TT-TT/1.2/O",
		LocalDate.of(2010, 4, 1), "TT-TT/1.2/GP",
		LocalDate.of(2013, 12, 9), "TT-TT/1.03/GP"
	);

	public static String kodAplikacji(@Nonnull String dataTworzeniaDokumentu) {
		return kodAplikacji(LocalDate.parse(dataTworzeniaDokumentu));
	}

	public static String kodAplikacji(@Nonnull LocalDate naDzien) {
		Preconditions.checkNotNull(naDzien);
		Preconditions.checkState(naDzien.getYear() > 1900 && naDzien.getYear() < 2100);
		return KOD_APLIKACJI.floorEntry(naDzien).getValue();
	}
}
