package pl.gov.mpips.slownikicentralne;

import java.time.LocalDate;
import java.util.NavigableMap;

import javax.annotation.Nonnull;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;

public final class Wymagania {
	private Wymagania() { }

	/**
	 * Aktualizacja słowników centralnych powinna być przeprowadzana bez potrzeby zmian w programie!
	 *
	 * Ta stała NIE POWINNA warunkować jakiegokolwiek działania programu. Ma służyć jedynie
	 * celom informacyjnym dla użytkowników.
	 */
	public static final int WERSJA_SLOWNIKOW_CENTRALNYCH = 82;

	public static final LocalDate DATA_SLOWNIKOW_CENTRALNYCH = LocalDate.parse("2024-06-18");

	private static final NavigableMap<LocalDate, String> KOD_APLIKACJI = ImmutableSortedMap.<LocalDate, String>of(
		LocalDate.parse("1900-01-01"), "TT-TT/1.2/O",
		LocalDate.parse("2010-04-01"), "TT-TT/1.2/GP",
		LocalDate.parse("2013-12-09"), "TT-TT/1.03/GP",
		LocalDate.parse("2015-12-28"), "TT-TT/1.04/GP",
		LocalDate.parse("2023-10-24"), "TT-TT/1.05/GP"
	);

	public static String kodAplikacji(@Nonnull String dataTworzeniaDokumentu) {
		return kodAplikacji(LocalDate.parse(dataTworzeniaDokumentu));
	}

	public static String kodAplikacji(@Nonnull LocalDate naDzien) {
		Preconditions.checkNotNull(naDzien);
		Preconditions.checkState(naDzien.getYear() > 1900 && naDzien.getYear() < 2100);
		return KOD_APLIKACJI.floorEntry(naDzien).getValue();
	}
}
