<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" version="1.0">
	<xsl:output doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" indent="no" method="html"/>
	<xsl:decimal-format name="pln" decimal-separator="," grouping-separator=" "/>
	<xsl:template match="/">
			<style type="text/css">
			    tr.pozycja-wartosc.warn td {
			    	color: #A5A5A5;
			    	text-decoration: line-through;
			    }

				tr.pozycja-wartosc td:first-child,
				tr.pozycja-wartosc td:nth-child(2) {
					width: 150px;
				}

				tr.pozycja-wartosc td:nth-child(3),
				tr.pozycja-wartosc td:nth-child(4) {
					width: 100px;
				}
			</style>
			<h1>Słowniki centralne (wraz z parametrami)</h1>
				<div class="container-fluid">
				<table class="table table-striped">
					<tbody>
						<xsl:apply-templates select="P_SLOCEN/Metryczka"/>
						<tr>
							<td>lista słowników</td>
							<td id="lista-slownikow">
								<table class="table table-condensed">
									<thead>
										<tr>
											<th class="text-right" style="width: 100px;">[kod, obszar]</th>
											<th>nazwa</th>
										</tr>
									</thead>
									<tbody>
										<xsl:for-each select="P_SLOCEN/Słowniki/Słownik">
											<xsl:sort select="Nazwa" order="ascending" data-type="text"/>
											<tr>
												<td class="text-right">
													[<xsl:value-of select="Kod"/>, <xsl:value-of select="Obszar"/>]
												</td>
												<td>
													<a>
														<xsl:attribute name="href">
															<xsl:text>#</xsl:text><xsl:value-of select="Nazwa"/>
														</xsl:attribute>
														<xsl:value-of select="Nazwa"/>
													</a>
												</td>
											</tr>
										</xsl:for-each>
									</tbody>
								</table>
							</td>
						</tr>
					</tbody>
					<tbody>
						<tr>
							<td>lista parametrów</td>
							<td id="lista-parametrow">
								<table class="table table-condensed">
									<thead>
										<tr>
											<th class="text-right" style="width: 100px;">[kod, obszar]</th>
											<th>nazwa</th>
										</tr>
									</thead>
									<tbody>
										<xsl:for-each select="P_SLOCEN/Parametry/Parametr">
											<xsl:sort select="Nazwa" order="ascending" data-type="text"/>
											<tr>
												<td class="text-right">
													[<xsl:value-of select="Kod"/>, <xsl:value-of select="Obszar"/>]
												</td>
												<td>
													<a>
														<xsl:attribute name="href">
															<xsl:text>#</xsl:text><xsl:value-of select="Nazwa"/>
														</xsl:attribute>
														<xsl:value-of select="Nazwa"/>
													</a>
												</td>
											</tr>
										</xsl:for-each>
									</tbody>
								</table>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:apply-templates select="P_SLOCEN/Słowniki/Słownik">
				<xsl:sort select="Nazwa" order="ascending" data-type="text"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="P_SLOCEN/Parametry/Parametr">
				<xsl:sort select="Nazwa" order="ascending" data-type="text"/>
			</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="Metryczka">
		<tr>
			<td>numer zestawu</td>
			<td><xsl:value-of select="Nr_Zestawu"/></td>
		</tr>
		<tr>
			<td>data utworzenia</td>
			<td><xsl:value-of select="Data_Utworzenia"/></td>
		</tr>
	</xsl:template>
	<xsl:template match="Słownik">
		<div class="container-fluid">
			<section>
				<xsl:attribute name="id">
					<xsl:value-of select="Nazwa"/>
				</xsl:attribute>
				<div>
					<h3>
						[<xsl:value-of select="Kod"/>, <xsl:value-of select="Obszar"/>]
						<xsl:value-of select="Nazwa"/>
						<small>
							<a>
								<xsl:attribute name="href">
									<xsl:text>#lista-slownikow</xsl:text>
								</xsl:attribute>
								(lista słowników)
							</a>
						</small>
					</h3>
				</div>
				<div><h5><xsl:value-of select="Opis"/></h5></div>
				<table class="table table-hover">
					<thead>
						<tr>
							<th>kod</th>
							<th>kod<br/>sprawozdawczy</th>
							<th>data od</th>
							<th>data do</th>
							<th>opis</th>
						</tr>
					</thead>
					<tbody>
						<xsl:apply-templates select="Pozycje/Pozycja"/>
					</tbody>
				</table>
			</section>
		</div>
	</xsl:template>
	<xsl:template match="Pozycja">
		<tr>
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="Data_Do != ''">pozycja-wartosc warn</xsl:when>
					<xsl:otherwise>pozycja-wartosc</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<td nowrap="nowrap"><xsl:value-of select="Kod"/></td>
			<td nowrap="nowrap"><xsl:value-of select="Kod_Spr"/></td>
			<td nowrap="nowrap"><xsl:value-of select="Data_Od"/></td>
			<td nowrap="nowrap"><xsl:value-of select="Data_Do"/></td>
			<td><xsl:value-of select="Opis"/></td>
		</tr>
	</xsl:template>
	<xsl:template match="Parametr">
		<div class="container-fluid">
			<section>
				<xsl:attribute name="id">
					<xsl:value-of select="Nazwa"/>
				</xsl:attribute>
				<div>
					<h3>
						[<xsl:value-of select="Kod"/>, <xsl:value-of select="Obszar"/>]
						<xsl:value-of select="Nazwa"/>
						<small>
							<a>
								<xsl:attribute name="href">
									<xsl:text>#lista-parametrow</xsl:text>
								</xsl:attribute>
								(lista parametrów)
							</a>
						</small>
					</h3>
				</div>
				<div><h5><xsl:value-of select="Opis"/></h5></div>
				<table class="table table-hover" style="width: 500px;">
					<thead>
						<tr>
							<th>data od</th>
							<th>data do</th>
							<th>wartość</th>
						</tr>
					</thead>
					<tbody>
						<xsl:apply-templates select="Wartości/Wartość"/>
					</tbody>
				</table>
			</section>
		</div>
	</xsl:template>
	<xsl:template match="Wartość">
		<tr>
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="Data_Do != ''">pozycja-wartosc warn</xsl:when>
					<xsl:otherwise>pozycja-wartosc</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<td nowrap="nowrap"><xsl:value-of select="Data_Od"/></td>
			<td nowrap="nowrap"><xsl:value-of select="Data_Do"/></td>
			<xsl:choose>
				<xsl:when test="War_Log">
					<td>
						<xsl:value-of select="War_Log"/>
					</td>
				</xsl:when>
				<xsl:when test="War_Całk">
					<td class="text-right">
						<xsl:value-of select="format-number(War_Całk, '0')"/>
					</td>
				</xsl:when>
				<xsl:when test="War_Rzecz">
					<td class="text-right">
						<xsl:value-of select="format-number(War_Rzecz, '0,00', 'pln')"/>
					</td>
				</xsl:when>
				<xsl:when test="War_Tekst">
					<td>
						<xsl:value-of select="War_Tekst"/>
					</td>
				</xsl:when>
				<xsl:when test="War_Dat">
					<td>
						<xsl:value-of select="War_Dat"/>
					</td>
				</xsl:when>
			</xsl:choose>
		</tr>
	</xsl:template>
</xsl:stylesheet>
