/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.slownikicentralne;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import java.time.LocalDate;
import java.util.NavigableMap;
import javax.annotation.Nonnull;

public final class Wymagania {
    public static final int WERSJA_SLOWNIKOW_CENTRALNYCH = 86;
    public static final LocalDate DATA_SLOWNIKOW_CENTRALNYCH = LocalDate.parse("2025-03-17");
    private static final NavigableMap<LocalDate, String> KOD_APLIKACJI = ImmutableSortedMap.of((Comparable)LocalDate.parse("1900-01-01"), (Object)"TT-TT/1.2/O", (Comparable)LocalDate.parse("2010-04-01"), (Object)"TT-TT/1.2/GP", (Comparable)LocalDate.parse("2013-12-09"), (Object)"TT-TT/1.03/GP", (Comparable)LocalDate.parse("2015-12-28"), (Object)"TT-TT/1.04/GP", (Comparable)LocalDate.parse("2023-10-24"), (Object)"TT-TT/1.05/GP");

    private Wymagania() {
    }

    public static String kodAplikacji(@Nonnull String dataTworzeniaDokumentu) {
        return Wymagania.kodAplikacji(LocalDate.parse(dataTworzeniaDokumentu));
    }

    public static String kodAplikacji(@Nonnull LocalDate naDzien) {
        Preconditions.checkNotNull((Object)naDzien);
        Preconditions.checkState((naDzien.getYear() > 1900 && naDzien.getYear() < 2100 ? 1 : 0) != 0);
        return KOD_APLIKACJI.floorEntry(naDzien).getValue();
    }
}

