<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.0'"/>				<!-- wersja arkusza XSLT -->

	<xsl:variable name="suma" select="'(sum'"/>
	<xsl:variable name="ogółem" select="'(ogółem'"/>
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator="," />
	<xsl:variable name="grosze" select="'###&#160;###&#160;###&#160;##0,00'" />
	<xsl:variable name="złote" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'948px'"/>
	<xsl:variable name="iloraz" select="'(ilor'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
												font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>; padding-top: 6px;
                                				}

                    		.cw0			{width:  340px;}
                    		.cw1			{width:  948px;}
                    		.cw2			{width:  432px;}  /*  3 * cw3  */
                    		.cw3			{width:  144px;}  /*  2 * cw4  */
                    		.cw4			{width:    72px;}
                    		.cw5			{width:  325px;}
                    		.cw6			{width:    15px;}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal;
                                					}
                   			 .contents	{height: 2.0em; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.0em; padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; padding-top: 24px;
                                				}
                    		.empty			{border: 0 0 0 0;}
                </style>
			</head>
			<body>
				<xsl:apply-templates select="Dożywianie"/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dożywianie">
		<xsl:apply-templates select="Metryczka"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Dział_I"/>
		<xsl:apply-templates select="Dział_II"/>
		<xsl:apply-templates select="Dział_III"/>
		<xsl:apply-templates select="Dział_IV"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/> <br/> <br/>
			</div>
		</xsl:if>
		<table border="2" cellspacing="0" cellpadding="8">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th colspan="3">
						<span  style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO PRACY I POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5, 00-513 Warszawa
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="300">
						<span  style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
						</span>
						<center>
							<xsl:for-each select="Nadawca">
								<table cellspacing="0" cellpadding="0">
									<tr>
										<td class="stamp" colspan="2">
											<xsl:value-of select="Pełna-nazwa"/>
										</td>
									</tr>
									<xsl:for-each select="Adres-pocztowy">
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Ulica-i-numer"/>
											</td>
										</tr>
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Kod-i-poczta"/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td class="stamp" style="font-size: 11px; text-align: left">
											<xsl:for-each select="Telefon">
                                 					           Tel. <xsl:apply-templates/> &#160;
					                        </xsl:for-each>
										</td>
										<td class="stamp" style="font-size: 11px; text-align: right">
											<xsl:for-each select="Faks">
					                                            &#160;Fax <xsl:apply-templates/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>
						</center>
					</td>
					<td rowspan="2" style="text-align: center; font-weight: bold;">
						<p style="font-size: 18px">
							<span style="font-size: 22px">Sprawozdanie</span><br/>z realizacji programu<br/>"POMOC PAŃSTWA W ZAKRESIE DOŻYWIANIA"
						</p>
						za
						<xsl:choose>
							<xsl:when test="Za-okres/Kwartał = 'I'">I-III</xsl:when>
							<xsl:when test="Za-okres/Kwartał = 'II'">I-VI</xsl:when>
							<xsl:when test="Za-okres/Kwartał = 'III'">I-IX</xsl:when>
							<xsl:otherwise>I-XII</xsl:otherwise>
						</xsl:choose>
						<xsl:value-of select="concat(' ', Za-okres/Rok, ' r.')"/>
					</td>
					<td width="300">
						<span  style="font-size: 11px; text-align: left;">
							Adresat:<br/>
						</span>
						<div class="stamp">
							<xsl:value-of select="Odbiorca/Pełna-nazwa"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<span  style="font-size: 11px; text-align: left;">
							Numer identyfikacyjny REGON:<br/>
						</span>
						<div style="font-weight: bold; text-align: center;">
							<xsl:value-of select="Nadawca/@Kod-REGON"/>
						</div>
					</td>
					<td>
						<div style="font-weight: bold; font-size: 13px; text-align: center;">
							Przekazać w terminie do
							<xsl:choose>
								<xsl:when test="../Nagłówek/Województwo">
									30
								</xsl:when>
								<xsl:otherwise>
									15
								</xsl:otherwise>
							</xsl:choose>
							dnia miesiąca<br/>następującego po okresie sprawozdawczym<sup>1)</sup>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<br/>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars"><sup>1)</sup></td>
				<td class="remark">
					Jeśli termin przekazania sprawozdania wypada na dzień wolny od pracy, to obowiązuje data pierwszego dnia roboczego po tym dniu.
                </td>
			</tr>
		</table>
		<br/> <br/> <br/> <br/> <br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table width="280">
			<caption>Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td>Imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td>Telefon:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td>Data wykonania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
		</table>

		
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="In-line-remarks">
		<sup>
			<xsl:choose>
				<xsl:when test="./@Pozycja='_I_02'"> 1)</xsl:when>
				<xsl:when test="./@Pozycja='_I_07'"> 2)</xsl:when>
				<xsl:when test="./@Pozycja='_I_20'"> 3)</xsl:when>
				<xsl:when test="./@Pozycja='_II_05'"> 1)</xsl:when>
				<xsl:when test="./@Pozycja='_III_09'"> 3)</xsl:when>
				<xsl:when test="./@Pozycja='_III_13'"> 4)</xsl:when>
			</xsl:choose>
		</sup>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Row-description">
		<xsl:param name="level"/><xsl:param name="prefix"/>
		<xsl:variable name="topbot" select="'margin-top: 4px; margin-bottom: 4px; margin-left: '"/>
		<xsl:variable name="indent" select="25"/>
		<td class="cw5 row_descr">
			<xsl:if test="not(preceding-sibling::*) and ../@Prefiks">
		 	        <p>
 					  <xsl:attribute name="style">
 						 <xsl:value-of select="concat($topbot, string($indent * ($level - 1)), 'px;')" />
					   </xsl:attribute>
					   <xsl:value-of select="../@Prefiks"/><br/>
				    </p>
			</xsl:if>
			<p>
				<xsl:if test="$level &gt;= 0">
					<xsl:attribute name="style">
						<xsl:value-of select="concat($topbot, string($indent * $level), 'px;')" />
					</xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="contains(@Opis, $suma)">
						<xsl:value-of select="substring-before(@Opis, $suma)"/>
						<br/>
						<span style="margin-top: 0.6em; font-size: 0.6em;">
							<xsl:value-of select="concat($suma, substring-after(@Opis, $suma))"/>
						</span>
					</xsl:when>
					<xsl:when test="contains(@Opis, $iloraz)">
						<xsl:value-of select="substring-before(@Opis, $iloraz)"/>
						<br/>
						<span style="margin-top: 0.6em; font-size: 0.6em;">
							<xsl:value-of select="concat($iloraz, substring-after(@Opis, $iloraz))"/>
						</span>
					</xsl:when>
					<xsl:when test="contains(@Opis, $ogółem)">
						<xsl:value-of select="substring-before(@Opis, $ogółem)"/>
						<xsl:call-template name="In-line-remarks"/>
						<br/>
						<span style="margin-top: 0.6em; font-size: 0.6em;">
							<xsl:value-of select="concat($ogółem, substring-before(substring-after(@Opis, $ogółem),'('))"/>
						</span>
						<br/>
						<span style="margin-top: 0.6em; font-size: 0.6em;">
							<xsl:value-of select="concat('(', substring-after(@Opis, ') ('))"/>
						</span>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@Opis"/>
						<xsl:call-template name="In-line-remarks"/>
					</xsl:otherwise>
				</xsl:choose>
			</p>
		</td>
		<td class="tab_row_no" style="width: 15px;">
			<xsl:value-of select="count(preceding::*[starts-with(@Pozycja, $prefix)])+
								  count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)])"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="with_format_check">
		<xsl:param name="contents"/>
		<xsl:param name="format"/>
		<xsl:param name="atrybucik">
			<xsl:value-of select="InputAttr"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="contains($contents, '.') and $format != $grosze">
				<td class="totals" style="background-color: red">
					<center><xsl:value-of select="'Format!'"/></center>
					<br/>
					<input name="{$atrybucik}" type="text" size="5" value="{$contents}" />
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<input name="{$atrybucik}" type="text" size="5" value="{$contents}" />
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="sumuj">
		<xsl:param name="wynik"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma"/>
		<xsl:param name="atrybucik">
			<xsl:value-of select="InputAttr"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="$suma!=''">
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="substring-after($suma,'+')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string(number($wynik)) = 'NaN'">
						<td class="totals" style="background-color: red">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:when test="string(number($contents)) != 'NaN'">
						<xsl:choose>
							<xsl:when test="$contents != $wynik">
								<td class="contents" style="background-color: red">
									<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
									<br/>
									<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="contents" style="background-color: red">
								<input name="{$atrybucik}" type="text" size="5" value="{$contents}" />
							  </td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<td class="contents" style="background-color: grey">
							<input name="{$atrybucik}" type="text" size="5" value="{$contents}" />
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_I">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_II">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_III">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_IV">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Dział">
		<xsl:param name="chapter" select="substring-after(name(.), '_')"/>
		<div>
 			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:value-of select="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('DZIAŁ ', $chapter, '.&#160;&#160;',@Opis)"/>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width">
			<xsl:choose>
				<xsl:when test="Inf-dot-kosztów">'600'</xsl:when>
				<xsl:when test="Inf-dot-świadczeń">'750'</xsl:when>
				<xsl:otherwise>'$width'</xsl:otherwise>
			</xsl:choose>
			</xsl:attribute>
			<thead>
				<tr>
					<th>
						<xsl:attribute name="colspan">
							<xsl:choose>
								<xsl:when test="Inf-dot-kosztów">4</xsl:when>
								<xsl:when test="Inf-dot-świadczeń">6</xsl:when>
								<xsl:otherwise>10</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						PROGRAM "POMOC PAŃSTWA W ZAKRESIE DOŻYWIANIA"
					</th>
				</tr>
				<tr>
					<th class="cw0" colspan="2">
						<xsl:attribute name="rowspan">
							<xsl:choose>
								<xsl:when test="Inf-ogółem">3</xsl:when>
								<xsl:when test="Inf-dot-posiłków">4</xsl:when>
								<xsl:when test="Inf-dot-świadczeń">2</xsl:when>
								<xsl:otherwise>1</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						WYSZCZEGÓLNIENIE
					</th>
					<xsl:choose>
						<xsl:when test="Inf-ogółem">
							<th class="cw4" rowspan="3">OGÓŁEM</th>
							<th class="cw4" rowspan="3">w tym na wsi</th>
							<th class="cw2" colspan="6">w tym:</th>
						</xsl:when>
						<xsl:when test="Inf-dot-posiłków">
							<th colspan="8">POSIŁEK <sup>1) 2)</sup></th>
						</xsl:when>
						<xsl:when test="Inf-dot-świadczeń">
							<th class="cw3" colspan="2">ZASIŁEK CELOWY</th>
							<th class="cw3" colspan="2">ŚWIADCZENIE RZECZOWE</th>
						</xsl:when>
						<xsl:otherwise>
							<th class="cw4">OGÓŁEM<br/>(w&#160;zł)&#160;<sup>1)</sup></th>
							<th class="cw4">w tym na wsi<br/>(w&#160;zł)&#160;<sup>1)</sup></th>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
				<xsl:if test="Inf-dot-posiłków">
					<th class="cw4" rowspan="3">OGÓŁEM</th>
					<th class="cw4" rowspan="3">w tym na wsi</th>
					<th class="cw2" colspan="6">w tym:</th>
				</xsl:if>
				<xsl:if test="not (Inf-dot-kosztów)">
					<xsl:if test="Inf-ogółem or Inf-dot-posiłków">
						<tr>
							<th class="cw3" colspan="2">dzieci do 7 roku życia</th>
							<th class="cw3" colspan="2">uczniowie do czasu ukończenia szkoły ponadgimnazjalnej</th>
							<th class="cw3" colspan="2">pozostałe osoby otrzymujące pomoc na podstawie art. 7 ustawy o&#160;pomocy społecznej</th>
						</tr>
					</xsl:if>
					<tr>
						<xsl:if test="not (Inf-dot-świadczeń)">
							<th class="cw4">OGÓŁEM</th>
							<th class="cw4">w tym na wsi</th>
						</xsl:if>
						<!--th class="cw4">OGÓŁEM</th>
						<th class="cw4">w tym na wsi</th-->
						<th class="cw4">OGÓŁEM</th>
						<th class="cw4">w tym na wsi</th>
						<th class="cw4">OGÓŁEM</th>
						<th class="cw4">w tym na wsi</th>
					</tr>
				</xsl:if>
				<tr>
					<td class="tab_col_no" colspan="2">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<xsl:if test="not (Inf-dot-kosztów)">
						<td class="tab_col_no">4</td>
						<td class="tab_col_no">5</td>
						<xsl:if test="not (Inf-dot-świadczeń)">
							<td class="tab_col_no">6</td>
							<td class="tab_col_no">7</td>
							<td class="tab_col_no">8</td>
							<td class="tab_col_no">9</td>
						</xsl:if>
					</xsl:if>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Inf-ogółem">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Inf-dot-świadczeń">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Inf-dot-posiłków">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Inf-dot-kosztów">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
			</tbody>
		</table>

		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<xsl:choose>
				<xsl:when test="Inf-ogółem">
					<tr>
						<td class="stars" width="6">1)</td>
						<td class="remark">należy uwzględnić również liczbę osób korzystających z posiłku z częściową odpłatnością.</td>
					</tr>
					<tr>
						<td class="stars" width="6">2)</td>
						<td class="remark">kwotę należy podać w zaokrągleniu do 1 zł.</td>
					</tr>
					<tr>
						<td class="stars" width="6">3)</td>
						<td class="remark">liczbę placówek wykazuje tylko ta gmina, na terenie której znajduje się placówka.</td>
					</tr>
				</xsl:when>
				<xsl:when test="Inf-dot-posiłków">
					<tr>
						<td class="stars" width="6">1)</td>
						<td class="remark">w przypadku posiłku informacje z decyzji należy skorygować o faktyczną realizację tego świadczenia.</td>
					</tr>
					<tr>
						<td class="stars" width="6">2)</td>
						<td class="remark">należy uwzględnić również informacje dotyczące osób korzystających z posiłku z częściową odpłatnością.</td>
					</tr>
					<tr>
						<td class="stars" width="6">3)</td>
						<td class="remark">przyznane decyzją całodzienne wyżywienie realizowane np. w przedszkolu należy traktować jako jedno świadczenie.</td>
					</tr>
					<tr>
						<td class="stars" width="6">4)</td>
						<td class="remark">koszt posiłków należy podać w zaokrągleniu do 1 zł.</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td class="stars" width="6">1)</td>
						<td class="remark">kwotę należy podać w zaokrągleniu do 1 zł</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-ogółem">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_I_'"/>
			</xsl:call-template>

			<xsl:call-template name="_III_contents"/>
		</tr>

		<xsl:apply-templates select="*/Inf-ogółem">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-dot-świadczeń">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_II_'"/>
			</xsl:call-template>

			<xsl:call-template name="_II_contents"/>
		</tr>

		<xsl:apply-templates select="*/Inf-dot-świadczeń">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-dot-posiłków">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_III_'"/>
			</xsl:call-template>

			<xsl:call-template name="_III_contents"/>
		</tr>

		<xsl:apply-templates select="*/Inf-dot-posiłków">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-dot-kosztów">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_IV_'"/>
			</xsl:call-template>

			<xsl:call-template name="_III_contents"/>
		</tr>

		<xsl:apply-templates select="*/Inf-dot-kosztów">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Rozbicie">
				<xsl:param name="format"/>
				<xsl:param name="subtree" select="name(.)"/>
				<xsl:choose>
					<xsl:when test="./@xsi:nil = 'true'">
						<td class="contents"><center>X</center></td>
						<td class="contents"><center>X</center></td>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="_2_level">
							<xsl:with-param name="subtree" select="$subtree"/>
							<xsl:with-param name="column" select="'Ogółem'"/>
							<xsl:with-param name="format" select="$format"/>
						</xsl:call-template>
						<xsl:call-template name="_2_level">
							<xsl:with-param name="subtree" select="$subtree"/>
							<xsl:with-param name="column" select="'Na-wsi'"/>
							<xsl:with-param name="format" select="$format"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_II_contents">
		<xsl:param name="format">
			<xsl:choose>
				<xsl:when test="@Grosze='false'">
					<xsl:value-of select="$złote"/>
				</xsl:when>
				<xsl:when test="@Grosze='true'">
					<xsl:value-of select="$grosze"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$liczba"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<xsl:for-each select="Dane/*">
			<xsl:call-template name="_0_level">
				<xsl:with-param name="subtree" select="name(.)"/>
				<xsl:with-param name="column" select="'Ogółem'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_0_level">
				<xsl:with-param name="subtree" select="name(.)"/>
				<xsl:with-param name="column" select="'Na-wsi'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_III_contents">
		<xsl:param name="subtree" select="'Dane'"/>
		<xsl:param name="format">
			<xsl:choose>
				<xsl:when test="@Grosze='false'">
					<xsl:value-of select="$złote"/>
				</xsl:when>
				<xsl:when test="@Grosze='true'">
					<xsl:value-of select="$grosze"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$liczba"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="Dane/Ogółem">
				<xsl:call-template name="_1_level">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="'Ogółem'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
				<xsl:call-template name="_1_level">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="'Na-wsi'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents"><center>X</center></td>
				<td class="contents"><center>X</center></td>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="Dane/Rozbicie/@xsi:nil='true'">
				<td class="contents"><center>X</center></td><td class="contents"><center>X</center></td>
				<td class="contents"><center>X</center></td><td class="contents"><center>X</center></td>
				<td class="contents"><center>X</center></td><td class="contents"><center>X</center></td>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="Dane/Rozbicie/*">
					<xsl:call-template name="Rozbicie">
						<xsl:with-param name="format" select="$format"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_level">
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:param name="atrybucik">
			<xsl:value-of select="$item/@InputAttr"/>
		</xsl:param>
		<td class="contents">
							<!--<xsl:value-of select="format-number($contents, $format)"/>aaa-->
							<input name="{$atrybucik}" type="text" size="5" value="{$contents}" />
						</td>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_totals">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="../../../Z-tego/*">
				<xsl:call-template name="_2_add_trees">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_add_trees">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="contents" select="Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_2_add_trees">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_1_level">
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:param name="atrybucik">
			<xsl:value-of select="$item/@InputAttr"/>
		</xsl:param>
		<td class="contents">
			<input name="{$atrybucik}" type="text" size="5" value="{$contents}" />
		</td>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_totals">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="Z-tego/*">
				<xsl:call-template name="_1_add_trees">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_add_trees">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="contents" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_1_add_trees">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_0_level">
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:param name="atrybucik">
			<xsl:value-of select="$item/@InputAttr"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="contains($contents, '.') and $format != $grosze">
				<td class="totals" style="background-color: red">
					<center><xsl:value-of select="'Format!'"/></center>
					<br/>
					<input name="{$atrybucik}" type="text" size="5" value="{$contents}" />
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<input name="{$atrybucik}" type="text" size="5" value="{$contents}" />
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_0_totals">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="../../Z-tego/*">
				<xsl:call-template name="_0_add_trees">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_0_add_trees">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="contents" select="Dane/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_0_add_trees">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
