<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.1'"/>
	<xsl:decimal-format grouping-separator="&#160;"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'944px'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>; padding-top: 6px;
                                				}

                    		.SKL_0		{width:  380px}
                    		.SKL_1		{width:  170px}
                    		.SKL_2		{width:    80px}
                    		.SKL_3		{width:  300px}
                    		.SKL_4		{width:  100px}
                    		.SKL_5		{width:  200px}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal; width: 20px;
                                					}
                   			 .contents	{height: 2.0em; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.0em; padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; width:  350px;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; padding-bottom: 8px;
                                				}
                    		.stars      	{padding-left: 2px; text-align: right; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; margin-top: 14px;
                                				}
                    		.empty		{border: 0 0 0 0;}
                </style>
			</head>
			<body>
				<xsl:apply-templates/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="SKŁ-ZDR">
		<xsl:apply-templates select="Metryczka"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Składki-wg-świadczeń"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<table border="2" cellspacing="0" cellpadding="4">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th colspan="3">
						<span  style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5, 00-513 Warszawa
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="290">
						<span  style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
						</span>
						<center>
							<xsl:for-each select="Nadawca">
								<table cellspacing="0" cellpadding="0">
									<tr>
										<td class="stamp" colspan="2">
											<xsl:value-of select="Pełna-nazwa"/>
										</td>
									</tr>
									<xsl:for-each select="Adres-pocztowy">
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Ulica-i-numer"/>
											</td>
										</tr>
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Kod-i-poczta"/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td class="stamp" style="font-size: 11px; text-align: left">
											<xsl:for-each select="Telefon">
                                 					           Tel. <xsl:apply-templates/> &#160;
					                                        </xsl:for-each>
										</td>
										<td class="stamp" style="font-size: 11px; text-align: right">
											<xsl:for-each select="Faks">
					                                            &#160;Fax <xsl:apply-templates/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>
						</center>
					</td>
					<td rowspan="3" style="text-align: center; font-weight: bold;">
						<span style="font-size: large;"><xsl:value-of select="name(..)"/></span>
						<br/>
						<p style="font-size: 13px">
                            			Składki na ubezpieczenie <xsl:value-of select="concat(substring(../Składki-wg-świadczeń/@Opis, 1, string-length(../Składki-wg-świadczeń/@Opis) - 1), 'e')"/>
						</p>
                    za I -
                    <xsl:choose>
							<xsl:when test="Za-okres/Kwartał = 'I'">III</xsl:when>
							<xsl:when test="Za-okres/Kwartał = 'II'">VI</xsl:when>
							<xsl:when test="Za-okres/Kwartał = 'III'">IX</xsl:when>
							<xsl:otherwise>XII</xsl:otherwise>
						</xsl:choose>
					</td>
					<td rowspan="3" width="300">
						<div style="font-weight: bold; font-size: 13px; text-align: left;">
							Przekazać w terminie do 15-tego następnego miesiąca po zakończeniu okresu sprawozdawczego
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<span  style="font-size: 11px; text-align: left;">
							Numer identyfikacyjny jednostki sprawozdawczej:<br/>
						</span>
						<div style="font-weight: bold; text-align: center;">
							<xsl:value-of select="Nadawca/@Kod-REGON"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<span  style="font-size: 11px; text-align: left;">
							Województwo:<br/>
						</span>
						<div style="font-weight: bold; text-align: center;">
							<xsl:value-of select="../Nagłówek/Województwo"/>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<br/><xsl:value-of select="Opis"/><br/>
			</div>
		</xsl:if>
		<br/>
		<xsl:if test="(Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III') and Kod/Cyklu-sprawozdawczego != 3 or
					(Za-okres/Kwartał = 'II' or Za-okres/Kwartał = 'IV') and Kod/Cyklu-sprawozdawczego != 4">
			<!--div style="font-size: large; text-align: center; color: red;">
				Niepoprawny kod cyklu sprawozdawczego!
			</div>
			<br/> <br/> <br/> <br/> <br/-->
		</xsl:if>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table border="0">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th width="370" align="left">Imię, nazwisko i telefon osoby, która sporządziła sprawozdanie</th>
					<th>Miejscowość i data</th>
					<th>Podpis Dyrektora</th>
				</tr>
			</thead>
			<tbody>
			<tr>
				<td>
					<xsl:value-of select="concat($kto/Imię-i-nazwisko, ', tel. ', $kto/Telefon)"/>
				</td>
				<td align="center">
					<xsl:value-of select="concat(substring(Metryczka/Nadawca/Adres-pocztowy/Kod-i-poczta, 8), ', ', $kto/Data-wykonania)"/>
				</td>
			</tr>
			</tbody>
		</table>
		<br/>
		<hr align="left" width="400" noshade="1" size="1"/>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars">*
	                    </td>
				<td class="remark">
					liczba osób otrzymujących na podstawie decyzji dany rodzaj świadczenia, a w przypadku rodzin
					zastępczych na podstawie umowy zawartej ze starostą o pełnienie funkcji rodziny zastępczej liczba
					osób otrzymujących wynagrodzenie
	                    </td>
			</tr>
			<tr>
				<td class="stars">**
	                    </td>
				<td class="remark">
					w zaokrągleniu do 1 zł
	                    </td>
			</tr>
		</table>

		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="xslt_ver" style="text-align: left;">
					Wersja szablonu XSLT: <xsl:value-of select="$wersja"/>
				</td>
				<td class="xslt_ver" style="text-align: right;">
					<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
					<xsl:if test="system-property('msxsl:version')">
						<xsl:value-of select="concat(', MSXML: ', system-property('msxsl:version'))"/>
					</xsl:if>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="prefix"/>
		<td class="row_descr">
			<p>
				<xsl:value-of select="@Opis"/>
			</p>
		</td>
		<td class="tab_row_no">
			<xsl:value-of select="count(preceding::*[starts-with(@Pozycja, $prefix)])+
								  count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)])"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Składki-wg-świadczeń">
		<xsl:param name="width" select="944"/>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th class="SKL_0" colspan="2" rowspan="3">WYSZCZEGÓLNIENIE<br/>(na podstawie ustawy z dn. 27.08.2004 r.<br/>o świadczeniach opieki zdrowotnej finans.<br/>ze środków publicznych art. 66 ust. 1)</th>
					<th class="SKL_1" rowspan="3">Liczba świadczeniobiorców<sup>*</sup>, za których jest opłacana składka <xsl:value-of select="@Opis"/></th>
					<th class="SKL_2" rowspan="3">Liczba składek należnych</th>
					<th class="SKL_3" colspan="3">Koszt składek należnych w zł<sup>**</sup></th>
				</tr>
				<tr>
					<th class="SKL_4" rowspan="2">ogółem (4 + 5)</th>
					<th class="SKL_5" colspan="2">z tego:</th>
				</tr>
				<tr>
					<th class="SKL_4">opłaconych</th>
					<th class="SKL_4">nieopłaconych</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates/>
			</tbody>
		</table>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Liczba-i-koszt-składek">
		<xsl:param name="subtree" select="'Koszt-składek_należnych'"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_SKL-ZDR_'"/>
			</xsl:call-template>

			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Liczba-świadczeniobiorców'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Liczba-składek'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>

			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Ogółem'"/>
				<xsl:with-param name="format" select="$kwota"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Opłaconych'"/>
				<xsl:with-param name="format" select="$kwota"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Nieopłaconych'"/>
				<xsl:with-param name="format" select="$kwota"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_1_column">
		<xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="../*[last()]/@Pozycja = ./@Pozycja and not($item/@xsi:nil)">
				<xsl:call-template name="_1_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="nodeset" select="../*[position() != last()]/*[name(.) = $column]"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_totals">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="result">
			<xsl:value-of select="sum($nodeset)"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="string(number($contents)) != 'NaN' and $contents != 0">
				<xsl:choose>
					<xsl:when test="string(number($result)) = 'NaN'">
						<td class="totals" style="background-color: red">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:when test="$contents != $result">
						<td class="contents" style="background-color: red">
							<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
							<br/>
							<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($result, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($result, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_2_column">
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="name(*[name(.) = $subtree]/*[position()=3]) = name($item)">
				<xsl:call-template name="_2_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="nodeset" select="*[name(.) = $subtree]/*[name(.) != $column]"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="../*[last()]/@Pozycja = ./@Pozycja">
				<xsl:call-template name="_2_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="nodeset" select="../*[position() != last()]/*[name(.) = $subtree]/*[name(.) = $column]"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_totals">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="result">
			<xsl:value-of select="sum($nodeset)"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="string(number($contents)) != 'NaN'">
				<xsl:choose>
					<xsl:when test="string(number($result)) = 'NaN'">
						<td class="totals" style="background-color: red">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:when test="$contents != $result">
						<td class="contents" style="background-color: red">
							<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
							<br/>
							<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($result, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($result, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
