<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.1'"/>
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="etat" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'948'"/>
	<xsl:variable name="suma" select="'(w. '"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
												font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>px;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>px;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>px; padding-top: 6px;
                                				}

                    		.MRPiPS_03_6_0        {width:  460px}
                    		.MRPiPS_03_6_1        {width:  100px}
							.MRPiPS_03_6_2        {width:  150px}
                    		.MRPiPS_03_6_0a      {width:  460px}
                    		.MRPiPS_03_6_0b      {width:    20px}

                    		.MRPiPS_03_8_0		{width:  260px}
                    		.MRPiPS_03_8_1		{width:  640px}
                    		.MRPiPS_03_8_2		{width:    93px}
                    		.MRPiPS_03_8_0a	{width:  280px}
                    		.MRPiPS_03_8_0b	{width:    20px}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal;
                                					}
                   			 .contents	{height: 2.0em; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.0em; padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				padding-bottom: 4px; font-weight: normal;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; padding-top: 18px;
                                				}
                    		.empty		{border: 0 0 0 0;}
				</style>
			</head>
			<body>
				<xsl:apply-templates select="MRPiPS-03"/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="MRPiPS-03">
		<xsl:apply-templates select="Metryczka"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Dział_2A"/>
		<xsl:apply-templates select="Dział_2B"/>
		<xsl:apply-templates select="Dział_2C-1"/>
		<xsl:apply-templates select="Dział_2C-3"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/>
				<br/>
				<br/>
			</div>
		</xsl:if>
		<table border="2" cellspacing="0" cellpadding="8">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th colspan="3">
						<span style="font-size: 16px; font-weight: bold;">
							MINISTERSTWO RODZINY, PRACY I POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5, 00-513 Warszawa
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="300">
						<span style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
						</span>
						<center>
							<xsl:for-each select="Nadawca">
								<table cellspacing="0" cellpadding="0">
									<tr>
										<td class="stamp" colspan="2">
											<xsl:value-of select="Pełna-nazwa"/>
										</td>
									</tr>
									<xsl:for-each select="Adres-pocztowy">
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Ulica-i-numer"/>
											</td>
										</tr>
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Kod-i-poczta"/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td class="stamp" style="font-size: 11px; text-align: left">
											<xsl:for-each select="Telefon">
											   Tel. <xsl:apply-templates/> &#160;
											</xsl:for-each>
										</td>
										<td class="stamp" style="font-size: 11px; text-align: right">
											<xsl:for-each select="Faks">
												&#160;Fax <xsl:apply-templates/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>
						</center>
					</td>
					<td rowspan="2" style="text-align: center; font-weight: bold;">
						<span style="font-size: large;">
							<xsl:choose>
								<xsl:when test="Za-okres/Kwartał = 'I'">MK1</xsl:when>
								<xsl:otherwise>MK2</xsl:otherwise>
							</xsl:choose>
						</span>
						<br/>
						<p style="font-size: 13px">
                            Meldunek kwartalny z udzielonych świadczeń<br/>pomocy społecznej - pieniężnych, w naturze i usługach
                         </p>
                         za 
						<xsl:choose>
							<xsl:when test="Za-okres/Kwartał = 'I'">I-III</xsl:when>
							<xsl:otherwise>I-IX</xsl:otherwise>
						</xsl:choose>
						<xsl:value-of select="concat(' ', Za-okres/Rok, ' r.')"/>
					</td>
					<td width="300">
						<span style="font-size: 11px; text-align: left;">
							Adresat:<br/>
						</span>
						<div class="stamp">
							<xsl:value-of select="Odbiorca/Pełna-nazwa"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<span style="font-size: 11px; text-align: left;">
							Numer identyfikacyjny REGON:<br/>
						</span>
						<div style="font-weight: bold; text-align: center;">
							<xsl:value-of select="Nadawca/@Kod-REGON"/>
						</div>
					</td>
					<td>
						<div style="font-weight: bold; font-size: 13px; text-align: center;">
							Przekazać / wysłać:<br/>
							<xsl:choose>
								<xsl:when test="../Nagłówek/Województwo or ../Nagłówek/Ministerstwo">
									<xsl:choose>
										<xsl:when test="Za-okres/Kwartał = 'I'">do 20 kwietnia za I kwartał</xsl:when>
										<xsl:otherwise>do 20 października za III kwartał</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									Termin określa urząd wojewódzki.
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<br/>
		<br/>
		<br/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table width="700">
			<caption>Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td width="160">Imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td width="160">Telefon:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td width="160">Data wykonania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
			<tr>
				<td width="160">e-mail:</td>
				<td>
					<xsl:value-of select="$kto/E-mail"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="level"/>
		<xsl:param name="prefix"/>
		<xsl:variable name="topbot" select="'margin-top: 4px; margin-bottom: 4px; margin-left: '"/>
		<xsl:variable name="topbot2" select="'margin-top: 4px; margin-bottom: 0px; margin-left: '"/>
		<xsl:variable name="indent" select="25"/>
		<td class="MRPiPS_03_6_0a row_descr">
			<xsl:if test="not(preceding-sibling::*) and ../@Prefiks">
				<p>
					<xsl:attribute name="style"><xsl:value-of select="concat($topbot2, string($indent * ($level - 1)), 'px;')"/></xsl:attribute>
					<xsl:value-of select="../@Prefiks"/>
					<br/>
				</p>
			</xsl:if>
			<xsl:if test="@Pozycja='_2B_01'">
				<xsl:value-of select="@Opis"/>
				<sup>1)</sup>
			</xsl:if>
			<xsl:if test="@Pozycja != '_2B_01'">
				<p>
					<xsl:if test="$level &gt;= 0">
						<xsl:attribute name="style"><xsl:value-of select="concat($topbot, string($indent * $level), 'px;')"/></xsl:attribute>
					</xsl:if>
					<xsl:choose>
						<xsl:when test="contains(@Opis, $suma)">
							<xsl:value-of select="substring-before(@Opis, $suma)"/>
							<br/>
							<span style="margin-top: 0.6em; font-size: 0.6em;">
								<xsl:value-of select="concat($suma, substring-after(@Opis, $suma))"/>
							</span>
						</xsl:when>
						<xsl:when test="@Pozycja='_2A_01'">
							<xsl:value-of select="@Opis"/>
							<sup>3)</sup>
						</xsl:when>
						<xsl:when test="@Pozycja='_2C-3_09'">
							<xsl:value-of select="substring-before(@Opis, ')')"/>)<sup>1)</sup>
							<xsl:value-of select="substring-after(@Opis, ')')"/>
						</xsl:when>
						<xsl:when test="@Pozycja='_2C-3_13'">
							<xsl:value-of select="substring-before(@Opis, ')')"/>)<sup>2)</sup>
							<xsl:value-of select="substring-after(@Opis, ')')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<!-- obsługa łamania pozycji _2B_37 _2B_38 -->
								<xsl:when test="@Pozycja = '_2B_37'">
									<xsl:value-of select="substring-before(@Opis,' na')"/>
									<br/>
									<xsl:value-of select="concat('na',substring-after(@Opis,' na'))"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@Opis"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</p>
			</xsl:if>
		</td>
		<td class="MRPiPS_03_6_0b tab_row_no">
			<xsl:value-of select="count(preceding::*[starts-with(@Pozycja, $prefix)])+
								  count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)])"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="sumuj">
		<xsl:param name="wynik"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma"/>
		<xsl:choose>
			<xsl:when test="$suma!=''">
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="substring-after($suma,'+')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string(number($wynik)) = 'NaN'">
						<td class="totals" style="background-color: red">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:when test="string(number($contents)) != 'NaN'">
						<xsl:choose>
							<xsl:when test="$contents != $wynik">
								<td class="contents" style="background-color: red">
									<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
									<br/>
									<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals">
									<xsl:value-of select="format-number($wynik, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($wynik, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_2A">
		<xsl:call-template name="Dział_2ABC"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_2B">
		<xsl:call-template name="Dział_2ABC"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_2C-3">
		<xsl:call-template name="Dział_2ABC"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Dział_2ABC">
		<xsl:param name="chapter" select="substring-after(name(.), '_')"/>
		<xsl:param name="atrybucik">
			<xsl:value-of select="InputAttr"/>
		</xsl:param>
		<div>
			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em; margin-top: 1.2em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat(substring-before(@Opis, '.'),'. ')"/>
			<div style="margin-top: -1.2em; margin-left: 6em">
				<xsl:value-of select="substring-after(@Opis, '.')"/>
			</div>
			<xsl:if test="Uchodźcom">
				<p style="margin-top: 0.5em; text-align: left">POMOC CUDZOZIEMCOM, KTÓRZY UZYSKALI STATUS UCHODŹCY, OCHRONĘ UZUPEŁNIAJĄCĄ LUB PRZYBYWAJĄ NA TERYTORIUM RP NA PODSTAWIE ZEZWOLENIA NA POBYT CZASOWY</p>
			</xsl:if>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th class="MRPiPS_03_6_0" colspan="2">FORMY POMOCY</th>
					<th class="MRPiPS_03_6_1">
						LICZBA OSÓB, KTÓRYM PRZYZNANO DECYZJĄ ŚWIADCZENIA
						<xsl:if test="Zlecone-gminom">
							<sup>1)</sup>
						</xsl:if>
					</th>
					<th class="MRPiPS_03_6_1">LICZBA ŚWIADCZEŃ</th>
					<th class="MRPiPS_03_6_1">KWOTA ŚWIADCZEŃ
						<br/>w zł
					</th>
					<th class="MRPiPS_03_6_1">LICZBA<br/>RODZIN
						<xsl:if test="Zlecone-gminom">
							<sup>1)</sup>
						</xsl:if>
					</th>
					<th class="MRPiPS_03_6_1">LICZBA OSÓB W RODZINACH
						<xsl:if test="Zlecone-gminom">
							<sup>1)</sup>
						</xsl:if>
					</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Zlecone-gminom[@Pozycja = '_2A_11']">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Zlecone-gminom[@Pozycja = '_2A_10']">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Zlecone-gminom[@Pozycja = '_2A_12' or @Pozycja = '_2A_15']">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Zlecone-gminom[@Pozycja = '_2A_18']">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Własne-gmin[@Pozycja != '_2B_30' and @Pozycja != '_2B_27' and @Pozycja != '_2B_28' and @Pozycja != '_2B_29']">
					<xsl:with-param name="margin" select="-1"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Własne-gmin[@Pozycja = '_2B_27']">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Własne-gmin[@Pozycja = '_2B_28']">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Własne-gmin[@Pozycja = '_2B_29']">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Uchodźcom">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
			</tbody>
		</table>
		<!--
			Wstawka dla zasad ustalonych na szkoleniu 14 - 15 grudnia 2004 r.
		-->
		<xsl:if test="Własne-gmin[@Pozycja = '_2B_30']">
			<br/>
			<table border="2" cellspacing="0" cellpadding="0">
				<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
				<tr>
					<th width="422" colspan="2"/>
					<!--xsl:value-of select="Własne-gmin[@Pozycja = '_2B_30']/@Opis"/></th-->
					<th class="MRPiPS_03_6_1">LICZBA OSÓB, KTÓRYM PRZYZNANO DECYZJĄ ŚWIADCZENIE</th>
					<th class="MRPiPS_03_6_1">LICZBA ŚWIADCZEŃ</th>
					<th class="MRPiPS_03_6_1">
						KWOTA ŚWIADCZEŃ<br/>w zł
					</th>
					<th class="MRPiPS_03_6_1">LICZBA<br/>RODZIN</th>
					<th class="MRPiPS_03_6_1">LICZBA OSÓB W RODZINACH</th>
				</tr>
				<tr>
					<xsl:for-each select="Własne-gmin[@Pozycja = '_2B_30']">
						<xsl:call-template name="Row-description">
							<xsl:with-param name="level" select="0"/>
							<xsl:with-param name="prefix" select="'_2B_'"/>
						</xsl:call-template>
						<xsl:call-template name="_2AB_contents"/>
					</xsl:for-each>
				</tr>
			</table>
		</xsl:if>
		<!--
			Koniec  wstawki dla zasad ustalonych na szkoleniu 14 - 15 grudnia 2004 r.
		-->
		<table style="width: 948px; padding-top: 6px;" border="0" cellspacing="0" cellpadding="0">
			<xsl:choose>
				<xsl:when test="Zlecone-gminom">
					<tr>
						<td class="stars">1)</td>
						<td class="remark">
								W kolumnie 1, 4 i 5 podana jest liczba osób otrzymujących decyzją świadczenie, liczba rodzin i liczba osób w tych rodzinach przy zachowaniu zasady, że osoba (rodzina) została wymieniona TYLKO raz bez względu na liczbę, kwotę i częstotliwość otrzymanych świadczeń.
							</td>
					</tr>
					<tr>
						<td class="stars">1)</td>
						<td class="remark">
								W przypadku świadczeń pomocy społecznej, które nie wymagają wydania decyzji administracyjnej (wiersz: 9) w kolumnie 1 za osobę otrzymującą decyzją świadczenie należy uznać świadczeniobiorcę, czyli osobę, która korzysta z tego świadczenia.
							</td>
					</tr>
				</xsl:when>
				<xsl:when test="Własne-gmin">
					<tr>
						<td class="stars">1)</td>
						<td class="remark">
								W wierszu 1 należy uwzględnić wszystkie formy pomocy przyznawanej w ramach zadań własnych gmin.<br/>
								W wierszu 1 oraz w odpowiednich wierszach, w zależności od typu przyznanej pomocy należy 
								uwzględnić każdą osobę otrzymującą pomoc w ramach programów finansowanych ze środków europejskich.<br/>
								Wiersz 1 nie obejmuje odpłatności gminy za pobyt w domu pomocy społecznej.
							</td>
					</tr>
					<tr>
						<td class="remark" colspan="2">
								We wszystkich wierszach działu <xsl:value-of select="$chapter"/> - analogicznie 
								jak w całym sprawozdaniu MRPiPS-03 - należy podać liczbę osób otrzymujących decyzją świadczenie, liczbę rodzin i liczbę osób w tych rodzinach 
								przy zachowaniu zasady, <br/>że osobę / rodzinę / wymieniono TYLKO raz bez względu na liczbę, kwotę i częstotliwość otrzymanych świadczeń.
							</td>
					</tr>
				</xsl:when>
				<xsl:when test="Uchodźcom">
					<tr>
						<td class="stars">1)</td>
						<td class="remark">
						Dot. cudzoziemców, którzy przybywają na terytorium Rzeczypospolitej Polskiej na podstawie zezwolenia na pobyt czasowy udzielonego w związku z okolicznością, 
						o której mowa w art. 159 ust. 1 pkt 1 lit. c ustawy z dnia 12 grudnia 2013 r. o cudzoziemcach.
					</td>
					</tr>
					<tr>
						<td class="stars">2)</td>
						<td class="remark">
						Dot. cudzoziemców, którzy przybywają na terytorium Rzeczypospolitej Polskiej na podstawie zezwolenia na pobyt czasowy udzielonego w związku z okolicznością, 
						o której mowa w art. 159 ust. 1 pkt 1 lit. d ustawy z dnia 12 grudnia 2013 r. o cudzoziemcach.
					</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td class="stars">1)</td>
						<td class="remark">
								W kolumnie 1, 4 i 5 podana jest liczba osób otrzymujących decyzją świadczenie, liczba rodzin i liczba osób w tych rodzinach przy zachowaniu zasady, 
								że osoba (rodzina) została wymieniona TYLKO raz bez względu na liczbę, kwotę i częstotliwość otrzymanych.
							</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Zlecone-gminom">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_2A_'"/>
			</xsl:call-template>
			<xsl:call-template name="_2AB_contents"/>
		</tr>
		<xsl:apply-templates select="*/Zlecone-gminom">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Własne-gmin">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_2B_'"/>
			</xsl:call-template>
			<xsl:call-template name="_2AB_contents"/>
		</tr>
		<xsl:apply-templates select="*/Własne-gmin">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Uchodźcom">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_2C-3_'"/>
			</xsl:call-template>
			<xsl:call-template name="_2AB_contents"/>
		</tr>
		<xsl:apply-templates select="*/Uchodźcom">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2AB_contents">
		<xsl:param name="subtree" select="'Udzielone-świadczenia'"/>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Osób-w-decyzjach'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-świadczeń'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Kwota-świadczeń'"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-rodzin'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Osób-w-rodzinach'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_column">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="atrybucik">
			<xsl:value-of select="$item/@InputAttr"/>
		</xsl:param>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="Z-tego and not($item/@xsi:nil)">
				<td class="totals">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<input type="number" step="1" min="0" name="{$atrybucik}" value="{$contents}" onchange="this.value = this.valueAsNumber.toFixed(0);"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<input type="number" step="1" min="0" name="{$atrybucik}" value="{$contents}" onchange="this.value = this.valueAsNumber.toFixed(0);"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_total">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="Z-tego/*">
				<xsl:call-template name="_2_add_tree">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_add_tree">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_2_add_tree">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_2C-1">
		<div>
			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em; margin-top: 1.2em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat(substring-before(@Opis, '.'),'. ')"/>
			<div style="margin-top: -1.2em; margin-left: 6em">
				<xsl:value-of select="substring-after(@Opis, '.')"/>
			</div>
			<p style="margin-top: 0.5em; text-align: left">POMOC MAJĄCA NA CELU ŻYCIOWE USAMODZIELNIENIE I INTEGRACJĘ ZE ŚRODOWISKIEM</p>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th class="MRPiPS_03_8_0" colspan="2" rowspan="3">WYSZCZEGÓLNIENIE</th>
					<th class="MRPiPS_03_8_0" style="padding-top: 4px; padding-bottom: 4px;" colspan="7">ZADANIA WŁASNE</th>
				</tr>
				<tr>
					<th class="MRPiPS_03_8_2" rowspan="2">POMOC PIENIĘŻNA NA USAMODZIEL-<br/>NIENIE</th>
					<th class="MRPiPS_03_8_2" rowspan="2">POMOC PIENIĘŻNA NA KONTYNUO-<br/>WANIE NAUKI</th>
					<th class="MRPiPS_03_8_2" rowspan="2">UZYSKANIE ODPOWIEDNICH WARUNKÓW MIESZKANIO-<br/>WYCH</th>
					<th class="MRPiPS_03_8_2">w tym</th>
					<th class="MRPiPS_03_8_2" rowspan="2">POMOC NA ZAGOSPODARO-<br/>WANIE W FORMIE RZECZOWEJ</th>
					<th class="MRPiPS_03_8_2" rowspan="2">POMOC W UZYSKANIU ZATRUDNIENIA</th>
					<th class="MRPiPS_03_8_2" rowspan="2">PRACA SOCJALNA</th>
				</tr>
				<tr>
					<th class="MRPiPS_03_8_2">w mieszkaniu chronionym</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
					<td class="tab_col_no">7</td>
					<td class="tab_col_no">8</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Placówki-PCPR"/>
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Placówki-PCPR">
		<xsl:call-template name="_2C-1_row">
			<xsl:with-param name="level" select="0"/>
			<xsl:with-param name="rowdescr" select="@Opis"/>
			<xsl:with-param name="format" select="$kwota"/>
			<xsl:with-param name="subtree" select="3"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2C-1_row">
		<xsl:param name="prefix" select="'_2C-1'"/>
		<xsl:param name="level"/>
		<xsl:param name="rowdescr"/>
		<xsl:param name="format"/>
		<xsl:param name="subtree"/>
		<xsl:variable name="topbot" select="'margin-top: 4px; margin-bottom: 4px; margin-left: '"/>
		<xsl:variable name="indent" select="25"/>
		<tr>
			<td class="MRPiPS_03_8_0a row_descr">
				<p>
					<xsl:if test="$level &gt;= 0">
						<xsl:attribute name="style"><xsl:value-of select="concat($topbot, string($indent * $level), 'px;')"/></xsl:attribute>
					</xsl:if>
					<xsl:value-of select="$rowdescr"/>
				</p>
			</td>
			<td class="MRPiPS_03_8_0b tab_row_no">
				<xsl:value-of select="'1'"/>
			</td>
			<xsl:for-each select="*/*[count(preceding-sibling::*) = $subtree]">
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string(./@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<input type="number" step="1" min="0" name="{@InputAttr}" value="{.}" onchange="this.value = this.valueAsNumber.toFixed(0);"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:for-each>
		</tr>
	</xsl:template>
</xsl:stylesheet>
<!-- Stylus Studio meta-information - (c) 2004-2008. Progress Software Corporation. All rights reserved.

<metaInformation>
	<scenarios/>
	<MapperMetaTag>
		<MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/>
		<MapperBlockPosition></MapperBlockPosition>
		<TemplateContext></TemplateContext>
		<MapperFilter side="source"></MapperFilter>
	</MapperMetaTag>
</metaInformation>
-->
