<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.1'"/>
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="ułamek" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="procent" select="'###&#160;###&#160;###&#160;##0,00%'"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'944px'"/>
	<!--
	=============================================================================================
	-->
	<xsl:include href="REGULY.xslt"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
							.blad           {background-color: red; text-align: right}
				            .pole           {background-color: white; text-align: right}

                     		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}

                    		.SKL_0		{width:  380px}
                    		.SKL_1		{width:  300px}
                    		.SKL_2		{width:    80px}
                    		.SKL_3		{width:  300px}
                    		.SKL_4		{width:  100px}
                    		.SKL_5		{width:  200px}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal; width: 20px;
                                					}
                   			 .contents	{height: 2.0em; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.0em; padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; width:  350px;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; padding-bottom: 8px;
                                				}
                    		.stars      	{padding-left: 2px; text-align: right; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; margin-top: 14px;
                                				}
                    		.empty		{border: 0 0 0 0;}
                </style>
                <xsl:call-template name="regulyStyle"/>
			</head>
			<body>
				<xsl:call-template name="regulyScript"/>
				<!-- Modyfikacja na potrzeby pokazywania błedów -->
				<div id="Reguly">
					<xsl:call-template name="reguly"/>
				</div>
				<div id="Sprawozdanie">
					<xsl:apply-templates/>
				</div>
				<xsl:call-template name="zaznaczWybrana"/>
				<!-- Koniec modyfikacja na potrzeby pokazywania błędów -->
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="DPS-PÓŁROCZNE">
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Tabela-1"/>
		<xsl:apply-templates select="Tabela-2"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Metryczka">
		<xsl:param name="width"/>
		<xsl:param name="table_name"/>
		<xsl:param name="table_title"/>
		<xsl:param name="table_subtitle"/>
		<xsl:for-each select="../Metryczka">
			<table border="2" cellspacing="0" cellpadding="4">
				<xsl:attribute name="style"><xsl:if test="$table_name != 'Tabela 1'">
 					page-break-before: always;
 				</xsl:if>
  				width: <xsl:number value="$width"/>px;
			</xsl:attribute>
				<thead>
					<tr>
						<th colspan="3">
							<span style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO PRACY I POLITYKI SPOŁECZNEJ<br/>ul. Nowogrodzka 1/3/5, 00-513 Warszawa
						</span>
						</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td width="290">
							<span style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
							</span>
							<center>
								<xsl:for-each select="Nadawca">
									<table cellspacing="0" cellpadding="0">
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Pełna-nazwa"/>
											</td>
										</tr>
										<xsl:for-each select="Adres-pocztowy">
											<tr>
												<td class="stamp" colspan="2">
													<xsl:value-of select="Ulica-i-numer"/>
												</td>
											</tr>
											<tr>
												<td class="stamp" colspan="2">
													<xsl:value-of select="Kod-i-poczta"/>
												</td>
											</tr>
										</xsl:for-each>
										<tr>
											<td class="stamp" style="font-size: 11px; text-align: left">
												<xsl:for-each select="Telefon">
                                 					           Tel. <xsl:apply-templates/> &#160;
					                                        </xsl:for-each>
											</td>
											<td class="stamp" style="font-size: 11px; text-align: right">
												<xsl:for-each select="Faks">
					                                            &#160;Fax <xsl:apply-templates/>
												</xsl:for-each>
											</td>
										</tr>
									</table>
								</xsl:for-each>
							</center>
						</td>
						<td rowspan="3" style="text-align: center; font-weight: bold;">
							<!--span style="font-size: large;"><xsl:value-of select="concat(name(..), ': ', $table_name)"/></span-->
							<span style="font-size: large;">
								<xsl:value-of select="$table_name"/>
							</span>
							<br/>
							<p style="font-size: 13px">
								<xsl:value-of select="$table_title"/>
							</p>
							<xsl:value-of select="$table_subtitle"/>
						</td>
						<td width="195">
							<div style="font-weight: bold; font-size: 13px; text-align: left;">
							Część&#160;&#160;85 - Budżety wojewodów<br/>Dział&#160;852 - Pomoc społeczna<br/>Rozdział 85202
						</div>
						</td>
					</tr>
					<tr>
						<td>
							<span style="font-size: 11px; text-align: left;">
							Numer identyfikacyjny jednostki sprawozdawczej:<br/>
							</span>
							<div style="font-weight: bold; text-align: center;">
								<xsl:value-of select="Nadawca/@Kod-REGON"/>
							</div>
						</td>
						<td rowspan="3" width="195">
							<div style="font-weight: bold; font-size: 13px; text-align: left;">
							Przekazać do 31 lipca 2008 r.<!--sup>1)</sup-->
							</div>
						</td>
					</tr>
					<tr>
						<td>
							<span style="font-size: 11px; text-align: left;">
							Województwo:<br/>
							</span>
							<div style="font-weight: bold; text-align: center;">
								<xsl:value-of select="../Nagłówek/Województwo"/>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
			<xsl:if test="Opis and Opis != ''">
				<div>
					<xsl:attribute name="style">
					color: red; font-family: Tahoma, Verdana;
					font-size: 14px; font-weight: bold; text-align: right;
					width: <xsl:value-of select="$width"/>px;
			</xsl:attribute>
					<br/>
					<xsl:value-of select="Opis"/>
					<br/>
				</div>
			</xsl:if>
			<br/>
			<xsl:if test="(Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III') and Kod/Cyklu-sprawozdawczego != 2 or
					Za-okres/Kwartał = 'II' and Kod/Cyklu-sprawozdawczego != 3  or Za-okres/Kwartał = 'IV' and Kod/Cyklu-sprawozdawczego != 4">
				<div style="font-size: large; text-align: center; color: red;">
				Niepoprawny kod cyklu sprawozdawczego!
			</div>
				<br/>
				<br/>
				<br/>
				<br/>
				<br/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:param name="width"/>
		<xsl:variable name="kto" select="../Nagłówek/Osoba-sporządzająca"/>
		<table border="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th width="390" align="left">Imię, nazwisko i numer telefonu osoby, która sporządziła informację</th>
					<th>Miejscowość i data</th>
					<th>DYREKTOR</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td>
						<xsl:value-of select="concat($kto/Imię-i-nazwisko, ', tel. ', $kto/Telefon)"/>
						<br/>
						<xsl:value-of select="concat('E-mail: ', $kto/E-mail)"/>
					</td>
					<td align="center">
						<xsl:value-of select="concat(substring(../Metryczka/Nadawca/Adres-pocztowy/Kod-i-poczta, 8), ', ', $kto/Data-wykonania)"/>
					</td>
				</tr>
			</tbody>
		</table>
		<br/>
		<br/>
		<!--hr align="left" width="400" noshade="1" size="1"/>
		<table border="0" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<tr>
				<td class="stars">1)</td>
				<td class="remark">
					Jeśli termin przekazania sprawozdania wypada na dzień wolny od pracy, to obowiązuje data pierwszego
					dnia roboczego po tym dniu.
				</td>
			</tr>
		</table-->
		<table border="0" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<tr>
				<td class="xslt_ver" style="text-align: left;">
					Wersja szablonu XSLT: <xsl:value-of select="$wersja"/>
				</td>
				<td class="xslt_ver" style="text-align: right;">
					<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
					<!--xsl:if test="system-property('msxsl:version')">
						<xsl:value-of select="concat(', MSXML: ', system-property('msxsl:version'))"/>
					</xsl:if-->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="level"/>
		<xsl:param name="prefix"/>
		<xsl:variable name="row_no" select="count(preceding::*[starts-with(@Pozycja, $prefix)])+
																	 count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)])"/>
		<xsl:variable name="topbot" select="'margin-top: 4px; margin-bottom: 4px; margin-left: '"/>
		<xsl:variable name="indent" select="25"/>
		<td class="row_descr">
			<xsl:if test="not(preceding-sibling::*) and ../@Prefiks">
				<p>
					<xsl:attribute name="style"><xsl:value-of select="concat($topbot, string($indent * ($level - 1)), 'px;')"/></xsl:attribute>
					<xsl:value-of select="../@Prefiks"/>
					<br/>
				</p>
			</xsl:if>
			<p>
				<xsl:if test="$level &gt;= 0">
					<xsl:attribute name="style"><xsl:value-of select="concat($topbot, string($indent * $level), 'px;')"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="name(..) = 'Tabela-1'">
						<xsl:if test="$row_no != 1">
							<xsl:value-of select="$row_no - 1"/>)
						</xsl:if>
						<xsl:value-of select="@Opis"/>
						<xsl:if test="$row_no = 1">
							(w. 2+3+4+5+6+7+8+9+10+11)
							<br/>z tego dla:
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="name(..) = 'Tabela-2'">
							<xsl:value-of select="substring-after(@Pozycja, $prefix)"/>.
						</xsl:if>
						<xsl:value-of select="@Opis"/>
					</xsl:otherwise>
				</xsl:choose>
			</p>
		</td>
		<xsl:if test="name(..) = 'Tabela-1'">
			<td class="tab_row_no">
				<xsl:value-of select="$row_no"/>
			</td>
		</xsl:if>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Tabela-1">
		<xsl:param name="width" select="844"/>
		<xsl:call-template name="Metryczka">
			<xsl:with-param name="width" select="$width"/>
			<xsl:with-param name="table_name" select="'Tabela 1'"/>
			<xsl:with-param name="table_title">
				Ogółem liczba ponadgminnych Domów Pomocy Społecznej, miejsc i&#160;mieszkańców wg typów domów,
				w podziale na domy samorządów powiatowych i&#160;podmiotów niepublicznych wg&#160;stanu na dzień
			</xsl:with-param>
			<xsl:with-param name="table_subtitle">
				30 VI <xsl:value-of select="../Metryczka/Za-okres/Rok"/> r.
			</xsl:with-param>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th colspan="2" rowspan="3">TYPY DOMÓW</th>
					<th colspan="3">OGÓŁEM</th>
					<th colspan="6">z tego domy:</th>
				</tr>
				<tr>
					<th width="6%" rowspan="2">LICZBA DOMÓW (4+7)</th>
					<th width="5%" rowspan="2">LICZBA MIEJSC (5+8)</th>
					<th width="9%" rowspan="2">LICZBA MIESZKAŃCÓW (6+9)</th>
					<th colspan="3">samorządów powiatowych</th>
					<th colspan="3">podmiotów niepublicznych</th>
				</tr>
				<tr>
					<th width="6%">liczba domów</th>
					<th width="5%">liczba miejsc</th>
					<th width="9%">liczba mieszkańców</th>
					<th width="6%">liczba domów</th>
					<th width="5%">liczba miejsc</th>
					<th width="9%">liczba mieszkańców</th>
				</tr>
				<tr>
					<td colspan="2" class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
					<td class="tab_col_no">7</td>
					<td class="tab_col_no">8</td>
					<td class="tab_col_no">9</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Domy-pomocy-społecznej">
					<xsl:call-template name="Domy-pomocy-społecznej">
						<xsl:with-param name="format" select="$liczba"/>
					</xsl:call-template>
				</xsl:for-each>
			</tbody>
		</table>
		<br/>
		<xsl:call-template name="Stopka">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Domy-pomocy-społecznej">
		<xsl:param name="format"/>
		<xsl:if test="@Pozycja = '_DPS-EWID_02' or @Pozycja = '_DPS-EWID_08'">
			<tr>
				<th colspan="11" style="border-left: none; border-right: none;"/>
			</tr>
		</xsl:if>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_DPS-EWID_'"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="subtree" select="'Ogółem'"/>
				<xsl:with-param name="column" select="'Liczba-domów'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="subtree" select="'Ogółem'"/>
				<xsl:with-param name="column" select="'Liczba-miejsc'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="subtree" select="'Ogółem'"/>
				<xsl:with-param name="column" select="'Liczba-mieszkańców'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="subtree" select="'Samorządów-powiatowych'"/>
				<xsl:with-param name="column" select="'Liczba-domów'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="subtree" select="'Samorządów-powiatowych'"/>
				<xsl:with-param name="column" select="'Liczba-miejsc'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="subtree" select="'Samorządów-powiatowych'"/>
				<xsl:with-param name="column" select="'Liczba-mieszkańców'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="subtree" select="'Podmiotów-niepublicznych'"/>
				<xsl:with-param name="column" select="'Liczba-domów'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="subtree" select="'Podmiotów-niepublicznych'"/>
				<xsl:with-param name="column" select="'Liczba-miejsc'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="subtree" select="'Podmiotów-niepublicznych'"/>
				<xsl:with-param name="column" select="'Liczba-mieszkańców'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_column">
		<xsl:param name="format"/>
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="*[name(.) = $subtree]/@Podsumowanie">
				<xsl:call-template name="_1_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="nodeset" select="*[name(.) != $subtree]/*[name(.) = $column]"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="komorka" select="$item/@Komorka"/>
					<xsl:with-param name="blad" select="$item/@Blad"/>
					<xsl:with-param name="edit" select="$item/@Edit"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="substring-after(substring-after(./@Pozycja, '_'), '_') = 1">
				<xsl:call-template name="_1_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="nodeset" select="../*/*[name(.) = $subtree]/*[name(.) = $column and ../../@Pozycja != current()/@Pozycja]"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="komorka" select="$item/@Komorka"/>
					<xsl:with-param name="blad" select="$item/@Blad"/>
					<xsl:with-param name="edit" select="$item/@Edit"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string($item/@xsi:nil) = 'true'">
						<td class="contents">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka !='' and $item/@Komorka !='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
										<td id="{$nazwa}" class="contents">
											<div id="K{$nazwa}" class="div_komorka">
											</div>
											<xsl:value-of select="concat('K', $nazwa)"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td id="{$nazwa}" class="contents">
											<div id="K{$nazwa}" class="div_komorka">
												<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
											</div>
											<xsl:value-of select="format-number(round(100 * $contents) div 100, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<td class="contents">
									<xsl:value-of select="format-number(round(100 * $contents) div 100, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_totals">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="result">
			<xsl:value-of select="sum($nodeset)"/>
		</xsl:param>
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:choose>
			<xsl:when test="$komorka !='' and $komorka !='NaN'">
				<xsl:variable name="nazwa">
					<xsl:value-of select="$komorka"/>
				</xsl:variable>
				<xsl:variable name="wartosc">
					<xsl:value-of select="$contents"/>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
						<td id="{$nazwa}" class="totals">
							<div id="K{$nazwa}" class="div_komorka">
									</div>
							<xsl:value-of select="concat('K', $nazwa)"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td id="{$nazwa}" class="totals">
							<div id="K{$nazwa}" class="div_komorka">
								<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
							</div>
							<xsl:value-of select="$contents"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string(number($contents)) != 'NaN'">
						<xsl:choose>
							<xsl:when test="string(number($result)) = 'NaN'">
								<td class="totals" style="background-color: red">
									<center>X</center>
								</td>
							</xsl:when>
							<xsl:when test="$contents != $result">
								<td class="contents" style="background-color: red">
									<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
									<br/>
									<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals">
									<xsl:value-of select="format-number($result, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($result, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Tabela-2">
		<xsl:param name="width" select="716"/>
		<xsl:call-template name="Metryczka">
			<xsl:with-param name="width" select="$width"/>
			<xsl:with-param name="table_name" select="'Tabela 2'"/>
			<xsl:with-param name="table_title">
				ŚRODOWISKOWE DOMY SAMOPOMOCY (rozdz. 85203)
				I&#160;MIESZKANIA CHRONIONE (rozdz. 85220)
				WG STANU NA DZIEŃ
			</xsl:with-param>
			<xsl:with-param name="table_subtitle">
				30 VI <xsl:value-of select="../Metryczka/Za-okres/Rok"/> r.
			</xsl:with-param>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th class="SKL_0" rowspan="2">WYSZCZEGÓLNIENIE</th>
					<th class="SKL_1" colspan="3">LICZBA</th>
				</tr>
				<tr>
					<th class="SKL_4">DOMÓW</th>
					<th class="SKL_4">MIEJSC</th>
					<th class="SKL_4">OSÓB PRZEBYWAJĄCYCH</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Domy-samopomocy">
					<xsl:call-template name="Domy-samopomocy"/>
				</xsl:for-each>
				<tr style="font-family: Tahoma, Verdana; font-size: 11px; font-weight: bold; text-align: center;">
					<td class="SKL_0" rowspan="2">&#160;</td>
					<td class="SKL_1" colspan="3">LICZBA</td>
				</tr>
				<tr style="font-family: Tahoma, Verdana; font-size: 11px; font-weight: bold; text-align: center;">
					<td class="SKL_4">MIESZKAŃ</td>
					<td class="SKL_4">MIEJSC</td>
					<td class="SKL_4">MIESZKAŃCÓW</td>
				</tr>
				<xsl:for-each select="Mieszkania-chronione">
					<xsl:call-template name="Mieszkania-chronione"/>
				</xsl:for-each>
			</tbody>
		</table>
		<br/>
		<xsl:call-template name="Stopka">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Domy-samopomocy">
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_SDSMCHR_'"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="column" select="'Domów'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="column" select="'Miejsc'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="column" select="'Osób-przebywających'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Mieszkania-chronione">
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_SDSMCHR_'"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="column" select="'Mieszkań'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="column" select="'Miejsc'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="column" select="'Mieszkańców'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_2_column">
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:choose>
			<xsl:when test="$item/@Komorka !='' and $item/@Komorka !='NaN'">
				<xsl:variable name="nazwa">
					<xsl:value-of select="$item/@Komorka"/>
				</xsl:variable>
				<xsl:variable name="wartosc">
					<xsl:value-of select="$contents"/>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
						<td id="{$nazwa}" class="contents">
							<div id="K{$nazwa}" class="div_komorka">
											</div>
							<xsl:value-of select="concat('K', $nazwa)"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td id="{$nazwa}" class="contents">
							<div id="K{$nazwa}" class="div_komorka">
								<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
							</div>
							<xsl:value-of select="format-number($contents, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:value-of select="format-number($contents, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
