<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:param name="operacja">przegladanie</xsl:param>
	<xsl:param name="przyciski">false</xsl:param>
	<xsl:param name="porownanie">false</xsl:param>
	<xsl:param name="formatowanie_kwota">###&#160;###&#160;###&#160;##0</xsl:param>
	<xsl:param name="formatowanie_liczba">##&#160;###&#160;##0</xsl:param>
	<xsl:param name="FrmSymbol"/>
	<xsl:param name="ZaOkres1"/>
	<xsl:param name="Nadawca1"/>
	<xsl:param name="Odbiorca1"/>
	<xsl:param name="WersjaZ1"/>
	<xsl:param name="ZaOkres2"/>
	<xsl:param name="Nadawca2"/>
	<xsl:param name="Odbiorca2"/>
	<xsl:param name="WersjaZ2"/>
	<xsl:param name="aplikacja">gmina</xsl:param>
	<!--zmiana gmina-->
	<xsl:param name="kod_wojewodztwa">false</xsl:param>
	<!--
	=============================================================================================
	-->
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.0'"/>
	<xsl:decimal-format grouping-separator="&#160;"/>
	<xsl:variable name="liczba" select="$formatowanie_liczba"/>
	<xsl:variable name="width">
		<xsl:choose>
			<xsl:when test="$aplikacja = 'gmina'">
				<xsl:value-of select="'870px'"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'944px'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
					<xsl:choose>
						<xsl:when test="$aplikacja = 'gmina'">
							<!--zmiana gmina-->
							<link rel="stylesheet" href="posilek.css"/>
						</xsl:when>
						<xsl:otherwise>
   				            .blad           {background-color: red; text-align: right}
				            .pole           {background-color: white; text-align: right}			            
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>; padding-top: 6px;
                                				}

                    		.KPPPwR_6_0        {width:  410px}
                    		.KPPPwR_6_1        {width:  100px}
                    		.KPPPwR_6_0a      {width:  390px}
                    		.KPPPwR_6_0b      {width:    80px; margin-left: 4px; margin-right: 4px; }

                    		.KPPPwR_7_0		{width:  370px}
                    		.KPPPwR_7_1		{width:  308px}
                    		.KPPPwR_7_2		{width:  100px}
                    		.KPPPwR_7_0a	{width:  350px}
                    		.KPPPwR_7_0b	{width:    20px}

                    		.KPPPwR_8_0		{width:  300px}
                    		.KPPPwR_8_1		{width:  640px}
                    		.KPPPwR_8_2		{width:    93px}
                    		.KPPPwR_8_0a	{width:  280px}
                    		.KPPPwR_8_0b	{width:    80px}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal;
                                					}
                   			 .contents	{white-space: pre; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{ padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				padding-bottom: 4px; font-weight: normal;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; padding-top: 24px;
                                				}
                    		.empty		{border: 0 0 0 0;}
                    		
                    		#Przyciski {top: 1em; position: absolute; overflow: auto; width: 99%; z-index: 2; cursor: default;}
							* html #Przyciski { /* IE hack */
									width: 100%;
									height: 12%;
							}
							#Sprawozdanie {top: 4em; bottom: 0em; position: absolute; overflow: auto; width: 99%; z-index: 1;}
							* html #Sprawozdanie { /* IE hack */
								height: 85%;								
								width: 100%;
							}
   	                    </xsl:otherwise>
					</xsl:choose>
				</style>
			</head>
			<body>
				<!-- Modyfikacja na potrzeby edytowania komorek -->
				<form name="SACKomorkiSprawozdania" action="/Pomost/SAC/sprawozdania/komorki/zapisz.do?operacja={$operacja}" method="POST">
					<div id="Przyciski">
						<xsl:if test="$przyciski = 'true'">
							<xsl:choose>
								<xsl:when test="$aplikacja = 'gmina'">
									<!--zmiana gmina-->
									<input type="submit" value="Akceptuj"/>
									<input type="submit" value="Waliduj"/>
									<input type="submit" value="Odswiez"/>
									<xsl:value-of select="' '"/>
									<input type="submit" value="Anuluj"/>
								</xsl:when>
								<xsl:otherwise>
									<a href="javascript:document.forms[0].submit();" accesskey="B">
										<img border="0" alt="Akceptuj (ALT+B)" src="../../../obrazki/lista/akceptuj.gif"/>
									</a>
									<xsl:value-of select="' '"/>
									<a href="javascript:document.forms[0].action='/Pomost/SAC/scalanieSprawozdan/initial.do'; document.forms[0].submit();" accesskey="K">
										<img border="0" alt="Anuluj (ALT+K)" src="../../../obrazki/lista/anuluj.gif"/>
									</a>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
					</div>
					<div id="Sprawozdanie">
						<xsl:apply-templates select="KPPPwR"/>
					</div>
				</form>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="KPPPwR">
		<xsl:apply-templates select="Metryczka"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<a id="czesc_i" name="czesc_i"></a>
		<xsl:apply-templates select="Część_I"/>
		<a id="czesc_ii" name="czesc_ii"></a>
		<xsl:apply-templates select="Część_II"/>
		<a id="czesc_iii" name="czesc_iii"></a>
		<xsl:apply-templates select="Część_III"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<!-- Modyfikacja na potrzeby edytowania komorek porownywanie-->
		<xsl:choose>
			<xsl:when test="$porownanie = 'false'">
				<xsl:if test="Opis and Opis != ''">
					<div class="reason">
						<xsl:value-of select="Opis"/>
						<br/>
						<br/>
					</div>
				</xsl:if>
				<table border="2" cellspacing="0" cellpadding="8">
					<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
					<thead>
						<tr>
							<th colspan="3">
								<span style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO PRACY I POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5, 00-513 Warszawa
						</span>
							</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td width="300">
								<span style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
								</span>
								<center>
									<xsl:for-each select="Nadawca">
										<table cellspacing="0" cellpadding="0">
											<tr>
												<td class="stamp" colspan="2">
													<xsl:value-of select="Pełna-nazwa"/>
												</td>
											</tr>
											<xsl:for-each select="Adres-pocztowy">
												<tr>
													<td class="stamp" colspan="2">
														<xsl:value-of select="Ulica-i-numer"/>
													</td>
												</tr>
												<tr>
													<td class="stamp" colspan="2">
														<xsl:value-of select="Kod-i-poczta"/>
													</td>
												</tr>
											</xsl:for-each>
											<tr>
												<td class="stamp" style="font-size: 11px; text-align: left">
													<xsl:for-each select="Telefon">
                                 					           Tel. <xsl:apply-templates/> &#160;
					                                        </xsl:for-each>
												</td>
												<td class="stamp" style="font-size: 11px; text-align: right">
													<xsl:for-each select="Faks">
					                                            Fax <xsl:apply-templates/>&#160;
											</xsl:for-each>
												</td>
											</tr>
										</table>
									</xsl:for-each>
								</center>
							</td>
							<td rowspan="2" style="text-align: center; font-weight: bold;">
								<span style="font-size: large;">SPRAWOZDANIE</span>
								<br/>
								<p style="font-size: 13px">
								z realizacji Krajowego Programu<br/>Przeciwdziałania Przemocy w Rodzinie
							</p>
							za
							<xsl:choose>
									<xsl:when test="Za-okres/Kwartał = 'II'">I-VI</xsl:when>
									<xsl:otherwise>I-XII</xsl:otherwise>
								</xsl:choose>
								<xsl:value-of select="concat(' ', Za-okres/Rok, ' r.')"/>
							</td>
							<td width="300">
								<span style="font-size: 11px; text-align: left;">
							Adresat:<br/>
								</span>
								<div class="stamp">
									<xsl:value-of select="Odbiorca/Pełna-nazwa"/>
								</div>
							</td>
						</tr>
						<tr>
							<td>
								<xsl:choose>
									<xsl:when test="$kod_wojewodztwa = 'false'">
										<span style="font-size: 11px; text-align: left;">
									Numer identyfikacyjny REGON:<br/>
										</span>
										<div style="font-weight: bold; text-align: center;">
											<xsl:value-of select="Nadawca/@Kod-REGON"/>
										</div>
									</xsl:when>
									<xsl:otherwise>
										<table>
											<tbody>
												<tr>
													<td>
														<span style="font-size: 11px; text-align: left;">
												Numer identyfikacyjny REGON:
											   </span>
													</td>
													<td>
														<span style="font-weight: bold; text-align: center;">
															<xsl:value-of select="Nadawca/@Kod-REGON"/>
														</span>
													</td>
												</tr>
												<tr>
													<td>
														<span style="font-size: 11px; text-align: left;">
												Kod województwa:
												</span>
													</td>
													<td>
														<span style="font-weight: bold; text-align: center;">
															<xsl:value-of select="substring(Nadawca/@Kod-KESO, 3, 2)"/>
														</span>
													</td>
												</tr>
											</tbody>
										</table>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td>
								<div style="font-weight: bold; font-size: 13px; text-align: center;">
									<xsl:choose>
										<xsl:when test="Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III'">
									Przekazać w terminie do 20 dnia<br/>miesiąca po okresie sprawozdawczym<sup>1)</sup>
										</xsl:when>
										<xsl:otherwise>
									Przekazać / wysłać w terminie<br/>do 10 lutego<sup>1)</sup>
										</xsl:otherwise>
									</xsl:choose>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<br/>
				<table class="wide" border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td class="stars" colspan="4">
							<sup>1)</sup>
							<font class="remark">
								<xsl:choose>
									<xsl:when test="Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III'">
								Jeśli termin przekazania sprawozdania wypada na dzień wolny od pracy, to obowiązuje data pierwszego dnia roboczego po tym dniu.
							</xsl:when>
									<xsl:otherwise>
								Do 10 lutego roku następnego.
							</xsl:otherwise>
								</xsl:choose>
							</font>
						</td>
						<td class="remark">					
                 </td>
					</tr>
				</table>
				<br/>
				<br/>
				<br/>
				<br/>
				<br/>
			</xsl:when>
			<xsl:otherwise>
				<table class="wide" border="1" cellspacing="0" cellpadding="0" width="100%">
					<thead>
						<tr>
							<th colspan="2">
								<span style="font-size: 18px; font-weight: bold;">
			                  Porównanie zawartości komórek sprawozdań o symbolu <xsl:value-of select="$FrmSymbol"/>
								</span>
							</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td width="50%">
								<table>
									<tr>
										<td>
											<B>Sprawozdanie za okres:</B>
											<xsl:value-of select="$ZaOkres1"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Nadawca:</B>
											<xsl:value-of select="$Nadawca1"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Odbiorca:</B>
											<xsl:value-of select="$Odbiorca1"/>
										</td>
									</tr>
									<xsl:if test="$WersjaZ1 != ''">
										<tr>
											<td>
												<B>Wersja z:</B> dnia <xsl:value-of select="$WersjaZ1"/>
											</td>
										</tr>
									</xsl:if>
								</table>
							</td>
							<td width="50%">
								<table>
									<tr>
										<td>
											<B>Sprawozdanie za okres:</B>
											<xsl:value-of select="$ZaOkres2"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Nadawca:</B>
											<xsl:value-of select="$Nadawca2"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Odbiorca:</B>
											<xsl:value-of select="$Odbiorca2"/>
										</td>
									</tr>
									<xsl:if test="$WersjaZ2 != ''">
										<tr>
											<td>
												<B>Wersja z:</B> dnia <xsl:value-of select="$WersjaZ2"/>
											</td>
										</tr>
									</xsl:if>
								</table>
							</td>
						</tr>
					</tbody>
				</table>
				<br/>
				<font size="-1">pola oznaczone kolorem <font color="orange">pomarańczowym</font> zawierają wartości różniących się komórek oraz procentowy przyrost wartości pierwszego sprawozdania względem drugiego</font>
				<br/>
				<br/>
				<br/>
			</xsl:otherwise>
		</xsl:choose>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek porownywanie-->
		<table border="0" cellspacing="0" cellpadding="8">
			<tbody>
				<tr>
					<th colspan="4">
						<xsl:if test="(Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III') and Kod/Cyklu-sprawozdawczego != 2 or
							Za-okres/Kwartał = 'II' and Kod/Cyklu-sprawozdawczego != 3 or Za-okres/Kwartał = 'IV' and Kod/Cyklu-sprawozdawczego != 4">
							<div style="font-size: large; text-align: center; color: red;">
						Kod cyklu sprawozdawczego nie odpowiada określeniu kwartału!
					</div>
							<br/>
							<br/>
							<br/>
							<br/>
							<br/>
						</xsl:if>
						<xsl:if test="Kod/Cyklu-sprawozdawczego != 4">
							<div style="font-size: large; text-align: center; color: red;">
						Niepoprawny kod cyklu sprawozdawczego, sprawozdanie musi być roczne!
					</div>
							<br/>
							<br/>
							<br/>
							<br/>
							<br/>
						</xsl:if>
					</th>
				</tr>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table width="370">
			<caption>Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td colspan="2">Imię i nazwisko: <b>
						<xsl:value-of select="$kto/Imię-i-nazwisko"/>
					</b>
				</td>
				<td colspan="2"/>
			</tr>
			<tr>
				<td colspan="2">Telefon: <b>
						<xsl:value-of select="$kto/Telefon"/>
					</b>
				</td>
				<td colspan="2"/>
			</tr>
			<tr>
				<td colspan="2">Data wykonania: <b>
						<xsl:value-of select="$kto/Data-wykonania"/>
					</b>
				</td>
				<td colspan="2"/>
			</tr>
			<tr>
				<td colspan="2">e-mail: <b>
						<xsl:value-of select="$kto/E-mail"/>
					</b>
				</td>
				<td colspan="2"/>
			</tr>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td colspan="2" class="xslt_ver" style="text-align: left;">
					Wersja szablonu XSLT: <xsl:value-of select="$wersja"/>
				</td>
				<td colspan="2" class="xslt_ver" style="text-align: right;">
					<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
					<!--xsl:if test="system-property('msxsl:version')">
						<xsl:value-of select="concat(', MSXML: ', system-property('msxsl:version'))"/>
					</xsl:if-->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="level"/>
		<xsl:param name="offset"/>
		<xsl:param name="prefix"/>
		<xsl:variable name="topbot" select="'margin-top: 4px; margin-bottom: 4px; margin-left: 4px; margin-right: 4px; '"/>
		<xsl:variable name="indent" select="25"/>
		<xsl:variable name="row_class">
			<!--zmina gmina -->
			<xsl:choose>
				<xsl:when test="$aplikacja = 'gmina'">
					<xsl:value-of select="'KPPPwR_6_0a'"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'KPPPwR_6_0a row_descr'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<td class="{$row_class}">
			<xsl:if test="not(preceding-sibling::*) and ../@Prefiks">
				<p>
					<xsl:attribute name="style"><xsl:value-of select="concat($topbot, string($indent * ($level - 1)), 'px;')"/></xsl:attribute>
					<xsl:value-of select="../@Prefiks"/>
					<br/>
				</p>
			</xsl:if>
			<p>
				<!--<xsl:if test="$level &gt;= 0">-->
					<xsl:attribute name="style"><xsl:value-of select="concat($topbot, string($indent * $level), 'px;')"/></xsl:attribute>
				<!--</xsl:if>-->
				<xsl:choose>
					<xsl:when test="@Pozycja = '_II_08'">w tym z wiersza 6:<br/> innym osobom w rodzinie </xsl:when>
					<xsl:when test="@Pozycja = '_II_17'">w tym z wiersza 15:<br/>innym osobom w rodzinie </xsl:when>
				</xsl:choose>
				<xsl:value-of select="@Opis"/>
				<xsl:choose>
					<xsl:when test="@Pozycja = '_I_07'">
						<sup>1)</sup>
					</xsl:when>
					<xsl:when test="@Pozycja = '_I_08'">
						<sup>2)</sup>
					</xsl:when>
					<xsl:when test="@Pozycja = '_II_22'">
						<br/>
						<span style="margin-top: 0.6em; font-size: 0.8em;">
							(z udziałem Policji, prokuratury, kuratorów sądowych)
						</span>
					</xsl:when>
					<xsl:when test="@Pozycja = '_II_24'">
						<sup>2)</sup>
					</xsl:when>
				</xsl:choose>
			</p>
		</td>
		<td class="tab_row_no">
			<xsl:value-of select="count(preceding::*[starts-with(@Pozycja, $prefix)])+
								  count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)]) + $offset"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="sumuj">
		<xsl:param name="wynik"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma"/>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<!-- Modyfikacje na potrzeby analizy -->
		<xsl:param name="analiza"/>
		<!-- Koniec modyfikacje na potrzeby analizy -->
		<xsl:choose>
			<xsl:when test="$suma!=''">
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="substring-after($suma,'+')"/>
					<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka" select="$komorka"/>
					<xsl:with-param name="blad" select="$blad"/>
					<xsl:with-param name="edit" select="$edit"/>
					<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					<!-- Modyfikacje na potrzeby analizy -->
					<xsl:with-param name="analiza" select="$analiza"/>
					<!-- Koniec modyfikacje na potrzeby analizy -->
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string(number($wynik)) = 'NaN'">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$blad='true'">
						                                    blad
						                </xsl:when>
										<xsl:otherwise>
						                                    pole
						                </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$edit='true'">
										<td class="totals" style="background-color: red">
											<!--Modyfikacja na potrzeby analizy -->
											<xsl:choose>
												<xsl:when test="$analiza='true'">
													<input type="submit" value="K{$nazwa}"/>
												</xsl:when>
											</xsl:choose>
											<!--Koniec Modyfikacja na potrzeby analizy -->
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="'suma: NaN'"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<center>X</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals" style="background-color: red">
											<center>X</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:when test="string(number($contents)) != 'NaN' and $contents != 0">
						<xsl:choose>
							<xsl:when test="$contents != $wynik">
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$komorka!='' and $komorka!='NaN'">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$contents"/>
										</xsl:variable>
										<xsl:variable name="class">
											<xsl:choose>
												<xsl:when test="$blad='true'">
						                                    blad
						                            </xsl:when>
												<xsl:otherwise>
						                                    pole
						                            </xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$edit='true'">
												<td class="contents" style="background-color: red">
													<!--Modyfikacja na potrzeby analizy -->
													<xsl:choose>
														<xsl:when test="$analiza='true'">
															<input type="submit" value="K{$nazwa}"/>
														</xsl:when>
													</xsl:choose>
													<!--Koniec Modyfikacja na potrzeby analizy -->
													<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
													<br/>
													<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents" style="background-color: red">
													<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
													<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
													<br/>
													<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$porownanie = 'true'">
												<xsl:choose>
													<xsl:when test="$blad='true'">
														<td class="contents" style="background-color: orange">
															<xsl:value-of select="$contents"/>
														</td>
													</xsl:when>
													<xsl:otherwise>
														<td class="totals">
															<xsl:value-of select="$contents"/>
														</td>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents" style="background-color: red">
													<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
													<br/>
													<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:when>
							<xsl:otherwise>
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$komorka!='' and $komorka!='NaN'">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$contents"/>
										</xsl:variable>
										<xsl:variable name="class">
											<xsl:choose>
												<xsl:when test="$blad='true'">
						                                    blad
						                            </xsl:when>
												<xsl:otherwise>
						                                    pole
						                            </xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$edit='true'">
												<td class="totals">
													<!--Modyfikacja na potrzeby analizy -->
													<xsl:choose>
														<xsl:when test="$analiza='true'">
															<input type="submit" value="K{$nazwa}"/>
														</xsl:when>
													</xsl:choose>
													<!--Koniec Modyfikacja na potrzeby analizy -->
													<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$porownanie = 'true'">
												<xsl:choose>
													<xsl:when test="$blad='true'">
														<td class="contents" style="background-color: orange">
															<xsl:value-of select="$contents"/>
														</td>
													</xsl:when>
													<xsl:otherwise>
														<td class="totals">
															<xsl:value-of select="$contents"/>
														</td>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="format-number($wynik, $format)"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$blad='true'">
						                                    blad
						                </xsl:when>
										<xsl:otherwise>
						                                    pole
						                </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$edit='true'">
										<td class="totals">
										<!--Modyfikacja na potrzeby analizy -->
											<xsl:choose>
												<xsl:when test="$analiza='true'">
													<input type="submit" value="K{$nazwa}"/>
												</xsl:when>
											</xsl:choose>
											<!--Koniec Modyfikacja na potrzeby analizy -->
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<input type="edit" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="$contents"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number($wynik, $format)"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_I">
		<xsl:param name="width" select="1130"/>
		<div>
			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('Część ', substring-after(name(.), '_'), '.')"/>
			<span style="margin-left: 0.8em">
				<xsl:value-of select="@Opis"/>
			</span>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th class="KPPPwR_7_0" colspan="2" rowspan="2">Wyszczególnienie</th>
					<th class="KPPPwR_7_1" colspan="3">PODMIOT PROWADZĄCY - GMINA</th>
					<th class="KPPPwR_7_1" colspan="3">PODMIOT PROWADZĄCY - POWIAT</th>
				</tr>
				<tr>
					<th class="KPPPwR_7_2">liczba<br/>jednostek</th>
					<th class="KPPPwR_7_2">liczba<br/>miejsc</th>
					<th class="KPPPwR_7_2">liczba osób<br/>korzystających</th>
					<th class="KPPPwR_7_2">liczba<br/>jednostek</th>
					<th class="KPPPwR_7_2">liczba<br/>miejsc</th>
					<th class="KPPPwR_7_2">liczba osób<br/>korzystających</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
					<td class="tab_col_no">7</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Infrastruktura">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
			</tbody>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" colspan="4">1), 2)	<font class="remark">odpowiednio w kolumnie 4 i 7 należy podać TYLKO  liczbę ofiar przemocy w rodzinie.</font>
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Infrastruktura">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_I_'"/>
				<xsl:with-param name="offset" select="0"/>
			</xsl:call-template>
			<xsl:call-template name="_I_contents">
				<xsl:with-param name="subtree" select="'Gmina'"/>
			</xsl:call-template>
			<xsl:call-template name="_I_contents">
				<xsl:with-param name="subtree" select="'Powiat'"/>
			</xsl:call-template>
		</tr>
		<xsl:apply-templates select="*/Infrastruktura">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_I_contents">
		<xsl:param name="subtree"/>
		<xsl:call-template name="_I_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-jednostek'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_I_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-miejsc'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_I_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-korzystających'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_I_column">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="Podmiot-prowadzący/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="Z-tego and not($item/@xsi:nil)">
				<xsl:call-template name="_I_total">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka">
						<xsl:value-of select="$item/@Komorka"/>
					</xsl:with-param>
					<xsl:with-param name="blad">
						<xsl:value-of select="$item/@Blad"/>
					</xsl:with-param>
					<xsl:with-param name="edit">
						<xsl:value-of select="$item/@Edit"/>
					</xsl:with-param>
					<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					<!-- Modyfikacja na potrzeby analizy komorek -->
					<xsl:with-param name="analiza" select="$item/@Analiza"/>
					<!-- Koniec modyfikacja na potrzeby analizy komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string($item/@xsi:nil) = 'true'">
						<td class="contents">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                        blad
						                </xsl:when>
										<xsl:otherwise>
						                        pole
						                </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents">
											<!--Modyfikacja na potrzeby analizy -->
											<xsl:choose>
												<xsl:when test="$item/@Analiza='true'">
													<input type="submit" value="K{$nazwa}"/>
												</xsl:when>
											</xsl:choose>
											<!--Koniec Modyfikacja na potrzeby analizy -->
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="format-number($contents, $format)"/>
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_I_total">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="Z-tego/*">
				<xsl:call-template name="_I_add_tree">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<!-- Modyfikacje na potrzeby analizy -->
		<xsl:param name="analiza"/>
		<!-- Koniec modyfikacje na potrzeby analizy -->
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
			<!-- Modyfikacja na potrzeby edytowania komorek -->
			<xsl:with-param name="komorka" select="$komorka"/>
			<xsl:with-param name="blad" select="$blad"/>
			<xsl:with-param name="edit" select="$edit"/>
			<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			<!-- Modyfikacje na potrzeby analizy -->
			<xsl:with-param name="analiza" select="$analiza"/>
			<!-- Koniec modyfikacje na potrzeby analizy -->
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_I_add_tree">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents" select="Podmiot-prowadzący/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_I_add_tree">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_II">
		<xsl:param name="width" select="1130"/>
		<div>
			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('Część ', substring-after(name(.), '_'), '.')"/>
			<span style="margin-left: 0.8em">
				<xsl:value-of select="@Opis"/>
			</span>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th class="KPPPwR_7_0" colspan="2" rowspan="2">Wyszczególnienie<sup>1)</sup>
					</th>
					<th class="KPPPwR_7_1" colspan="4">PODMIOT PROWADZĄCY - GMINA</th>
					<th class="KPPPwR_7_1" colspan="4">PODMIOT PROWADZĄCY - POWIAT</th>
				</tr>
				<tr>
					<th class="KPPPwR_7_2c">liczba osób, którym udzielono pomocy</th>
					<th class="KPPPwR_7_2c">liczba świadczeń</th>
					<th class="KPPPwR_7_2c">liczba<br/>rodzin</th>
					<th class="KPPPwR_7_2c">liczba osób<br/>w rodzinach</th>
					<th class="KPPPwR_7_2c">liczba osób, którym udzielono pomocy</th>
					<th class="KPPPwR_7_2c">liczba świadczeń</th>
					<th class="KPPPwR_7_2c">liczba<br/>rodzin</th>
					<th class="KPPPwR_7_2c">liczba osób<br/>w rodzinach</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
					<td class="tab_col_no">7</td>
					<td class="tab_col_no">8</td>
					<td class="tab_col_no">9</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Formy-pomocy">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<tr class="empty">
					<th colspan="10">
						<br/>
						<br/>
					</th>
				</tr>
				<xsl:for-each select="Formy-pomocy">
					<xsl:call-template name="Niebieskie-karty">
						<xsl:with-param name="margin" select="0"/>
					</xsl:call-template>
				</xsl:for-each>
			</tbody>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td colspan="4" class="stars">1) <font class="remark">należy uwzględnić każdą pomoc, która została udzielona w jednostkach wymienionych w części I.</font>
				</td>
				<td class="remark"/>
			</tr>
			<tr>
				<td colspan="4" class="stars">2) <font class="remark">Niebieska karta dotycząca przemocy w rodzinie (Załącznik do kwestionariusza wywiadu środowiskowego)</font>
				</td>
				<td class="remark"> </td>
			</tr>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Formy-pomocy">
		<xsl:param name="margin"/>
		<xsl:if test="@Pozycja != '_II_24' and @Pozycja != '_II_25'">
			<tr>
				<xsl:call-template name="Row-description">
					<xsl:with-param name="level" select="$margin"/>
					<xsl:with-param name="prefix" select="'_II_'"/>
					<xsl:with-param name="offset" select="0"/>
				</xsl:call-template>
				<xsl:call-template name="_II_contents">
					<xsl:with-param name="subtree" select="'Gmina'"/>
				</xsl:call-template>
				<xsl:call-template name="_II_contents">
					<xsl:with-param name="subtree" select="'Powiat'"/>
				</xsl:call-template>
			</tr>
			<xsl:apply-templates select="*/Formy-pomocy">
				<xsl:with-param name="margin" select="$margin + 1"/>
			</xsl:apply-templates>
		</xsl:if>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_II_contents">
		<xsl:param name="subtree"/>
		<!--xsl:param name="subtree" select="'Udzielone-świadczenia'"/-->
		<xsl:call-template name="_II_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Osób-w-decyzjach'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_II_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-świadczeń'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_II_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-rodzin'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_II_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Osób-w-rodzinach'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_II_column">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="Podmiot-prowadzący/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="Z-tego and not($item/@xsi:nil)">
				<xsl:call-template name="_II_total">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka">
						<xsl:value-of select="$item/@Komorka"/>
					</xsl:with-param>
					<xsl:with-param name="blad">
						<xsl:value-of select="$item/@Blad"/>
					</xsl:with-param>
					<xsl:with-param name="edit">
						<xsl:value-of select="$item/@Edit"/>
					</xsl:with-param>
					<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					<!-- Modyfikacja na potrzeby analizy komorek -->
					<xsl:with-param name="analiza" select="$item/@Analiza"/>
					<!-- Koniec modyfikacja na potrzeby analizy komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string($item/@xsi:nil) = 'true'">
						<td class="contents">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                        blad
						                </xsl:when>
										<xsl:otherwise>
						                        pole
						                </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents">
											<!--Modyfikacja na potrzeby analizy -->
											<xsl:choose>
												<xsl:when test="$item/@Analiza='true'">
													<input type="submit" value="K{$nazwa}"/>
												</xsl:when>
											</xsl:choose>
											<!--Koniec Modyfikacja na potrzeby analizy -->
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="format-number($contents, $format)"/>
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_II_total">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="Z-tego/*">
				<xsl:call-template name="_II_add_tree">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<!-- Modyfikacje na potrzeby analizy -->
		<xsl:param name="analiza"/>
		<!-- Koniec modyfikacje na potrzeby analizy -->
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
			<!-- Modyfikacja na potrzeby edytowania komorek -->
			<xsl:with-param name="komorka" select="$komorka"/>
			<xsl:with-param name="blad" select="$blad"/>
			<xsl:with-param name="edit" select="$edit"/>
			<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			<!-- Modyfikacje na potrzeby analizy -->
			<xsl:with-param name="analiza" select="$analiza"/>
			<!-- Koniec modyfikacje na potrzeby analizy -->
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_II_add_tree">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents" select="Podmiot-prowadzący/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_II_add_tree">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_III">
		<xsl:param name="width" select="600"/>
		<div>
			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('Część ', substring-after(name(.), '_'), '.')"/>
			<span style="margin-left: 0.8em">
				<xsl:value-of select="@Opis"/>
			</span>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th class="KPPPwR_7_0" colspan="2" rowspan="2">Wyszczególnienie</th>
					<th class="KPPPwR_7_1" colspan="8">liczba sprawców przemocy</th>
				</tr>
				<tr>
					<th colspan="4">PODMIOT PROWADZĄCY<br/>GMINA</th>
					<th colspan="4">PODMIOT PROWADZĄCY<br/>POWIAT</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">1</td>
					<td class="tab_col_no" colspan="4">2</td>
					<td class="tab_col_no" colspan="4">3</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Formy-działań">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
			</tbody>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Formy-działań">
		<xsl:param name="margin"/>
		<xsl:if test="@Pozycja != '_III_06' and @Pozycja != '_III_07'">
			<tr>
				<xsl:call-template name="Row-description">
					<xsl:with-param name="level" select="$margin"/>
					<xsl:with-param name="prefix" select="'_III_'"/>
					<xsl:with-param name="offset" select="0"/>
				</xsl:call-template>
				<xsl:call-template name="_III_contents">
					<xsl:with-param name="column" select="'Gmina'"/>
				</xsl:call-template>
				<xsl:call-template name="_III_contents">
					<xsl:with-param name="column" select="'Powiat'"/>
				</xsl:call-template>
			</tr>
			<xsl:apply-templates select="*/Formy-działań">
				<xsl:with-param name="margin" select="$margin + 1"/>
			</xsl:apply-templates>
		</xsl:if>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Niebieskie-karty">
		<xsl:param name="margin"/>
		<xsl:if test="@Pozycja = '_II_24' or @Pozycja = '_II_25'">
			<tr>
				<xsl:call-template name="Row-description">
					<xsl:with-param name="level" select="$margin"/>
					<xsl:with-param name="prefix" select="'_II_'"/>
					<xsl:with-param name="offset" select="0"/>
				</xsl:call-template>
				<xsl:call-template name="_III_column">
					<xsl:with-param name="item" select="./Podmiot-prowadzący/Gmina/Liczba-świadczeń"/>
					<xsl:with-param name="format" select="$liczba"/>
				</xsl:call-template>
				<xsl:call-template name="_III_column">
					<xsl:with-param name="item" select="./Podmiot-prowadzący/Powiat/Liczba-świadczeń"/>
					<xsl:with-param name="format" select="$liczba"/>
				</xsl:call-template>
			</tr>
			<xsl:for-each select="*/Formy-pomocy">
				<xsl:call-template name="Niebieskie-karty">
					<xsl:with-param name="margin" select="$margin + 1"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_III_contents">
		<xsl:param name="column"/>
		<xsl:call-template name="_III_column">
			<xsl:with-param name="column" select="$column"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_III_column">
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="Podmiot-prowadzący/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="Z-tego and not($item/@xsi:nil)">
				<xsl:call-template name="_III_total">
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka">
						<xsl:value-of select="$item/@Komorka"/>
					</xsl:with-param>
					<xsl:with-param name="blad">
						<xsl:value-of select="$item/@Blad"/>
					</xsl:with-param>
					<xsl:with-param name="edit">
						<xsl:value-of select="$item/@Edit"/>
					</xsl:with-param>
					<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					<!-- Modyfikacja na potrzeby analizy komorek -->
					<xsl:with-param name="analiza" select="$item/@Analiza"/>
					<!-- Koniec modyfikacja na potrzeby analizy komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string($item/@xsi:nil) = 'true'">
						<td class="contents" colspan="4">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                        blad
						                </xsl:when>
										<xsl:otherwise>
						                        pole
						                </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents" colspan="4">
											<!--Modyfikacja na potrzeby analizy -->
											<xsl:choose>
												<xsl:when test="$item/@Analiza='true'">
													<input type="submit" value="K{$nazwa}"/>
												</xsl:when>
											</xsl:choose>
											<!--Koniec Modyfikacja na potrzeby analizy -->
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" colspan="4">
											<xsl:value-of select="format-number($contents, $format)"/>
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" colspan="4" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents" colspan="4">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" colspan="4">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_III_total">
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="Z-tego/*">
				<xsl:call-template name="_III_add_tree">
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<!-- Modyfikacje na potrzeby analizy -->
		<xsl:param name="analiza"/>
		<!-- Koniec modyfikacje na potrzeby analizy -->
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
			<!-- Modyfikacja na potrzeby edytowania komorek -->
			<xsl:with-param name="komorka" select="$komorka"/>
			<xsl:with-param name="blad" select="$blad"/>
			<xsl:with-param name="edit" select="$edit"/>
			<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			<!-- Modyfikacje na potrzeby analizy -->
			<xsl:with-param name="analiza" select="$analiza"/>
			<!-- Koniec modyfikacje na potrzeby analizy -->
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_III_add_tree">
		<xsl:param name="column"/>
		<xsl:param name="contents" select="Podmiot-prowadzący/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_III_add_tree">
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
