<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:param name="operacja">przegladanie</xsl:param>
	<xsl:param name="przyciski">false</xsl:param>
	<xsl:param name="porownanie">false</xsl:param>
	<xsl:param name="formatowanie_kwota">###&#160;###&#160;###&#160;##0</xsl:param>
	<xsl:param name="formatowanie_liczba">##&#160;###&#160;##0</xsl:param>
	<xsl:param name="FrmSymbol"/>
	<xsl:param name="ZaOkres1"/>
	<xsl:param name="Nadawca1"/>
	<xsl:param name="Odbiorca1"/>
	<xsl:param name="WersjaZ1"/>
	<xsl:param name="ZaOkres2"/>
	<xsl:param name="Nadawca2"/>
	<xsl:param name="Odbiorca2"/>
	<xsl:param name="WersjaZ2"/>
	<xsl:param name="ImieNazwisko1" />
	<xsl:param name="Telefon1" />
	<xsl:param name="DataWykonania1" />
	<xsl:param name="Miejscowosc1" />
	<xsl:param name="ImieNazwisko2" />
	<xsl:param name="Telefon2" />
	<xsl:param name="DataWykonania2" />
	<xsl:param name="Miejscowosc2" />
	<xsl:param name="aplikacja">sac</xsl:param>
	<xsl:param name="_CSID_CONST"/>
	<xsl:param name="_CSID_VAL"/>
	<!--zmiana gsac-->
	<xsl:param name="kod_wojewodztwa">false</xsl:param>
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.1'"/>
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="ułamek" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="procent" select="'###&#160;###&#160;###&#160;##0,00%'"/>
	<xsl:variable name="kwota" select="$formatowanie_kwota"/>
	<xsl:variable name="liczba" select="$formatowanie_liczba"/>
	<xsl:variable name="width">
		<xsl:choose>
			<xsl:when test="$aplikacja = 'gsac'">
				<xsl:value-of select="'550px'"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'716px'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<xsl:choose>
					<xsl:when test="$aplikacja = 'gsac'">
						<!--zmiana gsac-->
						<link rel="stylesheet" href="../Dane/Wzorce/CSS/sprawozdania.css"/>
					</xsl:when>
					<xsl:otherwise>
						<style type="text/css">
				            .blad           {background-color: red; text-align: right}
				            .pole           {background-color: white; text-align: right}
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>;
                                				}

                    		.skl_0		{width:  380px}       <!--zmiana gsac-->
                    		.skl_1		{width:  300px}
                    		.skl_2		{width:    80px}
                    		.skl_3		{width:  300px}
                    		.skl_4		{width:  100px}
                    		.skl_5		{width:  200px}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal; width: 20px;
                                					}
                   			 .contents	{white-space: pre; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; width:  350px;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; padding-bottom: 8px;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; margin-top: 14px;
                                				}
                    		.empty		{border: 0 0 0 0;}
                    		
                    		#Przyciski {top: 1em; position: absolute; overflow: auto; width: 99%; z-index: 2; cursor: default;}
							* html #Przyciski { /* IE hack */
									width: 100%;
									height: 12%;
							}
							#Sprawozdanie {top: 4em; bottom: 0em; position: absolute; overflow: auto; width: 99%; z-index: 1;}
							* html #Sprawozdanie { /* IE hack */
								height: 85%;								
								width: 100%;
							}
                        </style>
					</xsl:otherwise>
				</xsl:choose>
			</head>
			<body>
				<!-- Modyfikacja na potrzeby edytowania komorek -->
				<form name="SACKomorkiSprawozdania" action="/Pomost/SAC/sprawozdania/komorki/zapisz.do?operacja={$operacja}" method="POST">
					<input type="hidden" name="{$_CSID_CONST}" value="{$_CSID_VAL}"/>
					<xsl:if test="$przyciski = 'true'">
				  	<div id="Przyciski">
							<xsl:choose>
								<xsl:when test="$aplikacja = 'gsac'">
									<!--zmiana gsac-->
									<input type="submit" value="Akceptuj"/>
									<xsl:value-of select="' '"/>
									<input type="submit" value="Anuluj"/>
								</xsl:when>
								<xsl:otherwise>
									<a href="javascript:document.forms[0].submit();">
										<img border="0" alt="Akceptuj" src="../../../obrazki/lista/akceptuj.gif"/>
									</a>
									<xsl:value-of select="' '"/>
									<a href="javascript:document.forms[0].action='/Pomost/SAC/sac/scalanieSprawozdan/initial.do'; document.forms[0].submit();">
										<img border="0" alt="Anuluj" src="../../../obrazki/lista/anuluj.gif"/>
									</a>
								</xsl:otherwise>
							</xsl:choose>
					  </div>
					</xsl:if>
					<xsl:if test="$porownanie != 'true'">
            <div id="Sprawozdanie">
              <xsl:apply-templates/>
            </div>
          </xsl:if> 
          <xsl:if test="$porownanie = 'true'">
            <xsl:apply-templates/>
          </xsl:if> 
				</form>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="SRODOSAM">
		<xsl:apply-templates select="Metryczka"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Domy-samopomocy"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<table border="2" cellspacing="0" cellpadding="4">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<tr>
				<th style="border-right: none; font-weight: normal;">I.</th>
				<th colspan="2" align="left" style="border-left: none; border-right: none; font-weight: normal;">Liczba osób umieszczonych w środowiskowych domach samopomocy w <xsl:value-of select="Metryczka/Za-okres/Rok"/> roku</th>
				<!-- Modyfikacja na potrzeby edytowania komorek -->
				<xsl:choose>
					<xsl:when test="Osób-umieszczonych/@Komorka">
						<xsl:variable name="nazwa">
							<xsl:value-of select="Osób-umieszczonych/@Komorka"/>
						</xsl:variable>
						<xsl:variable name="wartosc">
							<xsl:value-of select="Osób-umieszczonych"/>
						</xsl:variable>
						<xsl:variable name="class">
							<xsl:choose>
								<xsl:when test="Osób-umieszczonych/@Blad='true'">
				                        blad
				                    </xsl:when>
								<xsl:otherwise>
				                        pole
				                    </xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="Osób-umieszczonych/@Edit='true'">
								<th style="border-left: none;" width="240" align="right">
									<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
								</th>
							</xsl:when>
							<xsl:otherwise>
								<th style="border-left: none;" width="240" align="right">
									<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
									<xsl:value-of select="Osób-umieszczonych"/>
								</th>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$porownanie = 'true'">
								<xsl:choose>
									<xsl:when test="Osób-umieszczonych/@Blad='true'">
										<th style="border-left: none; background-color: orange" width="240" align="right">
											<xsl:value-of select="Osób-umieszczonych"/>
										</th>
									</xsl:when>
									<xsl:otherwise>
										<th style="border-left: none;" width="240" align="right">
											<xsl:value-of select="Osób-umieszczonych"/>
										</th>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<th style="border-left: none;" width="240" align="right">
									<xsl:value-of select="Osób-umieszczonych"/>
								</th>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</tr>
			<tr>
				<th style="border-right: none; font-weight: normal;">II.</th>
				<th colspan="2" align="left" style="border-left: none; border-right: none; font-weight: normal;">Liczba osób oczekujących na umieszczenie w środowiskowych domach samopomocy<br/>wg stanu na dzień 31.XII <xsl:value-of select="Metryczka/Za-okres/Rok"/> roku</th>
				<!-- Modyfikacja na potrzeby edytowania komorek -->
				<xsl:choose>
					<xsl:when test="Osób-oczekujących/@Komorka">
						<xsl:variable name="nazwa">
							<xsl:value-of select="Osób-oczekujących/@Komorka"/>
						</xsl:variable>
						<xsl:variable name="wartosc">
							<xsl:value-of select="Osób-oczekujących"/>
						</xsl:variable>
						<xsl:variable name="class">
							<xsl:choose>
								<xsl:when test="Osób-oczekujących/@Blad='true'">
				                        blad
				                    </xsl:when>
								<xsl:otherwise>
				                        pole
				                    </xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="Osób-oczekujących/@Edit='true'">
								<th style="border-left: none;" align="right">
									<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
								</th>
							</xsl:when>
							<xsl:otherwise>
								<th style="border-left: none;" align="right">
									<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
									<xsl:value-of select="Osób-oczekujących"/>
								</th>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$porownanie = 'true'">
								<xsl:choose>
									<xsl:when test="Osób-oczekujących/@Blad='true'">
										<th style="border-left: none; background-color: orange" align="right">
											<xsl:value-of select="Osób-oczekujących"/>
										</th>
									</xsl:when>
									<xsl:otherwise>
										<th style="border-left: none;" align="right">
											<xsl:value-of select="Osób-oczekujących"/>
										</th>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<th style="border-left: none;" align="right">
									<xsl:value-of select="Osób-oczekujących"/>
								</th>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</tr>
			<tr>
				<th rowspan="2" style="border-right: none; font-weight: normal;">III.</th>
				<th rowspan="2" align="left" style="border-left: none; border-right: none; font-weight: normal;">Stopień zaspokojenia potrzeb:</th>
				<th style="border-left: none; border-right: none;">liczba osób umieszczonych x 100</th>
				<th style="border-left: none;" rowspan="2" align="right">
					<xsl:value-of select="format-number((100 * Osób-umieszczonych) div (Osób-umieszczonych + Osób-oczekujących), $ułamek)"/>
				</th>
			</tr>
			<tr>
				<th style="border-left: none; border-right: none;">liczba osób umieszczonych + oczekujących</th>
			</tr>
		</table>
		<br/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<!-- Modyfikacja na potrzeby edytowania komorek porownywanie-->
		<xsl:choose>
			<xsl:when test="$porownanie = 'false'">
				<table border="2" cellspacing="0" cellpadding="4">
					<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
					<thead>
						<tr>
							<th colspan="3">
								<span style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO PRACY I POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5,<br/>00-513 Warszawa
						</span>
							</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td width="290">
								<span style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
								</span>
								<center>
									<xsl:for-each select="Nadawca">
										<table cellspacing="0" cellpadding="0">
											<tr>
												<td class="stamp" colspan="2">
													<xsl:value-of select="Pełna-nazwa"/>
												</td>
											</tr>
											<xsl:for-each select="Adres-pocztowy">
												<tr>
													<td class="stamp" colspan="2">
														<xsl:value-of select="Ulica-i-numer"/>
													</td>
												</tr>
												<tr>
													<td class="stamp" colspan="2">
														<xsl:value-of select="Kod-i-poczta"/>
													</td>
												</tr>
											</xsl:for-each>
											<tr>
												<td colspan="2" class="stamp" style="font-size: 11px; text-align: left">
													<xsl:for-each select="Telefon">
                         	        					           Tel. <xsl:apply-templates/> &#160;
								                        </xsl:for-each>
												</td>
											</tr>
											<tr>
												<td colspan="2" class="stamp" style="font-size: 11px; text-align: left">
													<xsl:for-each select="Faks">
						                                           Fax <xsl:apply-templates/> &#160;
											</xsl:for-each>
												</td>
											</tr>
										</table>
									</xsl:for-each>
								</center>
							</td>
							<td width="195" rowspan="3" style="text-align: center; font-weight: bold;">
								<span style="font-size: large;">
									<xsl:value-of select="name(..)"/>
								</span>
								<br/>
								<p style="font-size: 13px">
									<xsl:value-of select="../Domy-samopomocy/@Opis"/>
								w <xsl:value-of select="Za-okres/Rok"/> roku
						</p>
							</td>
							<td width="205">
								<div style="font-weight: bold; font-size: 13px; text-align: left;">
							Część&#160;&#160;85 - Budżet Wojewody<br/>Dział&#160;852 - Pomoc Społeczna<br/>Rozdział 85203
						</div>
							</td>
						</tr>
						<tr>
							<td>
								<xsl:choose>
									<xsl:when test="$kod_wojewodztwa = 'false'">
										<span style="font-size: 11px; text-align: left;">
									Numer identyfikacyjny jednostki sprawozdawczej:<br/>
										</span>
										<div style="font-weight: bold; text-align: center;">
											<xsl:value-of select="Nadawca/@Kod-REGON"/>
										</div>
									</xsl:when>
									<xsl:otherwise>
										<table>
											<tbody>
												<tr>
													<td>
														<span style="font-size: 11px; text-align: left;">
												Numer identyfikacyjny jednostki sprawozdawczej:
											   </span>
													</td>
													<td>
														<span style="font-weight: bold; text-align: center;">
															<xsl:value-of select="Nadawca/@Kod-REGON"/>
														</span>
													</td>
												</tr>
												<tr>
													<td>
														<span style="font-size: 11px; text-align: left;">
												Kod województwa:
												</span>
													</td>
													<td>
														<span style="font-weight: bold; text-align: center;">
															<xsl:value-of select="substring(Nadawca/@Kod-KESO, 3, 2)"/>
														</span>
													</td>
												</tr>
											</tbody>
										</table>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td rowspan="2" width="200">
								<div style="font-weight: bold; font-size: 13px; text-align: left;">
							Przekazać w terminie do 15-go lutego<sup>1)</sup>
								</div>
							</td>
						</tr>
						<tr>
							<td>
								<span style="font-size: 11px; text-align: left;">
							Województwo:<br/>
								</span>
								<div style="font-weight: bold; text-align: center;">
									<xsl:value-of select="../Nagłówek/Województwo"/>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<xsl:if test="Opis and Opis != ''">
					<div class="reason">
						<br/>
						<xsl:value-of select="Opis"/>
						<br/>
					</div>
				</xsl:if>
				<br/>
				<xsl:if test="(Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III') and Kod/Cyklu-sprawozdawczego != 3 or
					(Za-okres/Kwartał = 'II' or Za-okres/Kwartał = 'IV') and Kod/Cyklu-sprawozdawczego != 4">
					<!--div style="font-size: large; text-align: center; color: red;">
				Niepoprawny kod cyklu sprawozdawczego!
			</div>
			<br/> <br/> <br/> <br/> <br/-->
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<!-- Naglowkowa tabella porownania -->
				<table class="wide" border="1" cellspacing="0" cellpadding="0" width="100%">
					<thead>
						<tr>
							<th colspan="2">
								<span style="font-size: 18px; font-weight: bold;">
			                  Porównanie zawartości komórek sprawozdań o symbolu <xsl:value-of select="$FrmSymbol"/>
								</span>
							</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td width="50%">
								<table>
									<tr>
										<td>
											<B>Sprawozdanie za okres:</B>
											<xsl:value-of select="$ZaOkres1"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Nadawca:</B>
											<xsl:value-of select="$Nadawca1"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Odbiorca:</B>
											<xsl:value-of select="$Odbiorca1"/>
										</td>
									</tr>
									<xsl:if test="$WersjaZ1 != ''">
										<tr>
											<td>
												<B>Wersja po modyfikacji z:</B> dnia <xsl:value-of select="$WersjaZ1"/>
											</td>
										</tr>
									</xsl:if>
								</table>
							</td>
							<td width="50%">
								<table>
									<tr>
										<td>
											<B>Sprawozdanie za okres:</B>
											<xsl:value-of select="$ZaOkres2"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Nadawca:</B>
											<xsl:value-of select="$Nadawca2"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Odbiorca:</B>
											<xsl:value-of select="$Odbiorca2"/>
										</td>
									</tr>
									<xsl:if test="$WersjaZ2 != ''">
										<tr>
											<td>
												<B>Wersja po modyfikacji z:</B> dnia <xsl:value-of select="$WersjaZ2"/>
											</td>
										</tr>
									</xsl:if>
								</table>
							</td>
						</tr>
					</tbody>
				</table>
				<br/>
				<font size="-1">pola oznaczone kolorem <font color="orange">pomarańczowym</font> zawierają wartości różniących się komórek oraz procentowy przyrost wartości pierwszego sprawozdania względem drugiego</font>
				<br/>
				<br/>
				<br/>
				<!-- Koniec naglowkowa tabella porownania -->
			</xsl:otherwise>
		</xsl:choose>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek porownywanie-->
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<xsl:choose>
			<xsl:when test="$porownanie = 'false'">
				<table border="0">
					<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
					<thead>
						<tr>
							<th colspan="2" width="390" align="left">Imię, nazwisko i numer telefonu osoby, która sporządziła informację</th>
							<th>Miejscowość i data</th>
							<th>DYREKTOR</th>
						</tr>
					</thead>
					<tbody>
						<tr style="font-size:12px;">
							<td colspan="2">
								<xsl:value-of select="concat($kto/Imię-i-nazwisko, ', tel. ', $kto/Telefon)"/>
							</td>
							<td align="center">
								<xsl:value-of select="concat(substring(Metryczka/Nadawca/Adres-pocztowy/Kod-i-poczta, 8), ', ', $kto/Data-wykonania)"/>
							</td>
						</tr>
					</tbody>
				</table>
			</xsl:when>
			<xsl:otherwise>
				<table class="wide" border="1" cellspacing="0" cellpadding="0" width="100%">
				<thead>
					<tr>
						<th colspan="2" style="font-size:14px; font-weight:bold;">Osoba sporządzająca</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td width="50%">
							<table>
								<tr>
									<td>
										<B>Imię, nazwisko i numer telefonu osoby, która sporządziła informację: </B>
										<xsl:value-of select="concat($ImieNazwisko1, ', tel. ', $Telefon1)"/>
									</td>
								</tr>
								<tr>
									<td>
										<B>Miejscowość i data: </B>
										<xsl:value-of select="concat(substring($Miejscowosc1, 8), ', ', $DataWykonania1)"/>
									</td>
								</tr>
								<tr>
									<td>
										<B>DYREKTOR</B>
									</td>
								</tr>
							</table>
						</td>
						<td width="50%">
						<table>
								<tr>
									<td>
										<B>Imię, nazwisko i numer telefonu osoby, która sporządziła informację: </B>
										<xsl:value-of select="concat($ImieNazwisko2, ', tel. ', $Telefon2)"/>
									</td>
								</tr>
								<tr>
									<td>
										<B>Miejscowość i data: </B>
										<xsl:value-of select="concat(substring($Miejscowosc2, 8), ', ', $DataWykonania2)"/>
									</td>
								</tr>
								<tr>
									<td>
										<B>DYREKTOR</B>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</tbody>
				</table>
			</xsl:otherwise>
		</xsl:choose>
		<br/>
		<br/>
		<small>W wierszu I należy wykazać osoby umieszczone po raz pierwszy w środowiskowym domu samopomocy.</small>
		<br/>
		<br/>
		<hr align="left" width="400" noshade="1" size="1"/>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td colspan="2" class="stars">1) <font class="remark">
					Jeśli termin przekazania sprawozdania wypada w dzień wolny od pracy, to obowiązuje data pierwszego
					dnia roboczego po tym dniu. Powyższe daty są terminami przekazania sprawozdania do MPS.</font>
				</td>
			</tr>
			<tr>
				<td colspan="2" class="stars">2) <font class="remark">
					Stan na dzień 31.XII roku poprzedniego.</font>
				</td>
			</tr>
			<tr>
				<td colspan="2" class="stars">3) <font class="remark">
					Przybyło i ubyło w roku bieżącym. </font>
				</td>
			</tr>
			<tr>
				<td colspan="2" class="stars">4) <font class="remark">
					Stan na dzień 31.XII roku bieżącego.</font>
				</td>
			</tr>
			<tr>
				<td colspan="2" class="stars">5) <font class="remark">
					Planowane zwiększenie środków w roku następnym.</font>
				</td>
			</tr>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr/>
			<tr>
				<td colspan="2" class="xslt_ver" style="text-align: left;">
					Wersja szablonu XSLT: <xsl:value-of select="$wersja"/>
				</td>
				<td colspan="2" class="xslt_ver" style="text-align: right;">
					<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
					<!--xsl:if test="system-property('msxsl:version')">
						<xsl:value-of select="concat(', MSXML: ', system-property('msxsl:version'))"/>
					</xsl:if-->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="prefix"/>
		<xsl:variable name="row_no" select="count(preceding::*[starts-with(@Pozycja, $prefix)]) + 1"/>
		<td class="row_descr">
			<p>
				<xsl:value-of select="count(preceding::*[starts-with(@Pozycja, $prefix)])+
									  count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)])"/>.
				<xsl:choose>
					<xsl:when test="$row_no = 1">
						Stan na dzień 31.XII <xsl:value-of select="../../Metryczka/Za-okres/Rok - 1"/> roku <sup>2)</sup>
					</xsl:when>
					<xsl:when test="$row_no = 2">
						Przybyło w <xsl:value-of select="../../Metryczka/Za-okres/Rok"/> roku <sup>3)</sup>
					</xsl:when>
					<xsl:when test="$row_no = 3">
						Ubyło w <xsl:value-of select="../../Metryczka/Za-okres/Rok"/> roku <sup>3)</sup>
					</xsl:when>
					<xsl:when test="$row_no =4">
						Stan na dzień 31.XII <xsl:value-of select="../../Metryczka/Za-okres/Rok"/> roku <sup>4)</sup> (1 + 2 - 3)
					</xsl:when>
					<xsl:when test="$row_no = 5">
						Planowane zwiększenie w <xsl:value-of select="../../Metryczka/Za-okres/Rok + 1"/> roku <sup>5)</sup>
					</xsl:when>
				</xsl:choose>
			</p>
		</td>
		<td class="tab_row_no">
			0<xsl:value-of select="$row_no"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Domy-samopomocy">
		<xsl:param name="width" select="716"/>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th class="skl_0" colspan="2" rowspan="2">WYSZCZEGÓLNIENIE</th>
					<th class="skl_1" colspan="3">LICZBA</th>
				</tr>
				<tr>
					<th class="skl_4">DOMÓW</th>
					<th class="skl_4">MIEJSC</th>
					<th class="skl_4">OSÓB PRZEBYWAJĄCYCH</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates/>
			</tbody>
		</table>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Stan-lub-zmiana">
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_SRODOSAM_'"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Domów'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Miejsc'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Osób-przebywających'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_1_column">
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="../*[last() - 1]/@Pozycja = ./@Pozycja">
				<xsl:call-template name="_1_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="nodeset" select="../*[position() &lt; last() - 1]/*[name(.) = $column]"/>
					<xsl:with-param name="format" select="$format"/>
					<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka" select="$item/@Komorka"/>
					<xsl:with-param name="blad" select="$item/@Blad"/>
					<xsl:with-param name="edit" select="$item/@Edit"/>
					<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string($item/@xsi:nil) = 'true'">
						<td class="contents">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                        blad
						                    </xsl:when>
										<xsl:otherwise>
						                        pole
						                    </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($item, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="format-number($item, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_totals">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="result">
			<xsl:value-of select="$nodeset[1] + $nodeset[2] - $nodeset[3]"/>
		</xsl:param>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<xsl:choose>
			<xsl:when test="string(number($contents)) != 'NaN' and $contents != 0">
				<xsl:choose>
					<xsl:when test="string(number($result)) = 'NaN'">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$blad='true'">
						                                    blad
						                    </xsl:when>
										<xsl:otherwise>
						                                    pole
						                    </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$edit='true'">
										<td class="totals" style="background-color: red">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="'suma: NaN'"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<center>X</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$blad='true'">
												<td class="totals" style="background-color: orange">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals" style="background-color: red">
											<center>X</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:when test="$contents != $result">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$blad='true'">
						                                    blad
						                            </xsl:when>
										<xsl:otherwise>
						                                    pole
						                            </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$edit='true'">
										<td class="contents" style="background-color: red">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$blad='true'">
						                                    blad
						                            </xsl:when>
										<xsl:otherwise>
						                                    pole
						                            </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$edit='true'">
										<td class="totals">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($result, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$blad='true'">
												<td class="totals" style="background-color: orange">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<xsl:value-of select="format-number($result, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!-- Modyfikacja na potrzeby edytowania komorek -->
				<xsl:choose>
					<xsl:when test="$komorka!='' and $komorka!='NaN'">
						<xsl:variable name="nazwa">
							<xsl:value-of select="$komorka"/>
						</xsl:variable>
						<xsl:variable name="wartosc">
							<xsl:value-of select="$contents"/>
						</xsl:variable>
						<xsl:variable name="class">
							<xsl:choose>
								<xsl:when test="$blad='true'">
						                                    blad
						                    </xsl:when>
								<xsl:otherwise>
						                                    pole
						                    </xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$edit='true'">
								<td class="totals">
									<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals">
									<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
									<xsl:value-of select="format-number($result, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$porownanie = 'true'">
								<xsl:choose>
									<xsl:when test="$blad='true'">
										<td class="totals" style="background-color: orange">
											<xsl:value-of select="$contents"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<xsl:value-of select="$contents"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals">
									<xsl:value-of select="format-number($result, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
