<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'944'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
					.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;}
					.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
											font-weight: bold;
										}
					.heading_1  	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
											font-weight: bold; text-align: center;
											width: <xsl:value-of select="$width"/>px;
										}
					.data_table	{border: 1px solid black; border-collapse: collapse;
											color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal;
										}
					.bottom_table 	{max-width: 615px; border-width: 0;}
					th          		{padding: 5px; font-weight: bold; border: 1px solid black;}
					caption     	{color: #000000; font-family: Tahoma, Verdana;
											text-align: left; font-size: 14px; font-weight: bold;
											margin-bottom: 0.4em;
										}
					.tab_col_no	{text-align: center; font-size: 8px;
											border: 1px solid black; padding: 5px;
										}
					.tab_row_no	{padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
											text-align: left; border: 1px solid black;
										}
					.contents		{padding: 5px; text-align: right; border: 1px solid black;}
					.totals     		{padding: 5px; text-align: right; border: 1px solid black;}
					.blad				{background-color: red; font-weight: bold;}
					.row_descr	{padding: 5px; text-align: left; border: 1px solid black;}
					.remark			{padding-left: 8px; text-align: justify; vertical-align: baseline;
											color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
											padding-top: 4px; font-weight: normal;
										}
					.stars      		{padding-left: 2px; text-align: left; vertical-align: super;
											color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
											padding-top: 2px; font-weight: normal;
										}
					.stopka			{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal; width: 500px;
										}
				</style>
			</head>
			<body>
				<xsl:apply-templates select="DWiDZK"/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="DWiDZK">
		<xsl:apply-templates select="Metryczka"/>
		<!--
		- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		-->
		<xsl:apply-templates select="Część_A"/>
		<xsl:apply-templates select="Część_B"/>
		<xsl:apply-templates select="Część_C"/>
		<xsl:apply-templates select="Część_D"/>
		<xsl:apply-templates select="Część_E"/>
		<!--
		- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<div class="auth_name">
			Organ sporządzający sprawozdanie:
		</div>
		<div class="stamp">
			<xsl:for-each select="../Nagłówek">
				<xsl:for-each select="Ministerstwo">
					Polska <xsl:apply-templates />
				</xsl:for-each>
				<xsl:for-each select="Województwo">
					Województwo <xsl:apply-templates/>
				</xsl:for-each>
				<xsl:for-each select="Powiat">
					Powiat <xsl:apply-templates/>
				</xsl:for-each>
			</xsl:for-each>
		</div>
		<div class="stamp">
			Adres: 
			<xsl:for-each select="Nadawca/Adres-pocztowy">
				<xsl:value-of select="Ulica-i-numer"/>, <xsl:value-of select="Kod-i-poczta"/>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
		<div class="heading_1">
			SPRAWOZDANIE RZECZOWO-FINANSOWE Z WYKONYWANIA PRZEZ POWIAT DODATKU WYCHOWAWCZEGO, DODATKU DO ZRYCZAŁTOWANEJ KWOTY, O KTÓRYM MOWA W ART. 115 UST. 2A USTAWY<br/>Z DNIA 9 CZERWCA 2011 R. O WSPIERANIU RODZINY I SYSTEMIE PIECZY ZASTĘPCZEJ, I DODATKU W WYSOKOŚCI ŚWIADCZENIA WYCHOWAWCZEGO, O KTÓRYM MOWA W ART. 113A TEJ USTAWY, 
			<xsl:for-each select="Za-okres">
				<xsl:for-each select="Kwartał">
						ZA <xsl:apply-templates/> KWARTAŁ
					</xsl:for-each>
				<xsl:value-of select="concat(' ', Rok, ' R.')"/>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table class="stopka">
			<caption class="stopka">Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td>imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td>telefon służbowy:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td>e-mail służbowy:</td>
				<td>
					<xsl:value-of select="$kto/E-mail"/>
				</td>
			</tr>
			<tr>
				<td>Data sporządzenia sprawozdania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
			<tr>
                <td>Uwagi:</td>
                <td>
                    <xsl:value-of select="Metryczka/Opis"/>
                </td>
            </tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Tables-description">
		<xsl:param name="table_name"/>
		<xsl:choose>
			<xsl:when test="$table_name = 'Część_A'">Wydatki na dodatek wychowawczy, dodatek do zryczałtowanej kwoty, o którym mowa w art. 115 ust. 2a ustawy z dnia 9 czerwca 2011 r. o wspieraniu rodziny i systemie pieczy zastępczej, zwanej dalej "ustawą", i dodatek w wysokości świadczenia wychowawczego, o&#160;którym mowa w art. 113a ustawy, finansowane z dotacji celowej z budżetu państwa oraz liczba świadczeń</xsl:when>
			<xsl:when test="$table_name = 'Część_B'">Informacja o odzyskanych świadczeniach nienależnie pobranych oraz świadczeniach niepodjętych</xsl:when>
			<xsl:when test="$table_name = 'Część_C'">Informacja na temat finansowania dodatku wychowawczego, dodatku do zryczałtowanej kwoty, o którym mowa w art. 115 ust. 2a ustawy, i dodatku w wysokości świadczenia wychowawczego, o którym mowa w art. 113a ustawy</xsl:when>
			<xsl:when test="$table_name = 'Część_D'">Informacja uzupełniająca o realizacji dodatków wychowawczych, dodatków do zryczałtowanej kwoty, o których mowa w art. 115 ust. 2a ustawy, i dodatków w wysokości świadczenia wychowawczego, o których mowa w art. 113a ustawy</xsl:when>
			<xsl:when test="$table_name = 'Część_E'">Informacje o liczbie rodzin zastępczych i rodzinnych domów dziecka pobierających dodatek wychowawczy, liczbie placówek opiekuńczo-wychowawczych typu rodzinnego pobierających dodatek do zryczałtowanej kwoty, o którym mowa w art. 115 ust. 2a ustawy, liczbie placówek opiekuńczo-wychowawczych pobierających dodatek w wysokości świadczenia wychowawczego, o którym mowa w art. 113a ustawy, oraz liczbie dzieci, na które wypłacano dodatek</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Table-caption">
		<caption>
			<xsl:value-of select="concat(substring-after(name(.), '_'), '. ')"/>
			<xsl:call-template name="Tables-description">
				<xsl:with-param name="table_name" select="name()"/>
			</xsl:call-template>		
		</caption>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Rows-description">
		<xsl:param name="row_name"/>
		<xsl:choose>
			<xsl:when test="$row_name = 'A_1'">Dodatek wychowawczy, w tym w:</xsl:when>
			<xsl:when test="$row_name = 'A_1.1'">rodzinach spokrewnionych</xsl:when>
			<xsl:when test="$row_name = 'A_1.2'">rodzinach niezawodowych</xsl:when>
			<xsl:when test="$row_name = 'A_1.3'">rodzinach zawodowych</xsl:when>
			<xsl:when test="$row_name = 'A_1.4'">rodzinnych domach dziecka</xsl:when>
			<xsl:when test="$row_name = 'A_2'">Dodatek do zryczałtowanej kwoty, o którym mowa w art. 115 ust. 2a ustawy</xsl:when>
			<xsl:when test="$row_name = 'A_3'">Dodatek w wysokości świadczenia wychowawczego, o którym mowa w art. 113a ustawy</xsl:when>
			<xsl:when test="$row_name = 'B_1'">Dodatek wychowawczy, dodatek do zryczałtowanej kwoty, o którym mowa w art. 115 ust. 2a ustawy, i&#160;dodatek w wysokości świadczenia wychowawczego, o którym mowa w art. 113a ustawy</xsl:when>
			<xsl:when test="$row_name = 'B_1.1'">- w tym: kwota odzyskanych nienależnie pobranych dodatków wychowawczych, dodatków do zryczałtowanej kwoty, o których mowa w art. 115 ust. 2a ustawy, i dodatków w wysokości świadczenia wychowawczego, o&#160;których mowa w art. 113a ustawy, podlegająca zwrotowi do budżetu państwa</xsl:when>
			<xsl:when test="$row_name = 'C_1'">Wysokość planowanych w danym roku wydatków budżetu państwa na realizację ustawy w zakresie dodatku wychowawczego, dodatku do zryczałtowanej kwoty, o którym mowa w art. 115 ust. 2a ustawy, i dodatku w&#160;wysokości świadczenia wychowawczego, o którym mowa w art. 113a ustawy (wg stanu na ostatni dzień miesiąca)<sup>1)</sup></xsl:when>
			<xsl:when test="$row_name = 'C_2'">Otrzymana z budżetu państwa w danym miesiącu dotacja na realizację ustawy w zakresie dodatku wychowawczego, dodatku do zryczałtowanej kwoty, o którym mowa w art. 115 ust. 2a ustawy, i dodatku w&#160;wysokości świadczenia wychowawczego, o którym mowa w art. 113a ustawy, z tego:</xsl:when>
			<xsl:when test="$row_name = 'C_2.1'">- na wypłaty dodatków wychowawczych</xsl:when>
			<xsl:when test="$row_name = 'C_2.2'">- na wypłaty dodatku do zryczałtowanej kwoty, o którym mowa w art. 115 ust. 2a ustawy</xsl:when>
			<xsl:when test="$row_name = 'C_2.3'">- na wypłaty dodatku w wysokości świadczenia wychowawczego</xsl:when>
			<xsl:when test="$row_name = 'C_2.4'">- na koszty obsługi</xsl:when>
			<xsl:when test="$row_name = 'C_3'">Wydatki na obsługę ustawy w zakresie dodatku wychowawczego, dodatku do zryczałtowanej kwoty, o&#160;którym mowa w art. 115 ust. 2a ustawy, i dodatku w wysokości świadczenia wychowawczego, o którym mowa w art. 113a ustawy, z tego:</xsl:when>
			<xsl:when test="$row_name = 'C_3.1'">- wydatki na wynagrodzenia osób zatrudnionych na podstawie umowy o pracę</xsl:when>
			<xsl:when test="$row_name = 'C_3.2'">- wydatki na wynagrodzenia osób zatrudnionych na podstawie umowy cywilnoprawnej</xsl:when>
			<xsl:when test="$row_name = 'C_3.3'">- wydatki pozostałe</xsl:when>
			<xsl:when test="$row_name = 'C_4'">Wydatki na obsługę ustawy w zakresie dodatku wychowawczego, dodatku do zryczałtowanej kwoty, o&#160;którym mowa w art. 115 ust. 2a ustawy, i dodatku w wysokości świadczenia wychowawczego, o którym mowa w art. 113a ustawy, sfinansowane z dotacji z budżetu państwa, z tego:</xsl:when>
			<xsl:when test="$row_name = 'C_4.1'">- wydatki na wynagrodzenia osób zatrudnionych na podstawie umowy o pracę</xsl:when>
			<xsl:when test="$row_name = 'C_4.2'">- wydatki na wynagrodzenia osób zatrudnionych na podstawie umowy cywilnoprawnej</xsl:when>
			<xsl:when test="$row_name = 'C_4.3'">- wydatki pozostałe</xsl:when>
			<xsl:when test="$row_name = 'D_1'">Liczba wniosków dotyczących dodatku wychowawczego, dodatku do zryczałtowanej kwoty, o którym mowa w art. 115 ust. 2a ustawy, lub dodatku w wysokości świadczenia wychowawczego, o którym mowa w art. 113a ustawy, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D_1.1'">- o przyznanie dodatków wychowawczych</xsl:when>
			<xsl:when test="$row_name = 'D_1.2'">- o przyznanie dodatku do zryczałtowanej kwoty, o którym mowa w art. 115 ust. 2a ustawy</xsl:when>
			<xsl:when test="$row_name = 'D_1.3'">- o przyznanie dodatku w wysokości świadczenia wychowawczego, o którym mowa w art. 113a ustawy</xsl:when>
			<xsl:when test="$row_name = 'D_2'">Liczba decyzji wydanych przez organ właściwy w sprawach dotyczących dodatku wychowawczego, dodatku do zryczałtowanej kwoty, o którym mowa w art. 115 ust. 2a ustawy, i dodatku w wysokości świadczenia wychowawczego, o którym mowa w art. 113a ustawy<sup>1)</sup>, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D_2.1'">- stwierdzających nienależnie pobrane dodatki wychowawcze</xsl:when>
			<xsl:when test="$row_name = 'D_2.2'">- stwierdzających nienależnie pobrane dodatki do zryczałtowanej kwoty, o których mowa w art. 115 ust. 2a ustawy</xsl:when>
			<xsl:when test="$row_name = 'D_2.3'">- stwierdzających nienależnie pobrane dodatki w wysokości świadczenia wychowawczego, o których mowa w art. 113a ustawy</xsl:when>
			<xsl:when test="$row_name = 'E_1'">Liczba rodzin zastępczych i rodzinnych domów dziecka, pobierających dodatek wychowawczy, z tego:</xsl:when>
			<xsl:when test="$row_name = 'E_1.1'">rodzin spokrewnionych</xsl:when>
			<xsl:when test="$row_name = 'E_1.2'">rodzin niezawodowych</xsl:when>
			<xsl:when test="$row_name = 'E_1.3'">rodzin zawodowych</xsl:when>
			<xsl:when test="$row_name = 'E_1.4'">rodzinnych domów dziecka</xsl:when>
			<xsl:when test="$row_name = 'E_2'">Liczba placówek opiekuńczo-wychowawczych typu rodzinnego pobierających dodatek do zryczałtowanej kwoty, o którym mowa w art. 115 ust. 2a ustawy</xsl:when>
			<xsl:when test="$row_name = 'E_3'">Liczba placówek opiekuńczo-wychowawczych, w tym regionalnych placówek opiekuńczo-terapeutycznych i&#160;interwencyjnych ośrodków preadopcyjnych, pobierających dodatek w wysokości świadczenia wychowawczego, o którym mowa w art. 113a ustawy</xsl:when>
			<xsl:when test="$row_name = 'E_4'">Liczba dzieci w rodzinach zastępczych i rodzinnych domach dziecka, na które pobierany był dodatek wychowawczy, z tego:</xsl:when>
			<xsl:when test="$row_name = 'E_4.1'">w rodzinach spokrewnionych</xsl:when>
			<xsl:when test="$row_name = 'E_4.2'">w rodzinach niezawodowych</xsl:when>
			<xsl:when test="$row_name = 'E_4.3'">w rodzinach zawodowych</xsl:when>
			<xsl:when test="$row_name = 'E_4.4'">w rodzinnych domach dziecka</xsl:when>
			<xsl:when test="$row_name = 'E_5'">Liczba dzieci w placówkach opiekuńczo-wychowawczych typu rodzinnego, na które pobierany był dodatek do zryczałtowanej kwoty, o którym mowa w art. 115 ust. 2a ustawy</xsl:when>
			<xsl:when test="$row_name = 'E_6'">Liczba dzieci w placówkach opiekuńczo-wychowawczych, w tym w regionalnych placówkach opiekuńczo-terapeutycznych i interwencyjnych ośrodkach preadopcyjnych, na które pobierany był dodatek w wysokości świadczenia wychowawczego, o którym mowa w art. 113a ustawy</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Row-description">
		<td class="tab_row_no">
			<xsl:value-of select="concat(substring-after(name(), '_'), '.')"/>
		</td>
		<td class="row_descr">
			<xsl:call-template name="Rows-description">
				<xsl:with-param name="row_name" select="name()"/>
			</xsl:call-template>
		</td>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka-tabeli">
		<xsl:param name="remark1"/>
		<table class="bottom_table" cellspacing="0" cellpadding="0">
			<xsl:if test="$remark1">
				<xsl:call-template name="Stopka-tabeli-wiersz">
					<xsl:with-param name="numer" select="'1'"/>
					<xsl:with-param name="opis" select="$remark1"/>
				</xsl:call-template>
			</xsl:if>
		</table>
	</xsl:template>
	<!--
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 -->
	<xsl:template name="Stopka-tabeli-wiersz">
		<xsl:param name="numer"/>
		<xsl:param name="opis"/>
		<tr>
			<td class="stars">
				<xsl:value-of select="$numer"/>)</td>
			<td class="remark">
				<xsl:value-of select="$opis"/>
			</td>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_A">
		<xsl:call-template name="Kwoty-i-liczby-kw-narast"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_B">
		<xsl:call-template name="Kwoty-kw-narast">
			<xsl:with-param name="grouphdr1" select="'Wydatki narastająco od początku roku w zł'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_C">
		<xsl:call-template name="Kwoty-kw-narast">
			<xsl:with-param name="grouphdr1" select="'Wydatki narastająco od początku roku'"/>
		</xsl:call-template>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Zasada narastania nie dotyczy wiersza 1.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_D">
		<xsl:call-template name="Kwoty-kw-nienarast"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'W wierszu 2 należy ująć wszystkie wydane decyzje w sprawach.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_E">
		<xsl:call-template name="Kwoty-kw-nienarast"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Kwoty-i-liczby-kw-narast">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-i-liczby-kw-narast-header"/>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Kwoty-i-liczby-kw-narast-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-i-liczby-kw-narast-header">
		<xsl:param name="grouphdr1" select="'Wydatki narastająco od początku roku w zł'"/>
		<xsl:param name="grouphdr2" select="'Liczba świadczeń narastająco od początku roku'"/>
		<xsl:param name="descrwidth" select="36"/>
		<xsl:param name="lpwidth" select="4"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(round((100-number($descrwidth)-$lpwidth) div 2))"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="{$lpwidth}%" rowspan="2">Lp.</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr1"/>
				</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr2"/>
				</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Pierwszy miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Dwa miesiące kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Trzy miesiące kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Pierwszy miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Dwa miesiące kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Trzy miesiące kwartału</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
				<td class="tab_col_no">7</td>
				<td class="tab_col_no">8</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-i-liczby-kw-narast-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Narast-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Kwoty-narastająco'"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="Narast-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Liczby-narastająco'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Narast-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Trzy-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-narast">
		<xsl:param name="grouphdr1"/>
		<xsl:param name="remark"/>
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-kw-narast-header">
				<xsl:with-param name="grouphdr1" select="$grouphdr1"/>
				<xsl:with-param name="remark" select="$remark"/>
			</xsl:call-template>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Narast-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
							<xsl:with-param name="subtree" select="''"/>
							<xsl:with-param name="format" select="$kwota"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-narast-header">
		<xsl:param name="grouphdr1" select="'Wydatki narastająco od początku roku w zł'"/>
		<xsl:param name="remark"/>
		<xsl:call-template name="Triple-header">
			<xsl:with-param name="grouphdr1" select="$grouphdr1"/>
			<xsl:with-param name="descr2c1" select="'Pierwszy miesiąc kwartału'"/>
			<xsl:with-param name="descr2c2" select="'Dwa miesiące kwartału'"/>
			<xsl:with-param name="descr2c3" select="'Trzy miesiące kwartału'"/>
			<xsl:with-param name="remark" select="$remark"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-nienarast">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-kw-nienarast-header"/>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Kwoty-kw-nienarast-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
							<xsl:with-param name="subtree" select="''"/>
							<xsl:with-param name="format" select="$kwota"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-nienarast-header">
		<xsl:call-template name="Triple-header"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-nienarast-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Drugi-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Trzeci-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Triple-header">
		<xsl:param name="grouphdr1" select="'Wykonanie miesięczne'"/>
		<xsl:param name="descr2c1" select="'Pierwszy miesiąc kwartału'"/>
		<xsl:param name="descr2c2" select="'Drugi miesiąc kwartału'"/>
		<xsl:param name="descr2c3" select="'Trzeci miesiąc kwartału'"/>
		<xsl:param name="remark"/>
		<xsl:param name="descrwidth" select="57"/>
		<xsl:param name="lpwidth" select="4"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(round((100-number($descrwidth)-$lpwidth)))"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="{$lpwidth}%" rowspan="2">Lp.</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr1"/>
					<xsl:if test="$remark">
						<sup>
							<xsl:value-of select="$remark"/>
						</sup>
					</xsl:if>
				</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>
					<xsl:value-of select="$descr2c1"/>
				</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>
					<xsl:value-of select="$descr2c2"/>
				</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>
					<xsl:value-of select="$descr2c3"/>
				</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Column">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="skladniki"/>
		<xsl:param name="format"/>
		<xsl:variable name="item" select="descendant-or-self::*[name(.) = $column]"/>
		<xsl:variable name="subtree_item" select="*[name(.) = $subtree]/descendant-or-self::*[name(.) = $column]"/>
		<xsl:variable name="contents">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="$subtree_item"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$item"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="suma">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string(number($contents)) = 'NaN'">
							<div style="color: red; text-align: center;">???</div>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="suma">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents"/>
		<xsl:param name="format"/>
		<xsl:param name="skladniki"/>
		<xsl:variable name="wynik">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="sum(../*[contains($skladniki,concat(name(.),' '))]/*[name(.) = $subtree]/descendant-or-self::*[name(.) = $column])"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="sum(../*[contains($skladniki,concat(name(.),' '))]/descendant-or-self::*[name(.) = $column])"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string(number($wynik)) = 'NaN'">
				<td class="totals blad">
					<center>???</center>
				</td>
			</xsl:when>
			<xsl:when test="string(number($contents)) != 'NaN' and $contents != ''">
				<xsl:choose>
					<xsl:when test="$contents != $wynik">
						<td class="contents blad">
							<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
							<br/>
							<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($wynik, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($wynik, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>