<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.2'"/>
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator="," />
	<xsl:variable name="ułamek" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="procent" select="'###&#160;###&#160;###&#160;##0,00%'"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'944px'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
                     		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal; width: 20px;
                                					}
                   			 .contents	{height: 2.0em; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.0em; padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; width:  350px;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold; padding-bottom: 8px;
                                				}
                    		.stars      	{padding-left: 0px; text-align: right; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; margin-top: 14px;
                                				}
                    		.empty		{border: 0 0 0 0;}
                </style>
			</head>
			<body>
				<xsl:apply-templates/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="MPiPS-05">
	<xsl:apply-templates select="Metryczka"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Tabela-1"/>
		<xsl:apply-templates select="Tabela-2"/>
		<xsl:apply-templates select="Tabela-3"/>
		<xsl:apply-templates select="Tabela-4"/>
		<xsl:apply-templates select="Tabela-5"/>
		<xsl:apply-templates select="Tabela-6"/>
		
		<xsl:apply-templates select="Tabela-1G"/>
		<xsl:apply-templates select="Tabela-2G"/>
		<xsl:apply-templates select="Tabela-3G"/>
		<xsl:apply-templates select="Tabela-4G"/>
		<xsl:apply-templates select="Tabela-5G"/>
		<xsl:apply-templates select="Tabela-6G"/>
		
		<xsl:apply-templates select="Tabela-7"/>
		<xsl:apply-templates select="Tabela-8"/>
		<xsl:apply-templates select="Tabela-9"/>
		<xsl:apply-templates select="Tabela-10"/>
		<xsl:apply-templates select="Tabela-11"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Metryczka_Tabeli">
		<xsl:param name="width"/>
		<xsl:param name="table_name"/>
		<xsl:param name="table_title"/>
		<table border="1" cellspacing="0" cellpadding="2">
			<xsl:attribute name="style">
 				<xsl:if test="$table_name != 'Tablica 1'">
 					page-break-before: always;
 				</xsl:if>
  				width: <xsl:number value="$width"/>px;
			</xsl:attribute>
			<tbody>
				<tr>
				<td width="20%" style="vertical-align: bottom">
					<xsl:call-template name="Stempel_Jednostki"/>
				</td>
				<td style="text-align: center; font-weight: bold;">
					<span style="font-size: large;"><xsl:value-of select="$table_name"/></span>
					<br/>
					<p style="font-size: 13px">
						<xsl:value-of select="$table_title"/>
						<xsl:if test="$table_name != 'Tablica 7' and $table_name != 'Tablica 8' and $table_name != 'Tablica 9' and $table_name != 'Tablica 10' and $table_name != 'Tablica 11'">
							<span class="stars">*</span>
 						</xsl:if>
					</p>
				</td>
				<td width="20%"  style="vertical-align: bottom">
					<xsl:call-template name="Data_Przekazania"/>
				</td>
				</tr>
			</tbody>
		</table>
		<br/>
	</xsl:template>
	<!-- 
	=============================================================================================
	 -->
	<xsl:template name="Stempel_Jednostki">
		<table border="0" cellspacing="0" cellpadding="2">
			<tr><td style="font-size: 8px; text-align: left;">..................................................</td></tr>
			<tr><td style="font-size: 8px; text-align: left;"><b>Stempel jednostki wykonującej sprawozdanie</b></td></tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Data_Przekazania">
		<div style="font-weight: bold; font-size: 13px; text-align: center;">
			Przekazać / wysłać:<br/>
			<xsl:choose>
				<xsl:when test="../Nagłówek/Województwo or ../Nagłówek/Ministerstwo">
					do 28 lutego <xsl:value-of select="../Metryczka/Za-okres/Rok + 1"/> r.
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<!-- ../Metryczka/Nadawca/@Kod-KESO -->
						<xsl:when test="starts-with(../Metryczka/Nadawca/@Kod-KESO, '20') or starts-with(../Metryczka/Nadawca/@Kod-KESO, '25') or starts-with(../Metryczka/Nadawca/@Kod-KESO, '30') or starts-with(../Metryczka/Nadawca/@Kod-KESO, '40') ">
							do 15 lutego <xsl:value-of select="../Metryczka/Za-okres/Rok + 1"/> r.
						</xsl:when>
						<xsl:otherwise>
							do 31 stycznia <xsl:value-of select="../Metryczka/Za-okres/Rok + 1"/> r. 
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	-->
	<xsl:template name="Tabela_Podpis">
		<span class="stars">* - Należy wypełnić pola dotyczące jednostki wykonującej sprawozdanie.</span>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/> <br/> <br/>
			</div>
		</xsl:if>
		<table border="2" cellspacing="0" cellpadding="8">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th colspan="3">
						<span  style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO PRACY I POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5, 00-513 Warszawa
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="300">
						<span  style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
						</span>
						<center>
							<xsl:for-each select="Nadawca">
								<table cellspacing="0" cellpadding="0">
									<tr>
										<td class="stamp" colspan="2">
											<xsl:value-of select="Pełna-nazwa"/>
										</td>
									</tr>
									<xsl:for-each select="Adres-pocztowy">
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Ulica-i-numer"/>
											</td>
										</tr>
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Kod-i-poczta"/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td class="stamp" style="font-size: 11px; text-align: left">
											<xsl:for-each select="Telefon">
                                 					           Tel. <xsl:apply-templates/> &#160;
					                                        </xsl:for-each>
										</td>
										<td class="stamp" style="font-size: 11px; text-align: right">
											<xsl:for-each select="Faks">
					                                            &#160;Fax <xsl:apply-templates/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>
						</center>
					</td>
					<td rowspan="2" style="text-align: center; font-weight: bold;">
					    <span style="font-size: large;">MPiPS-05</span><br/>
					    <p style="font-size: 13px">
					      Sprawozdanie<br/>o placówkach zapewniających<br/>
					      całodobową opiekę i wsparcie<br/><br/>
					      za rok <xsl:value-of select="concat(' ', Za-okres/Rok)"/>
					    </p>
					</td>
					<td width="300">
						<span  style="font-size: 11px; text-align: left;">
							Adresat:<br/>
						</span>
						<div class="stamp">
							<xsl:value-of select="Odbiorca/Pełna-nazwa"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<span  style="font-size: 11px; text-align: left;">
							Numer identyfikacyjny REGON:<br/>
						</span>
						<div style="font-weight: bold; text-align: center;">
							<xsl:value-of select="Nadawca/@Kod-REGON"/>
						</div>
					</td>
					<td>
						<div style="font-weight: bold; font-size: 13px; text-align: center;">
						  	<xsl:call-template name="Data_Przekazania"/>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<br/>
		<br/> <br/> <br/>
		<xsl:if test="(Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III') and Kod/Cyklu-sprawozdawczego != 2 or
					Za-okres/Kwartał = 'II' and Kod/Cyklu-sprawozdawczego != 3 or
					Za-okres/Kwartał = 'IV' and Kod/Cyklu-sprawozdawczego != 4">
			<div style="font-size: large; text-align: center; color: red;">
				Niepoprawny okres lub kod cyklu sprawozdawczego!
			</div>
			<br/> <br/> <br/>
		</xsl:if>
	</xsl:template>

	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:param name="width"/>
		<xsl:variable name="kto" select="../Nagłówek/Osoba-sporządzająca"/>
		<table border="0">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th width="390" align="left">Imię, nazwisko i numer telefonu osoby, która sporządziła informację</th>
					<th>Miejscowość i data</th>
					<th>DYREKTOR</th>
				</tr>
			</thead>
			<tbody>
			<tr>
				<td>
					<xsl:value-of select="concat($kto/Imię-i-nazwisko, ', tel. ', $kto/Telefon)"/>
					<br/>
					<xsl:value-of select="concat('E-mail: ', $kto/E-mail)"/>
				</td>
				<td align="center">
					<xsl:value-of select="concat(substring(../Metryczka/Nadawca/Adres-pocztowy/Kod-i-poczta, 8), ', ', $kto/Data-wykonania)"/>
				</td>
			</tr>
			</tbody>
		</table>

		<br/><br/>
		<!--hr align="left" width="400" noshade="1" size="1"/>
		<table border="0" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<tr>
				<td class="stars">1)</td>
				<td class="remark">
					Jeśli termin przekazania sprawozdania wypada na dzień wolny od pracy, to obowiązuje data pierwszego
					dnia roboczego po tym dniu.
				</td>
			</tr>
		</table-->

		<xsl:if test="name(.)='Tabela-11'">
			<table border="0" cellspacing="0" cellpadding="0">
				<xsl:attribute name="width">
					<xsl:value-of select="$width"/>
				</xsl:attribute>
				<tr>
					<td class="xslt_ver" style="text-align: left;">
						Wersja szablonu XSLT: <xsl:value-of select="$wersja"/>
					</td>
					<td class="xslt_ver" style="text-align: right;">
						<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="level"/><xsl:param name="prefix"/>
		<xsl:variable name="row_no" select="count(preceding::*[starts-with(@Pozycja, $prefix)])+ count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)])"/>
		<xsl:variable name="topbot" select="'margin-top: 4px; margin-bottom: 4px; margin-left: '"/>
		<xsl:variable name="indent" select="25"/>
		<td class="row_descr">
			<xsl:if test="not(preceding-sibling::*) and ../@Prefiks">
		 	        <p>
						<xsl:attribute name="style">
							<xsl:value-of select="concat($topbot, string($indent * ($level - 1)), 'px;')" />
						</xsl:attribute>
						<xsl:value-of select="../@Prefiks"/><br/>
				    </p>
			</xsl:if>
			<p>
				<xsl:if test="$level &gt;= 0">
					<xsl:attribute name="style">
						<xsl:value-of select="concat($topbot, string($indent * $level), 'px;')" />
					</xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="name(..) = 'Tabela-2' or name(..) = 'Tabela-2G' or name(..) = 'Tabela-5' or name(..) = 'Tabela-5G' or name(..) = 'Tabela-6' or name(..) = 'Tabela-6G' or name(..) = 'Tabela-9' or name(..) = 'Tabela-11'">
						<xsl:if test="$row_no != 1">
							<xsl:value-of select="$row_no - 1"/>)
						</xsl:if>
						<xsl:value-of select="@Opis"/>
						<xsl:if test="$row_no = 1">
							<xsl:choose>
								<xsl:when test="name(..) = 'Tabela-2' or name(..) = 'Tabela-2G'">
									(dla liczby mieszkańców i&#160;miejsc) (w. 2+3+4+5+6+7+8+9+10+11)
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="name(..) = 'Tabela-6' or name(..) = 'Tabela-6G'">
											(1+2+3+4+5+6)
										</xsl:when>
										<xsl:when test="name(..) != 'Tabela-11' and name(..) != 'Tabela-6' and name(..) != 'Tabela-6G'">
											(1+2+3+4+5)
										</xsl:when>
										<xsl:otherwise/>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
							<br/>z tego<xsl:if test="name(..) = 'Tabela-2' or name(..) = 'Tabela-2G' or name(..) = 'Tabela-11'"> dla</xsl:if>:
						</xsl:if>
					</xsl:when>
					<xsl:when test="name(../..) = 'Tabela-7' or name(../..) = 'Tabela-10'">
						<xsl:value-of select="$row_no"/>.
						<xsl:value-of select="@Opis"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@Opis"/>
					</xsl:otherwise>
				</xsl:choose>
			</p>
		</td>
		<xsl:if test="name(..) = 'Tabela-2'or name(..) = 'Tabela-2G' or name(..) = 'Tabela-3' or name(..) = 'Tabela-3G' or name(../../..) = 'Tabela-3' or name(../../../../..) = 'Tabela-3' or name(../../..) = 'Tabela-3G' or name(../../../../..) = 'Tabela-3G'">
			<td class="tab_row_no">
				<xsl:if test="$row_no &lt; 10 and (name(..) != 'Tabela-2' or name(..) != 'Tabela-2G' )"><xsl:value-of select="'0'"/></xsl:if>
				<xsl:value-of select="$row_no"/>
			</td>
		</xsl:if>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="sumuj">
		<xsl:param name="wynik"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma"/>
		<xsl:param name="extrefname"/>
		<xsl:param name="extrefval"/>
		<xsl:choose>
			<xsl:when test="$suma!=''">
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="substring-after($suma,'+')"/>
					<xsl:with-param name="extrefname" select="$extrefname"/>
					<xsl:with-param name="extrefval" select="$extrefval"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string(number($wynik)) = 'NaN'">
						<td class="totals" style="background-color: red">
							<center>???</center>
						</td>
					</xsl:when>
					<xsl:when test="string(number($contents)) != 'NaN'">
						<xsl:choose>
							<xsl:when test="$contents != $wynik">
								<td class="contents" style="background-color: red">
									<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
									<br/>
									<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
								</td>
							</xsl:when>
							<xsl:when test="string($extrefname) = 'Tabela 6' or string($extrefname) = 'Tabela 6G'">
								 <xsl:choose>
										<xsl:when test="$contents &lt; $extrefval">
											<td class="contents" style="background-color: red">
												<xsl:value-of select="concat('Tutaj: ', format-number($contents, $format))"/>
												<br/>
												<xsl:value-of select="concat($extrefname, ': ', format-number($extrefval, $format))"/>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td class="totals">
												<xsl:value-of select="format-number($wynik, $format)"/>
											</td>
										</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="string($extrefval) != '' and $contents != $extrefval">
								<td class="contents" style="background-color: red">
									<xsl:value-of select="concat('Tutaj: ', format-number($contents, $format))"/>
									<br/>
									<xsl:value-of select="concat($extrefname, ': ', format-number($extrefval, $format))"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals">
									<xsl:value-of select="format-number($wynik, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($wynik, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Tabela-1">
		<xsl:call-template name="Tabela-1_G"/>
	</xsl:template>

	<xsl:template match="Tabela-1G">
		<xsl:call-template name="Tabela-1_G"/>
	</xsl:template>
		
	<xsl:template name="Tabela-1_G">
		<xsl:param name="width" select="816"/>
		<xsl:param name="rodzaj" select="substring-after(name(.), '-')"/>
		<xsl:call-template name="Metryczka_Tabeli">
			<xsl:with-param name="width" select="$width"/>
			<xsl:with-param name="table_name" select="concat('Tablica ', $rodzaj)  "/>
			<xsl:with-param name="table_title">
				Bilans liczby miejsc w&#160;Domach Pomocy Społecznej za rok sprawozdawczy 
				i&#160;planowane zwiększenie liczby miejsc w&#160;następnym roku sprawozdawczym
			</xsl:with-param>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th rowspan="2">WYSZCZEGÓLNIENIE</th>
					<th width="12%" rowspan="2">OGÓŁEM<br/>LICZBA MIEJSC<br/>(2+3)</th>
					<th colspan="2">z tego w domach:</th>
				</tr>
				<tr>
					<th width="12%">SAMORZĄDÓW</th>
					<th width="12%">PODMIOTÓW NIEPUBLICZNYCH</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
				</tr>
			</thead>
			<tbody>
			<xsl:apply-templates select="Bilans-miejsc">
				<xsl:with-param name="margin" select="0"/>
			</xsl:apply-templates>
			</tbody>
		</table>
		<xsl:call-template name="Tabela_Podpis"/>
		<br/>
		<xsl:call-template name="Stopka">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Bilans-miejsc">
		<xsl:param name="margin"/>
		<xsl:if test="@Pozycja = '_BIL-MIEJSC_12' or @Pozycja = '_BIL-MIEJSC-G_12'">
			<tr>
				<th style="border-left: none; border-right: none;">&#160;<br/>&#160;</th>
				<th style="border-left: none; border-right: none;">&#160;<br/>&#160;</th>
				<th style="border-left: none; border-right: none;">&#160;<br/>&#160;</th>
				<th style="border-left: none; border-right: none;">&#160;<br/>&#160;</th>
			</tr>
		</xsl:if>

		<tr>
			<xsl:choose>
				<xsl:when test="starts-with(@Pozycja, '_BIL-MIEJSC_')">
					<xsl:call-template name="Row-description">
						<xsl:with-param name="prefix" select="'_BIL-MIEJSC_'" />
						<xsl:with-param name="level" select="$margin"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
				<xsl:call-template name="Row-description">
					<xsl:with-param name="prefix" select="'_BIL-MIEJSC-G_'" />
					<xsl:with-param name="level" select="$margin"/>
				</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:apply-templates select="Miejsc-w-PDPS"/>
		</tr>

		<xsl:apply-templates select="*/Bilans-miejsc">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Miejsc-w-PDPS">
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Ogółem'"/>
				<xsl:with-param name="subtree" select="'Miejsc-w-PDPS'"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'W-samorządowych'"/>
				<xsl:with-param name="subtree" select="'Miejsc-w-PDPS'"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'W-niepublicznych'"/>
				<xsl:with-param name="subtree" select="'Miejsc-w-PDPS'"/>
			</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_column">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="format" select="$liczba"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="../Z-tego and not($item/@xsi:nil)">
				<xsl:choose>
					<!-- Tabela-4 -->
					<xsl:when test="../@Pozycja = '_BIL-ZATR_02'">
						<xsl:call-template name="_1_z_tego">
							<xsl:with-param name="subtree" select="$subtree"/>
							<xsl:with-param name="column" select="$column"/>
							<xsl:with-param name="contents" select="$contents"/>
							<xsl:with-param name="extrefname" select="'Tabela 5'"/>
							<xsl:with-param name="extrefval">
								<xsl:choose>
									<xsl:when test="$column = 'W-samorządowych'">
										<xsl:value-of select="//Tabela-5/*[./@Pozycja = '_ETATY-PDPS_01']/W-samorządowych/Liczba-osób"/>
									</xsl:when>
									<xsl:when test="$column = 'W-niepublicznych'">
										<xsl:value-of select="//Tabela-5/*[./@Pozycja = '_ETATY-PDPS_01']/W-niepublicznych/Liczba-osób"/>
									</xsl:when>
								</xsl:choose>
							</xsl:with-param>
							<xsl:with-param name="format" select="$format"/>
						</xsl:call-template>
					</xsl:when>
					<!-- Tabela-4G -->
					<xsl:when test="../@Pozycja = '_BIL-ZATR-G_02'">
						<xsl:call-template name="_1_z_tego">
							<xsl:with-param name="subtree" select="$subtree"/>
							<xsl:with-param name="column" select="$column"/>
							<xsl:with-param name="contents" select="$contents"/>
							<xsl:with-param name="extrefname" select="'Tabela 5G'"/>
							<xsl:with-param name="extrefval">
								<xsl:choose>
									<xsl:when test="$column = 'W-samorządowych'">
										<xsl:value-of select="//Tabela-5G/*[./@Pozycja = '_ETATY-PDPS-G_01']/W-samorządowych/Liczba-osób"/>
									</xsl:when>
									<xsl:when test="$column = 'W-niepublicznych'">
										<xsl:value-of select="//Tabela-5G/*[./@Pozycja = '_ETATY-PDPS-G_01']/W-niepublicznych/Liczba-osób"/>
									</xsl:when>
								</xsl:choose>
							</xsl:with-param>
							<xsl:with-param name="format" select="$format"/>
						</xsl:call-template>
					</xsl:when>
					<!-- Tabela-3 -->
					<xsl:when test="../@Pozycja = '_BIL-OSOB_02' and $column = 'Ogółem'">
						<xsl:call-template name="_1_z_tego">
							<xsl:with-param name="subtree" select="$subtree"/>
							<xsl:with-param name="column" select="$column"/>
							<xsl:with-param name="contents" select="$contents"/>
							<xsl:with-param name="extrefname" select="'Tabela 6'"/>
							<xsl:with-param name="extrefval" select="//Tabela-6/*[./@Pozycja = '_DPS-UOCZ_01']/Liczba-umieszczonych"/>
							<xsl:with-param name="format" select="$format"/>
						</xsl:call-template>
					</xsl:when>
					<!-- Tabela-3G -->
					<xsl:when test="../@Pozycja = '_BIL-OSOB-G_02' and $column = 'Ogółem'">
						<xsl:call-template name="_1_z_tego">
							<xsl:with-param name="subtree" select="$subtree"/>
							<xsl:with-param name="column" select="$column"/>
							<xsl:with-param name="contents" select="$contents"/>
							<xsl:with-param name="extrefname" select="'Tabela 6G'"/>
							<xsl:with-param name="extrefval" select="//Tabela-6G/*[./@Pozycja = '_DPS-UOCZ-G_01']/Liczba-umieszczonych"/>
							<xsl:with-param name="format" select="$format"/>
						</xsl:call-template>
					</xsl:when>
					<!-- Tabela-3 -->
					<xsl:when test="../@Pozycja = '_BIL-OSOB_10'">
						<xsl:call-template name="_1_z_tego">
							<xsl:with-param name="subtree" select="$subtree"/>
							<xsl:with-param name="column" select="$column"/>
							<xsl:with-param name="contents" select="$contents"/>
							<xsl:with-param name="extrefname" select="'Tabela 2'"/>
							<xsl:with-param name="extrefval">
								<xsl:choose>
									<xsl:when test="$column = 'W-samorządowych'">
										<xsl:value-of select="//Tabela-2/*[./@Pozycja = '_DPS-EWID_01']/Samorządów/Liczba-mieszkańców"/>
									</xsl:when>
									<xsl:when test="$column = 'W-niepublicznych'">
										<xsl:value-of select="//Tabela-2/*[./@Pozycja = '_DPS-EWID_01']/Podmiotów-niepublicznych/Liczba-mieszkańców"/>
									</xsl:when>
								</xsl:choose>
							</xsl:with-param>
							<xsl:with-param name="format" select="$format"/>
						</xsl:call-template>
					</xsl:when>
					<!-- Tabela-3G -->
					<xsl:when test="../@Pozycja = '_BIL-OSOB-G_10'">
						<xsl:call-template name="_1_z_tego">
							<xsl:with-param name="subtree" select="$subtree"/>
							<xsl:with-param name="column" select="$column"/>
							<xsl:with-param name="contents" select="$contents"/>
							<xsl:with-param name="extrefname" select="'Tabela 2G'"/>
							<xsl:with-param name="extrefval">
								<xsl:choose>
									<xsl:when test="$column = 'W-samorządowych'">
										<xsl:value-of select="//Tabela-2G/*[./@Pozycja = '_DPS-EWID-G_01']/Samorządów/Liczba-mieszkańców"/>
									</xsl:when>
									<xsl:when test="$column = 'W-niepublicznych'">
										<xsl:value-of select="//Tabela-2G/*[./@Pozycja = '_DPS-EWID-G_01']/Podmiotów-niepublicznych/Liczba-mieszkańców"/>
									</xsl:when>
								</xsl:choose>
							</xsl:with-param>
							<xsl:with-param name="format" select="$format"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="_1_z_tego">
							<xsl:with-param name="subtree" select="$subtree"/>
							<xsl:with-param name="column" select="$column"/>
							<xsl:with-param name="contents" select="$contents"/>
							<xsl:with-param name="format" select="$format"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$column = 'Ogółem'">
				<xsl:choose>
					<!-- Tabela-3 -->
					<xsl:when test="../@Pozycja = '_BIL-OSOB_02'">
						<xsl:call-template name="_1_totals">
							<xsl:with-param name="contents" select="$contents"/>
							<xsl:with-param name="nodeset" select="*[name(.) != $column]"/>
							<xsl:with-param name="extrefname" select="'Tabela 6'"/>
							<xsl:with-param name="extrefval" select="//Tabela-6/*[./@Pozycja = '_DPS-UOCZ_01']/Liczba-umieszczonych"/>
							<xsl:with-param name="format" select="$format"/>
						</xsl:call-template>
					</xsl:when>
					<!-- Tabela-3G -->
					<xsl:when test="../@Pozycja = '_BIL-OSOB-G_02'">
						<xsl:call-template name="_1_totals">
							<xsl:with-param name="contents" select="$contents"/>
							<xsl:with-param name="nodeset" select="*[name(.) != $column]"/>
							<xsl:with-param name="extrefname" select="'Tabela 6G'"/>
							<xsl:with-param name="extrefval" select="//Tabela-6G/*[./@Pozycja = '_DPS-UOCZ-G_01']/Liczba-umieszczonych"/>
							<xsl:with-param name="format" select="$format"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="_1_totals">
							<xsl:with-param name="contents" select="$contents"/>
							<xsl:with-param name="nodeset" select="*[name(.) != $column]"/>
							<xsl:with-param name="format" select="$format"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- Tabela 1 -->
			<xsl:when test="../@Pozycja = '_BIL-MIEJSC_10'">
				<xsl:call-template name="_1_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 1: w. 4 = (w. 2 - w. 3)
					-->
					<xsl:with-param name="result" select="../../*[./@Pozycja = '_BIL-MIEJSC_02']/*[name(.) = $subtree]/*[name(.) = $column] -
																				   ../../*[./@Pozycja = '_BIL-MIEJSC_06']/*[name(.) = $subtree]/*[name(.) = $column]"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 1G -->
			<xsl:when test="../@Pozycja = '_BIL-MIEJSC-G_10'">
				<xsl:call-template name="_1_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 1G: w. 4 = (w. 2 - w. 3)
					-->
					<xsl:with-param name="result" select="../../*[./@Pozycja = '_BIL-MIEJSC-G_02']/*[name(.) = $subtree]/*[name(.) = $column] -
																				   ../../*[./@Pozycja = '_BIL-MIEJSC-G_06']/*[name(.) = $subtree]/*[name(.) = $column]"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 1 -->
			<xsl:when test="../@Pozycja = '_BIL-MIEJSC_11'">
				<xsl:call-template name="_1_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 1: w. 5 = (w. 1 + w. 2 - w. 3) = (w. 1 + w. 4)
					-->
					<xsl:with-param name="result" select="../../*[./@Pozycja = '_BIL-MIEJSC_01']/*[name(.) = $subtree]/*[name(.) = $column] +
																				../../*[./@Pozycja = '_BIL-MIEJSC_10']/*[name(.) = $subtree]/*[name(.) = $column]"/>
					<xsl:with-param name="extrefname" select="'Tabela 2'"/>
					<xsl:with-param name="extrefval">
						<xsl:choose>
							<xsl:when test="$column = 'W-samorządowych'">
								<xsl:value-of select="//Tabela-2/*[./@Pozycja = '_DPS-EWID_01']/Samorządów/Liczba-miejsc"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="//Tabela-2/*[./@Pozycja = '_DPS-EWID_01']/Podmiotów-niepublicznych/Liczba-miejsc"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:with-param>															   
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 1G -->
			<xsl:when test="../@Pozycja = '_BIL-MIEJSC-G_11'">
				<xsl:call-template name="_1_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 1G: w. 5 = (w. 1 + w. 2 - w. 3) = (w. 1 + w. 4)
					-->
					<xsl:with-param name="result" select="../../*[./@Pozycja = '_BIL-MIEJSC-G_01']/*[name(.) = $subtree]/*[name(.) = $column] +
																				../../*[./@Pozycja = '_BIL-MIEJSC-G_10']/*[name(.) = $subtree]/*[name(.) = $column]"/>
					<xsl:with-param name="extrefname" select="'Tabela 2G'"/>
					<xsl:with-param name="extrefval">
						<xsl:choose>
							<xsl:when test="$column = 'W-samorządowych'">
								<xsl:value-of select="//Tabela-2G/*[./@Pozycja = '_DPS-EWID-G_01']/Samorządów/Liczba-miejsc"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="//Tabela-2G/*[./@Pozycja = '_DPS-EWID-G_01']/Podmiotów-niepublicznych/Liczba-miejsc"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:with-param>															   
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 3 -->
			<xsl:when test="../@Pozycja = '_BIL-OSOB_01'">
				<xsl:call-template name="_1_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 3: w. 1 = (w. 10 + w. 5 - w. 2)
					-->
					<xsl:with-param name="result" select="../../*[./@Pozycja = '_BIL-OSOB_10']/*[name(.) = $subtree]/*[name(.) = $column] +
																				   ../../*[./@Pozycja = '_BIL-OSOB_05']/*[name(.) = $subtree]/*[name(.) = $column] -
																				   ../../*[./@Pozycja = '_BIL-OSOB_02']/*[name(.) = $subtree]/*[name(.) = $column]"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 3G -->
			<xsl:when test="../@Pozycja = '_BIL-OSOB-G_01'">
				<xsl:call-template name="_1_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 3G: w. 1 = (w. 10 + w. 5 - w. 2)
					-->
					<xsl:with-param name="result" select="../../*[./@Pozycja = '_BIL-OSOB-G_10']/*[name(.) = $subtree]/*[name(.) = $column] +
																				   ../../*[./@Pozycja = '_BIL-OSOB-G_05']/*[name(.) = $subtree]/*[name(.) = $column] -
																				   ../../*[./@Pozycja = '_BIL-OSOB-G_02']/*[name(.) = $subtree]/*[name(.) = $column]"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 3 -->
			<xsl:when test="../@Pozycja = '_BIL-OSOB_26'">
				<xsl:call-template name="_1_diffs">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 3: w. 26 = (w. 10 - w. 17)
					-->
					<xsl:with-param name="result" select =	"../../*[./@Pozycja = '_BIL-OSOB_10']/*[name(.) = $subtree]/*[name(.) = $column] -
																				 ../../*[./@Pozycja = '_BIL-OSOB_17']/*[name(.) = $subtree]/*[name(.) = $column] "/>
					<xsl:with-param name="descr" select="'w10-w17'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 3G -->
			<xsl:when test="../@Pozycja = '_BIL-OSOB-G_26'">
				<xsl:call-template name="_1_diffs">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 3G: w. 26 = (w. 10 - w. 17)
					-->
					<xsl:with-param name="result" select =	"../../*[./@Pozycja = '_BIL-OSOB-G_10']/*[name(.) = $subtree]/*[name(.) = $column] -
																				 ../../*[./@Pozycja = '_BIL-OSOB-G_17']/*[name(.) = $subtree]/*[name(.) = $column] "/>
					<xsl:with-param name="descr" select="'w10-w17'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 3 -->
			<xsl:when test="../@Pozycja = '_BIL-OSOB_28'">
				<xsl:call-template name="_1_diffs">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 3: w. 28 = (w. 36 - w. 30 - w. 32 - w. 34)
					-->
					<xsl:with-param name="result" select = 	"../../../../../../*[./@Pozycja = '_BIL-OSOB_36']/*[name(.) = $subtree]/*[name(.) = $column] -
																							 ../../*[./@Pozycja = '_BIL-OSOB_30']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB_32']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB_34']/*[name(.) = $subtree]/*[name(.) = $column]
																				"/>
					<xsl:with-param name="descr" select="'w36-w30-w32-w34'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 3G -->
			<xsl:when test="../@Pozycja = '_BIL-OSOB-G_28'">
				<xsl:call-template name="_1_diffs">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 3G: w. 28 = (w. 36 - w. 30 - w. 32 - w. 34)
					-->
					<xsl:with-param name="result" select = 	"../../../../../../*[./@Pozycja = '_BIL-OSOB-G_36']/*[name(.) = $subtree]/*[name(.) = $column] -
																							 ../../*[./@Pozycja = '_BIL-OSOB-G_30']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB-G_32']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB-G_34']/*[name(.) = $subtree]/*[name(.) = $column]
																				"/>
					<xsl:with-param name="descr" select="'w36-w30-w32-w34'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 3 -->
			<xsl:when test="../@Pozycja = '_BIL-OSOB_30'">
				<xsl:call-template name="_1_diffs">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 3: w. 30 = (w. 36 - w. 28 - w. 32 - w. 34)
					-->
					<xsl:with-param name="result" select = 	"../../../../../../*[./@Pozycja = '_BIL-OSOB_36']/*[name(.) = $subtree]/*[name(.) = $column] -
																							 ../../*[./@Pozycja = '_BIL-OSOB_28']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB_32']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB_34']/*[name(.) = $subtree]/*[name(.) = $column]
																				"/>
					<xsl:with-param name="descr" select="'w36-w28-w32-w34'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 3G -->
			<xsl:when test="../@Pozycja = '_BIL-OSOB-G_30'">
				<xsl:call-template name="_1_diffs">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 3G: w. 30 = (w. 36 - w. 28 - w. 32 - w. 34)
					-->
					<xsl:with-param name="result" select = 	"../../../../../../*[./@Pozycja = '_BIL-OSOB-G_36']/*[name(.) = $subtree]/*[name(.) = $column] -
																							 ../../*[./@Pozycja = '_BIL-OSOB-G_28']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB-G_32']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB-G_34']/*[name(.) = $subtree]/*[name(.) = $column]
																				"/>
					<xsl:with-param name="descr" select="'w36-w28-w32-w34'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 3 -->
			<xsl:when test="../@Pozycja = '_BIL-OSOB_32'">
				<xsl:call-template name="_1_diffs">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 3: w. 32 = (w. 36 - w. 28 - w. 30 - w. 34)
					-->
					<xsl:with-param name="result" select = 	"../../../../../../*[./@Pozycja = '_BIL-OSOB_36']/*[name(.) = $subtree]/*[name(.) = $column] -
																							 ../../*[./@Pozycja = '_BIL-OSOB_34']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB_28']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB_30']/*[name(.) = $subtree]/*[name(.) = $column]
																				"/>
					<xsl:with-param name="descr" select="'w36-w28-w30-w34'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 3G -->
			<xsl:when test="../@Pozycja = '_BIL-OSOB-G_32'">
				<xsl:call-template name="_1_diffs">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 3G: w. 32 = (w. 36 - w. 28 - w. 30 - w. 34)
					-->
					<xsl:with-param name="result" select = 	"../../../../../../*[./@Pozycja = '_BIL-OSOB-G_36']/*[name(.) = $subtree]/*[name(.) = $column] -
																							 ../../*[./@Pozycja = '_BIL-OSOB-G_34']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB-G_28']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB-G_30']/*[name(.) = $subtree]/*[name(.) = $column]
																				"/>
					<xsl:with-param name="descr" select="'w36-w28-w30-w34'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 3 -->
			<xsl:when test="../@Pozycja = '_BIL-OSOB_34'">
				<xsl:call-template name="_1_diffs">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 3: w. 34 = (w. 36 - w. 28 - w. 30 - w. 32)
					-->
					<xsl:with-param name="result" select = 	"../../../../../../*[./@Pozycja = '_BIL-OSOB_36']/*[name(.) = $subtree]/*[name(.) = $column] -
																							 ../../*[./@Pozycja = '_BIL-OSOB_32']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB_28']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB_30']/*[name(.) = $subtree]/*[name(.) = $column]
																				"/>
					<xsl:with-param name="descr" select="'w36-w28-w30-w32'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<!-- Tabela 3G -->
			<xsl:when test="../@Pozycja = '_BIL-OSOB-G_34'">
				<xsl:call-template name="_1_diffs">
					<xsl:with-param name="contents" select="$contents"/>
					<!--
						- Tabela 3G: w. 34 = (w. 36 - w. 28 - w. 30 - w. 32)
					-->
					<xsl:with-param name="result" select = 	"../../../../../../*[./@Pozycja = '_BIL-OSOB-G_36']/*[name(.) = $subtree]/*[name(.) = $column] -
																							 ../../*[./@Pozycja = '_BIL-OSOB-G_32']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB-G_28']/*[name(.) = $subtree]/*[name(.) = $column] -
																				  ../../../../*/*/*[./@Pozycja = '_BIL-OSOB-G_30']/*[name(.) = $subtree]/*[name(.) = $column]
																				"/>
					<xsl:with-param name="descr" select="'w36-w28-w30-w32'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_z_tego">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="extrefname"/>
		<xsl:param name="extrefval"/>
		<xsl:param name="suma">
			<xsl:for-each select="../Z-tego/*">
				<xsl:call-template name="_1_add_tree">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
			<xsl:with-param name="extrefname" select="$extrefname"/>
			<xsl:with-param name="extrefval" select="$extrefval"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_add_tree">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="contents" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_1_add_tree">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_totals">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="result">
			<xsl:if test="$nodeset">
				<xsl:value-of select="sum($nodeset)"/>
			</xsl:if>
		</xsl:param>
		<xsl:param name="extrefname"/>
		<xsl:param name="extrefval"/>
		<xsl:choose>
			<xsl:when test="string(number($contents)) = 'NaN' or string(number($result)) = 'NaN'">
				<td class="totals" style="background-color: red">
					<center>???</center>
				</td>
			</xsl:when>
			<xsl:when test="$contents != $result">
				<td class="contents" style="background-color: red">
					<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
					<br/>
					<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
				</td>
			</xsl:when>
			<xsl:when test="$extrefval and $contents != $extrefval">
				<td class="contents" style="background-color: red">
					<xsl:value-of select="concat('Tutaj: ', format-number($contents, $format))"/>
					<br/>
					<xsl:value-of select="concat($extrefname, ': ', format-number($extrefval, $format))"/>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($result, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_diffs">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="result">
			<xsl:if test="$nodeset">
				<xsl:value-of select="sum($nodeset)"/>
			</xsl:if>
		</xsl:param>
		<xsl:param name="descr"/>
		<xsl:choose>
			<xsl:when test="string(number($contents)) = 'NaN' or string(number($result)) = 'NaN'">
				<td class="totals" style="background-color: red">
					<center>???</center>
				</td>
			</xsl:when>
			<xsl:when test="$contents != $result">
				<td class="contents" style="background-color: red">
					<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
					<br/>
					<xsl:value-of select="concat($descr, ': ', format-number($result, $format))"/>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($result, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Tabela-2">
		<xsl:call-template name="Tabela-2_G"/>
	</xsl:template>

	<xsl:template match="Tabela-2G">
		<xsl:call-template name="Tabela-2_G"/>
	</xsl:template>
	
	<xsl:template name="Tabela-2_G">
		<xsl:param name="width" select="844"/>
		<xsl:param name="rodzaj" select="substring-after(name(.), '-')"/>
		<xsl:call-template name="Metryczka_Tabeli">
			<xsl:with-param name="width" select="$width"/>
			<xsl:with-param name="table_name" select="concat('Tablica ', $rodzaj)  "/>
			<xsl:with-param name="table_title">
				Ogółem liczba Domów Pomocy Społecznej, miejsc i&#160;mieszkańców wg typów domów,
				w&#160;podziale na domy samorządów i&#160;podmiotów niepublicznych wg&#160;stanu na dzień 31 XII
			</xsl:with-param>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th colspan="2" rowspan="3">TYPY DOMÓW</th>
					<th colspan="4">OGÓŁEM</th>
					<th colspan="8">z tego domy:</th>
				</tr>
				<tr>
					<th width="6%" rowspan="2">Domy zarejes-<br/>trowane (Suma k. 5+9)</th>
					<th width="6%" rowspan="2">RZECZYWIS-<br/>TA LICZBA DOMÓW<br/>(K. 6+10)</th>
					<th width="6%" rowspan="2">LICZBA MIEJSC<br/><br/>(K.&#160;7+11)</th>
					<th width="9%" rowspan="2">LICZBA MIESZKAŃ-<br/>CÓW<br/>(K. 8+12)</th>
					<th colspan="4">samorządów</th>
					<th colspan="4">podmiotów niepublicznych</th>
				</tr>
				<tr>
					<th width="6%">Domy zarejes-<br/>trowane</th>
					<th width="6%">rzeczywi-<br/>sta liczba domów</th>
					<th width="5%">liczba miejsc</th>
					<th width="9%">liczba mieszkań-<br/>ców</th>
					<th width="6%">Domy zarejes-<br/>trowane</th>
					<th width="6%">rzeczywi-<br/>sta liczba domów</th>
					<th width="5%">liczba miejsc</th>
					<th width="9%">liczba mieszkań-<br/>ców</th>
				</tr>
				<tr>
					<td colspan="2" class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
					<td class="tab_col_no">7</td>
					<td class="tab_col_no">8</td>
					<td class="tab_col_no">9</td>
					<td class="tab_col_no">10</td>
					<td class="tab_col_no">11</td>
					<td class="tab_col_no">12</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Domy-pomocy-społecznej">
					<xsl:call-template name="Domy-pomocy-społecznej">
						<xsl:with-param name="format" select="$liczba"/>
					</xsl:call-template>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="Tabela_Podpis"/>
		<br/>
		<xsl:call-template name="Stopka">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Domy-pomocy-społecznej">
		<xsl:param name="format"/>
		<xsl:if test="@Pozycja = '_DPS-EWID_02' or @Pozycja = '_DPS-EWID_08' or @Pozycja = '_DPS-EWID-G_02' or @Pozycja = '_DPS-EWID-G_08'">
			<tr>
				<th colspan="14" style="border-left: none; border-right: none;"></th>
			</tr>
		</xsl:if>

		<tr>
			<xsl:choose>
				<xsl:when test="starts-with(@Pozycja, '_DPS-EWID_')">
					<xsl:call-template name="Row-description">
						<xsl:with-param name="prefix" select="'_DPS-EWID_'" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
				<xsl:call-template name="Row-description">
					<xsl:with-param name="prefix" select="'_DPS-EWID-G_'" />
				</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Ogółem'"/>
				<xsl:with-param name="column" select="'Domów-zarejestrowanych'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Ogółem'"/>
				<xsl:with-param name="column" select="'Liczba-domów'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Ogółem'"/>
				<xsl:with-param name="column" select="'Liczba-miejsc'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Ogółem'"/>
				<xsl:with-param name="column" select="'Liczba-mieszkańców'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Samorządów'"/>
				<xsl:with-param name="column" select="'Domów-zarejestrowanych'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Samorządów'"/>
				<xsl:with-param name="column" select="'Liczba-domów'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Samorządów'"/>
				<xsl:with-param name="column" select="'Liczba-miejsc'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Samorządów'"/>
				<xsl:with-param name="column" select="'Liczba-mieszkańców'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Podmiotów-niepublicznych'"/>
				<xsl:with-param name="column" select="'Domów-zarejestrowanych'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Podmiotów-niepublicznych'"/>
				<xsl:with-param name="column" select="'Liczba-domów'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Podmiotów-niepublicznych'"/>
				<xsl:with-param name="column" select="'Liczba-miejsc'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Podmiotów-niepublicznych'"/>
				<xsl:with-param name="column" select="'Liczba-mieszkańców'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_column">
		<xsl:param name="format"/>
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="*[name(.) = $subtree]/@Podsumowanie">
				<xsl:call-template name="_2_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="nodeset" select="*[name(.) != $subtree]/*[name(.) = $column]"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="substring-after(substring-after(./@Pozycja, '_'), '_') = 1 and $column != 'Liczba-domów'">
				<xsl:call-template name="_2_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="nodeset" select="../*/*[name(.) = $subtree]/*[name(.) = $column and ../../@Pozycja != current()/@Pozycja]"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number(round(100 * $contents) div 100, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_totals">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="rounded" select="round(100 * $contents)"/>
		<xsl:param name="result">
			<xsl:value-of select="round(100 * sum($nodeset))"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="string(number($contents)) = 'NaN' or string(number($result)) = 'NaN'">
				<td class="totals" style="background-color: red">
					<center>???</center>
				</td>
			</xsl:when>
			<xsl:when test="$rounded != $result">
				<td class="contents" style="background-color: red">
					<xsl:value-of select="concat('jest: ', format-number($rounded div 100, $format))"/>
					<br/>
					<xsl:value-of select="concat('suma: ', format-number($result div 100, $format))"/>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($result div 100, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Tabela-3">
		<xsl:call-template name="Tabela-3_G"/>
	</xsl:template>

	<xsl:template match="Tabela-3G">
		<xsl:call-template name="Tabela-3_G"/>
	</xsl:template>
	
	<xsl:template name="Tabela-3_G">
		<xsl:param name="width" select="816"/>
		<xsl:param name="rodzaj" select="substring-after(name(.), '-')"/>
		<xsl:call-template name="Metryczka_Tabeli">
			<xsl:with-param name="width" select="$width"/>
			<xsl:with-param name="table_name" select="concat('Tablica ', $rodzaj)  "/>
			<xsl:with-param name="table_title">
				Ogółem mieszkańcy Domów Pomocy Społecznej w&#160;podziale na mieszkańców
				Domów Pomocy Społecznej samorządów i&#160;podmiotów niepublicznych w roku sprawozdawczym
			</xsl:with-param>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th colspan="2" rowspan="2">WYSZCZEGÓLNIENIE</th>
					<th width="12%" rowspan="2">OGÓŁEM LICZBA MIESZKAŃCÓW<br/>(2+3)</th>
					<th colspan="2">z tego w domach:</th>
				</tr>
				<tr>
					<th width="12%">SAMORZĄDÓW</th>
					<th width="12%">PODMIOTÓW NIEPUBLICZNYCH</th>
				</tr>
				<tr>
					<td colspan="2" class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
				</tr>
			</thead>
			<tbody>
			<xsl:apply-templates select="Bilans-mieszk">
				<xsl:with-param name="margin" select="0"/>
			</xsl:apply-templates>
			</tbody>
		</table>
		<xsl:call-template name="Tabela_Podpis"/>
		<br/>
		<xsl:call-template name="Stopka">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Bilans-mieszk">
		<xsl:param name="margin"/>
		<xsl:if test="@Pozycja = '_BIL-OSOB_12' or @Pozycja = '_BIL-OSOB_17' or @Pozycja = '_BIL-OSOB_26' or @Pozycja = '_BIL-OSOB-G_12' or @Pozycja = '_BIL-OSOB-G_17' or @Pozycja = '_BIL-OSOB-G_26'">
			<tr>
				<th style="border-left: none; border-right: none;">&#160;<br/>&#160;</th>
				<th style="border-left: none; border-right: none;">&#160;<br/>&#160;</th>
				<th style="border-left: none; border-right: none;">&#160;<br/>&#160;</th>
				<th style="border-left: none; border-right: none;">&#160;<br/>&#160;</th>
				<th style="border-left: none; border-right: none;">&#160;<br/>&#160;</th>
			</tr>
		</xsl:if>

		<tr>
			<xsl:choose>
				<xsl:when test="starts-with(@Pozycja, '_BIL-OSOB_')">
					<xsl:call-template name="Row-description">
						<xsl:with-param name="prefix" select="'_BIL-OSOB_'"/>
						<xsl:with-param name="level" select="$margin"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="Row-description">
						<xsl:with-param name="prefix" select="'_BIL-OSOB-G_'"/>
						<xsl:with-param name="level" select="$margin"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		
			<xsl:apply-templates select="Mieszk-w-PDPS"/>
		</tr>

		<xsl:apply-templates select="*/Bilans-mieszk">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Mieszk-w-PDPS">
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Ogółem'"/>
				<xsl:with-param name="subtree" select="'Mieszk-w-PDPS'"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'W-samorządowych'"/>
				<xsl:with-param name="subtree" select="'Mieszk-w-PDPS'"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'W-niepublicznych'"/>
				<xsl:with-param name="subtree" select="'Mieszk-w-PDPS'"/>
			</xsl:call-template>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Tabela-4">
		<xsl:call-template name="Tabela-4_G"/>
	</xsl:template>

	<xsl:template match="Tabela-4G">
		<xsl:call-template name="Tabela-4_G"/>
	</xsl:template>
	
	<xsl:template name="Tabela-4_G">
		<xsl:param name="width" select="816"/>
		<xsl:param name="rodzaj" select="substring-after(name(.), '-')"/>
		<xsl:call-template name="Metryczka_Tabeli">
			<xsl:with-param name="width" select="$width"/>
			<xsl:with-param name="table_name" select="concat('Tablica ', $rodzaj)  "/>
			<xsl:with-param name="table_title">
				Ogółem liczba osób zatrudnionych w&#160;Domach Pomocy Społecznej w&#160;podziale na
				domy samorządów i&#160;podmiotów niepublicznych według form zatrudnienia wg stanu
				na dzień 31&#160;XII
			</xsl:with-param>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th rowspan="2">WYSZCZEGÓLNIENIE</th>
					<th width="12%" rowspan="2">OGÓŁEM<br/>(2+3)</th>
					<th colspan="2">z tego w domach:</th>
				</tr>
				<tr>
					<th width="12%">SAMORZĄDÓW</th>
					<th width="12%">PODMIOTÓW NIEPUBLICZNYCH</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
				</tr>
			</thead>
			<tbody>
			<xsl:apply-templates select="Bilans-zatr">
				<xsl:with-param name="margin" select="0"/>
			</xsl:apply-templates>
			</tbody>
		</table>
		<xsl:call-template name="Tabela_Podpis"/>
		<br/>
		<xsl:call-template name="Stopka">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Bilans-zatr">
		<xsl:param name="margin"/>
		<tr>
			<xsl:choose>
				<xsl:when test="starts-with(@Pozycja, '_BIL-ZATR_')">
					<xsl:call-template name="Row-description">
						<xsl:with-param name="prefix" select="'_BIL-ZATR_'"/>
						<xsl:with-param name="level" select="$margin"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="Row-description">
						<xsl:with-param name="prefix" select="'_BIL-ZATR-G_'"/>
						<xsl:with-param name="level" select="$margin"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:apply-templates select="Zatr-w-PDPS"/>
		</tr>

		<xsl:apply-templates select="*/Bilans-zatr">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Zatr-w-PDPS">
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Ogółem'"/>
				<xsl:with-param name="subtree" select="'Zatr-w-PDPS'"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'W-samorządowych'"/>
				<xsl:with-param name="subtree" select="'Zatr-w-PDPS'"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'W-niepublicznych'"/>
				<xsl:with-param name="subtree" select="'Zatr-w-PDPS'"/>
			</xsl:call-template>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Tabela-5">
		<xsl:call-template name="Tabela-5_G"/>
	</xsl:template>

	<xsl:template match="Tabela-5G">
		<xsl:call-template name="Tabela-5_G"/>
	</xsl:template>
	
	<xsl:template name="Tabela-5_G">
		<xsl:param name="width" select="844"/>
		<xsl:param name="rodzaj" select="substring-after(name(.), '-')"/>
		<xsl:call-template name="Metryczka_Tabeli">
			<xsl:with-param name="width" select="$width"/>
			<xsl:with-param name="table_name" select="concat('Tablica ', $rodzaj)  "/>
			<xsl:with-param name="table_title">
				Ogółem liczba osób zatrudnionych w Domach Pomocy Społecznej na podstawie
				umowy o&#160;pracę w&#160;przeliczeniu na pełne etaty wg działów w&#160;podziale na zatrudnionych w domach
				samorządów i&#160;podmiotów niepublicznych wg&#160;stanu na dzień 31&#160;XII
			</xsl:with-param>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th rowspan="3">PRACOWNICY</th>
					<th colspan="2">OGÓŁEM ZATRUDNIENI</th>
					<th colspan="4">z tego w domach:</th>
				</tr>
				<tr>
					<th width="12%" rowspan="2">LICZBA OSÓB (3+5)</th>
					<th width="12%" rowspan="2">W PRZELICZENIU NA PEŁNE ETATY (4+6)</th>
					<th colspan="2">SAMORZĄDÓW</th>
					<th colspan="2">PODMIOTÓW NIEPUBLICZNYCH</th>
				</tr>
				<tr>
					<th width="12%">liczba osób</th>
					<th width="12%">w przeliczeniu na pełne etaty</th>
					<th width="12%">liczba osób</th>
					<th width="12%">w przeliczeniu na pełne etaty</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Etaty-w-PDPS">
					<xsl:call-template name="Etaty-w-PDPS"/>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="Tabela_Podpis"/>
		<p class="remark">
			UWAGA!    Etaty należy podać z dwoma miejscami po przecinku.
		</p>
		<xsl:call-template name="Stopka">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Etaty-w-PDPS">
		<tr>
			
			<xsl:choose>
				<xsl:when test="starts-with(@Pozycja, '_ETATY-PDPS_')">
					<xsl:call-template name="Row-description">
						<xsl:with-param name="prefix" select="'_ETATY-PDPS_'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="Row-description">
						<xsl:with-param name="prefix" select="'_ETATY-PDPS-G_'"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Ogółem'"/>
				<xsl:with-param name="column" select="'Liczba-osób'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Ogółem'"/>
				<xsl:with-param name="column" select="'Pełnych-etatów'"/>
				<xsl:with-param name="format" select="$ułamek"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'W-samorządowych'"/>
				<xsl:with-param name="column" select="'Liczba-osób'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'W-samorządowych'"/>
				<xsl:with-param name="column" select="'Pełnych-etatów'"/>
				<xsl:with-param name="format" select="$ułamek"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'W-niepublicznych'"/>
				<xsl:with-param name="column" select="'Liczba-osób'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'W-niepublicznych'"/>
				<xsl:with-param name="column" select="'Pełnych-etatów'"/>
				<xsl:with-param name="format" select="$ułamek"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Tabela-6">
		<xsl:call-template name="Tabela-6_G"/>
	</xsl:template>

	<xsl:template match="Tabela-6G">
		<xsl:call-template name="Tabela-6_G"/>
	</xsl:template>
	
	<xsl:template name="Tabela-6_G">
		<xsl:param name="width" select="816"/>
		<xsl:param name="rodzaj" select="substring-after(name(.), '-')"/>
		<xsl:call-template name="Metryczka_Tabeli">
			<xsl:with-param name="width" select="$width"/>
			<xsl:with-param name="table_name" select="concat('Tablica ', $rodzaj)  "/>
			<xsl:with-param name="table_title">
				Ogółem liczba osób umieszczonych w&#160;Domach Pomocy Społecznej
				w&#160;roku sprawozdawczym oraz oczekujących na umieszczenie wg stanu na dzień 31 XII
			</xsl:with-param>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th>OSOBY</th>
					<th width="19%">LICZBA OSÓB UMIESZCZONYCH W&#160;DPS-ach w&#160;roku sprawozdawczym.</th>
					<th width="19%">LICZBA OSÓB OCZEKUJĄCYCH NA UMIESZCZENIE WG STANU NA DZIEŃ 31 XII</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Domy-pomocy-społecznej">
					<xsl:call-template name="Umieszczonych-i-oczekujących"/>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="Tabela_Podpis"/>
		<br/>
		<xsl:call-template name="Stopka">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Umieszczonych-i-oczekujących">
		<tr>
			<xsl:choose>
				<xsl:when test="starts-with(@Pozycja, '_DPS-UOCZ_')">
					<xsl:call-template name="Row-description">
						<xsl:with-param name="prefix" select="'_DPS-UOCZ_'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="Row-description">
						<xsl:with-param name="prefix" select="'_DPS-UOCZ-G_'"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>		
		
			<xsl:call-template name="_6_column">
				<xsl:with-param name="column" select="'Liczba-umieszczonych'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_6_column">
				<xsl:with-param name="column" select="'Liczba-oczekujących'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_6_column">
		<xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="substring-after(substring-after(./@Pozycja, '_'), '_') = 1">
				<xsl:call-template name="_6_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="nodeset" select="../*/*[name(.) = $column and ../@Pozycja != current()/@Pozycja]"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number(round(100 * $contents) div 100, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_6_totals">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="rounded" select="round(100 * $contents)"/>
		<xsl:param name="result">
			<xsl:value-of select="round(100 * sum($nodeset))"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="string(number($contents)) = 'NaN' or string(number($result)) = 'NaN'">
				<td class="totals" style="background-color: red">
					<center>???</center>
				</td>
			</xsl:when>
			<xsl:when test="$rounded != $result">
				<td class="contents" style="background-color: red">
					<xsl:value-of select="concat('jest: ', format-number($rounded div 100, $format))"/>
					<br/>
					<xsl:value-of select="concat('suma: ', format-number($result div 100, $format))"/>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($result div 100, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Zaspokojenie-potrzeb">
		<xsl:param name="descr"/> <xsl:param name="width"/>
		<xsl:param name="zaspokojenie" select="(100 * Osób-umieszczonych) div (Osób-umieszczonych + Osób-oczekujących)"/>
		<xsl:param name="rounded" select="round(100 * $zaspokojenie)"/>
		<table border="2" cellspacing="0" cellpadding="4">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<tr>
				<th style="border-right: none; font-weight: normal;">I.</th>
				<th colspan="3" align="left" style="border-left: none; border-right: none; font-weight: normal;">Liczba osób umieszczonych w <xsl:value-of select="$descr"/>
				<xsl:choose>
					<xsl:when test="./Domy-samopomocy">
					 w&#160;roku sprawozdawczym.
					</xsl:when>
					<xsl:otherwise>
					 w&#160;ciągu roku.
					</xsl:otherwise>
				</xsl:choose>
				</th>
				<th width="15%" align="right">
					<xsl:attribute name="style">
						<xsl:choose>
							<xsl:when test="Osób-umieszczonych &gt; ./Domy-samopomocy/*[@Pozycja = '_SRODOSAM_02']/Osób-przebywających">
								<xsl:value-of select="'border-left: ridge 2px; background-color: red'"/>
							</xsl:when>
							<xsl:when test="Osób-umieszczonych &gt; ./Mieszkania-chronione/*[@Pozycja = '_MIECHR_02']/Mieszkańców">
								<xsl:value-of select="'border-left: ridge 2px; background-color: red'"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="'border-left: ridge 2px'"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
					<xsl:value-of select="Osób-umieszczonych"/>
				</th>
			</tr>
			<tr>
				<th style="border-right: none; font-weight: normal;">II.</th>
				<th colspan="3" align="left" style="border-left: none; border-right: none; font-weight: normal;">Liczba osób oczekujących na umieszczenie w <xsl:value-of select="$descr"/> wg stanu na dzień 31 XII.</th>
				<th style="border-left: ridge 2px;" align="right"><xsl:value-of select="Osób-oczekujących"/></th>
			</tr>
			<tr>
				<th rowspan="2" style="border-right: none; font-weight: normal;">III.</th>
				<th rowspan="2" align="left" style="border-left: none; border-right: none; font-weight: normal;">Stopień zaspokojenia potrzeb:</th>
				<th style="border-left: none; border-right: none;">liczba osób umieszczonych x 100</th>
				<th rowspan="2" style="border-left: none; border-right: none;">&#160;</th>
				<th style="border-left: ridge 2px;" rowspan="2" align="right"><xsl:value-of select="format-number($rounded div 100, $ułamek)"/></th>
			</tr>
			<tr>
				<th style="border-left: none; border-right: none;">liczba osób umieszczonych + oczekujących</th>
			</tr>
		</table>
		<br/>
		<xsl:call-template name="Stopka">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Tabela-7">
		<xsl:param name="width" select="816"/>
		<xsl:call-template name="Metryczka_Tabeli">
			<xsl:with-param name="width" select="$width"/>
			<xsl:with-param name="table_name" select="'Tablica 7'"/>
			<xsl:with-param name="table_title">
				<xsl:value-of select="Domy-samopomocy/@Opis"/>
			</xsl:with-param>
			<xsl:with-param name="table_subtitle">
				w <xsl:value-of select="../Metryczka/Za-okres/Rok"/> r.
			</xsl:with-param>
			<xsl:with-param name="rozdzial" select="'85203'"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th rowspan="2">WYSZCZEGÓLNIENIE</th>
					<th width="45%" colspan="3">LICZBA</th>
				</tr>
				<tr>
					<th width="15%">DOMÓW</th>
					<th width="15%">MIEJSC</th>
					<th width="15%">OSÓB PRZEBYWAJĄCYCH</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Domy-samopomocy"/>
			</tbody>
		</table>
		<br/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Zaspokojenie-potrzeb">
			<xsl:with-param name="descr" select="'środowiskowych domach samopomocy'"/>
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Domy-samopomocy">
		<xsl:for-each select="Stan-lub-zmiana">
			<tr>
				<xsl:call-template name="Row-description">
					<xsl:with-param name="prefix" select="'_SRODOSAM_'"/>
				</xsl:call-template>

				<xsl:call-template name="_7_column">
					<xsl:with-param name="column" select="'Domów'"/>
					<xsl:with-param name="format" select="$liczba"/>
				</xsl:call-template>
				<xsl:call-template name="_7_column">
					<xsl:with-param name="column" select="'Miejsc'"/>
					<xsl:with-param name="format" select="$liczba"/>
				</xsl:call-template>
				<xsl:call-template name="_7_column">
					<xsl:with-param name="column" select="'Osób-przebywających'"/>
					<xsl:with-param name="format" select="$liczba"/>
				</xsl:call-template>
			</tr>
		</xsl:for-each>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_7_column">
		<xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="../*[last() - 1]/@Pozycja = ./@Pozycja">
				<xsl:call-template name="_7_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="nodeset" select="../*[position() &lt; last() - 1]/*[name(.) = $column]"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_7_totals">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="result">
			<xsl:value-of select="$nodeset[1] + $nodeset[2] - $nodeset[3]"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="string(number($contents)) != 'NaN'">
				<xsl:choose>
					<xsl:when test="string(number($result)) = 'NaN'">
						<td class="totals" style="background-color: red">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:when test="$contents != $result">
						<td class="contents" style="background-color: red">
							<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
							<br/>
							<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($result, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($result, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Tabela-8">
		<xsl:param name="width" select="816"/>
		<xsl:call-template name="Metryczka_Tabeli">
			<xsl:with-param name="width" select="$width"/>
			<xsl:with-param name="table_name" select="'Tablica 8'"/>
			<xsl:with-param name="table_title">
				Liczba osób zatrudnionych w Środowiskowych Domach Samopomocy
				według form zatrudnienia wg stanu na dzień 31&#160;XII
			</xsl:with-param>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th>WYSZCZEGÓLNIENIE</th>
					<th width="22%">LICZBA OSÓB</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
				</tr>
			</thead>
			<tbody>
			<xsl:apply-templates select="Zatr-w-ŚDS">
				<xsl:with-param name="margin" select="0"/>
			</xsl:apply-templates>
			</tbody>
		</table>
		<br/>
		<xsl:call-template name="Stopka">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Zatr-w-ŚDS">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_ZATR-ŚDS_'"/>
				<xsl:with-param name="level" select="$margin"/>
			</xsl:call-template>

			<xsl:call-template name="_8_column">
				<xsl:with-param name="column" select="'Liczba-osób'"/>
			</xsl:call-template>
		</tr>

		<xsl:apply-templates select="*/Zatr-w-ŚDS">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_8_column">
		<xsl:param name="column"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="format" select="$liczba"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="Z-tego and not($item/@xsi:nil)">
				<xsl:call-template name="_8_z_tego">
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="extrefname" select="'Tabela 9'"/>
					<xsl:with-param name="extrefval">
						<xsl:if test="./@Pozycja = '_ZATR-ŚDS_02'">
							<xsl:value-of select="//Tabela-9/*[./@Pozycja = '_ETATY-ŚDS_01']/Liczba-osób"/>
						</xsl:if>
					</xsl:with-param>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_8_z_tego">
		<xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="extrefname"/>
		<xsl:param name="extrefval"/>
		<xsl:param name="suma">
			<xsl:for-each select="Z-tego/*">
				<xsl:call-template name="_8_add_tree">
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
			<xsl:with-param name="extrefname" select="$extrefname"/>
			<xsl:with-param name="extrefval" select="$extrefval"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_8_add_tree">
		<xsl:param name="column"/>
		<xsl:param name="contents" select="*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_8_add_tree">
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Tabela-9">
		<xsl:param name="width" select="816"/>
		<xsl:call-template name="Metryczka_Tabeli">
			<xsl:with-param name="width" select="$width"/>
			<xsl:with-param name="table_name" select="'Tablica 9'"/>
			<xsl:with-param name="table_title">
				Liczba osób zatrudnionych w&#160;Środowiskowych Domach Samopomocy na podstawie
				umowy o&#160;pracę w&#160;przeliczeniu na pełne etaty wg działów wg stanu na&#160;dzień 31&#160;XII
			</xsl:with-param>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th>PRACOWNICY</th>
					<th width="19%">LICZBA OSÓB</th>
					<th width="19%">W PRZELICZENIU<BR/>NA PEŁNE ETATY</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Etaty-w-ŚDS">
					<xsl:call-template name="Osób-i-etatów"/>
				</xsl:for-each>
			</tbody>
		</table>
		<p class="remark">
			UWAGA!    Etaty należy podać z dwoma miejscami po przecinku.
		</p>
		<!--table border="0" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<tr>
				<td class="stars" width="6">*</td>
				<td class="remark">
					UWAGA!    Etaty należy podać z dwoma miejscami po przecinku.
				</td>
			</tr>
		</table-->
		<xsl:call-template name="Stopka">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Osób-i-etatów">
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_ETATY-ŚDS_'"/>
			</xsl:call-template>

			<xsl:call-template name="_6_column">
				<xsl:with-param name="column" select="'Liczba-osób'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_6_column">
				<xsl:with-param name="column" select="'Pełnych-etatów'"/>
				<xsl:with-param name="format" select="$ułamek"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Tabela-10">
		<xsl:param name="width" select="816"/>
		<xsl:call-template name="Metryczka_Tabeli">
			<xsl:with-param name="width" select="$width"/>
			<xsl:with-param name="table_name" select="'Tablica 10'"/>
			<xsl:with-param name="table_title">
				<xsl:value-of select="Mieszkania-chronione/@Opis"/>
			</xsl:with-param>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th rowspan="2">WYSZCZEGÓLNIENIE</th>
					<th width="45%" colspan="3">LICZBA</th>
				</tr>
				<tr>
					<th width="15%">MIESZKAŃ</th>
					<th width="15%">MIEJSC</th>
					<th width="15%">MIESZKAŃCÓW</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Mieszkania-chronione"/>
			</tbody>
		</table>
		<br/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Zaspokojenie-potrzeb">
			<xsl:with-param name="descr" select="'mieszkaniach chronionych'"/>
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Mieszkania-chronione">
		<xsl:for-each select="Stan-lub-zmiana">
			<tr>
				<xsl:call-template name="Row-description">
					<xsl:with-param name="prefix" select="'_MIECHR_'"/>
				</xsl:call-template>

				<xsl:call-template name="_7_column">
					<xsl:with-param name="column" select="'Mieszkań'"/>
					<xsl:with-param name="format" select="$liczba"/>
				</xsl:call-template>
				<xsl:call-template name="_7_column">
					<xsl:with-param name="column" select="'Miejsc'"/>
					<xsl:with-param name="format" select="$liczba"/>
				</xsl:call-template>
				<xsl:call-template name="_7_column">
					<xsl:with-param name="column" select="'Mieszkańców'"/>
					<xsl:with-param name="format" select="$liczba"/>
				</xsl:call-template>
			</tr>
		</xsl:for-each>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Tabela-11">
		<xsl:param name="width" select="844"/>
		<xsl:call-template name="Metryczka_Tabeli">
			<xsl:with-param name="width" select="$width"/>
			<xsl:with-param name="table_name" select="'Tablica 11'"/>
			<xsl:with-param name="table_title">
				Ogółem liczba placówek całodobowej opieki, miejsc i&#160;mieszkańców,
				w&#160;podziale na placówki prowadzone w&#160;ramach działalności statutowej i&#160;gospodarczej
				wg stanu na dzień 31 XII
			</xsl:with-param>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th rowspan="3"><span style="letter-spacing: 0.3em">PRZEZNACZENIE</span><br/>(art. 67 i 69 ust. o pom. społ.)</th>
					<th colspan="3">OGÓŁEM</th>
					<th colspan="6"><span style="letter-spacing: 0.1em">z  tego placówki prowadzone w ramach działalności:</span></th>
				</tr>
				<tr>
					<th width="7%" rowspan="2">LICZBA PLACÓWEK (4+7)</th>
					<th width="5%" rowspan="2">LICZBA MIEJSC (5+8)</th>
					<th width="9%" rowspan="2">LICZBA MIESZKAŃCÓW (6+9)</th>
					<th colspan="3">statutowej</th>
					<th colspan="3">gospodarczej</th>
				</tr>
				<tr>
					<th width="7%">liczba placówek</th>
					<th width="5%">liczba miejsc</th>
					<th width="9%">liczba mieszkańców</th>
					<th width="7%">liczba placówek</th>
					<th width="5%">liczba miejsc</th>
					<th width="9%">liczba mieszkańców</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
					<td class="tab_col_no">7</td>
					<td class="tab_col_no">8</td>
					<td class="tab_col_no">9</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Placówki-opieki-całodobowej">
					<xsl:call-template name="Placówki-opieki-całodobowej">
						<xsl:with-param name="format" select="$liczba"/>
					</xsl:call-template>
				</xsl:for-each>
			</tbody>
		</table>
		<br/>
		<xsl:call-template name="Stopka">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Placówki-opieki-całodobowej">
		<xsl:param name="format"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_POC-EWID_'"/>
			</xsl:call-template>

			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Ogółem'"/>
				<xsl:with-param name="column" select="'Liczba-placówek'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Ogółem'"/>
				<xsl:with-param name="column" select="'Liczba-miejsc'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Ogółem'"/>
				<xsl:with-param name="column" select="'Liczba-mieszkańców'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Działalność-statutowa'"/>
				<xsl:with-param name="column" select="'Liczba-placówek'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Działalność-statutowa'"/>
				<xsl:with-param name="column" select="'Liczba-miejsc'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Działalność-statutowa'"/>
				<xsl:with-param name="column" select="'Liczba-mieszkańców'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Działalność-gospodarcza'"/>
				<xsl:with-param name="column" select="'Liczba-placówek'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Działalność-gospodarcza'"/>
				<xsl:with-param name="column" select="'Liczba-miejsc'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="'Działalność-gospodarcza'"/>
				<xsl:with-param name="column" select="'Liczba-mieszkańców'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
