
<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.1'"/>
	<xsl:decimal-format grouping-separator="&#160;"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'944px'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>; padding-top: 6px;
                                				}

                    		.MPiPS_03_6_0        {width:  410px}
                    		.MPiPS_03_6_1        {width:  100px}
                    		.MPiPS_03_6_0a      {width:  390px}
                    		.MPiPS_03_6_0b      {width:    20px}

                    		.MPiPS_03_7_0		{width:  370px}
                    		.MPiPS_03_7_1		{width:  308px}
                    		.MPiPS_03_7_2		{width:  100px}
                    		.MPiPS_03_7_0a	{width:  350px}
                    		.MPiPS_03_7_0b	{width:    20px}

                    		.MPiPS_03_8_0		{width:  300px}
                    		.MPiPS_03_8_1		{width:  640px}
                    		.MPiPS_03_8_2		{width:    93px}
                    		.MPiPS_03_8_0a	{width:  280px}
                    		.MPiPS_03_8_0b	{width:    20px}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal;
                                					}
                   			 .contents	{height: 2.0em; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.0em; padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; padding-top: 24px;
                                				}
                    		.empty		{border: 0 0 0 0;}
                </style>
			</head>
			<body>
				<xsl:apply-templates select="MPiPS-03"/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="MPiPS-03">
		<xsl:apply-templates select="Metryczka"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Dział_1"/>
		<xsl:apply-templates select="Dział_2A"/>
		<xsl:apply-templates select="Dział_2B"/>
		<xsl:apply-templates select="Dział_2C-1"/>
		<xsl:apply-templates select="Dział_2C-2"/>
		<xsl:apply-templates select="Dział_2C-3"/>
		<xsl:apply-templates select="Dział_3"/>
		<xsl:apply-templates select="Dział_4"/>
		<xsl:apply-templates select="Dział_5"/>
		<xsl:apply-templates select="Dział_6A"/>
		<xsl:apply-templates select="Dział_6B"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/> <br/> <br/>
			</div>
		</xsl:if>
		<table border="2" cellspacing="0" cellpadding="8">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th colspan="3">
						<span  style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5, 00-513 Warszawa
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="300">
						<span  style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
						</span>
						<center>
							<xsl:for-each select="Nadawca">
								<table cellspacing="0" cellpadding="0">
									<tr>
										<td class="stamp" colspan="2">
											<xsl:value-of select="Pełna-nazwa"/>
										</td>
									</tr>
									<xsl:for-each select="Adres-pocztowy">
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Ulica-i-numer"/>
											</td>
										</tr>
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Kod-i-poczta"/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td class="stamp" style="font-size: 11px; text-align: left">
											<xsl:for-each select="Telefon">
                                 					           Tel. <xsl:apply-templates/> &#160;
					                                        </xsl:for-each>
										</td>
										<td class="stamp" style="font-size: 11px; text-align: right">
											<xsl:for-each select="Faks">
					                                            &#160;Fax <xsl:apply-templates/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>
						</center>
					</td>
					<td rowspan="2" style="text-align: center; font-weight: bold;">
						<xsl:choose>
							<xsl:when test="Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III'">
								<span style="font-size: large;">
                            					<xsl:choose>
										<xsl:when test="Za-okres/Kwartał = 'I'">MK1</xsl:when>
										<xsl:otherwise>MK2</xsl:otherwise>
									</xsl:choose>
								</span><br/>
                            				<p style="font-size: 13px">
                            					Meldunek kwartalny z udzielonych świadczeń<br/>
                            	pomocy społecznej<br/>pieniężnych, w naturze i usługach
                            				</p>
                            				za okres
                            				<xsl:choose>
									<xsl:when test="Za-okres/Kwartał = 'I'">I-III</xsl:when>
									<xsl:otherwise>I-IX</xsl:otherwise>
								</xsl:choose>
								<xsl:value-of select="concat(' ', Za-okres/Rok, ' r.')"/>
							</xsl:when>
							<xsl:otherwise>
								<span style="font-size: large;">MPiPS-03</span><br/>
                            				<p style="font-size: 13px">
                            					Sprawozdanie półroczne i roczne<br/>z udzielonych świadczeń<br/>
                            	pomocy społecznej - pieniężnych,<br/>w naturze i usługach
                            				</p>
                            				za
                            				<xsl:choose>
									<xsl:when test="Za-okres/Kwartał = 'II'">I-VI</xsl:when>
									<xsl:otherwise>I-XII</xsl:otherwise>
								</xsl:choose>
								<xsl:value-of select="concat(' ', Za-okres/Rok, ' r.')"/>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					<td width="300">
						<span  style="font-size: 11px; text-align: left;">
							Adresat:<br/>
						</span>
						<div class="stamp">
							<xsl:value-of select="Odbiorca/Pełna-nazwa"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<span  style="font-size: 11px; text-align: left;">
							Numer identyfikacyjny REGON:<br/>
						</span>
						<div style="font-weight: bold; text-align: center;">
							<xsl:value-of select="Nadawca/@Kod-REGON"/>
						</div>
					</td>
					<td>
						<div style="font-weight: bold; font-size: 13px; text-align: center;">
							<xsl:choose>
								<xsl:when test="Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III'">
									Przekazać w terminie do 20 dnia<br/>miesiąca po okresie sprawozdawczym<sup>1)</sup>
								</xsl:when>
								<xsl:otherwise>
									Przekazać / wysłać w terminie<br/>do 10 lutego i 10 sierpnia<sup>1)</sup>
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<br/>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars">
					<sup>1)</sup>
                            </td>
				<td class="remark">
					<xsl:choose>
						<xsl:when test="Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III'">
							Jeśli termin przekazania sprawozdania wypada na dzień wolny od pracy, to obowiązuje data pierwszego dnia roboczego po tym dniu.
						</xsl:when>
						<xsl:otherwise>
							Do 10 sierpnia roku bieżącego i 10 lutego roku następnego. Daty powyższe obowiązują Służby Wojewody realizujące zadania z zakresu pomocy społecznej w zależności od rodzaju sprawozdania (półroczne, roczne).
						</xsl:otherwise>
					</xsl:choose>
                            </td>
			</tr>
		</table>
		<br/> <br/> <br/> <br/> <br/>
		<xsl:if test="(Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III') and Kod/Cyklu-sprawozdawczego != 3 or
					(Za-okres/Kwartał = 'II' or Za-okres/Kwartał = 'IV') and Kod/Cyklu-sprawozdawczego != 4">
			<!--div style="font-size: large; text-align: center; color: red;">
				Niepoprawny kod cyklu sprawozdawczego!
			</div>
			<br/> <br/> <br/> <br/> <br/-->
		</xsl:if>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table width="280">
			<caption>Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td>Imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td>Telefon:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td>Data wykonania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
		</table>

		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="xslt_ver" style="text-align: left;">
					Wersja szablonu XSLT: <xsl:value-of select="$wersja"/>
				</td>
				<td class="xslt_ver" style="text-align: right;">
					<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
					<xsl:if test="system-property('msxsl:version')">
						<xsl:value-of select="concat(', MSXML: ', system-property('msxsl:version'))"/>
					</xsl:if>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="level"/><xsl:param name="prefix"/>
		<xsl:variable name="topbot" select="'margin-top: 4px; margin-bottom: 4px; margin-left: '"/>
		<xsl:variable name="indent" select="25"/>
		<td class="MPiPS_03_6_0a row_descr">
			<xsl:if test="not(preceding-sibling::*) and ../@Prefiks">
		 	        <p>
 					  <xsl:attribute name="style">
 						 <xsl:value-of select="concat($topbot, string($indent * ($level - 1)), 'px;')" />
					   </xsl:attribute>
					   <xsl:value-of select="../@Prefiks"/><br/>
				    </p>
			</xsl:if>
			<p>
				<xsl:if test="$level &gt;= 0">
					<xsl:attribute name="style">
						<xsl:value-of select="concat($topbot, string($indent * $level), 'px;')" />
					</xsl:attribute>
				</xsl:if>
				<xsl:value-of select="@Opis"/>
			</p>
		</td>
		<td class="MPiPS_03_6_0b tab_row_no">
			<xsl:value-of select="count(preceding::*[starts-with(@Pozycja, $prefix)])+
								  count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)])"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="sumuj">
		<xsl:param name="wynik"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma"/>
		<xsl:choose>
			<xsl:when test="$suma!=''">
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="substring-after($suma,'+')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string(number($wynik)) = 'NaN'">
						<td class="totals" style="background-color: red">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:when test="string(number($contents)) != 'NaN' and $contents != 0">
						<xsl:choose>
							<xsl:when test="$contents != $wynik">
								<td class="contents" style="background-color: red">
									<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
									<br/>
									<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals">
									<xsl:value-of select="format-number($wynik, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($wynik, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_1">
		<xsl:param name="width" select="538"/>
		<div style="page-break-before: always">
 			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('DZIAŁ ', substring-after(name(.), '_'), '. ')"/>
			<div style="margin-top: -1.2em; margin-left: 5em">
				<xsl:value-of select="@Opis"/>
			</div>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr height="25">
					<th class="MPiPS_03_6_0" colspan="2">WYSZCZEGÓLNIENIE</th>
					<th class="MPiPS_03_6_1">OGÓŁEM</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">0</td>
					<td class="tab_col_no">1</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Zatrudnienie">
					<xsl:with-param name="margin" select="-1"/>
				</xsl:apply-templates>
			</tbody>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Zatrudnienie">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_1_'"/>
			</xsl:call-template>

			<xsl:choose>
				<xsl:when test="Z-tego">
					<xsl:call-template name="_1_totals"/>
				</xsl:when>
				<xsl:otherwise>
					<td class="contents">
						<xsl:value-of select="format-number(./Ogółem, $liczba)"/>
					</td>
				</xsl:otherwise>
			</xsl:choose>
		</tr>

		<xsl:apply-templates select="*/Zatrudnienie">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_totals">
		<xsl:param name="suma" select="sum(descendant::*[@Pozycja][not(name(..) = 'W-tym')][not(Z-tego)]/Ogółem)"/>
		<xsl:choose>
			<xsl:when test="Ogółem and Ogółem != 0">
				<xsl:choose>
					<xsl:when test="Ogółem != $suma">
						<td class="totals" style="background-color: red">
							<xsl:value-of select="concat('jest: ', format-number(Ogółem, $liczba))"/>
							<br/>
							<xsl:value-of select="concat('suma: ', format-number($suma, $liczba))"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($suma, $liczba)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($suma, $liczba)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_2A">
		<xsl:call-template name="Dział_2ABC"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_2B">
		<xsl:call-template name="Dział_2ABC"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_2C-3">
		<xsl:call-template name="Dział_2ABC"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Dział_2ABC">
		<xsl:param name="width" select="948"/>
		<xsl:param name="chapter" select="substring-after(name(.), '_')"/>
		<div>
 			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('DZIAŁ ', $chapter, '. ')"/>
			<div>
	 			<xsl:attribute name="style">
	 				margin-top: -1.2em; margin-left: 
					<xsl:choose>
						<xsl:when test="Uchodźcom">6.5em</xsl:when> <xsl:otherwise>5.5em</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:value-of select="@Opis"/>
			</div>
			<xsl:if test="Uchodźcom">
				<p style="margin-top: 0.5em; text-align: left">POMOC DLA UCHODŹCÓW</p>
			</xsl:if>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th class="MPiPS_03_6_0" colspan="2">FORMY POMOCY</th>
					<th class="MPiPS_03_6_1">LICZBA OSÓB, KTÓRYM PRZYZNANO DECYZJĄ ŚWIAD.</th>
					<th class="MPiPS_03_6_1">LICZBA ŚWIADCZEŃ</th>
					<th class="MPiPS_03_6_1">KWOTA ŚWIADCZEŃ W ZŁ</th>
					<th class="MPiPS_03_6_1">LICZBA RODZIN</th>
					<th class="MPiPS_03_6_1">LICZBA OSÓB W RODZINACH</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Zlecone-gminom">
					<xsl:with-param name="margin" select="-1"/>
				</xsl:apply-templates>
				<xsl:choose>
					<xsl:when test="../Metryczka/Za-okres/Kwartał = 'I' or ../Metryczka/Za-okres/Kwartał = 'III'">
						<xsl:apply-templates select="Własne-gmin">
							<xsl:with-param name="margin" select="0"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="Własne-gmin[@Pozycja != '_2B_30']">
							<xsl:with-param name="margin" select="-1"/>
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:apply-templates select="Uchodźcom">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
			</tbody>
		</table>
	<!--
			Wstawka dla zasad ustalonych na szkoleniu 14 - 15 grudnia 2004 r.
	-->
		<xsl:if test="Własne-gmin[@Pozycja = '_2B_30']">
			<br/>
			<table border="2" cellspacing="0" cellpadding="0">
 				<xsl:attribute name="width">
 					<xsl:number value="$width"/>
				</xsl:attribute>
				<tr>
					<th width="422" rowspan="2"><xsl:value-of select="Własne-gmin[@Pozycja = '_2B_30']/@Opis"/></th>
					<th class="MPiPS_03_6_1">LICZBA OSÓB, KTÓRYM PRZYZNANO DECYZJĄ ŚWIAD.</th>
					<th class="MPiPS_03_6_1">LICZBA ŚWIADCZEŃ</th>
					<th class="MPiPS_03_6_1">KWOTA ŚWIADCZEŃ W ZŁ</th>
					<th class="MPiPS_03_6_1">LICZBA RODZIN</th>
					<th class="MPiPS_03_6_1">LICZBA OSÓB W RODZINACH</th>
				</tr>
				<tr>
					<xsl:for-each select="Własne-gmin[@Pozycja = '_2B_30']">
						<xsl:call-template name="_2AB_contents"/>
					</xsl:for-each>
				</tr>
			</table>
			<br/>
		</xsl:if>
	<!--
			Koniec  wstawki dla zasad ustalonych na szkoleniu 14 - 15 grudnia 2004 r.
	-->
		<xsl:if test="not(Uchodźcom)">
			<table class="wide" border="0" cellspacing="0" cellpadding="0">
				<xsl:if test="not(name(.) = 'Dział_2B' and (../Metryczka/Za-okres/Kwartał = 'I' or ../Metryczka/Za-okres/Kwartał = 'III'))">
					<tr>
						<td class="stars">
						</td>
						<td class="remark">
							W wierszu 1 kolumna 3 "kwota świadczeń w zł" jest sumą kwot
							wydatkowanych na świadczenia wymienione w wierszach 2,
							<xsl:choose>
								<xsl:when test="Zlecone-gminom">5, 10, 11</xsl:when>
								<xsl:otherwise>9, 10, 12, 13, 15, 17, 18, 19, 21, 23</xsl:otherwise>
							</xsl:choose>
							(w kolumnie 3).
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="stars">
	                            </td>
					<td class="remark">
						 We wszystkich wierszach działu <xsl:value-of select="$chapter"/> analogicznie
						 jak w całym sprawozdaniu MPiPS-03 należy podawać liczbę osób otrzymujących
						decyzją świadczenie, liczbę rodzin i liczbę osób w tych rodzinach przy zachowaniu
						zasady, że osobę (rodzinę) wymieniamy TYLKO raz bez względu na liczbę otrzymanych
						świadczeń, kwotę świadczeń i częstotliwość otrzymywania świadczenia.
	                            </td>
				</tr>
			</table>
		</xsl:if>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Zlecone-gminom">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_2A_'"/>
			</xsl:call-template>

			<xsl:call-template name="_2AB_contents"/>
		</tr>

		<xsl:apply-templates select="*/Zlecone-gminom">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Własne-gmin">
		<xsl:param name="margin"/>

		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_2B_'"/>
			</xsl:call-template>

			<xsl:call-template name="_2AB_contents"/>
		</tr>

		<xsl:apply-templates select="*/Własne-gmin">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Uchodźcom">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_2C-3_'"/>
			</xsl:call-template>

			<xsl:call-template name="_2AB_contents"/>
		</tr>

		<xsl:apply-templates select="*/Uchodźcom">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2AB_contents">
		<xsl:param name="subtree" select="'Udzielone-świadczenia'"/>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Osób-w-decyzjach'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-świadczeń'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Kwota-świadczeń'"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-rodzin'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Osób-w-rodzinach'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_column">
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="Z-tego and not($item/@xsi:nil)">
				<xsl:call-template name="_2_total">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_total">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="Z-tego/*">
				<xsl:call-template name="_2_add_tree">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_add_tree">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="contents" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_2_add_tree">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_2C-1">
		<xsl:param name="width" select="944"/>
		<div>
 			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('DZIAŁ ', substring-after(name(.), '_'), '. ')"/>
			<div style="margin-top: -1.2em; margin-left: 6.5em">
				<xsl:value-of select="@Opis"/>
			</div>
			<p style="margin-top: 0.5em; text-align: left">POMOC MAJĄCA NA CELU ŻYCIOWE USAMODZIELNIENIE I INTEGRACJĘ ZE ŚRODOWISKIEM DLA OPUSZCZAJĄCYCH:</p>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th class="MPiPS_03_8_0" colspan="2" rowspan="3">WYSZCZEGÓLNIENIE</th>
					<th class="MPiPS_03_8_1" style="padding-top: 4px; padding-bottom: 4px;" colspan="7">ZADANIA WŁASNE</th>
				</tr>
				<tr>
					<th class="MPiPS_03_8_2" rowspan="2">POMOC PIENIĘŻNA NA USAMODZIEL-<br/>NIENIE</th>
					<th class="MPiPS_03_8_2" rowspan="2">POMOC PIENIĘŻNA NA KONTYNUO-<br/>WANIE NAUKI</th>
					<th class="MPiPS_03_8_2" rowspan="2">UZYSKANIE ODPOWIEDNICH WARUNKÓW MIESZKANIO-<br/>WYCH</th>
					<th class="MPiPS_03_8_2">w tym</th>
					<th class="MPiPS_03_8_2" rowspan="2">POMOC NA ZAGOSPODARO-<br/>WANIE W FORMIE RZECZOWEJ</th>
					<th class="MPiPS_03_8_2" rowspan="2">POMOC W UZYSKANIU ZATRUDNIENIA</th>
					<th class="MPiPS_03_8_2" rowspan="2">PRACA SOCJALNA</th>
				</tr>
				<tr>
					<th class="MPiPS_03_8_2">w mieszkaniu chronionym</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
					<td class="tab_col_no">7</td>
					<td class="tab_col_no">8</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Placówki-PCPR"/>
			</tbody>
		</table>
		<xsl:if test="not(../Metryczka/Za-okres/Kwartał = 'I' or ../Metryczka/Za-okres/Kwartał = 'III')">
			<table class="wide" border="0" cellspacing="0" cellpadding="0">
				<tr>
					<td class="stars" width="6">&#160;</td>
					<td class="remark">
                           	     W wierszach 1, 5, 9, 13, 17, 21, 25, 29 i 33 należy podać liczbę np. rodzin zastępczych, placówek
	                                opiekuńczo - wychowawczych itd. z których osobom udzielono pomocy mającej na celu życiowe
       	                         usamodzielnienie i integrację ze środowiskiem.
       				</td>
				</tr>
			</table>
		</xsl:if>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Placówki-PCPR">
		<xsl:choose>
			<xsl:when test="../../Metryczka/Za-okres/Kwartał = 'I' or ../../Metryczka/Za-okres/Kwartał = 'III'">
				<xsl:call-template name="_2C-1_row">
					<xsl:with-param name="level" select="0"/>
					<xsl:with-param name="rowdescr" select="@Opis"/>
					<xsl:with-param name="format" select="$kwota"/>
					<xsl:with-param name="subtree" select="3"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="_2C-1_row">
					<xsl:with-param name="level" select="0"/>
					<xsl:with-param name="rowdescr" select="@Opis"/>
					<xsl:with-param name="format" select="$liczba"/>
					<xsl:with-param name="subtree" select="0"/>
				</xsl:call-template>
				<xsl:call-template name="_2C-1_row">
					<xsl:with-param name="level" select="1"/>
					<xsl:with-param name="rowdescr" select="'liczba osób'"/>
					<xsl:with-param name="format" select="$liczba"/>
					<xsl:with-param name="subtree" select="1"/>
				</xsl:call-template>
				<xsl:call-template name="_2C-1_row">
					<xsl:with-param name="level" select="1"/>
					<xsl:with-param name="rowdescr" select="'liczba świadczeń'"/>
					<xsl:with-param name="format" select="$liczba"/>
					<xsl:with-param name="subtree" select="2"/>
				</xsl:call-template>
				<xsl:call-template name="_2C-1_row">
					<xsl:with-param name="level" select="1"/>
					<xsl:with-param name="rowdescr" select="'kwota świadczeń'"/>
					<xsl:with-param name="format" select="$kwota"/>
					<xsl:with-param name="subtree" select="3"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2C-1_row">
		<xsl:param name="prefix" select="'_2C-1'"/> <xsl:param name="level"/>
		<xsl:param name="rowdescr"/> <xsl:param name="format"/> <xsl:param name="subtree"/>
		<xsl:variable name="topbot" select="'margin-top: 4px; margin-bottom: 4px; margin-left: '"/>
		<xsl:variable name="indent" select="25"/>
		<tr>
			<td class="MPiPS_03_8_0a row_descr">
				<p>
					<xsl:if test="$level &gt;= 0">
						<xsl:attribute name="style">
							<xsl:value-of select="concat($topbot, string($indent * $level), 'px;')" />
						</xsl:attribute>
					</xsl:if>
					<xsl:value-of select="$rowdescr"/>
				</p>
			</td>
			<td class="MPiPS_03_8_0b tab_row_no">
				<xsl:choose>
					<xsl:when test="not(../../Metryczka/Za-okres/Kwartał = 'I' or ../../Metryczka/Za-okres/Kwartał = 'III')">
						<xsl:value-of select="4*(count(preceding::*[starts-with(@Pozycja, $prefix)])+
													   count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)]) - 1)+
													   $subtree + 1"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'1'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<xsl:for-each select="*/*[count(preceding-sibling::*) = $subtree]">
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string(./@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number(., $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:for-each>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_2C-2">
		<xsl:param name="width" select="948"/>
		<div>
 			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('DZIAŁ ', substring-after(name(.), '_'), '. ')"/>
			<div style="margin-top: -1.2em; margin-left: 6.5em">
				<xsl:value-of select="@Opis"/>
			</div>
			<p style="margin-top: 0.5em; text-align: left">RODZINY ZASTĘPCZE</p>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th class="MPiPS_03_6_0" colspan="2">FORMY POMOCY</th>
					<th class="MPiPS_03_6_1">LICZBA OSÓB, KTÓRYM PRZYZNANO DECYZJĄ ŚWIAD.</th>
					<th class="MPiPS_03_6_1">LICZBA ŚWIADCZEŃ</th>
					<th class="MPiPS_03_6_1">KWOTA ŚWIADCZEŃ W ZŁ</th>
					<th class="MPiPS_03_6_1">LICZBA RODZIN</th>
					<th class="MPiPS_03_6_1">LICZBA DZIECI UMIESZCZONYCH W RODZINIE ZASTĘPCZEJ</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Rodzinom-zastępczym">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
			</tbody>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars">
                            </td>
				<td class="remark">
                                W kolumnie 5 należy podać liczbę wszystkich dzieci umieszczonych w rodzinach zastępczych, a nie tylko przyjętych w okresie sprawozdawczym.
                            </td>
			</tr>
			<tr>
				<td class="stars">
                            </td>
				<td class="remark">
                                Za osobę, której decyzją przyznano świadczenie należy
                                uznać dziecko lub dzieci, na które przyznawane jest
					<xsl:choose>
						<xsl:when test="not(../Metryczka/Za-okres/Kwartał = 'I' or ../Metryczka/Za-okres/Kwartał = 'III')">
							świadczenie lub w przypadku wierszy 21, 28, 35 i 36 dorosłego członka rodziny zastępczej,
							na którego wypłacane jest wynagrodzenie.
						</xsl:when>
						<xsl:otherwise>
							świadczenie.
						</xsl:otherwise>
					</xsl:choose>
                            </td>
			</tr>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Rodzinom-zastępczym">
		<xsl:param name="subtree" select="'Udzielone-rodzinom'"/>
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_2C-2_'"/>
			</xsl:call-template>

			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Osób-w-decyzjach'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Liczba-świadczeń'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Kwota-świadczeń'"/>
				<xsl:with-param name="format" select="$kwota"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Liczba-rodzin'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Dzieci-umieszczonych'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
		</tr>

		<xsl:apply-templates select="*/Rodzinom-zastępczym">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_3">
		<xsl:param name="width" select="846"/>
		<div>
 			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('DZIAŁ ', substring-after(name(.), '_'), '. ')"/>
			<div style="margin-top: -1.2em; margin-left: 5em">
				<xsl:value-of select="@Opis"/>
			</div>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th class="MPiPS_03_6_0" colspan="2" rowspan="2">WYSZCZEGÓLNIENIE</th>
					<th class="MPiPS_03_6_1" rowspan="2">LICZBA OSÓB, KTÓRYM PRZYZNANO DECYZJĄ ŚWIAD.</th>
					<th class="MPiPS_03_6_1" colspan="2">LICZBA RODZIN</th>
					<th class="MPiPS_03_6_1" rowspan="2">LICZBA OSÓB W RODZINACH</th>
				</tr>
				<tr>
					<th class="MPiPS_03_6_1">OGÓŁEM</th>
					<th class="MPiPS_03_6_1">w tym:<br/>NA WSI<sup>*</sup></th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Objętych-pomocą">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
			</tbody>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" width="6">*</td>
				<td class="remark">
                                Należy wypełnić wyłącznie za I - XII.
                            </td>
			</tr>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Objętych-pomocą">
		<xsl:param name="subtree" select="'Decyzji-i-rodzin'"/>
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_3_'"/>
			</xsl:call-template>

			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Osób-w-decyzjach'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Rodzin-ogółem'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Rodzin-na-wsi'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Osób-w-rodzinach'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
		</tr>

		<xsl:apply-templates select="*/Objętych-pomocą">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_4">
		<xsl:call-template name="Dział_45"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_5">
		<xsl:call-template name="Dział_45"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Dział_45">
		<xsl:param name="width" select="744"/>
		<xsl:param name="chapter" select="substring-after(name(.), '_')"/>
		<div>
 			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('DZIAŁ ', $chapter, '. ')"/>
			<div style="margin-top: -1.2em; margin-left: 5em">
				<xsl:value-of select="@Opis"/>
			</div>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th class="MPiPS_03_6_0" colspan="2" rowspan="2">
						<xsl:choose>
							<xsl:when test="Powody-przyznania">
								POWÓD TRUDNEJ SYTUACJI ŻYCIOWEJ
							</xsl:when>
							<xsl:otherwise>
								WYSZCZEGÓLNIENIE
							</xsl:otherwise>
						</xsl:choose>
					</th>
					<th class="MPiPS_03_6_1" colspan="2">LICZBA RODZIN</th>
					<th class="MPiPS_03_6_1" rowspan="2">LICZBA OSÓB W RODZINACH</th>
				</tr>
				<tr>
					<th class="MPiPS_03_6_1">OGÓŁEM</th>
					<th class="MPiPS_03_6_1">w tym:<br/>NA WSI<sup>*</sup></th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Powody-przyznania">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Typy-rodzin">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
			</tbody>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" width="6">*</td>
				<td class="remark">
                                Należy wypełnić wyłącznie za I - XII.
                            </td>
			</tr>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Powody-przyznania">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_4_'"/>
			</xsl:call-template>

			<xsl:call-template name="_45_contents"/>
		</tr>

		<xsl:apply-templates select="*/Powody-przyznania">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Typy-rodzin">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_5_'"/>
			</xsl:call-template>

			<xsl:call-template name="_45_contents"/>
		</tr>

		<xsl:apply-templates select="*/Typy-rodzin">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_45_contents">
		<xsl:param name="subtree" select="'Rodzin-objętych'"/>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Rodzin-ogółem'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Rodzin-na-wsi'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Osób-w-rodzinach'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_6A">
		<xsl:call-template name="Dział_6AB"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_6B">
		<xsl:call-template name="Dział_6AB"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Dział_6AB">
		<xsl:param name="width" select="944"/>
		<div>
 			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('DZIAŁ ', substring-after(name(.), '_'), '. ')"/>
			<div style="margin-top: -1.2em; margin-left: 5.5em">
				<xsl:value-of select="@Opis"/>
			</div>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th class="MPiPS_03_7_0" colspan="2" rowspan="2">WYSZCZEGÓLNIENIE</th>
					<th class="MPiPS_03_7_1" colspan="3">
						PODMIOT PROWADZĄCY -
						<xsl:choose>
							<xsl:when test="JOPS-lokalne">
								<xsl:value-of select="'GMINA'"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="'POWIAT'"/>
							</xsl:otherwise>
						</xsl:choose>
					</th>
					<th class="MPiPS_03_7_1" colspan="3">INNY PODMIOT PROWADZĄCY</th>
				</tr>
				<tr>
					<th class="MPiPS_03_7_2">liczba<br/>jednostek<sup>*</sup></th>
					<th class="MPiPS_03_7_2">liczba<br/>miejsc<sup>**</sup></th>
					<th class="MPiPS_03_7_2">liczba osób<br/>korzystających<sup>***</sup></th>
					<th class="MPiPS_03_7_2">liczba<br/>jednostek<sup>*</sup></th>
					<th class="MPiPS_03_7_2">liczba<br/>miejsc<sup>**</sup></th>
					<th class="MPiPS_03_7_2">liczba osób<br/>korzystających<sup>***</sup></th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
					<td class="tab_col_no">7</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="JOPS-lokalne">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="JOPS-ponadgminne">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
			</tbody>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" width="6">*</td>
				<td class="remark">
                                Liczba jednostek w ostatnim dniu okresu sprawozdawczego.
                            </td>
			</tr>
			<tr>
				<td class="stars" width="6">**</td>
				<td class="remark">
                                Liczba miejsc wg statutu.
                            </td>
			</tr>
			<tr>
				<td class="stars" width="6">***</td>
				<td class="remark">
                                Rzeczywista liczba osób korzystających w okresie sprawozdawczym. Daną osobę należy wykazać tylko raz bez względu na liczbę dni pobytu lub liczbę wizyt.
                            </td>
			</tr>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="JOPS-lokalne">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_6A_'"/>
			</xsl:call-template>

			<xsl:call-template name="_6AB_contents">
				<xsl:with-param name="subtree" select="'Gmina'"/>
			</xsl:call-template>
			<xsl:call-template name="_6AB_contents">
				<xsl:with-param name="subtree" select="'Inne'"/>
			</xsl:call-template>
		</tr>

		<xsl:apply-templates select="*/JOPS-lokalne">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="JOPS-ponadgminne">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_6B_'"/>
			</xsl:call-template>

			<xsl:call-template name="_6AB_contents">
				<xsl:with-param name="subtree" select="'Powiat'"/>
			</xsl:call-template>
			<xsl:call-template name="_6AB_contents">
				<xsl:with-param name="subtree" select="'Inne'"/>
			</xsl:call-template>
		</tr>

		<xsl:apply-templates select="*/JOPS-ponadgminne">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_6AB_contents">
		<xsl:param name="subtree"/>
		<xsl:call-template name="_6AB_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-jednostek'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_6AB_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-miejsc'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_6AB_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-korzystających'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_6AB_column">
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="Podmiot-prowadzący/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="Z-tego and not($item/@xsi:nil)">
				<xsl:call-template name="_6AB_total">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_6AB_total">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="Z-tego/*">
				<xsl:call-template name="_6AB_add_tree">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_6AB_add_tree">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="contents" select="Podmiot-prowadzący/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_6AB_add_tree">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
