<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.1'"/>
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="ułamek" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="procent" select="'###&#160;###&#160;###&#160;##0,00%'"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'716px'"/>
	<!--
	=============================================================================================
	-->
	<xsl:include href="REGULY.xslt"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
				            .blad           {background-color: red; text-align: right}
				            .pole           {background-color: white; text-align: right}
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>; padding-top: 2px;
                                				}

                    		.skl_0		{width:  380px}
                    		.skl_1		{width:  300px}
                    		.skl_2		{width:    80px}
                    		.skl_3		{width:  300px}
                    		.skl_4		{width:  100px}
                    		.skl_5		{width:  200px}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal; width: 20px;
                                					}
                   			 .contents	{padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; width:  350px;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; padding-bottom: 8px;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; margin-top: 14px;
                                				}
                    		.empty		{border: 0 0 0 0;}
                      </style>
                      <xsl:call-template name="regulyStyle"/>
			</head>
			<body>
				<xsl:call-template name="regulyScript"/>
				<div id="Reguly">
					<xsl:call-template name="reguly"/>
				</div>
				<div id="Sprawozdanie">
					<xsl:apply-templates/>
				</div>
				<xsl:call-template name="zaznaczWybrana"/>
				<!-- Koniec modyfikacja na potrzeby pokazywania błędów -->
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="SDSMCHR">
		<xsl:apply-templates select="Metryczka"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Domy-i-mieszkania"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<!-- Modyfikacja na potrzeby edytowania komorek porownywanie-->
		<table border="2" cellspacing="0" cellpadding="4">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th colspan="3">
						<span style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO PRACY I POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5,<br/>00-513 Warszawa
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="290">
						<span style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
						</span>
						<center>
							<xsl:for-each select="Nadawca">
								<table cellspacing="0" cellpadding="0">
									<tr>
										<td class="stamp" colspan="2">
											<xsl:value-of select="Pełna-nazwa"/>
										</td>
									</tr>
									<xsl:for-each select="Adres-pocztowy">
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Ulica-i-numer"/>
											</td>
										</tr>
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Kod-i-poczta"/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td colspan="2" class="stamp" style="font-size: 11px; text-align: left">
											<xsl:for-each select="Telefon">
                         	        					           Tel. <xsl:apply-templates/> &#160;
								                        </xsl:for-each>
										</td>
									</tr>
									<tr>
										<td colspan="2" class="stamp" style="font-size: 11px; text-align: left">
											<xsl:for-each select="Faks">
						                                           Fax <xsl:apply-templates/> &#160;
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>
						</center>
					</td>
					<td width="195" rowspan="3" style="text-align: center; font-weight: bold;">
						<!--span style="font-size: large;"><xsl:value-of select="name(..)"/></span>
						<br/-->
						<p style="font-size: 12px">
                            			ŚRODOWISKOWE DOMY SAMOPOMOCY (rozdz. 85203)
                            			I&#160;MIESZKANIA CHRONIONE (rozdz. 85220)
								WG STANU NA DZIEŃ 30.VI.<xsl:value-of select="Za-okres/Rok"/> r.
						</p>
					</td>
					<td width="205">
						<div style="font-weight: bold; font-size: 12px; text-align: left;">
							Część&#160;85 - Budżety Wojewodów
							<br/>
							Dział&#160;852 - Pomoc społeczna
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<span style="font-size: 11px; text-align: left;">
							Numer identyfikacyjny jednostki sprawozdawczej:<br/>
						</span>
						<div style="font-weight: bold; text-align: center;">
							<xsl:value-of select="Nadawca/@Kod-REGON"/>
						</div>
					</td>
					<td rowspan="2" width="200">
						<div style="font-weight: bold; font-size: 13px; text-align: left;">
							Przekazać w terminie do&#160;31&#160;lipca<sup>1)</sup>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<span style="font-size: 11px; text-align: left;">
							Województwo:<br/>
						</span>
						<div style="font-weight: bold; text-align: center;">
							<xsl:value-of select="../Nagłówek/Województwo"/>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<br/><xsl:value-of select="Opis"/><br/>
			</div>
		</xsl:if>
		<br/>
		<xsl:if test="(Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III') and Kod/Cyklu-sprawozdawczego != 3 or
					(Za-okres/Kwartał = 'II' or Za-okres/Kwartał = 'IV') and Kod/Cyklu-sprawozdawczego != 4">
			<!--div style="font-size: large; text-align: center; color: red;">
				Niepoprawny kod cyklu sprawozdawczego!
			</div>
			<br/> <br/> <br/> <br/> <br/-->
		</xsl:if>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek porownywanie-->
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table border="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th colspan="2" width="390" align="left">Imię, nazwisko i numer telefonu osoby, która sporządziła informację</th>
					<th>Miejscowość i data</th>
					<th>DYREKTOR</th>
				</tr>
			</thead>
			<tbody>
				<tr style="font-size: 12px;">
					<td colspan="2">
						<xsl:value-of select="concat($kto/Imię-i-nazwisko, ', tel. ', $kto/Telefon)"/>
					</td>
					<td align="center">
						<xsl:value-of select="concat(substring(Metryczka/Nadawca/Adres-pocztowy/Kod-i-poczta, 8), ', ', $kto/Data-wykonania)"/>
					</td>
				</tr>
			</tbody>
		</table>
		<br/>
		<br/>
		<hr align="left" width="400" noshade="1" size="1"/>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td colspan="4" class="stars">1) <font class="remark">
					Jeśli termin przekazania sprawozdania wypada w dzień wolny od pracy, to obowiązuje data pierwszego
					dnia roboczego po tym dniu. Powyższe daty są terminami przekazania sprawozdania do MPS.</font>
				</td>
			</tr>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr/>
			<tr>
				<td colspan="2" class="xslt_ver" style="text-align: left;">
					Wersja szablonu XSLT: <xsl:value-of select="$wersja"/>
				</td>
				<td colspan="2" class="xslt_ver" style="text-align: right;">
					<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
					<!--xsl:if test="system-property('msxsl:version')">
						<xsl:value-of select="concat(', MSXML: ', system-property('msxsl:version'))"/>
					</xsl:if-->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="prefix"/>
		<td class="row_descr">
			<p>
				<xsl:value-of select="substring-after(@Pozycja, $prefix)"/>. <xsl:value-of select="@Opis"/>
			</p>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Domy-i-mieszkania">
		<xsl:param name="width" select="716"/>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th class="skl_0" rowspan="2">WYSZCZEGÓLNIENIE</th>
					<th class="skl_1" colspan="3">LICZBA</th>
				</tr>
				<tr>
					<th class="skl_4">DOMÓW</th>
					<th class="skl_4">MIEJSC</th>
					<th class="skl_4">OSÓB PRZEBYWAJĄCYCH</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Domy-samopomocy">
					<xsl:call-template name="Domy-samopomocy"/>
				</xsl:for-each>
				<tr style="font-family: Tahoma, Verdana; font-size: 11px; font-weight: bold; text-align: center;">
					<td class="skl_0" rowspan="2">&#160;</td>
					<td class="skl_1" colspan="3">LICZBA</td>
				</tr>
				<tr style="font-family: Tahoma, Verdana; font-size: 11px; font-weight: bold; text-align: center;">
					<td class="skl_4">MIESZKAŃ</td>
					<td class="skl_4">MIEJSC</td>
					<td class="skl_4">MIESZKAŃCÓW</td>
				</tr>
				<xsl:for-each select="Mieszkania-chronione">
					<xsl:call-template name="Mieszkania-chronione"/>
				</xsl:for-each>
			</tbody>
		</table>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Domy-samopomocy">
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_SDSMCHR_'"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Domów'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Miejsc'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Osób-przebywających'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Mieszkania-chronione">
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_SDSMCHR_'"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Mieszkań'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Miejsc'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Mieszkańców'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_1_column">
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:choose>
			<xsl:when test="$item/@Komorka">
				<xsl:variable name="nazwa">
					<xsl:value-of select="$item/@Komorka"/>
				</xsl:variable>
				<xsl:variable name="wartosc">
					<xsl:value-of select="$item"/>
				</xsl:variable>
				<xsl:variable name="class" select="'pole'"/>
				<xsl:choose>
					<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
						<td id="{$nazwa}" class="contents">
							<div id="K{$nazwa}" class="div_komorka">
											</div>
							<xsl:value-of select="concat('K', $nazwa)"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td id="{$nazwa}" class="contents">
							<div id="K{$nazwa}" class="div_komorka">
								<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
							</div>
							<xsl:value-of select="format-number($item, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:value-of select="format-number($item, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
