<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:param name="operacja">przegladanie</xsl:param>
	<xsl:param name="przyciski">false</xsl:param>
	<xsl:param name="porownanie">false</xsl:param>
	<xsl:param name="formatowanie_kwota">###&#160;###&#160;###&#160;##0</xsl:param>
	<xsl:param name="formatowanie_liczba">##&#160;###&#160;##0</xsl:param>
	<xsl:param name="FrmSymbol"/>
	<xsl:param name="ZaOkres1"/>
	<xsl:param name="Nadawca1"/>
	<xsl:param name="Odbiorca1"/>
	<xsl:param name="WersjaZ1"/>
	<xsl:param name="ZaOkres2"/>
	<xsl:param name="Nadawca2"/>
	<xsl:param name="Odbiorca2"/>
	<xsl:param name="WersjaZ2"/>
	<xsl:param name="aplikacja">gmina</xsl:param>
	<!--zmiana gmina-->
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.1'"/>
	<xsl:decimal-format grouping-separator="&#160;"/>
	<xsl:variable name="kwota" select="$formatowanie_kwota"/>
	<xsl:variable name="liczba" select="$formatowanie_liczba"/>
	<xsl:variable name="width">
		<xsl:choose>
			<xsl:when test="$aplikacja = 'gmina'">
				<xsl:value-of select="'727px'"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'944px'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<xsl:choose>
					<xsl:when test="$aplikacja = 'gmina'">
						<!--zmiana gmina-->
						<link rel="stylesheet" href="skl_emrent.css"/>
					</xsl:when>
					<xsl:otherwise>
						<style type="text/css">
				            .blad           {background-color: red; text-align: right}
				            .pole           {background-color: white; text-align: right}
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>; padding-top: 6px;
                                				}
                    		.skl_0		{width:  380px}
                    		.skl_1		{width:  170px}
                    		.skl_2		{width:    80px}
                    		.skl_3		{width:  300px}
                    		.skl_4		{width:  100px}
                    		.skl_5		{width:  200px}
                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal; width: 20px;
                                					}
                   			 .contents	{padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; width:  350px;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; padding-bottom: 8px;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal; width:  10px;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; margin-top: 14px;
                                				}
                    		.empty		{border: 0 0 0 0;}
                    		
                    		#Przyciski {top: 1em; position: absolute; overflow: auto; width: 99%; z-index: 2; cursor: default;}
							* html #Przyciski { /* IE hack */
									width: 100%;
									height: 12%;
							}
							#Sprawozdanie {top: 4em; bottom: 0em; position: absolute; overflow: auto; width: 99%; z-index: 1;}
							* html #Sprawozdanie { /* IE hack */
								height: 85%;								
								width: 100%;
							}
                      </style>
					</xsl:otherwise>
				</xsl:choose>
			</head>
			<body>
				<!-- Modyfikacja na potrzeby edytowania komorek -->
				<form name="SACKomorkiSprawozdania" action="/Pomost/SAC/sprawozdania/komorki/zapisz.do?operacja={$operacja}" method="POST">
					<div id="Przyciski">
						<xsl:if test="$przyciski = 'true'">
							<xsl:choose>
								<xsl:when test="$aplikacja = 'gmina'">
									<!--zmiana gmina-->
									<input type="submit" value="Akceptuj"/>
									<input type="submit" value="Waliduj"/>
									<input type="submit" value="Odswiez"/>
									<xsl:value-of select="' '"/>
									<input type="submit" value="Anuluj"/>
								</xsl:when>
								<xsl:otherwise>
									<a href="javascript:document.forms[0].submit();" accesskey="B">
										<img border="0" alt="Akceptuj (ALT+B)" src="../../../obrazki/lista/akceptuj.gif"/>
									</a>
									<xsl:value-of select="' '"/>
									<a href="javascript:document.forms[0].action='/Pomost/SAC/scalanieSprawozdan/initial.do'; document.forms[0].submit();" accesskey="K">
										<img border="0" alt="Anuluj (ALT+K)" src="../../../obrazki/lista/anuluj.gif"/>
									</a>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
					</div>
					<div id="Sprawozdanie">
						<xsl:apply-templates/>
					</div>
				</form>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="SKŁ-EMRENT">
		<xsl:apply-templates select="Metryczka"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Składki-wg-świadczeń"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<!-- Modyfikacja na potrzeby edytowania komorek porownywanie-->
		<xsl:choose>
			<xsl:when test="$porownanie = 'false'">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<br/><xsl:value-of select="Opis"/><br/> <br/>
			</div>
		</xsl:if>
		<table border="2" cellspacing="0" cellpadding="8">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th colspan="3">
						<span  style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO PRACY I POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5, 00-513 Warszawa
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="300">
						<span  style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
						</span>
						<center>
							<xsl:for-each select="Nadawca">
								<table cellspacing="0" cellpadding="0">
									<tr>
										<td class="stamp" colspan="2">
											<xsl:value-of select="Pełna-nazwa"/>
										</td>
									</tr>
									<xsl:for-each select="Adres-pocztowy">
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Ulica-i-numer"/>
											</td>
										</tr>
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Kod-i-poczta"/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td class="stamp" style="font-size: 11px; text-align: left">
											<xsl:for-each select="Telefon">
                                 					           Tel. <xsl:apply-templates/> &#160;
					                                        </xsl:for-each>
										</td>
										<td class="stamp" style="font-size: 11px; text-align: right">
											<xsl:for-each select="Faks">
					                                            &#160;Fax <xsl:apply-templates/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>
						</center>
					</td>
					<td rowspan="2" style="text-align: center; font-weight: bold;">
						<span style="font-size: large;"><xsl:value-of select="name(..)"/></span>
						<br/>
						<p style="font-size: 13px">
                            			Składki na ubezpieczenie <xsl:value-of select="concat(substring(../Składki-wg-świadczeń/@Opis, 1, string-length(../Składki-wg-świadczeń/@Opis) - 1), 'e')"/>
						</p> za I -
						<xsl:choose>
							<xsl:when test="Za-okres/Kwartał = 'I'">III</xsl:when>
							<xsl:when test="Za-okres/Kwartał = 'II'">VI</xsl:when>
							<xsl:when test="Za-okres/Kwartał = 'III'">IX</xsl:when>
							<xsl:otherwise>XII</xsl:otherwise>
						</xsl:choose>  
						<xsl:value-of select="concat(' ', Za-okres/Rok, ' r.')"/> 
					 </td>
					<td>
						<span  style="font-size: 11px; text-align: left;">
							Adresat:<br/>
						</span>
						<div class="stamp">
							<xsl:value-of select="Odbiorca/Pełna-nazwa"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<span  style="font-size: 11px; text-align: left;">
							Numer identyfikacyjny REGON:<br/>
						</span>
						<div style="font-weight: bold; text-align: center;">
							<xsl:value-of select="Nadawca/@Kod-REGON"/>
						</div>
					</td>
					<td>
						<div style="font-weight: bold; font-size: 13px; text-align: center;">
							Przekazać w terminie do 15 dnia miesiąca następującego po okresie sprawozdawczym
						</div>
					</td>
				</tr>
			</tbody>
		</table>

		<br/>
		<xsl:if test="(Za-okres/Kwartał = 'II' or Za-okres/Kwartał = 'IV') and Kod/Cyklu-sprawozdawczego != 3">
			<div style="font-size: large; text-align: center; color: red;">
				Niepoprawny okres lub kod cyklu sprawozdawczego!
			</div>
			<br/> <br/> <br/> <br/> <br/>
		</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<!-- Naglowkowa tabella porownania -->
				<table class="wide" border="1" cellspacing="0" cellpadding="0" width="100%">
					<thead>
						<tr>
							<th colspan="2">
								<span style="font-size: 18px; font-weight: bold;">
			                  Porównanie zawartości komórek sprawozdań o symbolu <xsl:value-of select="$FrmSymbol"/>
								</span>
							</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td width="50%">
								<table>
									<tr>
										<td>
											<B>Sprawozdanie za okres:</B>
											<xsl:value-of select="$ZaOkres1"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Nadawca:</B>
											<xsl:value-of select="$Nadawca1"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Odbiorca:</B>
											<xsl:value-of select="$Odbiorca1"/>
										</td>
									</tr>
									<xsl:if test="$WersjaZ1 != ''">
										<tr>
											<td>
												<B>Wersja po modyfikacji z:</B> dnia <xsl:value-of select="$WersjaZ1"/>
											</td>
										</tr>
									</xsl:if>
								</table>
							</td>
							<td width="50%">
								<table>
									<tr>
										<td>
											<B>Sprawozdanie za okres:</B>
											<xsl:value-of select="$ZaOkres2"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Nadawca:</B>
											<xsl:value-of select="$Nadawca2"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Odbiorca:</B>
											<xsl:value-of select="$Odbiorca2"/>
										</td>
									</tr>
									<xsl:if test="$WersjaZ2 != ''">
										<tr>
											<td>
												<B>Wersja po modyfikacji z:</B> dnia <xsl:value-of select="$WersjaZ2"/>
											</td>
										</tr>
									</xsl:if>
								</table>
							</td>
						</tr>
					</tbody>
				</table>
				<br/>
				<!-- Koniec naglowkowa tabella porownania -->
			</xsl:otherwise>
		</xsl:choose>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek porownywanie-->
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table>
			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				
				<tr>
					<th width="160" align="left" colspan="2">
					    <span  style="font-size: 14px; font-weight: bold;">
						Osoba&#160;sporządzająca&#160;sprawozdanie:
					    </span>
					</th>
					
					<th align="right">Pieczątka imienna i podpis osoby działającej w imieniu sprawozdawcy:</th>
				</tr>
			</thead>
			<tr>
				<td width="160">Imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td width="160">Telefon:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td width="160">Data wykonania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
			<tr>
				<td width="160">e-mail:</td>
				<td>
					<xsl:value-of select="$kto/E-mail"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="prefix"/>
		<td class="row_descr">
				<xsl:value-of select="@Opis"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Składki-wg-świadczeń">
		<!--xsl:param name="width" select="944"/-->
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th class="skl_0" rowspan="3">RODZAJ ŚWIADCZENIA</th>
					<th class="skl_1" rowspan="3">Liczba świadczeniobiorców<sup>*</sup>, za których jest opłacana składka <xsl:value-of select="@Opis"/>
					</th>
					<th class="skl_2" rowspan="3">Liczba składek należnych</th>
					<th class="skl_3" colspan="3">Koszt składek należnych w zł<sup>**</sup>
					</th>
				</tr>
				<tr>
					<th class="skl_4" rowspan="2">ogółem (4 + 5)</th>
					<th class="skl_5" colspan="2">z tego:</th>
				</tr>
				<tr>
					<th class="skl_4">opłaconych</th>
					<th class="skl_4">nieopłaconych</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates/>
			</tbody>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0" >
			<tr>
				<td class="stars">*
	                    </td>
				<td class="remark">
					liczba osób otrzymujących na podstawie decyzji dany rodzaj świadczenia
	                    </td>
			</tr>
			<tr>
				<td class="stars">**
	                    </td>
				<td class="remark">
					w zaokrągleniu do 1 zł
	                    </td>
			</tr>
		</table><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Liczba-i-koszt-składek">
		<xsl:param name="subtree" select="'Koszt-składek_należnych'"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_SKL-EMRENT_'"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Liczba-świadczeniobiorców'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Liczba-składek'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Ogółem'"/>
				<xsl:with-param name="format" select="$kwota"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Opłaconych'"/>
				<xsl:with-param name="format" select="$kwota"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Nieopłaconych'"/>
				<xsl:with-param name="format" select="$kwota"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_1_column">
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="string($item/@xsi:nil) = 'true'">
				<td class="contents">
					<center>X</center>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<!-- Modyfikacja na potrzeby edytowania komorek -->
				<xsl:choose>
					<xsl:when test="$item/@Komorka">
						<xsl:variable name="nazwa">
							<xsl:value-of select="$item/@Komorka"/>
						</xsl:variable>
						<xsl:variable name="wartosc">
							<xsl:value-of select="$item"/>
						</xsl:variable>
						<xsl:variable name="class">
							<xsl:choose>
								<xsl:when test="$item/@Blad='true'">
				                        blad
				                    </xsl:when>
						<xsl:otherwise>
				                        pole
				                    </xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$item/@Edit='true'">
								<td class="contents">
									<!--Modyfikacja na potrzeby analizy -->
									<xsl:choose>
										<xsl:when test="$item/@Analiza='true'">
											<input type="submit" value="K{$nazwa}"/>
										</xsl:when>
									</xsl:choose>
									<!--Koniec Modyfikacja na potrzeby analizy -->
									<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="contents">
									<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
									<xsl:value-of select="format-number($item, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$porownanie = 'true'">
								<xsl:choose>
									<xsl:when test="$item/@Blad='true'">
										<td class="contents" style="background-color: orange">
											<xsl:value-of select="$item"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="$item"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<td class="contents">
									<xsl:value-of select="format-number($item, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_totals">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="result">
			<xsl:value-of select="sum($nodeset)"/>
		</xsl:param>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<!-- Modyfikacja na potrzeby analizy komorek-->
		<xsl:param name="analiza"/>
		<!-- Koniec modyfikacja na potrzeby analizy komorek-->
		<xsl:choose>
			<xsl:when test="string(number($contents)) != 'NaN'">
				<xsl:choose>
					<xsl:when test="string(number($result)) = 'NaN'">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$blad='true'">
						                                    blad
						                    </xsl:when>
										<xsl:otherwise>
						                                    pole
						                    </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$edit='true'">
										<td class="totals" style="background-color: red">
											<!--Modyfikacja na potrzeby analizy -->
											<xsl:choose>
												<xsl:when test="$analiza='true'">
													<input type="submit" value="K{$nazwa}"/>
												</xsl:when>
											</xsl:choose>
											<!--Koniec Modyfikacja na potrzeby analizy -->
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="'suma: NaN'"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<center>X</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$blad='true'">
												<td class="totals" style="background-color: orange">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals" style="background-color: red">
											<center>X</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:when test="$contents != $result">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$blad='true'">
						                                    blad
						                            </xsl:when>
										<xsl:otherwise>
						                                    pole
						                            </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$edit='true'">
										<td class="contents" style="background-color: red">
											<!--Modyfikacja na potrzeby analizy -->
											<xsl:choose>
												<xsl:when test="$analiza='true'">
													<input type="submit" value="K{$nazwa}"/>
												</xsl:when>
											</xsl:choose>
											<!--Koniec Modyfikacja na potrzeby analizy -->
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$blad='true'">
						                                    blad
						                            </xsl:when>
										<xsl:otherwise>
						                                    pole
						                            </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$edit='true'">
										<td class="totals">
											<!--Modyfikacja na potrzeby analizy -->
											<xsl:choose>
												<xsl:when test="$analiza='true'">
													<input type="submit" value="K{$nazwa}"/>
												</xsl:when>
											</xsl:choose>
											<!--Koniec Modyfikacja na potrzeby analizy -->
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($result, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$blad='true'">
												<td class="totals" style="background-color: orange">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<xsl:value-of select="format-number($result, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!-- Modyfikacja na potrzeby edytowania komorek -->
				<xsl:choose>
					<xsl:when test="$komorka!='' and $komorka!='NaN'">
						<xsl:variable name="nazwa">
							<xsl:value-of select="$komorka"/>
						</xsl:variable>
						<xsl:variable name="wartosc">
							<xsl:value-of select="$contents"/>
						</xsl:variable>
						<xsl:variable name="class">
							<xsl:choose>
								<xsl:when test="$blad='true'">
						                                    blad
						                    </xsl:when>
								<xsl:otherwise>
						                                    pole
						                    </xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$edit='true'">
								<td class="totals">
									<!--Modyfikacja na potrzeby analizy -->
									<xsl:choose>
										<xsl:when test="$analiza='true'">
											<input type="submit" value="K{$nazwa}"/>
										</xsl:when>
									</xsl:choose>
									<!--Koniec Modyfikacja na potrzeby analizy -->
									<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals">
									<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
									<xsl:value-of select="format-number($result, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$porownanie = 'true'">
								<xsl:choose>
									<xsl:when test="$blad='true'">
										<td class="totals" style="background-color: orange">
											<xsl:value-of select="$contents"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<xsl:value-of select="$contents"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals">
									<xsl:value-of select="format-number($result, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_2_column">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="name(*[name(.) = $subtree]/*[position()=3]) = name($item)">
				<xsl:call-template name="_2_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="nodeset" select="*[name(.) = $subtree]/*[name(.) != $column]"/>
					<xsl:with-param name="format" select="$format"/>
					<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka" select="$item/@Komorka"/>
					<xsl:with-param name="blad" select="$item/@Blad"/>
					<xsl:with-param name="edit" select="$item/@Edit"/>
					<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					<!-- Modyfikacja na potrzeby analizy-->
					<xsl:with-param name="analiza" select="$item/@Analiza"/>
					<!-- Koniec modyfikacja na potrzeby analizy-->
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string($item/@xsi:nil) = 'true'">
						<td class="contents">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                        blad
						                    </xsl:when>
										<xsl:otherwise>
						                        pole
						                    </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents">
											<!--Modyfikacja na potrzeby analizy -->
											<xsl:choose>
												<xsl:when test="$item/@Analiza='true'">
													<input type="submit" value="K{$nazwa}"/>
												</xsl:when>
											</xsl:choose>
											<!--Koniec Modyfikacja na potrzeby analizy -->
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($item, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="format-number($item, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_totals">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="result">
			<xsl:value-of select="sum($nodeset)"/>
		</xsl:param>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<!-- Modyfikacja na potrzeby analizy-->
		<xsl:param name="analiza"/>
		<!-- Koniec modyfikacja na potrzeby analizy-->
		<xsl:choose>
			<xsl:when test="string(number($contents)) != 'NaN'">
				<xsl:choose>
					<xsl:when test="string(number($result)) = 'NaN'">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$blad='true'">
						                                    blad
						                    </xsl:when>
										<xsl:otherwise>
						                                    pole
						                    </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$edit='true'">
										<td class="totals" style="background-color: red">
											<!--Modyfikacja na potrzeby analizy -->
											<xsl:choose>
												<xsl:when test="$analiza='true'">
													<input type="submit" value="K{$nazwa}"/>
												</xsl:when>
											</xsl:choose>
											<!--Koniec Modyfikacja na potrzeby analizy -->
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="'suma: NaN'"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<center>X</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$blad='true'">
												<td class="totals" style="background-color: orange">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals" style="background-color: red">
											<center>X</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:when test="$contents != $result">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$blad='true'">
						                                    blad
						                            </xsl:when>
										<xsl:otherwise>
						                                    pole
						                            </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$edit='true'">
										<td class="contents" style="background-color: red">
											<!--Modyfikacja na potrzeby analizy -->
											<xsl:choose>
												<xsl:when test="$analiza='true'">
													<input type="submit" value="K{$nazwa}"/>
												</xsl:when>
											</xsl:choose>
											<!--Koniec Modyfikacja na potrzeby analizy -->
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$blad='true'">
						                                    blad
						                            </xsl:when>
										<xsl:otherwise>
						                                    pole
						                            </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$edit='true'">
										<td class="totals">
											<!--Modyfikacja na potrzeby analizy -->
											<xsl:choose>
												<xsl:when test="$analiza='true'">
													<input type="submit" value="K{$nazwa}"/>
												</xsl:when>
											</xsl:choose>
											<!--Koniec Modyfikacja na potrzeby analizy -->
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($result, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$blad='true'">
												<td class="totals" style="background-color: orange">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<xsl:value-of select="format-number($result, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!-- Modyfikacja na potrzeby edytowania komorek -->
				<xsl:choose>
					<xsl:when test="$komorka!='' and $komorka!='NaN'">
						<xsl:variable name="nazwa">
							<xsl:value-of select="$komorka"/>
						</xsl:variable>
						<xsl:variable name="wartosc">
							<xsl:value-of select="$contents"/>
						</xsl:variable>
						<xsl:variable name="class">
							<xsl:choose>
								<xsl:when test="$blad='true'">
						                                    blad
						                    </xsl:when>
								<xsl:otherwise>
						                                    pole
						                    </xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$edit='true'">
								<td class="totals">
											<!--Modyfikacja na potrzeby analizy -->
											<xsl:choose>
												<xsl:when test="$analiza='true'">
													<input type="submit" value="K{$nazwa}"/>
												</xsl:when>
											</xsl:choose>
											<!--Koniec Modyfikacja na potrzeby analizy -->
									<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals">
									<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
									<xsl:value-of select="format-number($result, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$porownanie = 'true'">
								<xsl:choose>
									<xsl:when test="$blad='true'">
										<td class="totals" style="background-color: orange">
											<xsl:value-of select="$contents"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<xsl:value-of select="$contents"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals">
									<xsl:value-of select="format-number($result, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
