<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
    <xsl:param name="FrmSymbol"></xsl:param>
    <xsl:param name="FrmWersja"></xsl:param>
    <xsl:param name="KomEdyt">false</xsl:param>
    <xsl:param name="DataOd"></xsl:param>
    <xsl:param name="DataDo"></xsl:param>
    <xsl:param name="przyciskiKomorek">false</xsl:param>
	<xsl:param name="formatowanie_kwota">###&#160;###&#160;###&#160;##0</xsl:param>
	<xsl:param name="formatowanie_liczba">##&#160;###&#160;##0</xsl:param>
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.1'"/>
	<xsl:decimal-format grouping-separator="&#160;"/>
	<xsl:variable name="kwota" select="$formatowanie_kwota"/>
	<xsl:variable name="liczba" select="$formatowanie_liczba"/>
	<xsl:variable name="width" select="'944px'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
				            .blad           {background-color: red; text-align: right}
				            .pole           {background-color: white; text-align: right}
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>; padding-top: 6px;
                                				}
                    		.SKL_0		{width:  380px}
                    		.SKL_1		{width:  170px}
                    		.SKL_2		{width:    80px}
                    		.SKL_3		{width:  300px}
                    		.SKL_4		{width:  100px}
                    		.SKL_5		{width:  200px}
                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal; width: 20px;
                                					}
                   			 .contents	{height: 2.0em; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.0em; padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; width:  350px;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; padding-bottom: 8px;
                                				}
                    		.stars      	{padding-left: 2px; text-align: right; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal; ; width:  10px;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; margin-top: 14px;
                                				}
                    		.empty		{border: 0 0 0 0;}
                </style>
			</head>
			<body>
<!-- Modyfikacja na potrzeby edytowania komorek -->
                <SCRIPT LANGUAGE="JavaScript1.1">
                    var operator = '';
                    function dodajOperator(regula){
                        operator = '';
                        if (regula.length > 0)
                        {
                           operator = '+';
                           if (regula.charAt(regula.length -1) == "+") {
                              operator ='';
                           }
                           if (regula.charAt(regula.length -1) == "-") {
                              operator ='';
                           }
                           if (regula.charAt(regula.length -1) == "*") {
                              operator ='';
                           }
                           if (regula.charAt(regula.length -1) == "/") {
                              operator ='';
                           }
                           if (regula.charAt(regula.length -1) == "=") {
                              operator ='';
                           }
                           if (regula.charAt(regula.length -1) == "&gt;") {
                              operator ='';
                           }
                           if (regula.charAt(regula.length -1) == "&lt;") {
                              operator ='';
                           }
                        }
                    }
                </SCRIPT>
			    <form name="SACKomorkiSprawozdania" action="" method="POST">
                    <xsl:apply-templates/>
				</form>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="SKŁ-EMRENT">
		<xsl:apply-templates select="Metryczka"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Składki-wg-świadczeń"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<table border="2" cellspacing="0" cellpadding="8">
 			<xsl:attribute name="width">
 				<xsl:value-of select="'944px'"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th>
						<span  style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO PRACY I POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5, 00-513 Warszawa
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td style="text-align: center; font-weight: bold;">
						<span style="font-size: large;">
                            Komórki dla formularza o symbolu: <xsl:value-of select="$FrmSymbol"/>
						</span><br/>
					</td>
				</tr>
			</tbody>
		</table>
		<br/> <br/> <br/> <br/> <br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table>
			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				
				<tr>
					<th width="160" align="left" colspan="2">
					    <span  style="font-size: 14px; font-weight: bold;">
						Osoba&#160;sporządzająca&#160;sprawozdanie:
					    </span>
					</th>
					
					<th align="right">Pieczątka imienna i podpis osoby działającej w imieniu sprawozdawcy:</th>
				</tr>
			</thead>
			<tr>
				<td width="160">Imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td width="160">Telefon:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td width="160">Data wykonania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
			<tr>
				<td width="160">e-mail:</td>
				<td>
					<xsl:value-of select="$kto/E-mail"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="prefix"/>
		<td class="row_descr">
				<xsl:value-of select="@Opis"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Składki-wg-świadczeń">
		<xsl:param name="width" select="944"/>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th class="SKL_0" rowspan="3">RODZAJ ŚWIADCZENIA</th>
					<th class="SKL_1" rowspan="3">Liczba świadczeniobiorców<sup>*</sup>, za których jest opłacana składka <xsl:value-of select="@Opis"/></th>
					<th class="SKL_2" rowspan="3">Liczba składek należnych</th>
					<th class="SKL_3" colspan="3">Koszt składek należnych w zł<sup>**</sup></th>
				</tr>
				<tr>
					<th class="SKL_4" rowspan="2">ogółem (4 + 5)</th>
					<th class="SKL_5" colspan="2">z tego:</th>
				</tr>
				<tr>
					<th class="SKL_4">opłaconych</th>
					<th class="SKL_4">nieopłaconych</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates/>
			</tbody>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0" >
			<tr>
				<td class="stars">*
	                    </td>
				<td class="remark">
					liczba osób otrzymujących na podstawie decyzji dany rodzaj świadczenia
	                    </td>
			</tr>
			<tr>
				<td class="stars">**
	                    </td>
				<td class="remark">
					w zaokrągleniu do 1 zł
	                    </td>
			</tr>
		</table><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Liczba-i-koszt-składek">
		<xsl:param name="subtree" select="'Koszt-składek_należnych'"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_SKL-EMRENT_'"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Liczba-świadczeniobiorców'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Liczba-składek'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Ogółem'"/>
				<xsl:with-param name="format" select="$kwota"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Opłaconych'"/>
				<xsl:with-param name="format" select="$kwota"/>
			</xsl:call-template>
			<xsl:call-template name="_2_column">
				<xsl:with-param name="subtree" select="$subtree"/>
				<xsl:with-param name="column" select="'Nieopłaconych'"/>
				<xsl:with-param name="format" select="$kwota"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_1_column">
		<xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="string($item/@xsi:nil) = 'true'">
			    <td class="contents">
				    <center>X</center>
      			    </td>
			</xsl:when>
			<xsl:otherwise>
			<!-- Modyfikacja na potrzeby edytowania komorek -->
				<xsl:choose>
			        <xsl:when test="$item/@Komorka">
			            <xsl:variable name="nazwa"><xsl:value-of select="$item/@Komorka"/></xsl:variable>
			            <xsl:choose>
			                <xsl:when test="$przyciskiKomorek = 'true'">
                                            <td class="contents">
		                	        <center>
		                	         <xsl:choose>
			                            <xsl:when test="$FrmWersja = '' and $KomEdyt = 'false'">
			                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                         onClick="javascript:window.opener.document.edytorApplet.getExchanger().returnKomorkaValue('K{$nazwa}');"/>
                                                    </xsl:when>
                                                    <xsl:when test="$KomEdyt = 'true'">
			                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.document.getElementById('SS_KOMORKI_EDYT@NR_KOMORKI').value ='K{$nazwa}';"/>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                            <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.document.edytorApplet.getExchanger().returnInnaKomorkaValue('{$FrmSymbol}','{$FrmWersja}','{$DataOd}','{$DataDo}', 'K{$nazwa}');"/>
                                                    </xsl:otherwise>
                                                    </xsl:choose>
  			                        </center>
		                            </td>
			                </xsl:when>
			                <xsl:otherwise>
			                  <td class="contents">
			                    <center><B>K<xsl:value-of select='$nazwa'/></B></center>
			                  </td>
					</xsl:otherwise>
				    </xsl:choose>
			        </xsl:when>
				<xsl:otherwise>
				    <td class="contents">
				      <xsl:value-of select="format-number($item, $format)"/>
				    </td>
				</xsl:otherwise>
				</xsl:choose>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_totals">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="result">
			<xsl:value-of select="sum($nodeset)"/>
		</xsl:param>
<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"></xsl:param>
		<xsl:param name="blad"></xsl:param>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
<!-- Modyfikacja na potrzeby edytowania komorek -->
                            <xsl:choose>
						        <xsl:when test="$komorka!='' and $komorka!='NaN'">
						            <xsl:variable name="nazwa"><xsl:value-of select="$komorka"/></xsl:variable>
						            <xsl:choose>
						                <xsl:when test="$przyciskiKomorek = 'true'">
                                            <td class="totals">
					                	        <center>
						                            <xsl:choose>
						                                <xsl:when test="$FrmWersja = '' and $KomEdyt = 'false'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.document.edytorApplet.getExchanger().returnKomorkaValue('K{$nazwa}');"/>
                                                        </xsl:when>
                                                        <xsl:when test="$KomEdyt = 'true'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.document.getElementById('SS_KOMORKI_EDYT@NR_KOMORKI').value ='K{$nazwa}';"/>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.document.edytorApplet.getExchanger().returnInnaKomorkaValue('{$FrmSymbol}','{$FrmWersja}','{$DataOd}','{$DataDo}', 'K{$nazwa}');"/>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
						                        </center>
					                        </td>
					                    </xsl:when>
					                    <xsl:otherwise>
					                        <td class="totals">
					                            <center><B>K<xsl:value-of select='$nazwa'/></B></center>
					                        </td>
					                    </xsl:otherwise>
					                </xsl:choose>
						        </xsl:when>
						        <xsl:otherwise>
                                    <td class="totals">
						                <center>X</center>
                                    </td>
						        </xsl:otherwise>
						    </xsl:choose>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_2_column">
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="name(*[name(.) = $subtree]/*[position()=3]) = name($item)">
				<xsl:call-template name="_2_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="nodeset" select="*[name(.) = $subtree]/*[name(.) != $column]"/>
					<xsl:with-param name="format" select="$format"/>
<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka" select="$item/@Komorka"/>
					<xsl:with-param name="blad" select="$item/@Blad"/>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
						    <td class="contents">
							    <center>X</center>
							</td>
						</xsl:when>
						<xsl:otherwise>
<!-- Modyfikacja na potrzeby edytowania komorek -->
							<xsl:choose>
						        <xsl:when test="$item/@Komorka">
						            <xsl:variable name="nazwa"><xsl:value-of select="$item/@Komorka"/></xsl:variable>
						            <xsl:choose>
						                <xsl:when test="$przyciskiKomorek = 'true'">
                                            <td class="contents">
					                	        <center>
						                            <xsl:choose>
						                                <xsl:when test="$FrmWersja = '' and $KomEdyt = 'false'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.document.edytorApplet.getExchanger().returnKomorkaValue('K{$nazwa}');"/>
                                                        </xsl:when>
                                                        <xsl:when test="$KomEdyt = 'true'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.document.getElementById('SS_KOMORKI_EDYT@NR_KOMORKI').value ='K{$nazwa}';"/>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.document.edytorApplet.getExchanger().returnInnaKomorkaValue('{$FrmSymbol}','{$FrmWersja}','{$DataOd}','{$DataDo}', 'K{$nazwa}');"/>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
						                        </center>
					                        </td>
					                    </xsl:when>
					                    <xsl:otherwise>
					                        <td class="contents">
					                            <center><B>K<xsl:value-of select='$nazwa'/></B></center>
					                        </td>
					                    </xsl:otherwise>
					                </xsl:choose>
						        </xsl:when>
						        <xsl:otherwise>
						            <td class="contents">
				                        <xsl:value-of select="format-number($item, $format)"/>
				                    </td>
						        </xsl:otherwise>
						    </xsl:choose>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
						</xsl:otherwise>
					</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_totals">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="result">
			<xsl:value-of select="sum($nodeset)"/>
		</xsl:param>
<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"></xsl:param>
		<xsl:param name="blad"></xsl:param>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
<!-- Modyfikacja na potrzeby edytowania komorek -->
                            <xsl:choose>
						        <xsl:when test="$komorka!='' and $komorka!='NaN'">
						            <xsl:variable name="nazwa"><xsl:value-of select="$komorka"/></xsl:variable>
						            <xsl:choose>
						                <xsl:when test="$przyciskiKomorek = 'true'">
                                            <td class="totals">
					                	        <center>
						                            <xsl:choose>
						                                <xsl:when test="$FrmWersja = '' and $KomEdyt = 'false'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.document.edytorApplet.getExchanger().returnKomorkaValue('K{$nazwa}');"/>
                                                        </xsl:when>
                                                        <xsl:when test="$KomEdyt = 'true'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.document.getElementById('SS_KOMORKI_EDYT@NR_KOMORKI').value ='K{$nazwa}';"/>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.document.edytorApplet.getExchanger().returnInnaKomorkaValue('{$FrmSymbol}','{$FrmWersja}','{$DataOd}','{$DataDo}', 'K{$nazwa}');"/>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
						                        </center>
					                        </td>
					                    </xsl:when>
					                    <xsl:otherwise>
					                        <td class="totals">
					                            <center><B>K<xsl:value-of select='$nazwa'/></B></center>
					                        </td>
					                    </xsl:otherwise>
					                </xsl:choose>
						        </xsl:when>
						        <xsl:otherwise>
                                    <td class="totals">
						                <center>X</center>
                                    </td>
						        </xsl:otherwise>
						    </xsl:choose>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>