<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:msxsl="urn:schemas-microsoft-com:xslt">
    <!--
	=============================================================================================
	-->
    <xsl:variable name="wersja" select="'1.1'"/>
    <xsl:decimal-format grouping-separator="&#160;" decimal-separator="," />
    <xsl:variable name="obsada" select="'###&#160;###&#160;###&#160;##0,00'" />
    <xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'" />
    <xsl:variable name="liczba" select="'##&#160;###&#160;##0'" />
    <xsl:variable name="width" select="'944'" />
    <!--
	=============================================================================================
	-->
    <xsl:template match="/">
        <html>
            <head>
                <style type="text/css">
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								                font-weight: bold; text-align: center; border-width: 0px;
                                 				width: <xsl:value-of select="$width"/>px; padding: 5px;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: normal; text-align: left; border-width: 0px;
                                				}
                            .stamp_foot    	{color: #000000; font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: normal; text-align: left;  border-width: 0px;
                                 				padding-left: 5px;
                                				}
                            
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; margin-left: 1.0em; border-width: 0px;
                                 				padding-left: 10px; padding: 5px;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-align: center; border-width: 0px;
                                 				width: <xsl:value-of select="$width"/>px; padding-top: 20px;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                            table               {border-color: black; border-width:1px; border-style: solid;
                                                 border-collapse: collapse;
                                                }
                            .table_no_border     {border-color: black; border-width:0px; border-style: solid;
                                                }
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold; border-width: 1px; padding: 0px; border-style: inset;
	                                            border-color: black;
                                				}
                            td          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold; border-width: 1px; padding: 0px; border-style: inset;
	                                            border-color: black;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>px; padding-top: 6px;
                                				}
                    
					.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
								font-family: Tahoma, Verdana; font-size: 10px;
								font-weight: normal;
								}
					.tab_row_no {padding: 5px;
								color: #000000; font-family: Tahoma, Verdana; font-size: 10px;
								text-align: left; vertical-align: middle; font-weight: normal;
								}
					.tab_header {padding: 5px;
								color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
								text-align: center; vertical-align: middle; font-weight: bold;
								}
					.tab_header_2 {padding: 5px;
								color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
								text-align: left; vertical-align: middle; font-weight: bold;
								}			
				
                   			 .contents	{height: 2.5em;
                   			 			padding: 5px;
                                 				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: normal;
                                				}
                   			 .totals     	{height: 2.5em;
                   			 			padding: 5px;
                                 				font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: normal;
                                				}
                    		.row_descr	{padding: 5px;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: left; vertical-align: middle; font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: baseline;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 			     font-weight: normal; border-width: 0px;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: baseline;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; border-width: 0px;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; padding-top: 24px;
                                				}
                    		.empty		{border: 0 0 0 0;}
				</style>
            </head>
            <body>
                <xsl:apply-templates select="WRiSPZ-M"/>
            </body>
        </html>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="WRiSPZ-M">
        <xsl:apply-templates select="Metryczka"/>

        <xsl:apply-templates select="Tabela_A"/>
        <xsl:apply-templates select="Tabela_B"/>
        <xsl:apply-templates select="Tabela_C"/>
        <xsl:apply-templates select="Tabela_D"/>
        <xsl:apply-templates select="Tabela_E"/>
        <xsl:apply-templates select="Tabela_F"/>
        <xsl:apply-templates select="Tabela_G"/>
        <xsl:apply-templates select="Tabela_H"/>
        
        <xsl:call-template name="Stopka"/>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Tabela_A">
        <xsl:call-template name="Tabela_A"/>
    </xsl:template>
    <xsl:template match="Tabela_B">
        <xsl:call-template name="Tabela_B"/>
    </xsl:template>
    <xsl:template match="Tabela_C">
        <xsl:call-template name="Tabela_C"/>
    </xsl:template>
    <xsl:template match="Tabela_D">
        <xsl:call-template name="Tabela_D"/>
    </xsl:template>
    <xsl:template match="Tabela_E">
        <xsl:call-template name="Tabela_E"/>
    </xsl:template>
    <xsl:template match="Tabela_F">
        <xsl:call-template name="Tabela_F"/>
    </xsl:template>
    <xsl:template match="Tabela_G">
        <xsl:call-template name="Tabela_G"/>
    </xsl:template>
    <xsl:template match="Tabela_H">
        <xsl:call-template name="Tabela_H"/>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Tabela_A">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="975"/>
            </xsl:attribute>
            <xsl:call-template name="A_header"/>
            <tbody>
                <xsl:if test="Instytucjonalna-piecza-zastepcza">
                    <xsl:apply-templates select="Instytucjonalna-piecza-zastepcza">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Tabela_B">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="975"/>
            </xsl:attribute>
            <xsl:call-template name="B_header"/>
            <tbody>
                <xsl:if test="Placowki-zatrudnienie">
                    <xsl:apply-templates select="Placowki-zatrudnienie">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Tabela_C">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="975"/>
            </xsl:attribute>
            <xsl:call-template name="C_header"/>
            <tbody>
                <xsl:if test="Dzieci_C">
                    <xsl:apply-templates select="Dzieci_C">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Tabela_D">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="975"/>
            </xsl:attribute>
            <xsl:call-template name="C_header"/>
            <tbody>
                <xsl:if test="Napływ-dzieci">
                    <xsl:apply-templates select="Napływ-dzieci">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Tabela_E">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="975"/>
            </xsl:attribute>
            <xsl:call-template name="C_header"/>
            <tbody>
                <xsl:if test="Odpływ-dzieci">
                    <xsl:apply-templates select="Odpływ-dzieci">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!-- 
    ==============================================================================================
    -->
    <xsl:template name="Tabela_F">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="975"/>
            </xsl:attribute>
            <xsl:call-template name="F_header"/>
            <tbody>
                <xsl:if test="Piecza-zastępcza">
                    <xsl:apply-templates select="Piecza-zastępcza">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!-- 
    ==============================================================================================
    -->
    <xsl:template name="Tabela_G">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="975"/>
            </xsl:attribute>
            <xsl:call-template name="G_header"/>
            <tbody>
                <xsl:if test="Informacja-statystyczna">
                    <xsl:apply-templates select="Informacja-statystyczna">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!-- 
    ==============================================================================================
    -->
    <xsl:template name="Tabela_H">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="975"/>
            </xsl:attribute>
            <xsl:call-template name="H_header"/>
            <tbody>
                <xsl:if test="Informacja-finansowa ">
                    <xsl:apply-templates select="Informacja-finansowa">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Metryczka">

        <table class="table_no_border" cellspacing="4" cellpadding="0">
            <tr>
                <td class="auth_name" colspan="2">
                    Organ sporządzający sprawozdanie
                </td>
            </tr>
            <xsl:call-template name="Poziom"/>
            <tr>
                <td class="stamp" width="85px">Adres:</td>
                <td class="stamp">
                    <xsl:for-each select="Nadawca/Adres-pocztowy">
                        <xsl:value-of select="Ulica-i-numer"/>, <xsl:value-of select="Kod-i-poczta"/>
                    </xsl:for-each>
                </td>
            </tr>
            <tr>
                <td class="heading_1" colspan="2">
                    Sprawozdanie rzeczowo-finansowe z wykonywania przez samorząd województwa zadań z zakresu wspierania rodziny i systemu pieczy zastępczej
                    za okres 
                    <xsl:for-each select="Za-okres">
                        <xsl:for-each select="Data-początku">
                            od <xsl:apply-templates />
                        </xsl:for-each>
                        <xsl:for-each select="Data-końca">
                            do <xsl:apply-templates />
                        </xsl:for-each>
                    </xsl:for-each>
                </td>
            </tr>
        </table>
        <br/>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Stopka">
        <xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
        <table class="table_no_border" width="700">
            <tr>
                <th class="stamp_foot" colspan="2" align="left">Osoba&#160;sporządzająca&#160;sprawozdanie:</th>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">imię i nazwisko:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="$kto/Imię-i-nazwisko"/>
                </td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">telefon:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="$kto/Telefon"/>
                </td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">e-mail:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="$kto/E-mail"/>
                </td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">podpis:</td>
                <td class="stamp_foot"></td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">data:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="$kto/Data-wykonania"/>
                </td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">Uwagi:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="Metryczka/Opis"/>
                </td>
            </tr>
        </table>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Poziom">
        <tr>
        <xsl:for-each select="../Nagłówek">
            <xsl:for-each select="Wojewoda">
                <td class="stamp" width="85px" >Wojewoda:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
            <!-- W przypadku tego sprawozdania gmina i powiat zawsze mają Powiat -->
            <xsl:for-each select="Gmina">
                <td class="stamp" width="85px">Powiat:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
            <xsl:for-each select="Powiat">
                <td class="stamp" width="85px">Powiat:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
            <xsl:for-each select="Marszałek">
                <td class="stamp" width="85px">Samorząd województwa:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
            <xsl:for-each select="Ministerstwo">
                <td class="stamp" width="85px">Polska:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
        </xsl:for-each>
        </tr>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Table-caption">
        <xsl:param name="width"/>
        <div>
            <xsl:attribute name="style">
                font-family: Tahoma, Verdana; font-size: 14px; font-weight: bold; margin-bottom: 0.4em; margin-top: 1.2em;
                width: <xsl:number value="$width"/>px
            </xsl:attribute>
            <xsl:value-of select="concat('Tabela ', substring-after(name(.), '_'), '. ')"/><xsl:value-of select="@Opis"/>
        </div>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Table-description">
        <xsl:param name="width"/>
        <table class="table_no_border" style="padding-top: 6px;"  border="0" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="$width"/>
            </xsl:attribute>
            <xsl:for-each select="*[@Indeks != '']">
                <tr>
                    <td class="stars" width="1%">
                        <sup>
                            <xsl:choose>
                                <xsl:when test="substring(@Indeks,string-length(@Indeks),1) = ':'">                            
                                    <xsl:value-of select="substring-before(@Indeks,':')"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="@Indeks"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </sup>
                    </td>
                    <td class="remark">
                        <xsl:value-of select="@Indeks_opis"/>
                    </td>
                </tr>
            </xsl:for-each>
        </table>
        <br/>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="A_header">
        <thead>
            <tr>
                <th class="tab_header" rowspan="2" width="40px">Lp.</th>
                <th class="tab_header" rowspan="2" width="491px">Wyszczególnienie</th>
                <th class="tab_header" width="200px">Liczba świadczeń</th>
                <th class="tab_header" width="200px">Wydatki w zł<sup>1)</sup></th>
            </tr>
            <tr>
                <th class="tab_header">ogółem</th>
                <th class="tab_header">ogółem</th>
            </tr>    
            <tr>
                <td class="tab_col_no">1</td>
                <td class="tab_col_no">2</td>
                <td class="tab_col_no">3</td>
                <td class="tab_col_no">4</td>
            </tr>
        </thead>
    </xsl:template>
    <!-- 
    =============================================================================================
    -->
    <xsl:template name="B_header">
        <thead>
            <tr>
                <th class="tab_header" rowspan="2" width="40px">Lp.</th>
                <th class="tab_header" rowspan="2" width="398px">Wyszczególnienie</th>
                <th class="tab_header" rowspan="2" width="80px">Liczba placówek</th>
                <th class="tab_header" rowspan="2" width="100px">Przeciętna liczba miejsc<sup>1)</sup></th>
                <th class="tab_header" rowspan="2" width="100px">Przeciętna liczba umieszczonych dzieci<sup>2)</sup></th>
                <th class="tab_header" colspan="2">Liczba osób zatrudnionych</th>
            </tr>
            <tr>
                <th class="tab_header" width="80px">ogółem</th>
                <th class="tab_header" width="100px">w tym zajmujących się opieką i wychowaniem</th>
            </tr>    
            <tr>
                <td class="tab_col_no" >1</td>
                <td class="tab_col_no" >2</td>
                <td class="tab_col_no" >3</td>
                <td class="tab_col_no" >4</td>
                <td class="tab_col_no" >5</td>
                <td class="tab_col_no" >6</td>
                <td class="tab_col_no" >7</td>
            </tr>
        </thead>
        
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="C_header">
        <thead>
            <tr>
                <th class="tab_header" rowspan="2" width="40px">Lp.</th>
                <th class="tab_header" rowspan="2" width="351px">Wyszczególnienie</th>
                <th class="tab_header" colspan="2" >Liczba dzieci</th>
            </tr>
            <tr>
                <th class="tab_header" width="290px">Regionalne placówki opiekuńczo-terapeutyczne</th>
                <th class="tab_header" width="250px">Interwencyjne ośrodki preadopcyjne</th>
            </tr>
            <tr>
                <td class="tab_col_no">1</td>
                <td class="tab_col_no">2</td>
                <td class="tab_col_no">3</td>
                <td class="tab_col_no">4</td>
            </tr>
        </thead>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="F_header">
        <thead>
            <tr>
                <th class="tab_header" rowspan="2" width="40px">Lp.</th>
                <th class="tab_header" rowspan="2" width="241px">Wyszczególnienie</th>
                <th class="tab_header" colspan="7">Liczba dzieci w instytucjonalnej pieczy zastępczej</th>
            </tr>
            <tr>
                <th class="tab_header" width="85px">umieszczone w pieczy zastępczej ogółem</th>
                <th class="tab_header" width="85px">do 3 miesięcy</th>
                <th class="tab_header" width="85px">powyżej 3 do 6 miesięcy</th>
                <th class="tab_header" width="85px">powyżej 6 do 12 miesięcy</th>
                <th class="tab_header" width="85px">powyżej 1 roku do 2 lat</th>
                <th class="tab_header" width="85px">powyżej 2 lat do 3 lat</th>
                <th class="tab_header" width="85px">powyżej 3 lat</th>
            </tr>
            <tr>
                <td class="tab_col_no">1</td>
                <td class="tab_col_no">2</td>
                <td class="tab_col_no">3</td>
                <td class="tab_col_no">4</td>
                <td class="tab_col_no">5</td>
                <td class="tab_col_no">6</td>
                <td class="tab_col_no">7</td>
                <td class="tab_col_no">8</td>
                <td class="tab_col_no">9</td>
            </tr>
        </thead>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="G_header">
        <thead>
            <tr>
                <th class="tab_header" width="40px">Lp.</th>
                <th class="tab_header" width="602px">Wyszczególnienie</th>
                <th class="tab_header" width="300px">Liczba ośrodków/rodzin/osób przeszkolonych/procedur/konsultacji</th>
            </tr>
            <tr>
                <td class="tab_col_no">1</td>
                <td class="tab_col_no">2</td>
                <td class="tab_col_no">3</td>
            </tr>
        </thead>
    </xsl:template>
    <!-- 
    =============================================================================================
    -->
    <xsl:template name="H_header">
        <thead>
            <tr>
                <th class="tab_header" width="40px">Lp.</th>
                <th class="tab_header" width="702px">Wyszczególnienie</th>
                <th class="tab_header" width="200">Kwota w zł</th>
            </tr>
            <tr>
                <td class="tab_col_no">1</td>
                <td class="tab_col_no">2</td>
                <td class="tab_col_no">3</td>
            </tr>
        </thead>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Instytucjonalna-piecza-zastepcza">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_A_'"/>
            </xsl:call-template>
            <xsl:call-template name="_A_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Instytucjonalna-piecza-zastepcza">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Placowki-zatrudnienie">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_B_'"/>
            </xsl:call-template>
            <xsl:call-template name="_B_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Placowki-zatrudnienie">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Dzieci_C">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_C_'"/>
            </xsl:call-template>
            <xsl:call-template name="_C_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Dzieci_C">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Napływ-dzieci">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_D_'"/>
            </xsl:call-template>
            <xsl:call-template name="_C_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Napływ-dzieci">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Odpływ-dzieci">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_E_'"/>
            </xsl:call-template>
            <xsl:call-template name="_C_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Odpływ-dzieci">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Piecza-zastępcza">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_F_'"/>
            </xsl:call-template>
            <xsl:call-template name="_F_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Piecza-zastępcza">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Informacja-statystyczna">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_G_'"/>
            </xsl:call-template>
            <xsl:call-template name="_G_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Informacja-statystyczna">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Informacja-finansowa">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_H_'"/>
            </xsl:call-template>
            <xsl:call-template name="_H_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Informacja-finansowa">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>

    <!--
	==============================================================================================
	-->
    <xsl:template name="_A_contents">
        <xsl:for-each select="Świadczenia-wydatki">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Wydatki-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_B_contents">
        <xsl:for-each select="Składniki-tabela-B">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-placówek'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Przeciętna-liczba-miejsc'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Przeciętna-liczba-umieszczonych-dzieci'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-osób-zatrudnionych-ogólem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-osób-zatrudnionych-opieka-wychowanie'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_C_contents">
        <xsl:for-each select="Liczba-dzieci">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Regionalne-placówki-opiekuńczo-terapeutyczne'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Interwencyjne-ośrodki-preadopcyjne'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_F_contents">
        <xsl:for-each select="Liczba-dzieci">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-do-3-mc'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-3-6-mc'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-6-12-mc'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-1-2-lat'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-2-3-lat'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-3-wiecej-lat'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_G_contents">
        <xsl:for-each select="Liczba-ośrodków">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_H_contents">
        <xsl:for-each select="Wydatki-dochody">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Kwota'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="_ABC_column">
        <xsl:param name="subtree"/>
        <xsl:param name="column"/> 
        <xsl:param name="format"/>
        <xsl:param name="item" select="*[name(.) = $column]"/>
        <xsl:param name="contents">
            <xsl:value-of select="$item"/>
        </xsl:param>
        <xsl:choose>
            <xsl:when test="../Z-tego and not($item/@xsi:nil)">
                <xsl:call-template name="_ABC_total">
                    <xsl:with-param name="subtree" select="$subtree"/>
                    <xsl:with-param name="column" select="$column"/>
                    <xsl:with-param name="contents" select="$contents"/>
                    <xsl:with-param name="format" select="$format"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <td class="contents">
                    <xsl:choose>
                        <xsl:when test="string($item/@xsi:nil) = 'true'">
                            <center>X</center>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="format-number($contents, $format)"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </td>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="_ABC_total">
        <xsl:param name="subtree"/>
        <xsl:param name="column"/>
        <xsl:param name="format"/> <xsl:param name="contents"/>
        <xsl:param name="suma">
            <xsl:for-each select="../Z-tego/*">
                <xsl:call-template name="_ABC_add_tree">
                    <xsl:with-param name="subtree" select="$subtree"/>
                    <xsl:with-param name="column" select="$column"/>
                </xsl:call-template>
            </xsl:for-each>
        </xsl:param>
        <xsl:call-template name="sumuj">
            <xsl:with-param name="wynik" select="0"/>
            <xsl:with-param name="format" select="$format"/>
            <xsl:with-param name="contents" select="$contents"/>
            <xsl:with-param name="suma" select="$suma"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    
    <xsl:template name="_ABC_add_tree">
        <xsl:param name="subtree"/>
        <xsl:param name="column"/>
        <xsl:param name="contents" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
        <xsl:choose>
            <xsl:when test="Z-tego and not($contents/@xsi:nil)">
                <xsl:for-each select="Z-tego/*">
                    <xsl:call-template name="_ABC_add_tree">
                        <xsl:with-param name="subtree" select="$subtree"/>
                        <xsl:with-param name="column" select="$column"/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$contents/@xsi:nil">
                        0 
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$contents"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="'+'"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Row-description">
        <xsl:param name="level"/>
        <xsl:param name="prefix"/>
        <td class="tab_row_no">
            <xsl:number count="*[starts-with(@Pozycja, $prefix)]" level="multiple" format="1.1" />.
        </td>
        <td class="row_descr">
            <xsl:value-of select="@Opis"/>
            <sup>
                <xsl:choose>
                    <xsl:when test="substring(@Indeks,string-length(@Indeks),1) = ':'">                            
                        <xsl:value-of select="substring-before(@Indeks,':')"/>:
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="@Indeks"/>
                    </xsl:otherwise>
                </xsl:choose>    
            </sup>
        </td>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="sumuj">
        <xsl:param name="wynik"/>
        <xsl:param name="format"/>
        <xsl:param name="contents"/>
        <xsl:param name="suma"/>
        <xsl:choose>
            <xsl:when test="$suma!=''">
                <xsl:call-template name="sumuj">
                    <xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
                    <xsl:with-param name="format" select="$format"/>
                    <xsl:with-param name="contents" select="$contents"/>
                    <xsl:with-param name="suma" select="substring-after($suma,'+')"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="string(number($wynik)) = 'NaN'">
                        <td class="totals" style="background-color: red">
                            <center>X</center>
                        </td>
                    </xsl:when>
                    <xsl:when test="string(number($contents)) != 'NaN'">
                        <xsl:choose>
                            <xsl:when test="$contents != $wynik">
                                <td class="contents" style="background-color: red">
                                    <xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
                                    <br/>
                                    <xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
                                </td>
                            </xsl:when>
                            <xsl:otherwise>
                                <td class="totals">
                                    <xsl:value-of select="format-number($wynik, $format)"/>
                                </td>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <td class="totals">
                            <xsl:value-of select="format-number($wynik, $format)"/>
                        </td>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
