<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:variable name="suma" select="'(sum'"/>
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="grosze" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="złote" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="iloraz" select="'(ilor'"/>
	<xsl:variable name="width" select="'1044px'"/>
	<!--
	=============================================================================================
	-->
	<xsl:include href="REGULY.xslt"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
				            .blad           {background-color: red; text-align: right}
				            .pole           {background-color: white; text-align: right}
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>; padding-top: 6px;
                                				}

                    		.cw0		{width:  250px;}
                    		.cw1		{width:  786px;}
                    		.cw2		{width:  656px;}
                    		.cw3		{width:  130px;}
                    		.cw4		{width:    50px;}
                    		.cw5		{width:  235px;}
                    		.cw6		{width:    15px;}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal;
                                					}
                   			 .contents	{padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.empty		{border: 0 0 0 0;}
                      </style>
                      <xsl:call-template name="regulyStyle"/>
			</head>
			<body>
				<xsl:call-template name="regulyScript"/>
				<!-- Modyfikacja na potrzeby pokazywania błedów -->
				<div id="Reguly">
					<xsl:call-template name="reguly"/>
				</div>
				<div id="Sprawozdanie">
					<xsl:apply-templates select="Posiłek-dla-potrzebujących"/>
				</div>
				<xsl:call-template name="zaznaczWybrana"/>
				<!-- Koniec modyfikacja na potrzeby pokazywania błędów -->
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Posiłek-dla-potrzebujących">
		<xsl:apply-templates select="Metryczka"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Dział_I"/>
		<xsl:apply-templates select="Dział_II"/>
		<xsl:apply-templates select="Dział_III"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/><br/><br/>
			</div>
		</xsl:if>
		<!-- Modyfikacja na potrzeby edytowania komorek porownywanie-->
		<table border="2" cellspacing="0" cellpadding="8">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th colspan="3">
						<span style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5, 00-513 Warszawa
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="300">
						<span style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
						</span>
						<center>
							<xsl:for-each select="Nadawca">
								<table cellspacing="0" cellpadding="0">
									<tr>
										<td class="stamp" colspan="2">
											<xsl:value-of select="Pełna-nazwa"/>
										</td>
									</tr>
									<xsl:for-each select="Adres-pocztowy">
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Ulica-i-numer"/>
											</td>
										</tr>
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Kod-i-poczta"/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td colspan="2" class="stamp" style="font-size: 11px; text-align: left">
											<xsl:for-each select="Telefon">
                         	        					           Tel. <xsl:apply-templates/> &#160;
								                        </xsl:for-each>
										</td>
									</tr>
									<tr>
										<td colspan="2" class="stamp" style="font-size: 11px; text-align: left">
											<xsl:for-each select="Faks">
						                                           Fax <xsl:apply-templates/> &#160;
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>
						</center>
					</td>
					<td rowspan="2" style="text-align: center; font-weight: bold;">
						<p style="font-size: 18px">
							<span style="font-size: 22px">Sprawozdanie</span>
							<br/>z realizacji Rządowego Programu<br/>"Posiłek dla potrzebujących"
						</p>
						za
						<xsl:choose>
							<xsl:when test="Za-okres/Kwartał = 'I'">I-III</xsl:when>
							<xsl:when test="Za-okres/Kwartał = 'II'">I-VI</xsl:when>
							<xsl:when test="Za-okres/Kwartał = 'III'">I-IX</xsl:when>
							<xsl:otherwise>I-XII</xsl:otherwise>
						</xsl:choose>
						<xsl:value-of select="concat(' ', Za-okres/Rok, ' r.')"/>
					</td>
					<td width="300">
						<span style="font-size: 11px; text-align: left;">
							Adresat:<br/>
						</span>
						<div class="stamp">
							<xsl:value-of select="Odbiorca/Pełna-nazwa"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<span style="font-size: 11px; text-align: left;">
							Numer identyfikacyjny REGON:<br/>
						</span>
						<div style="font-weight: bold; text-align: center;">
							<xsl:value-of select="Nadawca/@Kod-REGON"/>
						</div>
					</td>
					<td>
						<div style="font-weight: bold; font-size: 13px; text-align: center;">
							Przekazać w terminie do końca miesiąca<br/>następującego po okresie sprawozdawczym<sup>1)</sup>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<br/>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td colspan="2" class="stars">
					<sup>1)</sup>
					<font class="remark">
					Jeśli termin przekazania sprawozdania wypada na dzień wolny od pracy, to obowiązuje data pierwszego dnia roboczego po tym dniu.</font>
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<br/>
		<br/>
		<br/>
		<xsl:if test="(Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III') and Kod/Cyklu-sprawozdawczego != 3 or
					(Za-okres/Kwartał = 'II' or Za-okres/Kwartał = 'IV') and Kod/Cyklu-sprawozdawczego != 4">
			<!--div style="font-size: large; text-align: center; color: red;">
				Niepoprawny kod cyklu sprawozdawczego!
			</div>
			<br/> <br/> <br/> <br/> <br/-->
		</xsl:if>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek porownywanie-->
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table width="280">
			<caption>Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td colspan="2">Imię i nazwisko: <b>
						<xsl:value-of select="$kto/Imię-i-nazwisko"/>
					</b>
				</td>
				<td colspan="2"/>
			</tr>
			<tr>
				<td colspan="2">Telefon: <b>
						<xsl:value-of select="$kto/Telefon"/>
					</b>
				</td>
				<td colspan="2"/>
			</tr>
			<tr>
				<td colspan="2">Data wykonania: <b>
						<xsl:value-of select="$kto/Data-wykonania"/>
					</b>
				</td>
				<td colspan="2"/>
			</tr>
		</table>
		<div class="xslt_ver">
			<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
			<!--xsl:if test="system-property('msxsl:version')">
				<xsl:value-of select="concat(', MSXML: ', system-property('msxsl:version'))"/>
			</xsl:if-->
		</div>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="level"/>
		<xsl:param name="prefix"/>
		<xsl:variable name="topbot" select="'margin-top: 4px; margin-bottom: 4px; margin-left: '"/>
		<xsl:variable name="indent" select="25"/>
		<td class="cw5 row_descr">
			<xsl:if test="not(preceding-sibling::*) and ../@Prefiks">
				<p>
					<xsl:attribute name="style"><xsl:value-of select="concat($topbot, string($indent * ($level - 1)), 'px;')"/></xsl:attribute>
					<xsl:value-of select="../@Prefiks"/>
					<br/>
				</p>
			</xsl:if>
			<p>
				<xsl:if test="$level &gt;= 0">
					<xsl:attribute name="style"><xsl:value-of select="concat($topbot, string($indent * $level), 'px;')"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="contains(@Opis, $suma)">
						<xsl:value-of select="substring-before(@Opis, $suma)"/>
						<br/>
						<span style="margin-top: 0.6em; font-size: 0.6em;">
							<xsl:value-of select="concat($suma, substring-after(@Opis, $suma))"/>
						</span>
					</xsl:when>
					<xsl:when test="contains(@Opis, $iloraz)">
						<xsl:value-of select="substring-before(@Opis, $iloraz)"/>
						<br/>
						<span style="margin-top: 0.6em; font-size: 0.6em;">
							<xsl:value-of select="concat($iloraz, substring-after(@Opis, $iloraz))"/>
						</span>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@Opis"/>
					</xsl:otherwise>
				</xsl:choose>
			</p>
		</td>
		<!--td class="cw6 tab_row_no"-->
		<td class="tab_row_no" style="width: 15px;">
			<xsl:value-of select="count(preceding::*[starts-with(@Pozycja, $prefix)])+
								  count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)])"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="with_format_check">
		<xsl:param name="contents"/>
		<xsl:param name="format"/>
		<xsl:choose>
			<xsl:when test="contains($contents, '.') and $format != $grosze">
				<td class="totals" style="background-color: red">
					<center>
						<xsl:value-of select="'Format!'"/>
					</center>
					<br/>
					<xsl:value-of select="format-number($contents, $grosze)"/>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($contents, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="sumuj">
		<xsl:param name="wynik"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma"/>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<xsl:choose>
			<xsl:when test="$suma!=''">
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="substring-after($suma,'+')"/>
					<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka" select="$komorka"/>
					<xsl:with-param name="blad" select="$blad"/>
					<xsl:with-param name="edit" select="$edit"/>
					<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string(number($wynik)) = 'NaN'">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class" select="'pole'"/>
								<xsl:choose>
									<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
										<td id="{$nazwa}" class="contents">
											<div id="K{$nazwa}" class="div_komorka">
											</div>
											<xsl:value-of select="concat('K', $nazwa)"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td id="{$nazwa}" class="contents">
											<div id="K{$nazwa}" class="div_komorka">
												<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
											</div>
											<xsl:value-of select="$wartosc"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals" style="background-color: red">
									<center>X</center>
								</td>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:when test="string(number($contents)) != 'NaN'">
						<xsl:choose>
							<xsl:when test="$contents != $wynik">
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$komorka!='' and $komorka!='NaN'">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$contents"/>
										</xsl:variable>
										<xsl:variable name="class" select="'pole'"/>
										<xsl:choose>
											<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
												<td id="{$nazwa}" class="contents">
													<div id="K{$nazwa}" class="div_komorka">
											</div>
													<xsl:value-of select="concat('K', $nazwa)"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td id="{$nazwa}" class="contents">
													<div id="K{$nazwa}" class="div_komorka">
														<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
													</div>
													<xsl:value-of select="format-number($contents, $format)"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:when>
							<xsl:otherwise>
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$komorka!='' and $komorka!='NaN'">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$contents"/>
										</xsl:variable>
										<xsl:variable name="class" select="'pole'"/>
										<xsl:choose>
											<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
												<td id="{$nazwa}" class="totals">
													<div id="K{$nazwa}" class="div_komorka">
											</div>
													<xsl:value-of select="concat('K', $nazwa)"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td id="{$nazwa}" class="totals">
													<div id="K{$nazwa}" class="div_komorka">
														<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
													</div>
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="with_format_check">
											<xsl:with-param name="format" select="$format"/>
											<xsl:with-param name="contents" select="$contents"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class" select="'pole'"/>
								<xsl:choose>
									<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
										<td id="{$nazwa}" class="totals">
											<div id="K{$nazwa}" class="div_komorka">
											</div>
											<xsl:value-of select="concat('K', $nazwa)"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td id="{$nazwa}" class="totals">
											<div id="K{$nazwa}" class="div_komorka">
												<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
											</div>
											<xsl:value-of select="$contents"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="with_format_check">
									<xsl:with-param name="format" select="$format"/>
									<xsl:with-param name="contents" select="$wynik"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_I">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_II">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_III">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Dział">
		<xsl:param name="chapter" select="substring-after(name(.), '_')"/>
		<div>
			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:value-of select="$width"/></xsl:attribute>
			<xsl:value-of select="concat('DZIAŁ ', $chapter, '.&#160;&#160;',@Opis)"/>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th class="cw0" colspan="2" rowspan="4">WYSZCZEGÓLNIENIE</th>
					<th class="cw1" colspan="12">Rządowy program "Posiłek dla potrzebujących"</th>
				</tr>
				<tr>
					<th class="cw4" rowspan="3">OGÓŁEM <span style="font-size: 8px;">(4+6+8+10+12)</span>
					</th>
					<th class="cw4" rowspan="3">w tym na wsi <span style="font-size: 8px;">(5+7+9+11+13)</span>
					</th>
					<th class="cw2" colspan="10">w tym:</th>
				</tr>
				<tr>
					<th class="cw3" colspan="2">dzieci 0-7 lat</th>
					<th class="cw3" colspan="2">uczniowie szkół podstawowych i&#160;gimnazjów</th>
					<th class="cw3" colspan="2">uczniowie szkół ponadgimnazjalnych</th>
					<th class="cw3" colspan="2">osoby stare, chore, niepełnosprawne</th>
					<th class="cw3" colspan="2">inne osoby</th>
				</tr>
				<tr>
					<th class="cw4">ogółem</th>
					<th class="cw4">w tym na wsi</th>
					<th class="cw4">ogółem</th>
					<th class="cw4">w tym na wsi</th>
					<th class="cw4">ogółem</th>
					<th class="cw4">w tym na wsi</th>
					<th class="cw4">ogółem</th>
					<th class="cw4">w tym na wsi</th>
					<th class="cw4">ogółem</th>
					<th class="cw4">w tym na wsi</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
					<td class="tab_col_no">7</td>
					<td class="tab_col_no">8</td>
					<td class="tab_col_no">9</td>
					<td class="tab_col_no">10</td>
					<td class="tab_col_no">11</td>
					<td class="tab_col_no">12</td>
					<td class="tab_col_no">13</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Inf-ogółem">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Inf-dot-posiłków">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Inf-dot-zasiłków">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
			</tbody>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-ogółem">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_I_'"/>
			</xsl:call-template>
			<xsl:call-template name="_III_contents"/>
		</tr>
		<xsl:apply-templates select="*/Inf-ogółem">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-dot-posiłków">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_II_'"/>
			</xsl:call-template>
			<xsl:call-template name="_III_contents"/>
		</tr>
		<xsl:apply-templates select="*/Inf-dot-posiłków">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-dot-zasiłków">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_III_'"/>
			</xsl:call-template>
			<xsl:call-template name="_III_contents"/>
		</tr>
		<xsl:apply-templates select="*/Inf-dot-zasiłków">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Rozbicie">
		<xsl:param name="format"/>
		<xsl:param name="subtree" select="name(.)"/>
		<xsl:call-template name="_2_level">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Ogółem'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_2_level">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Na-wsi'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_III_contents">
		<xsl:param name="subtree" select="'Dane'"/>
		<xsl:param name="format">
			<xsl:choose>
				<xsl:when test="@Grosze='false'">
					<xsl:value-of select="$złote"/>
				</xsl:when>
				<xsl:when test="@Grosze='true'">
					<xsl:value-of select="$grosze"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$liczba"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<xsl:call-template name="_1_level">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Ogółem'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_1_level">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Na-wsi'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:choose>
			<xsl:when test="Dane/Rozbicie/@xsi:nil='true'">
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="Dane/Rozbicie/*">
					<xsl:call-template name="Rozbicie">
						<xsl:with-param name="format" select="$format"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_level">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="../../../Z-tego and not($item/@xsi:nil)">
				<xsl:call-template name="_2_totals">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka">
						<xsl:value-of select="$item/@Komorka"/>
					</xsl:with-param>
					<xsl:with-param name="blad">
						<xsl:value-of select="$item/@Blad"/>
					</xsl:with-param>
					<xsl:with-param name="edit">
						<xsl:value-of select="$item/@Edit"/>
					</xsl:with-param>
					<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="contains($contents, '.') and $format != $grosze">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class" select="'pole'"/>
								<xsl:choose>
									<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
										<td id="{$nazwa}" class="contents">
											<div id="K{$nazwa}" class="div_komorka">
											</div>
											<xsl:value-of select="concat('K', $nazwa)"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td id="{$nazwa}" class="contents">
											<div id="K{$nazwa}" class="div_komorka">
												<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
											</div>
											<xsl:value-of select="format-number($contents, $grosze)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<td class="contents" style="background-color: red">
									<xsl:value-of select="format-number($contents, $grosze)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:when test="../../../@Pozycja = '_II_17'  or ../../../@Pozycja = '_II_18'">
						<xsl:choose>
							<xsl:when test="../../../@Pozycja = '_II_17'  and format-number($item, $format) !=
									format-number(../../../../*[@Pozycja='_II_01']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] div
												     ../../../../*[@Pozycja='_II_13']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column], $grosze)">
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$item/@Komorka">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$item/@Komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$item"/>
										</xsl:variable>
										<xsl:variable name="class" select="'pole'"/>
										<xsl:choose>
											<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
												<td id="{$nazwa}" class="contents">
													<div id="K{$nazwa}" class="div_komorka">
											</div>
													<xsl:value-of select="concat('K', $nazwa)"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td id="{$nazwa}" class="contents">
													<div id="K{$nazwa}" class="div_komorka">
														<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
													</div>
													<xsl:value-of select="format-number($contents, $grosze)"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<xsl:value-of select="concat('jest: ', format-number($contents, $grosze))"/>
											<br/>
											<xsl:value-of select="concat('1/13: ', format-number(../../../../*[@Pozycja='_II_01']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] div
																			                         ../../../../*[@Pozycja='_II_13']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column], $grosze))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:when>
							<xsl:when test="../../../@Pozycja = '_II_18'  and format-number($item, $format) !=
									format-number(../../../../*[@Pozycja='_II_04']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] div
												     ../../../../*[@Pozycja='_II_13']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column], $grosze)">
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$item/@Komorka">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$item/@Komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$item"/>
										</xsl:variable>
										<xsl:variable name="class" select="'pole'"/>
										<xsl:choose>
											<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
												<td id="{$nazwa}" class="contents">
													<div id="K{$nazwa}" class="div_komorka">
											</div>
													<xsl:value-of select="concat('K', $nazwa)"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td id="{$nazwa}" class="contents">
													<div id="K{$nazwa}" class="div_komorka">
														<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
													</div>
													<xsl:value-of select="format-number($contents, $grosze)"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="concat('jest: ', format-number($contents, $grosze))"/>
											<br/>
											<xsl:value-of select="concat('4/13: ', format-number(../../../../*[@Pozycja='_II_04']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] div
																			                         ../../../../*[@Pozycja='_II_13']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column], $grosze))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:when>
							<xsl:otherwise>
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$item/@Komorka">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$item/@Komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$item"/>
										</xsl:variable>
										<xsl:variable name="class" select="'pole'"/>
										<xsl:choose>
											<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
												<td id="{$nazwa}" class="totals">
													<div id="K{$nazwa}" class="div_komorka">
											</div>
													<xsl:value-of select="concat('K', $nazwa)"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td id="{$nazwa}" class="totals">
													<div id="K{$nazwa}" class="div_komorka">
														<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
													</div>
													<xsl:value-of select="format-number($contents, $format)"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="string($item/@xsi:nil) = 'true'">
								<td class="contents">
									<center>X</center>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$item/@Komorka">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$item/@Komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$item"/>
										</xsl:variable>
										<xsl:variable name="class" select="'pole'"/>
										<xsl:choose>
											<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
												<td id="{$nazwa}" class="contents">
													<div id="K{$nazwa}" class="div_komorka">
											</div>
													<xsl:value-of select="concat('K', $nazwa)"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td id="{$nazwa}" class="contents">
													<div id="K{$nazwa}" class="div_komorka">
														<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
													</div>
													<xsl:value-of select="format-number($contents, $format)"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_totals">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="../../../Z-tego/*">
				<xsl:call-template name="_2_add_trees">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
			<!-- Modyfikacja na potrzeby edytowania komorek -->
			<xsl:with-param name="komorka" select="$komorka"/>
			<xsl:with-param name="blad" select="$blad"/>
			<xsl:with-param name="edit" select="$edit"/>
			<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_add_trees">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents" select="Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_2_add_trees">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_1_level">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="Z-tego and not($item/@xsi:nil)">
				<xsl:call-template name="_1_totals">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka">
						<xsl:value-of select="$item/@Komorka"/>
					</xsl:with-param>
					<xsl:with-param name="blad">
						<xsl:value-of select="$item/@Blad"/>
					</xsl:with-param>
					<xsl:with-param name="edit">
						<xsl:value-of select="$item/@Edit"/>
					</xsl:with-param>
					<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="contains($contents, '.') and $format != $grosze">
				<!-- Modyfikacja na potrzeby edytowania komorek -->
				<xsl:choose>
					<xsl:when test="$item/@Komorka">
						<xsl:variable name="nazwa">
							<xsl:value-of select="$item/@Komorka"/>
						</xsl:variable>
						<xsl:variable name="wartosc">
							<xsl:value-of select="$item"/>
						</xsl:variable>
						<xsl:variable name="class" select="'pole'"/>
						<xsl:choose>
							<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
								<td id="{$nazwa}" class="contents">
									<div id="K{$nazwa}" class="div_komorka">
											</div>
									<xsl:value-of select="concat('K', $nazwa)"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td id="{$nazwa}" class="contents">
									<div id="K{$nazwa}" class="div_komorka">
										<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
									</div>
									<xsl:value-of select="format-number($contents, $grosze)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<td class="contents" style="background-color: red">
							<xsl:value-of select="format-number($contents, $grosze)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</xsl:when>
			<xsl:when test="@Pozycja = '_II_17'  or @Pozycja = '_II_18'">
				<xsl:choose>
					<xsl:when test="@Pozycja = '_II_17'  and format-number($item, $format) !=
									format-number(../*[@Pozycja='_II_01']/*[name(.) = $subtree]/*[name(.) = $column] div
												     ../*[@Pozycja='_II_13']/*[name(.) = $subtree]/*[name(.) = $column], $grosze)">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class" select="'pole'"/>
								<xsl:choose>
									<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
										<td id="{$nazwa}" class="contents">
											<div id="K{$nazwa}" class="div_komorka">
											</div>
											<xsl:value-of select="concat('K', $nazwa)"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td id="{$nazwa}" class="contents">
											<div id="K{$nazwa}" class="div_komorka">
												<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
											</div>
											<xsl:value-of select="format-number($contents, $grosze)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<td class="contents" style="background-color: red">
									<xsl:value-of select="format-number($contents, $grosze)"/>
									<br/>
									<xsl:value-of select="concat('1/13: ', format-number(../*[@Pozycja='_II_01']/*[name(.) = $subtree]/*[name(.) = $column] div
																									 ../*[@Pozycja='_II_13']/*[name(.) = $subtree]/*[name(.) = $column], $grosze))"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:when test="@Pozycja = '_II_18'  and format-number($item, $format) !=
									format-number(../*[@Pozycja='_II_04']/*[name(.) = $subtree]/*[name(.) = $column] div
												     ../*[@Pozycja='_II_13']/*[name(.) = $subtree]/*[name(.) = $column], $grosze)">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class" select="'pole'"/>
								<xsl:choose>
									<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
										<td id="{$nazwa}" class="contents">
											<div id="K{$nazwa}" class="div_komorka">
											</div>
											<xsl:value-of select="concat('K', $nazwa)"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td id="{$nazwa}" class="contents">
											<div id="K{$nazwa}" class="div_komorka">
												<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
											</div>
											<xsl:value-of select="format-number($contents, $grosze)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<td class="contents" style="background-color: red">
									<xsl:value-of select="format-number($contents, $grosze)"/>
									<br/>
									<xsl:value-of select="concat('4/13: ', format-number(../*[@Pozycja='_II_04']/*[name(.) = $subtree]/*[name(.) = $column] div
																			                         ../*[@Pozycja='_II_13']/*[name(.) = $subtree]/*[name(.) = $column], $grosze))"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class" select="'pole'"/>
								<xsl:choose>
									<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
										<td id="{$nazwa}" class="totals">
											<div id="K{$nazwa}" class="div_komorka">
											</div>
											<xsl:value-of select="concat('K', $nazwa)"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td id="{$nazwa}" class="totals">
											<div id="K{$nazwa}" class="div_komorka">
												<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
											</div>
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals">
									<xsl:value-of select="format-number($contents, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- ZAKOMENTOWANO -->
			<!-- xsl:when test="not(*[name(.) = $subtree]/Rozbicie/@xsi:nil)">
				<xsl:choose>
					<xsl:when test="$item != sum(*[name(.) = $subtree]/Rozbicie/*/*[name(.) = $column])">
                            <xsl:choose>
						        <xsl:when test="$item/@Komorka">
						            <xsl:variable name="nazwa"><xsl:value-of select="$item/@Komorka"/></xsl:variable>
						            <xsl:variable name="wartosc"><xsl:value-of select="$item"/></xsl:variable>
						            <xsl:variable name="class">
						                <xsl:choose>
						                    <xsl:when test="$item/@Blad='true'">
						                        blad
						                    </xsl:when>
						                    <xsl:otherwise>
						                        pole
						                    </xsl:otherwise>
						                </xsl:choose>
						            </xsl:variable>
						            <xsl:choose>
						                <xsl:when test="$item/@Edit='true'">
						                    <td class="contents" style="background-color: red">
						                        <input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
						                        <br/>
							                    <xsl:value-of select="concat('suma: ', format-number(sum(*[name(.) = $subtree]/Rozbicie/*/*[name(.) = $column]), $format))"/>
						                    </td>
						                </xsl:when>
						                <xsl:otherwise>
						                    <td class="contents" style="background-color: red">
						                        <input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
						                        <xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
							                    <br/>
							                    <xsl:value-of select="concat('suma: ', format-number(sum(*[name(.) = $subtree]/Rozbicie/*/*[name(.) = $column]), $format))"/>
						                    </td>
						                </xsl:otherwise>
						            </xsl:choose>
						        </xsl:when>
						        <xsl:otherwise>
						            <xsl:choose>
						                <xsl:when test="$porownanie = 'true'">
						                    <xsl:choose>
						                        <xsl:when test="$item/@Blad='true'">
						                            <td class="contents" style="background-color: orange">
						                                <xsl:value-of select="$item"/>
						                            </td>
						                        </xsl:when>
						                        <xsl:otherwise>
						                            <td class="totals">
						                                <xsl:value-of select="$item"/>
						                            </td>
						                        </xsl:otherwise>
						                    </xsl:choose>
						                </xsl:when>
						                <xsl:otherwise>
						                    <td class="contents" style="background-color: red">
							                    <xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
							                    <br/>
							                    <xsl:value-of select="concat('suma: ', format-number(sum(*[name(.) = $subtree]/Rozbicie/*/*[name(.) = $column]), $format))"/>
						                    </td>
						                </xsl:otherwise>
						            </xsl:choose>
						        </xsl:otherwise>
						    </xsl:choose>

					</xsl:when>
					<xsl:otherwise>

                            <xsl:choose>
						        <xsl:when test="$item/@Komorka">
						            <xsl:variable name="nazwa"><xsl:value-of select="$item/@Komorka"/></xsl:variable>
						            <xsl:variable name="wartosc"><xsl:value-of select="$item"/></xsl:variable>
						            <xsl:variable name="class">
						                <xsl:choose>
						                    <xsl:when test="$item/@Blad='true'">
						                        blad
						                    </xsl:when>
						                    <xsl:otherwise>
						                        pole
						                    </xsl:otherwise>
						                </xsl:choose>
						            </xsl:variable>
						            <xsl:choose>
						                <xsl:when test="$item/@Edit='true'">
						                    <td class="totals">
						                        <input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
						                    </td>
						                </xsl:when>
						                <xsl:otherwise>
						                    <td class="totals">
						                        <input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
						                        <xsl:value-of select="format-number($contents, $format)"/>
						                    </td>
						                </xsl:otherwise>
						            </xsl:choose>
						        </xsl:when>
						        <xsl:otherwise>
						            <xsl:choose>
						                <xsl:when test="$porownanie = 'true'">
						                    <xsl:choose>
						                        <xsl:when test="$item/@Blad='true'">
						                            <td class="totals" style="background-color: orange">
						                                <xsl:value-of select="$item"/>
						                            </td>
						                        </xsl:when>
						                        <xsl:otherwise>
						                            <td class="totals">
						                                <xsl:value-of select="$item"/>
						                            </td>
						                        </xsl:otherwise>
						                    </xsl:choose>
						                </xsl:when>
						                <xsl:otherwise>
						                    <td class="totals">
							                    <xsl:value-of select="format-number($contents, $format)"/>
						                     </td>
						                </xsl:otherwise>
						            </xsl:choose>
						        </xsl:otherwise>
						    </xsl:choose>

					</xsl:otherwise>
				</xsl:choose>
			</xsl:when -->
			<!-- ZAKOMENTOWANO -->
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string($item/@xsi:nil) = 'true'">
						<td class="contents">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class" select="'pole'"/>
								<xsl:choose>
									<xsl:when test="$REGULA_W_FORMULARZU = 'true'">
										<td id="{$nazwa}" class="contents">
											<div id="K{$nazwa}" class="div_komorka">
											</div>
											<xsl:value-of select="concat('K', $nazwa)"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td id="{$nazwa}" class="contents">
											<div id="K{$nazwa}" class="div_komorka">
												<xsl:value-of select="concat('Komórka: K', $nazwa)"/>
											</div>
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<td class="contents">
									<xsl:value-of select="format-number($contents, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_totals">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="Z-tego/*">
				<xsl:call-template name="_1_add_trees">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
			<!-- Modyfikacja na potrzeby edytowania komorek -->
			<xsl:with-param name="komorka" select="$komorka"/>
			<xsl:with-param name="blad" select="$blad"/>
			<xsl:with-param name="edit" select="$edit"/>
			<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_add_trees">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_1_add_trees">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
