<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:param name="FrmSymbol"></xsl:param>
    <xsl:param name="FrmWersja"></xsl:param>
    <xsl:param name="KomEdyt">false</xsl:param>
    <xsl:param name="DataOd"></xsl:param>
    <xsl:param name="DataDo"></xsl:param>
    <xsl:param name="przyciskiKomorek">false</xsl:param>
	<xsl:param name="formatowanie_kwota">###&#160;###&#160;###&#160;##0</xsl:param>
	<xsl:param name="formatowanie_liczba">##&#160;###&#160;##0</xsl:param>
	<xsl:param name="FCN_WYBRANA_KOMORKA">addTextToEditor</xsl:param>
	<xsl:param name="GRAFIKA_PREFIX"/>
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.1'"/>
    <xsl:decimal-format grouping-separator="&#160;" decimal-separator="," />
    <xsl:variable name="ułamek" select="'###&#160;###&#160;###&#160;##0,00'" />
    <xsl:variable name="procent" select="'###&#160;###&#160;###&#160;##0,00%'" />
	<xsl:variable name="kwota" select="$formatowanie_kwota"/>
	<xsl:variable name="liczba" select="$formatowanie_liczba"/>
	<xsl:variable name="width" select="'716px'"/>
	<!--
	=============================================================================================
	-->
	<xsl:include href="lib_KOM_EDIT.xslt"/>
	<!--
	=============================================================================================
	-->

	<xsl:template match="/">

		<html>
			<head>
				<style type="text/css">
				            .blad           {background-color: red; text-align: right}
				            .pole           {background-color: white; text-align: right}
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>; padding-top: 2px;
                                				}

                    		.SKL_0		{width:  380px}
                    		.SKL_1		{width:  300px}
                    		.SKL_2		{width:    80px}
                    		.SKL_3		{width:  300px}
                    		.SKL_4		{width:  100px}
                    		.SKL_5		{width:  200px}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal; width: 20px;
                                					}
                   			 .contents	{height: 2.0em; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.0em; padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; width:  350px;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; padding-bottom: 8px;
                                				}
                    		.stars      	{padding-left: 2px; text-align: right; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; margin-top: 14px;
                                				}
                    		.empty		{border: 0 0 0 0;}
                				</style>
				<xsl:call-template name="KomEditScriptTemplate"/>

				<link rel="stylesheet">
					<xsl:attribute name="href"><xsl:value-of select="$GRAFIKA_PREFIX"/>css/common/komunikat.css</xsl:attribute>
				</link>

			</head>
			<body onload="setCheckedValue(document.forms[0].KOA,getQueryStringValue('czyZakres'));refreshKOAPosition();" onResize="refreshKOAPosition();" onScroll="refreshKOAPosition();"><div id="MAIN_DIV_ID">
<!-- Modyfikacja na potrzeby edytowania komorek -->
                <SCRIPT LANGUAGE="JavaScript1.1">
                    var operator = '';
                    function dodajOperator(regula){
                        operator = '';
                        if (regula.length > 0)
                        {
                           operator = '+';
                           if (regula.charAt(regula.length -1) == "+") {
                              operator ='';
                           }
                           if (regula.charAt(regula.length -1) == "-") {
                              operator ='';
                           }
                           if (regula.charAt(regula.length -1) == "*") {
                              operator ='';
                           }
                           if (regula.charAt(regula.length -1) == "/") {
                              operator ='';
                           }
                           if (regula.charAt(regula.length -1) == "=") {
                              operator ='';
                           }
                           if (regula.charAt(regula.length -1) == "&gt;") {
                              operator ='';
                           }
                           if (regula.charAt(regula.length -1) == "&lt;") {
                              operator ='';
                           }
                        }
                    }
                </SCRIPT>
			    <form name="SACKomorkiSprawozdania" action="" method="POST">
				<xsl:call-template name="KomEditHtmlTemplate"/>
                    <xsl:apply-templates/>
				</form>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</div></body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="SDSMCHR">
		<xsl:apply-templates select="Metryczka"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Domy-i-mieszkania"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<table border="2" cellspacing="0" cellpadding="4">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th colspan="3">
						<span  style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO PRACY I POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5,<br/>00-513 Warszawa
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td style="text-align: center; font-weight: bold;">
						<span style="font-size: large;">
                            Komórki dla formularza o symbolu: <xsl:value-of select="$FrmSymbol"/>
						</span><br/>
					</td>
				</tr>
			</tbody>
		</table>
		<br/> <br/> <br/> <br/> <br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table border="0">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th width="390" align="left">Imię, nazwisko i numer telefonu osoby, która sporządziła informację</th>
					<th>Miejscowość i data</th>
					<th>DYREKTOR</th>
				</tr>
			</thead>
			<tbody>
			<tr style="font-size: 12px;">
				<td>
					<xsl:value-of select="concat($kto/Imię-i-nazwisko, ', tel. ', $kto/Telefon)"/>
				</td>
				<td align="center">
					<xsl:value-of select="concat(substring(Metryczka/Nadawca/Adres-pocztowy/Kod-i-poczta, 8), ', ', $kto/Data-wykonania)"/>
				</td>
			</tr>
			</tbody>
		</table>
		<br/><br/>
		<hr align="left" width="400" noshade="1" size="1"/>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars">1)
	                    </td>
				<td class="remark">
					Jeśli termin przekazania sprawozdania wypada w dzień wolny od pracy, to obowiązuje data pierwszego
					dnia roboczego po tym dniu. Powyższe daty są terminami przekazania sprawozdania do MPS.
	                    </td>
			</tr>
		</table>

		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="xslt_ver" style="text-align: left;">
					Wersja szablonu XSLT: <xsl:value-of select="$wersja"/>
				</td>
				<td class="xslt_ver" style="text-align: right;">
					<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
					<!--xsl:if test="system-property('msxsl:version')">
						<xsl:value-of select="concat(', MSXML: ', system-property('msxsl:version'))"/>
					</xsl:if-->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="prefix"/>
		<td class="row_descr">
			<p>
				<xsl:value-of select="substring-after(@Pozycja, $prefix)"/>. <xsl:value-of select="@Opis"/>
			</p>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Domy-i-mieszkania">
		<xsl:param name="width" select="716"/>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th class="SKL_0" rowspan="2">WYSZCZEGÓLNIENIE</th>
					<th class="SKL_1" colspan="3">LICZBA</th>
				</tr>
				<tr>
					<th class="SKL_4">DOMÓW</th>
					<th class="SKL_4">MIEJSC</th>
					<th class="SKL_4">OSÓB PRZEBYWAJĄCYCH</th>
				</tr>
				<tr>
					<td class="tab_col_no">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Domy-samopomocy">
					<xsl:call-template name="Domy-samopomocy"/>
				</xsl:for-each>
				<tr style="font-family: Tahoma, Verdana; font-size: 11px; font-weight: bold; text-align: center;">
					<td class="SKL_0" rowspan="2">&#160;</td>
					<td class="SKL_1" colspan="3">LICZBA</td>
				</tr>
				<tr style="font-family: Tahoma, Verdana; font-size: 11px; font-weight: bold; text-align: center;">
					<td class="SKL_4">MIESZKAŃ</td>
					<td class="SKL_4">MIEJSC</td>
					<td class="SKL_4">MIESZKAŃCÓW</td>
				</tr>
				<xsl:for-each select="Mieszkania-chronione">
					<xsl:call-template name="Mieszkania-chronione"/>
				</xsl:for-each>
			</tbody>
		</table>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Domy-samopomocy">
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_SDSMCHR_'"/>
			</xsl:call-template>

			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Domów'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Miejsc'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Osób-przebywających'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Mieszkania-chronione">
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_SDSMCHR_'"/>
			</xsl:call-template>

			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Mieszkań'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Miejsc'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Mieszkańców'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_1_column">
		<xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:choose>
			<xsl:when test="$item/@Komorka">
				<xsl:variable name="nazwa"><xsl:value-of select="$item/@Komorka"/></xsl:variable>
				<xsl:choose>
					<xsl:when test="$przyciskiKomorek = 'true'">
                        <td class="contents">
					        <center>
						        <xsl:choose>
 	             	            <xsl:when test="$FrmWersja = '' and $KomEdyt = 'false'">
			                            <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                        onClick="javascript:window.opener.{$FCN_WYBRANA_KOMORKA}('K{$nazwa}');"/>
                                    </xsl:when>
                                    <xsl:when test="$KomEdyt = 'true'">
		                                <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                        onClick="javascript:updateField('{$nazwa}');"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                        onClick="javascript:window.opener.addInnaToEditor('{$FrmSymbol}', '{$FrmWersja}', '{$DataOd}', '{$DataDo}', 'K{$nazwa}');"/>
                                    </xsl:otherwise>
                                </xsl:choose>
						    </center>
					    </td>
					</xsl:when>
					<xsl:otherwise>
					    <td class="contents">
					        <center><B>K<xsl:value-of select='$nazwa'/></B></center>
					    </td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
		    <xsl:otherwise>
			    <td class="contents">
				    <xsl:value-of select="format-number($item, $format)"/>
			     </td>
		    </xsl:otherwise>
	    </xsl:choose>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>