
<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
    	<xsl:decimal-format grouping-separator="&#160;" decimal-separator="," />
    	<xsl:variable name="ułamek" select="'###&#160;###&#160;###&#160;##0,00'" />
    	<xsl:variable name="procent" select="'###&#160;###&#160;###&#160;##0,00%'" />
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'716px'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>; padding-top: 2px;
                                				}

                    		.SKL_0		{width:  380px}
                    		.SKL_1		{width:  300px}
                    		.SKL_2		{width:    80px}
                    		.SKL_3		{width:  300px}
                    		.SKL_4		{width:  100px}
                    		.SKL_5		{width:  200px}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal; width: 20px;
                                					}
                   			 .contents	{height: 2.0em; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.0em; padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; width:  350px;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; padding-bottom: 8px;
                                				}
                    		.stars      	{padding-left: 2px; text-align: right; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.empty		{border: 0 0 0 0;}
                </style>
			</head>
			<body>
				<xsl:apply-templates/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="MIECHR">
		<xsl:apply-templates select="Metryczka"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Mieszkania-chronione"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<table border="2" cellspacing="0" cellpadding="4">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<tr>
				<th style="border-right: none; font-weight: normal;">I.</th>
				<th colspan="2" align="left" style="border-left: none; border-right: none; font-weight: normal;">Liczba osób umieszczonych w mieszkaniach chronionych w <xsl:value-of select="Metryczka/Za-okres/Rok"/> roku</th>
				<th style="border-left: none;" width="240" align="right"><xsl:value-of select="Osób-umieszczonych"/></th>
			</tr>
			<tr>
				<th style="border-right: none; font-weight: normal;">II.</th>
				<th colspan="2" align="left" style="border-left: none; border-right: none; font-weight: normal;">Liczba osób oczekujących na umieszczenie w mieszkaniach chronionych wg stanu na dzień 31.XII <xsl:value-of select="Metryczka/Za-okres/Rok"/> roku</th>
				<th style="border-left: none;" align="right"><xsl:value-of select="Osób-oczekujących"/></th>
			</tr>
			<tr>
				<th rowspan="2" style="border-right: none; font-weight: normal;">III.</th>
				<th rowspan="2" align="left" style="border-left: none; border-right: none; font-weight: normal;">Stopień zaspokojenia potrzeb:</th>
				<th style="border-left: none; border-right: none;">liczba osób umieszczonych x 100</th>
				<th style="border-left: none;" rowspan="2" align="right"><xsl:value-of select="format-number((100 * Osób-umieszczonych) div (Osób-umieszczonych + Osób-oczekujących), $ułamek)"/></th>
			</tr>
			<tr>
				<th style="border-left: none; border-right: none;">liczba osób umieszczonych + oczekujących</th>
			</tr>
		</table>
		<br/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<table border="2" cellspacing="0" cellpadding="4">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th colspan="3">
						<span  style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5,<br/>00-513 Warszawa
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="290">
						<span  style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
						</span>
						<center>
							<xsl:for-each select="Nadawca">
								<table cellspacing="0" cellpadding="0">
									<tr>
										<td class="stamp" colspan="2">
											<xsl:value-of select="Pełna-nazwa"/>
										</td>
									</tr>
									<xsl:for-each select="Adres-pocztowy">
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Ulica-i-numer"/>
											</td>
										</tr>
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Kod-i-poczta"/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td class="stamp" style="font-size: 11px; text-align: left">
											<xsl:for-each select="Telefon">
                                 					           Tel. <xsl:apply-templates/> &#160;
					                                        </xsl:for-each>
										</td>
										<td class="stamp" style="font-size: 11px; text-align: right">
											<xsl:for-each select="Faks">
					                                            &#160;Fax <xsl:apply-templates/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>
						</center>
					</td>
					<td width="200" rowspan="3" style="text-align: center; font-weight: bold;">
						<span style="font-size: large;"><xsl:value-of select="name(..)"/></span>
						<br/>
						<p style="font-size: 13px">
                            			<xsl:value-of select="../Mieszkania-chronione/@Opis"/>
                    	w <xsl:value-of select="Za-okres/Rok"/> roku
						</p>
					</td>
					<td width="200">
						<div style="font-weight: bold; font-size: 13px; text-align: left;">
							Część&#160;&#160;85 - Budżet Wojewody<br/>Dział&#160;852 - Pomoc Społeczna<br/>Rozdział 85220
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<span  style="font-size: 11px; text-align: left;">
							Numer identyfikacyjny jednostki sprawozdawczej:<br/>
						</span>
						<div style="font-weight: bold; text-align: center;">
							<xsl:value-of select="Nadawca/@Kod-REGON"/>
						</div>
					</td>
					<td rowspan="2" width="200">
						<div style="font-weight: bold; font-size: 13px; text-align: left;">
							Przekazać w terminie do 15-go lutego<sup>1)</sup>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<span  style="font-size: 11px; text-align: left;">
							Województwo:<br/>
						</span>
						<div style="font-weight: bold; text-align: center;">
							<xsl:value-of select="../Nagłówek/Województwo"/>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<br/><xsl:value-of select="Opis"/><br/>
			</div>
		</xsl:if>
		<br/>
		<xsl:if test="(Za-okres/Kwartał = 'I' or Za-okres/Kwartał = 'III') and Kod/Cyklu-sprawozdawczego != 3 or
					(Za-okres/Kwartał = 'II' or Za-okres/Kwartał = 'IV') and Kod/Cyklu-sprawozdawczego != 4">
			<!--div style="font-size: large; text-align: center; color: red;">
				Niepoprawny kod cyklu sprawozdawczego!
			</div>
			<br/> <br/> <br/> <br/> <br/-->
		</xsl:if>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table border="0">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th width="390" align="left">Imię, nazwisko i numer telefonu osoby, która sporządziła informację</th>
					<th>Miejscowość i data</th>
					<th>DYREKTOR</th>
				</tr>
			</thead>
			<tbody>
			<tr style="font-size: 12px;">
				<td>
					<xsl:value-of select="concat($kto/Imię-i-nazwisko, ', tel. ', $kto/Telefon)"/>
				</td>
				<td align="center">
					<xsl:value-of select="concat(substring(Metryczka/Nadawca/Adres-pocztowy/Kod-i-poczta, 8), ', ', $kto/Data-wykonania)"/>
				</td>
			</tr>
			</tbody>
		</table>
		<br/><br/>
		<small>W wierszu I należy wykazać osoby umieszczone po raz pierwszy w mieszkaniu chronionym.</small>
		<br/><br/>
		<hr align="left" width="400" noshade="1" size="1"/>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars">1)
	                    </td>
				<td class="remark">
					Jeśli termin przekazania sprawozdania wypada w dzień wolny od pracy, to obowiązuje data pierwszego
					dnia roboczego po tym dniu. Powyższe daty są terminami przekazania sprawozdania do MPS.
	                    </td>
			</tr>
			<tr>
				<td class="stars">2)
	                    </td>
				<td class="remark">
					Stan na dzień 31.XII roku poprzedniego.
	          </td>
			</tr>
			<tr>
				<td class="stars">3)
	                    </td>
				<td class="remark">
					Przybyło i ubyło w roku bieżącym.
				</td>
			</tr>
			<tr>
				<td class="stars">4)
	                    </td>
				<td class="remark">
					Stan na dzień 31.XII roku bieżącego.
				</td>
			</tr>
			<tr>
				<td class="stars">5)
	                    </td>
				<td class="remark">
					Planowane zwiększenie środków w roku następnym.
				</td>
			</tr>
		</table>

		<div class="xslt_ver">
			<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
			<xsl:if test="system-property('msxsl:version')">
				<xsl:value-of select="concat(', MSXML: ', system-property('msxsl:version'))"/>
			</xsl:if>
		</div>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="prefix"/>
		<xsl:variable name="row_no" select="count(preceding::*[starts-with(@Pozycja, $prefix)]) + 1"/>
		<td class="row_descr">
			<p>
				<xsl:value-of select="count(preceding::*[starts-with(@Pozycja, $prefix)])+
									  count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)])"/>.
				<xsl:choose>
					<xsl:when test="$row_no = 1">
						Stan na dzień 31.XII <xsl:value-of select="../../Metryczka/Za-okres/Rok - 1"/> roku <sup>2)</sup>
					</xsl:when>
					<xsl:when test="$row_no = 2">
						Przybyło w <xsl:value-of select="../../Metryczka/Za-okres/Rok"/> roku <sup>3)</sup>
					</xsl:when>
					<xsl:when test="$row_no = 3">
						Ubyło w <xsl:value-of select="../../Metryczka/Za-okres/Rok"/> roku <sup>3)</sup>
					</xsl:when>
					<xsl:when test="$row_no =4">
						Stan na dzień 31.XII <xsl:value-of select="../../Metryczka/Za-okres/Rok"/> roku <sup>4)</sup> (1 + 2 - 3)
					</xsl:when>
					<xsl:when test="$row_no = 5">
						Planowane zwiększenie w <xsl:value-of select="../../Metryczka/Za-okres/Rok + 1"/> roku <sup>5)</sup>
					</xsl:when>
				</xsl:choose>
			</p>
		</td>
		<td class="tab_row_no">
			0<xsl:value-of select="$row_no"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Mieszkania-chronione">
		<xsl:param name="width" select="716"/>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th class="SKL_0" colspan="2" rowspan="2">WYSZCZEGÓLNIENIE</th>
					<th class="SKL_1" colspan="3">LICZBA</th>
				</tr>
				<tr>
					<th class="SKL_4">MIESZKAŃ</th>
					<th class="SKL_4">MIEJSC</th>
					<th class="SKL_4">MIESZKAŃCÓW</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates/>
			</tbody>
		</table>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Stan-lub-zmiana">
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="prefix" select="'_MIECHR_'"/>
			</xsl:call-template>

			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Mieszkań'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Miejsc'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
			<xsl:call-template name="_1_column">
				<xsl:with-param name="column" select="'Mieszkańców'"/>
				<xsl:with-param name="format" select="$liczba"/>
			</xsl:call-template>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_1_column">
		<xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="../*[last() - 1]/@Pozycja = ./@Pozycja">
				<xsl:call-template name="_1_totals">
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="nodeset" select="../*[position() &lt; last() - 1]/*[name(.) = $column]"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_totals">
		<xsl:param name="nodeset"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="result">
			<xsl:value-of select="$nodeset[1] + $nodeset[2] - $nodeset[3]"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="string(number($contents)) != 'NaN' and $contents != 0">
				<xsl:choose>
					<xsl:when test="string(number($result)) = 'NaN'">
						<td class="totals" style="background-color: red">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:when test="$contents != $result">
						<td class="contents" style="background-color: red">
							<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
							<br/>
							<xsl:value-of select="concat('suma: ', format-number($result, $format))"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($result, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($result, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
