<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.1'"/>
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="etat" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'944px'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>; padding-top: 6px;
                                				}

                    		.MRiPS_06_6_0        {width:  270px}
                    		.MRiPS_06_6_1        {width:  80px}
							.MRiPS_06_6_2        {width:  120px}
							.MRiPS_06_6_3        {width:  200px}
							.MRiPS_06_6_4        {width:  400px}
							.MRiPS_06_6_6        {width:  600px}
							.MRiPS_06_6_12      {width:  1200px}
                    		.MRiPS_06_6_0a      {width:  460px}

                    		.MRiPS_06_7_0		{width:  370px}
                    		.MRiPS_06_7_1		{width:  308px}
                    		.MRiPS_06_7_2		{width:  100px}


                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal;
                                					}
                   			 .contents	{height: 2.0em; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.0em; padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				padding-bottom: 4px; font-weight: normal;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; padding-top: 18px;
                                				}
                    		.empty		{border: 0 0 0 0;}
				</style>
			</head>
			<body>
				<xsl:apply-templates select="MRiPS-06"/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="MRiPS-06">
		<xsl:apply-templates select="Metryczka"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Dział_1A"/>
		<xsl:apply-templates select="Dział_1B"/>
		<xsl:apply-templates select="Dział_2"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/>
				<br/>
				<br/>
			</div>
		</xsl:if>
		<table border="2" cellspacing="0" cellpadding="8">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th colspan="3">
						<span style="font-size: 16px; font-weight: bold;">
							MINISTERSTWO RODZINY I POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5, 00-513 Warszawa
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="300">
						<span style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
						</span>
						<center>
							<xsl:for-each select="Nadawca">
								<table cellspacing="0" cellpadding="0">
									<tr>
										<td class="stamp" colspan="2">
											<xsl:value-of select="Pełna-nazwa"/>
										</td>
									</tr>
									<xsl:for-each select="Adres-pocztowy">
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Ulica-i-numer"/>
											</td>
										</tr>
										<tr>
											<td class="stamp" colspan="2">
												<xsl:value-of select="Kod-i-poczta"/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td class="stamp" style="font-size: 11px; text-align: left">
											<xsl:for-each select="Telefon">
                                 					           Tel. <xsl:apply-templates/> &#160;
					                                        </xsl:for-each>
										</td>
										<td class="stamp" style="font-size: 11px; text-align: right">
											<xsl:for-each select="Faks">
					                                            &#160;Fax <xsl:apply-templates/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:for-each>
						</center>
					</td>
					<td rowspan="2" style="text-align: center; font-weight: bold;">
						<span style="font-size: large;">MRiPS-06</span>
						<br/>
						<p style="font-size: 13px">
										SPRAWOZDANIE ROCZNIE: <br/>WYBRANE JEDNOSTKI ORGANIZACYJNE POMOCY SPOŁECZNEJ I INNE JEDNOSTKI POMOCY SPOŁECZNEJ ORAZ ZATRUDNIENIE W SYSTEMIE POMOCY SPOŁECZNEJ.
										</p>
										za I-XII
							<xsl:value-of select="concat(' ', Za-okres/Rok, ' r.')"/>
					</td>
					<td width="300">
						<span style="font-size: 11px; text-align: left;">
							Adresat:<br/>
						</span>
						<div class="stamp">
							<xsl:value-of select="Odbiorca/Pełna-nazwa"/>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<span style="font-size: 11px; text-align: left;">
							Numer identyfikacyjny REGON:<br/>
						</span>
						<div style="font-weight: bold; text-align: center;">
							<xsl:value-of select="Nadawca/@Kod-REGON"/>
						</div>
					</td>
					<td>
						<div style="font-weight: bold; font-size: 13px; text-align: center;">
							Przekazać / wysłać:<br/>
							<xsl:choose>
								<xsl:when test="../Nagłówek/Województwo or ../Nagłówek/Ministerstwo">
									do 28 lutego
								</xsl:when>
								<xsl:otherwise>
									do 9 lutego
								</xsl:otherwise>
							</xsl:choose>
							<xsl:value-of select="concat(' ', Za-okres/Rok + 1, ' roku')"/> za <xsl:value-of select="Za-okres/Rok"/> rok
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<br/>
		<br/>
		<br/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table width="700">
			<caption>Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td width="160">Imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td width="160">Telefon:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td width="160">Data wykonania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
			<tr>
				<td width="160">e-mail:</td>
				<td>
					<xsl:value-of select="$kto/E-mail"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="level"/>
		<xsl:param name="prefix"/>
		<xsl:variable name="topbot" select="'margin-top: 4px; margin-bottom: 4px; margin-left: '"/>
		<xsl:variable name="topbot2" select="'margin-top: 4px; margin-bottom: 0px; margin-left: '"/>
		<xsl:variable name="indent" select="25"/>
		<td class="MRiPS_06_6_0a row_descr">
			<xsl:if test="not(preceding-sibling::*) and ../@Prefiks and ../@Prefiks != ''">
				<p>
					<xsl:attribute name="style"><xsl:value-of select="concat($topbot2, string($indent * ($level - 1)), 'px;')"/></xsl:attribute>
					<xsl:value-of select="../@Prefiks"/>
					<br/>
				</p>
			</xsl:if>
			<p>
				<xsl:if test="$level &gt;= 0">
					<xsl:attribute name="style"><xsl:value-of select="concat($topbot, string($indent * $level), 'px;')"/></xsl:attribute>
				</xsl:if>
				<xsl:value-of select="@Opis"/>
			</p>
		</td>
		<td class="MRiPS_03_6_0b tab_row_no">
			<xsl:value-of select="count(preceding::*[starts-with(@Pozycja, $prefix)])+
								  count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)])"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="sumuj">
		<xsl:param name="wynik"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma"/>
		<xsl:choose>
			<xsl:when test="$suma!=''">
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="substring-after($suma,'+')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string(number($wynik)) = 'NaN'">
						<td class="totals" style="background-color: red">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:when test="string(number($contents)) != 'NaN'">
						<xsl:choose>
							<xsl:when test="$contents != $wynik">
								<td class="contents" style="background-color: red">
									<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
									<br/>
									<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals">
									<xsl:value-of select="format-number($wynik, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($wynik, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_1A">
		<xsl:call-template name="Dział_1ABC"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_1B">
		<xsl:call-template name="Dział_1ABC"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Dział_1ABC">
		<xsl:param name="width" select="944"/>
		<div>
			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('DZIAŁ ', substring-after(name(.), '_'), '. ')"/>
			<div style="margin-top: -1.15em; margin-left: 5.5em">
				<xsl:value-of select="@Opis"/>
			</div>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th class="MRiPS_06_7_0" colspan="2" rowspan="2">WYSZCZEGÓLNIENIE</th>
					<th class="MRiPS_06_7_1" colspan="3">
						PODMIOT PROWADZĄCY -
						<xsl:choose>
							<xsl:when test="JOPS-lokalne">
								<xsl:value-of select="'GMINA'"/>
							</xsl:when>
							<xsl:when test="JOPS-ponadgminne">
								<xsl:value-of select="'POWIAT'"/>
							</xsl:when>
						</xsl:choose>
					</th>
					<th class="MRiPS_06_7_1" colspan="3">INNY PODMIOT PROWADZĄCY
						<xsl:choose>
							<xsl:when test="JOPS-lokalne">
								<xsl:value-of select="'NA ZLECENIE GMINY'"/>
							</xsl:when>
							<xsl:when test="JOPS-ponadgminne">
								<xsl:value-of select="'NA ZLECENIE POWIATU'"/>
							</xsl:when>
						</xsl:choose>
					</th>
				</tr>
				<tr>
					<th class="MRiPS_06_7_2">liczba<br/>jednostek<sup>1)</sup>
					</th>
					<th class="MRiPS_06_7_2">liczba<br/>miejsc<sup>2)</sup>
					</th>
					<th class="MRiPS_06_7_2">liczba osób<br/>korzystających<sup>3)</sup>
					</th>
					<th class="MRiPS_06_7_2">liczba<br/>jednostek<sup>1)</sup>
					</th>
					<th class="MRiPS_06_7_2">liczba<br/>miejsc<sup>2)</sup>
					</th>
					<th class="MRiPS_06_7_2">liczba osób<br/>korzystających<sup>3)</sup>
					</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">0</td>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="JOPS-lokalne">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="JOPS-ponadgminne">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
			</tbody>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" width="6">1)</td>
				<td class="remark">
					Liczba jednostek według stanu na dzień 31 grudnia roku sprawozdawczego.
				</td>
			</tr>
			<tr>
				<td class="stars" width="6">2)</td>
				<td class="remark">
					Liczba miejsc według statutu wg stanu na dzień 31 grudnia roku sprawozdawczego.
				</td>
			</tr>
			<tr>
				<td class="stars" width="6">3)</td>
				<td class="remark">
                    Rzeczywista liczba osób korzystających w okresie sprawozdawczym (narastająco za okres od 1 stycznia do 31 grudnia roku sprawozdawczego). Daną osobę należy wykazać tylko raz bez względu na liczbę dni pobytu lub liczbę wizyt.
                </td>
			</tr>
		</table>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="JOPS-lokalne">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_1A_'"/>
			</xsl:call-template>
			<xsl:call-template name="_1ABC_contents">
				<xsl:with-param name="subtree" select="'Gmina'"/>
			</xsl:call-template>
			<xsl:call-template name="_1ABC_contents">
				<xsl:with-param name="subtree" select="'Inne'"/>
			</xsl:call-template>
		</tr>
		<xsl:apply-templates select="*/JOPS-lokalne">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="JOPS-ponadgminne">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_1B_'"/>
			</xsl:call-template>
			<xsl:call-template name="_1ABC_contents">
				<xsl:with-param name="subtree" select="'Powiat'"/>
			</xsl:call-template>
			<xsl:call-template name="_1ABC_contents">
				<xsl:with-param name="subtree" select="'Inne'"/>
			</xsl:call-template>
		</tr>
		<xsl:apply-templates select="*/JOPS-ponadgminne">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1ABC_contents">
		<xsl:param name="subtree"/>
		<xsl:call-template name="_1ABC_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-jednostek'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_1ABC_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-miejsc'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_1ABC_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Liczba-korzystających'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1ABC_column">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="Podmiot-prowadzący/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="Z-tego and not($item/@xsi:nil)">
				<xsl:call-template name="_1ABC_total">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1ABC_total">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="Z-tego/*">
				<xsl:call-template name="_1ABC_add_tree">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="$column='Liczba-korzystających' and (@Pozycja='_1A_16' or @Pozycja='_1A_17' or @Pozycja='_1A_22' or @Pozycja='_1B_22' or @Pozycja='_1B_23' or @Pozycja='_1B_30')">
				<td class="contents">
					<xsl:value-of select="$contents"/>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="0"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="$suma"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1ABC_add_tree">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents" select="Podmiot-prowadzący/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_1ABC_add_tree">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_2">
		<xsl:for-each select="*">
			<xsl:call-template name="_2_table"/>
		</xsl:for-each>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_table">
		<xsl:variable name="width">
			<xsl:choose>
				<xsl:when test="name() = 'Część_3'">1400</xsl:when>
				<xsl:otherwise>1600</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<div style="page-break-before: always">
			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('DZIAŁ ', substring-after(name(..), '_'), '. ')"/>
			<div style="margin-top: -1.1em; margin-left: 5em">
				<xsl:value-of select="../@Opis"/>
				<xsl:if test="@Opis">
					<xsl:value-of select="' '"/>
					<xsl:value-of select="@Opis"/>
				</xsl:if>
			</div>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:variable name="headerTemplateName" select="concat('_2_',name(),'_table-header')"/>
			<xsl:choose>
				<xsl:when test="name() = 'Część_1'"><xsl:call-template name="_2_Część_1_table-header"/></xsl:when>
				<xsl:when test="name() = 'Część_2'"><xsl:call-template name="_2_Część_2_table-header"/></xsl:when>
				<xsl:when test="name() = 'Część_3'"><xsl:call-template name="_2_Część_3_table-header"/></xsl:when>
			</xsl:choose>
			<tbody>
				<xsl:for-each select="*">
					<xsl:call-template name="Zatrudnienie-row"/>
				</xsl:for-each>
			</tbody>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<xsl:attribute name="style">
 				width: <xsl:number value="$width"/>px
			</xsl:attribute>
			<tr>
				<td class="stars" width="6">1)</td>
				<td class="remark">
                    Wartości wykazane w wierszu 1 - "OGÓŁEM" w:
                    <br/>kolumnie 1 - odzwierciedlają rzeczywistą liczbę osób zatrudnionych w systemie pomocy społecznej, liczba osób jest mniejsza lub równa sumie liczby osób kolumn: 3+5+7+9+11+13+15+19+21
                    <br/>kolumnie 2 - stanowią sumę kolumn: 4+6+8+10+12+14+16+20+22
                 </td>
			</tr>
			<tr>
				<td class="stars" width="6">2)</td>
				<td class="remark">
                    Dyrektor/kierownik - w rozumieniu: kierujący jednostką organizacyjną pomocy społecznej.
                 </td>
			</tr>
			<tr>
				<td class="stars" width="6">3)</td>
				<td class="remark">
                    W kolumnach nadrzędnych (ogółem) w wierszu 1 należy wykazać daną osobę tylko jeden raz, aby wykazać rzeczywistą liczbę osób zatrudnionych.
                 </td>
			</tr>
			<tr>
				<td class="stars" width="6">4)</td>
				<td class="remark">
                    Etaty należy podawać z dokładnością do dwóch miejsc po przecinku.
                 </td>
			</tr>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_Część_1_table-header" match="xsl:template[@name='_2_Część_1_table-header']">
		<thead>
			<tr>
				<th class="MRiPS_06_6_0" colspan="2" rowspan="2">WYSZCZEGÓLNIENIE</th>
				<th class="MRiPS_06_6_3" colspan="2">OGÓŁEM</th>
				<th class="MRiPS_06_6_3" colspan="2">SŁUŻBY WOJEWODY REALIZUJĄCE ZADANIA Z ZAKRESU POMOCY SPOŁECZNEJ</th>
				<th class="MRiPS_06_6_3" colspan="2">REGIONALNE OŚRODKI POLITYKI SPOŁECZNEJ OGÓŁEM</th>
				<th class="MRiPS_06_6_3" colspan="2">POWIATOWE CENTRA POMOCY RODZINIE OGÓŁEM</th>
				<th class="MRiPS_06_6_3" colspan="2">OŚRODKI POMOCY SPOŁECZNEJ OGÓŁEM</th>
				<th class="MRiPS_06_6_3" colspan="2">CENTRA USŁUG SPOŁECZNYCH OGÓŁEM</th>
				<th class="MRiPS_06_6_3" colspan="2">DOMY POMOCY SPOŁECZNEJ OGÓŁEM</th>
			</tr>
			<tr>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
			</tr>
			<tr>
				<td class="tab_col_no" colspan="2">0</td>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
				<td class="tab_col_no">7</td>
				<td class="tab_col_no">8</td>
				<td class="tab_col_no">9</td>
				<td class="tab_col_no">10</td>
				<td class="tab_col_no">11</td>
				<td class="tab_col_no">12</td>
				<td class="tab_col_no">13</td>
				<td class="tab_col_no">14</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_Część_2_table-header" match="xsl:template[@name='_2_Część_2_table-header']">
		<thead>
			<tr>
				<th class="MRiPS_06_6_0" colspan="2" rowspan="4">WYSZCZEGÓLNIENIE</th>
				<th class="MRiPS_06_6_3" colspan="2" rowspan="3">PLACÓWKI SPECJALISTYCZNEGO PORADNICTWA OGÓŁEM</th>
				<th class="MRiPS_06_6_3" colspan="2">w tym:</th>
				<th class="MRiPS_06_6_3" colspan="2" rowspan="3">OŚRODKI INTERWENCJI KRYZYSOWEJ OGÓŁEM</th>
				<th class="MRiPS_06_6_3" colspan="2" rowspan="3">OŚRODKI WSPARCIA OGÓŁEM</th>
				<th class="MRiPS_06_6_6" colspan="6">w tym (kol.23 i 24, 29 i 30, 31 i 32, 33 i 34, 35 i 36, 37 i 38 i 39 i 40):</th>
			</tr>
			<tr>
				<th class="MRiPS_06_6_3" colspan="2" rowspan="2">PLACÓWKI SPECJALISTYCZNEGO PORADNICTWA RODZINNEGO</th>
				<th class="MRiPS_06_6_3" colspan="2" rowspan="2">OŚRODKI WSPARCIA DLA OSÓB Z ZABURZENIAMI PSYCHICZNYMI</th>
				<th class="MRiPS_06_6_4" colspan="4">w tym (kol.25 i 26, 27 i 28):</th>
			</tr>
			<tr>
				<th class="MRiPS_06_6_3" colspan="2">ŚRODOWISKOWE DOMY SAMOPOMOCY</th>
				<th class="MRiPS_06_6_3" colspan="2">KLUBY SAMOPOMOCY DLA OSÓB Z ZABURZENIAMI PSYCHICZNYMI</th>
			</tr>
			<tr>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
			</tr>
			<tr>
				<td class="tab_col_no" colspan="2">0</td>
				<td class="tab_col_no">15</td>
				<td class="tab_col_no">16</td>
				<td class="tab_col_no">17</td>
				<td class="tab_col_no">18</td>
				<td class="tab_col_no">19</td>
				<td class="tab_col_no">20</td>
				<td class="tab_col_no">21</td>
				<td class="tab_col_no">22</td>
				<td class="tab_col_no">23</td>
				<td class="tab_col_no">24</td>
				<td class="tab_col_no">25</td>
				<td class="tab_col_no">26</td>
				<td class="tab_col_no">27</td>
				<td class="tab_col_no">28</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_Część_3_table-header" match="xsl:template[@name='_2_Część_3_table-header']">
		<thead>
			<tr>
				<th class="MRiPS_06_6_0" colspan="2" rowspan="3">WYSZCZEGÓLNIENIE</th>
				<th class="MRiPS_06_6_12" colspan="12">w tym (kol.23 i 24, 29 i 30, 31 i 32, 33 i 34, 35 i 36, 37 i 38 i 39 i 40):</th>
			</tr>
			<tr>
				<th class="MRiPS_06_6_3" colspan="2">DZIENNE DOMY POMOCY</th>
				<th class="MRiPS_06_6_3" colspan="2">DOMY DLA MATEK Z MAŁOLETNIMI DZIEĆMI I KOBIET W CIĄŻY</th>
				<th class="MRiPS_06_6_3" colspan="2">SCHRONISKA DLA OSÓB BEZDOMNYCH</th>
				<th class="MRiPS_06_6_3" colspan="2">SCHRONISKA DLA OSÓB BEZDOMNYCH Z USŁUGAMI OPIEKUŃCZYMI</th>
				<th class="MRiPS_06_6_3" colspan="2">KLUBY SAMOPOMOCY<br/>(inne niż wymienione w kolumnach 27-28)</th>
				<th class="MRiPS_06_6_3" colspan="2">INNE OŚRODKI WSPARCIA</th>
			</tr>
			<tr>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
				<th class="MRiPS_06_6_1">liczba osób<sup>3)</sup>
				</th>
				<th class="MRiPS_06_6_2">w przeliczeniu<br/>na etaty<sup>4)</sup>
				</th>
			</tr>
			<tr>
				<td class="tab_col_no" colspan="2">0</td>
				<td class="tab_col_no">29</td>
				<td class="tab_col_no">30</td>
				<td class="tab_col_no">31</td>
				<td class="tab_col_no">32</td>
				<td class="tab_col_no">33</td>
				<td class="tab_col_no">34</td>
				<td class="tab_col_no">35</td>
				<td class="tab_col_no">36</td>
				<td class="tab_col_no">37</td>
				<td class="tab_col_no">38</td>
				<td class="tab_col_no">39</td>
				<td class="tab_col_no">40</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Zatrudnienie-row">
		<xsl:param name="margin" select="0"/>
		<tr>
			<xsl:call-template name="_2_row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_2_'"/>
			</xsl:call-template>
			<xsl:apply-templates select="Zatrudnienie"/>
		</tr>
		<xsl:for-each select="*[name() = 'W-tym' or name() = 'W-tym-siedziba']/*">
			<xsl:call-template name="Zatrudnienie-row">
				<xsl:with-param name="margin" select="$margin + 1"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Zatrudnienie">
		<xsl:call-template name="_2_contents"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_contents">
		<xsl:call-template name="_2_column">
			<xsl:with-param name="column" select="'Ogółem'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
		<xsl:call-template name="_2_column">
			<xsl:with-param name="column" select="'Pełne-etaty'"/>
			<xsl:with-param name="format" select="$etat"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_column">
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="@Pozycja='_2_001' and $column='Pełne-etaty'">
				<xsl:call-template name="_2_total">
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_total">
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:variable name="suma">
			<xsl:value-of select="sum(../../../*/Zatrudnienie_ogółem/Zatrudnienie[@Pozycja='_2_011' or @Pozycja='_2_031' or @Pozycja='_2_176' or @Pozycja='_2_054' or @Pozycja='_2_059' or @Pozycja='_2_065' or @Pozycja='_2_070']/Pełne-etaty)"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="format-number($contents,$format) != format-number($suma,$format)">
				<td class="totals" style="background-color: red">
					<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
					<br/>
					<xsl:value-of select="concat('suma: ', format-number($suma, $format))"/>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($suma, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_row-description">
		<xsl:param name="level"/>
		<xsl:param name="prefix"/>
		<xsl:variable name="topbot" select="'margin-top: 4px; margin-bottom: 4px; margin-left: '"/>
		<xsl:variable name="topbot2" select="'margin-top: 4px; margin-bottom: 0px; margin-left: '"/>
		<xsl:variable name="indent" select="25"/>
		<td class="MRiPS_06_6_0a row_descr">
			<xsl:if test="not(preceding-sibling::*) and ../@Prefiks and ../@Prefiks != ''">
				<p>
					<xsl:attribute name="style"><xsl:value-of select="concat($topbot2, string($indent * ($level - 1)), 'px;')"/></xsl:attribute>
					<xsl:value-of select="../@Prefiks"/>
					<br/>
				</p>
			</xsl:if>
			<p>
				<xsl:if test="$level &gt;= 0">
					<xsl:attribute name="style"><xsl:value-of select="concat($topbot, string($indent * $level), 'px;')"/></xsl:attribute>
				</xsl:if>
				<xsl:call-template name="_2_row-description-name"/>
				<xsl:if test="name() = 'Zatrudnienie_ogółem'">
					<sup>1)</sup>
				</xsl:if>
				<xsl:if test="name() = 'Dyrektor'">
					<sup>2)</sup>
				</xsl:if>
			</p>
		</td>
		<td class="MRiPS_03_6_0b tab_row_no">
			<xsl:variable name="rowNumber" select="count(preceding::*[Zatrudnienie])+count(ancestor-or-self::*[Zatrudnienie])"/>
			<xsl:choose>
				<xsl:when test="$rowNumber &gt; 68">
					<xsl:value-of select="$rowNumber - 68"/>
				</xsl:when>
				<xsl:when test="$rowNumber &gt; 34">
					<xsl:value-of select="$rowNumber - 34"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$rowNumber"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_row-description-name">
		<xsl:choose>
			<xsl:when test="name() = 'Zatrudnienie_ogółem'">OGÓŁEM</xsl:when>
			<xsl:when test="name() = 'Inspektor'">inspektor do spraw nadzoru i kontroli w pomocy społecznej</xsl:when>
			<xsl:when test="name() = 'Dyrektor'">dyrektor/kierownik</xsl:when>
			<xsl:when test="name() = 'Zastępca-dyrektora'">zastępca dyrektora/zastępca kierownika</xsl:when>
			<xsl:when test="name() = 'Kierownik'">kierownik działu, kierownik sekcji</xsl:when>
			<xsl:when test="name() = 'Pracownicy-ogółem'">pracownicy socjalni ogółem</xsl:when>
			<xsl:when test="name() = 'Praca-poza-siedzibą'">świadczący pracę socjalną poza siedzibą jednostki</xsl:when>
			<xsl:when test="name() = 'Wywiady-poza-siedzibą'">przeprowadzający rodzinne wywiady środowiskowe poza siedzibą jednostki</xsl:when>
			<xsl:when test="name() = 'Praca-wywiady-poza-siedzibą'">świadczący pracę socjalną i przeprowadzający rodzinne wywiady środowiskowe poza siedzibą jednostki</xsl:when>
			<xsl:when test="name() = 'Główny-specjalista-pracy-socjalnej'">główny specjalista pracy socjalnej</xsl:when>
			<xsl:when test="name() = 'Starszy-specjalista-pracy-socjalnej-koord'">starszy specjalista pracy socjalnej - koordynator</xsl:when>
			<xsl:when test="name() = 'Starszy-specjalista-pracy-socjalnej'">starszy specjalista pracy socjalnej</xsl:when>
			<xsl:when test="name() = 'Specjalista-pracy-socjalnej'">specjalista pracy socjalnej</xsl:when>
			<xsl:when test="name() = 'Starszy-pracownik-socjalny'">starszy pracownik socjalny</xsl:when>
			<xsl:when test="name() = 'Pracownik-socjalny'">pracownik socjalny</xsl:when>
			<xsl:when test="name() = 'Główny-specjalista'">główny specjalista będący pracownikiem socjalnym</xsl:when>
			<xsl:when test="name() = 'Aspirant'">aspirant pracy socjalnej</xsl:when>
			<xsl:when test="name() = 'Konsultant'">konsultant</xsl:when>
			<xsl:when test="name() = 'Koordynator-komputeryzacji'">koordynator ds. komputeryzacji pomocy społecznej</xsl:when>
			<xsl:when test="name() = 'Radca-prawny'">radca prawny</xsl:when>
			<xsl:when test="name() = 'Pracownicy-usługi-opiekuńcze'">pracownicy wykonujący usługi opiekuńcze</xsl:when>
			<xsl:when test="name() = 'Pracownicy-specjalistyczne-usługi-opiekuńcze'">pracownicy wykonujący specjalistyczne usługi opiekuńcze</xsl:when>
			<xsl:when test="name() = 'Pracownicy-zaburzenia-psychiczne'">pracownicy wykonujący specjalistyczne usługi opiekuńcze dla osób z zaburzeniami psychicznymi</xsl:when>
			<xsl:when test="name() = 'Organizator-pomocy'">organizator pomocy społecznej</xsl:when>
			<xsl:when test="name() = 'Psycholodzy'">psycholodzy</xsl:when>
			<xsl:when test="name() = 'Pedagodzy'">pedagodzy</xsl:when>
			<xsl:when test="name() = 'Instruktorzy-terapii'">instruktorzy terapii zajęciowej</xsl:when>
			<xsl:when test="name() = 'Asystenci-osoby-niep'">asystenci osoby niepełnosprawnej</xsl:when>
			<xsl:when test="name() = 'Inne-specjalistyczne'">inne specjalistyczne, które odpowiadają rodzajowi i zakresowi usług świadczonych w domu</xsl:when>
			<xsl:when test="name() = 'Pracownicy-zdrowie'">pracownicy realizujący świadczenia zdrowotne</xsl:when>
			<xsl:when test="name() = 'Lekarze'">lekarze</xsl:when>
			<xsl:when test="name() = 'Pielęgniarki'">pielęgniarki</xsl:when>
			<xsl:when test="name() = 'Pracownicy-zdrowie-inni'">inni</xsl:when>
			<xsl:when test="name() = 'Pracownicy-pozostali'">pozostali pracownicy</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
