<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:msxsl="urn:schemas-microsoft-com:xslt">
    <!-- 
    =============================================================================================
    -->
    <xsl:param name="FrmSymbol"></xsl:param>
    <xsl:param name="FrmWersja"></xsl:param>
    <xsl:param name="KomEdyt">false</xsl:param>
    <xsl:param name="DataOd"></xsl:param>
    <xsl:param name="DataDo"></xsl:param>
    <xsl:param name="przyciskiKomorek">false</xsl:param>
    <xsl:param name="formatowanie_kwota">###&#160;###&#160;###&#160;##0</xsl:param>
    <xsl:param name="formatowanie_liczba">##&#160;###&#160;##0</xsl:param>
    <!--
	=============================================================================================
	-->
    <xsl:variable name="wersja" select="'1.1'"/>
    <xsl:decimal-format grouping-separator="&#160;" decimal-separator="," />
    <xsl:variable name="obsada" select="'###&#160;###&#160;###&#160;##0,00'" />
    <xsl:variable name="kwota" select="$formatowanie_kwota" />
    <xsl:variable name="liczba" select="$formatowanie_liczba" />
    <xsl:variable name="width" select="'944'" />
    <!--
	=============================================================================================
	-->
    <xsl:template match="/">
        <html>
            <head>
                <style type="text/css">
                            .blad           {background-color: red; text-align: right}
				            .pole           {background-color: white; text-align: right}
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								                font-weight: bold; text-align: center; border-width: 0px;
                                 				width: <xsl:value-of select="$width"/>px; padding: 5px;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: normal; text-align: left; border-width: 0px;
                                				}
                            .stamp_foot    	{color: #000000; font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: normal; text-align: left;  border-width: 0px;
                                 				padding-left: 5px;
                                				}
                            
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; margin-left: 1.0em; border-width: 0px;
                                 				padding-left: 10px; padding: 5px;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-align: center; border-width: 0px;
                                 				width: <xsl:value-of select="$width"/>px; padding-top: 20px;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                            table               {border-color: black; border-width:1px; border-style: solid;
                                                 border-collapse: collapse;
                                                }
                            .table_no_border     {border-color: black; border-width:0px; border-style: solid;
                                                }
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold; border-width: 1px; padding: 0px; border-style: inset;
	                                            border-color: black;
                                				}
                            td          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold; border-width: 1px; padding: 0px; border-style: inset;
	                                            border-color: black;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>px; padding-top: 6px;
                                				}
                    
					.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
								font-family: Tahoma, Verdana; font-size: 10px;
								font-weight: normal;
								}
					.tab_row_no {padding: 5px;
								color: #000000; font-family: Tahoma, Verdana; font-size: 10px;
								text-align: left; vertical-align: middle; font-weight: normal;
								}
					.tab_header {padding: 5px;
								color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
								text-align: center; vertical-align: middle; font-weight: bold;
								}
                   			 .contents	{height: 2.5em;
                   			 			padding: 5px;
                                 				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: normal;
                                				}
                   			 .totals     	{height: 2.5em;
                   			 			padding: 5px;
                                 				font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: normal;
                                				}
                    		.row_descr	{padding: 5px;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: left; vertical-align: middle; font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: baseline;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 			     font-weight: normal; border-width: 0px;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: baseline;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; border-width: 0px;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; padding-top: 24px;
                                				}
                    		.empty		{border: 0 0 0 0;}
				</style>
            </head>
            <body>
                <!-- Modyfikacja na potrzeby edytowania komorek -->
                <SCRIPT LANGUAGE="JavaScript1.1">
                    var operator = '';
                    function dodajOperator(regula){
                    operator = '';
                    if (regula.length > 0)
                    {
                    operator = '+';
                    if (regula.charAt(regula.length -1) == "+") {
                    operator ='';
                    }
                    if (regula.charAt(regula.length -1) == "-") {
                    operator ='';
                    }
                    if (regula.charAt(regula.length -1) == "*") {
                    operator ='';
                    }
                    if (regula.charAt(regula.length -1) == "/") {
                    operator ='';
                    }
                    if (regula.charAt(regula.length -1) == "=") {
                    operator ='';
                    }
                    if (regula.charAt(regula.length -1) == "&gt;") {
                    operator ='';
                    }
                    if (regula.charAt(regula.length -1) == "&lt;") {
                    operator ='';
                    }
                    }
                    }
                </SCRIPT>
                <form name="SACKomorkiSprawozdania" action="" method="POST">
                    <xsl:apply-templates select="WRiSPZ-G"/>
                </form>
                <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
            </body>
        </html>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="WRiSPZ-G">
        <xsl:apply-templates select="Metryczka"/>

        <xsl:apply-templates select="Tabela_A"/>
        <xsl:apply-templates select="Tabela_B"/>
        <xsl:apply-templates select="Tabela_C"/>

        <xsl:call-template name="Stopka"/>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Tabela_A">
        <xsl:call-template name="Tabela_AB"/>
    </xsl:template>
    
    <xsl:template match="Tabela_B">
        <xsl:call-template name="Tabela_AB"/>
    </xsl:template>
    
    <xsl:template match="Tabela_C">
        <xsl:call-template name="Tabela_C"/>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Tabela_AB">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="850"/>
            </xsl:attribute>
            <xsl:call-template name="AB_header"/>
            <tbody>
                <xsl:if test="Rodzina">
                    <xsl:apply-templates select="Rodzina">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
                <xsl:if test="Asystent">
                    <xsl:apply-templates select="Asystent">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="850"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Tabela_C">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table border="2" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="850"/>
            </xsl:attribute>
            <xsl:call-template name="C_header"/>
            <tbody>
                <xsl:if test="Placówki-WD">
                    <xsl:apply-templates select="Placówki-WD">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="850"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Metryczka">

        <table class="table_no_border" cellspacing="4" cellpadding="0">
            <tr>
                <td class="auth_name" colspan="2">
                    Organ sporządzający sprawozdanie
                </td>
            </tr>
            <xsl:call-template name="Poziom"/>
            <tr>
                <td class="stamp" width="70px">Adres:</td>
                <td class="stamp">
                    <xsl:for-each select="Nadawca/Adres-pocztowy">
                        <xsl:value-of select="Ulica-i-numer"/>, <xsl:value-of select="Kod-i-poczta"/>
                    </xsl:for-each>
                </td>
            </tr>
            <tr>
                <td class="heading_1" colspan="2">
                    Komórki dla formularza o symbolu: <xsl:value-of select="$FrmSymbol"/>
                </td>
            </tr>
        </table>
        <br/>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Stopka">
        <xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
        <table class="table_no_border" width="700">
            <tr>
                <th class="stamp_foot" colspan="2" align="left">Osoba&#160;sporządzająca&#160;sprawozdanie:</th>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">imię i nazwisko:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="$kto/Imię-i-nazwisko"/>
                </td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">telefon:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="$kto/Telefon"/>
                </td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">e-mail:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="$kto/E-mail"/>
                </td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">podpis:</td>
                <td class="stamp_foot"></td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">data:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="$kto/Data-wykonania"/>
                </td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">Uwagi:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="Metryczka/Opis"/>
                </td>
            </tr>
        </table>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Poziom">
        <tr>
        <xsl:for-each select="../Nagłówek">
            <xsl:for-each select="Wojewoda">
                <td class="stamp" width="70px" >Wojewoda:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
            <!-- W przypadku tego sprawozdania gmina i powiat zawsze mają Gmina -->
            <xsl:for-each select="Gmina">
                <td class="stamp" width="70px">Gmina:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
            <xsl:for-each select="Powiat">
                <td class="stamp" width="70px">Gmina:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
            <xsl:for-each select="Marzałek">
                <td class="stamp" width="70px">Samorząd województwa:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
            <xsl:for-each select="Ministerstwo">
                <td class="stamp" width="70px">Polska:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
        </xsl:for-each>
        </tr>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Table-caption">
        <xsl:param name="width"/>
        <div>
            <xsl:attribute name="style">
                font-family: Tahoma, Verdana; font-size: 14px; font-weight: bold; margin-bottom: 0.4em; margin-top: 1.2em;
                width: <xsl:number value="$width"/>px
            </xsl:attribute>
            <xsl:value-of select="concat('Tabela ', substring-after(name(.), '_'), '. ')"/><xsl:value-of select="@Opis"/>
        </div>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Table-description">
        <xsl:param name="width"/>
        <table class="table_no_border" style="padding-top: 6px;"  border="0" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="$width"/>
            </xsl:attribute>
            <xsl:for-each select="*[@Indeks != '']">
                <tr>
                    <td class="stars" width="1%">
                        <sup>
                            <xsl:choose>
                                <xsl:when test="substring(@Indeks,string-length(@Indeks),1) = ':'">                            
                                    <xsl:value-of select="substring-before(@Indeks,':')"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="@Indeks"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </sup>
                    </td>
                    <td class="remark">
                        <xsl:value-of select="@Indeks_opis"/>
                    </td>
                </tr>
            </xsl:for-each>
        </table>
        <br/>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="AB_header">
        <thead>
            <tr>
                <th class="tab_header" width="40px">Lp.</th>
                <th class="tab_header">Wyszczególnienie</th>
                <th class="tab_header" width="160px">
                    <xsl:if test="Rodzina">Liczba rodzin</xsl:if>
                    <xsl:if test="Asystent">Wykonanie</xsl:if>
                </th>
            </tr>
            <tr>
                <td class="tab_col_no">1</td>
                <td class="tab_col_no">2</td>
                <td class="tab_col_no">3</td>
            </tr>
        </thead>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="C_header">
        <thead>
            <tr>
                <th class="tab_header" width="40px">Lp.</th>
                <th class="tab_header" >Wyszczególnienie</th>
                <th class="tab_header" width="90px">Ogółem</th>
                <th class="tab_header" width="280px">w tym placówek/w placówkach prowadzonych przez inne podmioty niż gmina</th>
            </tr>
            <tr>
                <td class="tab_col_no">1</td>
                <td class="tab_col_no">2</td>
                <td class="tab_col_no">3</td>
                <td class="tab_col_no">4</td>
            </tr>
        </thead>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Rodzina">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_A_'"/>
            </xsl:call-template>
            <xsl:call-template name="_A_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Rodzina">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Placówki-WD">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_C_'"/>
            </xsl:call-template>
            <xsl:call-template name="_C_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Placówki-WD">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Asystent">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_B_'"/>
            </xsl:call-template>
            <xsl:call-template name="_B_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Asystent">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_A_contents">
        <xsl:call-template name="_ABC_column">
            <xsl:with-param name="column" select="'Liczba-rodzin'"/>
            <xsl:with-param name="format" select="$liczba"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_B_contents">
        <xsl:call-template name="_ABC_column">
            <xsl:with-param name="column" select="'Wykonanie'"/>
            <xsl:with-param name="format" select="$liczba"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_C_contents">
        <xsl:call-template name="_ABC_column">
            <xsl:with-param name="column" select="'Ogółem'"/>
            <xsl:with-param name="format" select="$liczba"/>
        </xsl:call-template>
        <xsl:call-template name="_ABC_column">
            <xsl:with-param name="column" select="'Inne-podmioty'"/>
            <xsl:with-param name="format" select="$liczba"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_ABC_column">
        <xsl:param name="column"/> <xsl:param name="format"/>
        <xsl:param name="item" select="*[name(.) = $column]"/>
        <xsl:param name="contents">
            <xsl:value-of select="$item"/>
        </xsl:param>
        <xsl:choose>
            <xsl:when test="Z-tego and not($item/@xsi:nil)">
                <xsl:call-template name="_ABC_total">
                    <xsl:with-param name="column" select="$column"/>
                    <xsl:with-param name="contents" select="$contents"/>
                    <xsl:with-param name="format" select="$format"/>
                    <!-- Modyfikacja na potrzeby edytowania komorek -->
                    <xsl:with-param name="komorka" select="$item/@Komorka"/>
                    <xsl:with-param name="blad" select="$item/@Blad"/>
                    <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="string($item/@xsi:nil) = 'true'">
                            <td class="contents">
                                <center>X</center>
                            </td>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:choose>
                                <xsl:when test="$item/@Komorka">
                                    <xsl:variable name="nazwa">
                                        <xsl:value-of select="$item/@Komorka"/>
                                    </xsl:variable>
                                    <xsl:choose>
                                        <xsl:when test="$przyciskiKomorek = 'true'">
                                            <td class="contents">
                                                <center>
                                                    <xsl:choose>
                                                        <xsl:when test="$FrmWersja = '' and $KomEdyt = 'false'">
                                                            <input type="button" name="K{$nazwa}"
                                                                value="K{$nazwa}"
                                                                onClick="javascript:window.opener.document.edytorApplet.getExchanger().returnKomorkaValue('K{$nazwa}');"
                                                            />
                                                        </xsl:when>
                                                        <xsl:when test="$KomEdyt = 'true'">
                                                            <input type="button" name="K{$nazwa}"
                                                                value="K{$nazwa}"
                                                                onClick="javascript:window.opener.document.getElementById('SS_KOMORKI_EDYT@NR_KOMORKI').value ='K{$nazwa}';"
                                                            />
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <input type="button" name="K{$nazwa}"
                                                                value="K{$nazwa}"
                                                                onClick="javascript:window.opener.document.edytorApplet.getExchanger().returnInnaKomorkaValue('{$FrmSymbol}','{$FrmWersja}','{$DataOd}','{$DataDo}', 'K{$nazwa}');"
                                                            />
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </center>
                                            </td>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <td class="contents">
                                                <center>
                                                    <b>K<xsl:value-of select="$nazwa"/></b>
                                                </center>
                                            </td>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:when>
                                <xsl:otherwise>
                                    <td class="contents">
                                        <xsl:value-of select="format-number($contents, $format)"/>
                                    </td>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:otherwise>
                    </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="_ABC_total">
        <xsl:param name="column"/>
        <xsl:param name="format"/> <xsl:param name="contents"/>
        <xsl:param name="suma">
            <xsl:for-each select="Z-tego/*">
                <xsl:call-template name="_ABC_add_tree">
                    <xsl:with-param name="column" select="$column"/>
                </xsl:call-template>
            </xsl:for-each>
        </xsl:param>
        <!-- Modyfikacja na potrzeby edytowania komorek -->
        <xsl:param name="komorka"/>
        <xsl:param name="blad"/>
        <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
        
        
        <xsl:call-template name="sumuj">
            <xsl:with-param name="wynik" select="0"/>
            <xsl:with-param name="format" select="$format"/>
            <xsl:with-param name="contents" select="$contents"/>
            <xsl:with-param name="suma" select="$suma"/>
            <!-- Modyfikacja na potrzeby edytowania komorek -->
            <xsl:with-param name="komorka" select="$komorka"/>
            <xsl:with-param name="blad" select="$blad"/>
            <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    
    <xsl:template name="_ABC_add_tree">
        <xsl:param name="column"/>
        <xsl:param name="contents" select="*[name(.) = $column]"/>
        <xsl:choose>
            <xsl:when test="Z-tego and not($contents/@xsi:nil)">
                <xsl:for-each select="Z-tego/*">
                    <xsl:call-template name="_ABC_add_tree">
                        <xsl:with-param name="column" select="$column"/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$contents"/>
                <xsl:value-of select="'+'"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Row-description">
        <xsl:param name="level"/>
        <xsl:param name="prefix"/>
        <td class="tab_row_no">
            <xsl:number count="*[starts-with(@Pozycja, $prefix)]" level="multiple" format="1.1" />.
        </td>
        <td class="row_descr">
            <xsl:value-of select="@Opis"/>
            <sup>
                <xsl:choose>
                    <xsl:when test="substring(@Indeks,string-length(@Indeks),1) = ':'">                            
                        <xsl:value-of select="substring-before(@Indeks,':')"/>:
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="@Indeks"/>
                    </xsl:otherwise>
                </xsl:choose>    
            </sup>
        </td>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="sumuj">
        <xsl:param name="wynik"/>
        <xsl:param name="format"/>
        <xsl:param name="contents"/>
        <xsl:param name="suma"/>
        <!-- Modyfikacja na potrzeby edytowania komorek -->
        <xsl:param name="komorka"/>
        <xsl:param name="blad"/>
        <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
        <xsl:choose>
            <xsl:when test="$suma!=''">
                <xsl:call-template name="sumuj">
                    <xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
                    <xsl:with-param name="format" select="$format"/>
                    <xsl:with-param name="contents" select="$contents"/>
                    <xsl:with-param name="suma" select="substring-after($suma,'+')"/>
                    <!-- Modyfikacja na potrzeby edytowania komorek -->
                    <xsl:with-param name="komorka" select="$komorka"/>
                    <xsl:with-param name="blad" select="$blad"/>
                    <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                    <!-- Modyfikacja na potrzeby edytowania komorek -->
                    <xsl:choose>
                        <xsl:when test="$komorka!='' and $komorka!='NaN'">
                            <xsl:variable name="nazwa"><xsl:value-of select="$komorka"/></xsl:variable>
                            <xsl:choose>
                                <xsl:when test="$przyciskiKomorek = 'true'">
                                    <td class="totals">
                                        <center>
                                            <xsl:choose>
                                                <xsl:when test="$FrmWersja = '' and $KomEdyt = 'false'">
                                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                        onClick="javascript: if(isIE()) window.opener.document.edytorApplet.getExchanger().returnKomorkaValue('K{$nazwa}'); else window.opener.document.embeds[0].getExchanger().returnKomorkaValue('K{$nazwa}');"/>
                                                </xsl:when>
                                                <xsl:when test="$KomEdyt = 'true'">
                                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                        onClick="javascript:window.opener.document.getElementsByName('SS_KOMORKI_EDYT@NR_KOMORKI')[0].value ='K{$nazwa}';"/>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                        onClick="javascript: if(isIE()) window.opener.document.edytorApplet.getExchanger().returnInnaKomorkaValue('{$FrmSymbol}','{$FrmWersja}','{$DataOd}','{$DataDo}', 'K{$nazwa}'); else window.opener.document.embeds[0].getExchanger().returnInnaKomorkaValue('{$FrmSymbol}','{$FrmWersja}','{$DataOd}','{$DataDo}', 'K{$nazwa}');"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </center>
                                    </td>
                                </xsl:when>
                                <xsl:otherwise>
                                    <td class="totals">
                                        <center><B>K<xsl:value-of select='$nazwa'/></B></center>
                                    </td>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                            <td class="totals">
                                <center>X</center>
                            </td>
                        </xsl:otherwise>
                    </xsl:choose>
                    <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
