<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:param name="operacja">przegladanie</xsl:param>
	<xsl:param name="przyciski">false</xsl:param>
	<xsl:param name="porownanie">false</xsl:param>
	<xsl:param name="formatowanie_kwota">###&#160;###&#160;###&#160;##0</xsl:param>
	<xsl:param name="formatowanie_liczba">##&#160;###&#160;##0</xsl:param>
	<xsl:param name="FrmSymbol"/>
	<xsl:param name="ZaOkres1"/>
	<xsl:param name="Nadawca1"/>
	<xsl:param name="Odbiorca1"/>
	<xsl:param name="WersjaZ1"/>
	<xsl:param name="ZaOkres2"/>
	<xsl:param name="Nadawca2"/>
	<xsl:param name="Odbiorca2"/>
	<xsl:param name="WersjaZ2"/>
	<xsl:param name="ImieNazwisko1" />
	<xsl:param name="Telefon1" />
	<xsl:param name="DataWykonania1" />
	<xsl:param name="ImieNazwisko2" />
	<xsl:param name="Telefon2" />
	<xsl:param name="DataWykonania2" />
	<xsl:param name="aplikacja">sac</xsl:param>
	<xsl:param name="_CSID_CONST"/>
	<xsl:param name="_CSID_VAL"/>
	<!--zmiana gsac-->
	<xsl:param name="kod_wojewodztwa">false</xsl:param>
	<!--
	=============================================================================================
	-->
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.1'"/>
	<!-- wersja arkusza XSLT -->
	<xsl:variable name="suma" select="'(sum'"/>
	<xsl:variable name="ogółem" select="'(ogółem'"/>
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="grosze" select="concat($formatowanie_kwota, ',00')"/>
	<xsl:variable name="złote" select="$formatowanie_kwota"/>
	<xsl:variable name="liczba" select="$formatowanie_liczba"/>
	<xsl:variable name="width" select="'948px'"/>
	<xsl:variable name="iloraz" select="'(ilor'"/>
	<xsl:variable name="width">
		<xsl:choose>
			<xsl:when test="$aplikacja = 'gsac'">
				<xsl:value-of select="'870px'"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'948px'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
					<xsl:choose>
						<xsl:when test="$aplikacja = 'gsac'">
							<!--zmiana gsac-->
							<link rel="stylesheet" href="../Dane/Wzorce/CSS/posilek.css"/>
						</xsl:when>
						<xsl:otherwise>
   				            .blad           {background-color: red; text-align: right}
				            .pole           {background-color: white; text-align: right}

                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
												font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>;
                                				}

                    		.cw0			{width:  340px;}
                    		.cw1			{width:  948px;}
                    		.cw2			{width:  432px;}  /*  3 * cw3  */
                    		.cw3			{width:  144px;}  /*  2 * cw4  */
                    		.cw4			{width:    72px;}
                    		.cw5			{width:  325px;}
                    		.cw6			{width:    15px;}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal;
                                					}
                   		.contents	{white-space: pre; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   		.totals     	{padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; padding-top: 24px;
                                				}
                    		.empty			{border: 0 0 0 0;}
                    		
                    		#Przyciski {top: 1em; position: absolute; overflow: auto; width: 99%; z-index: 2; cursor: default;}
							* html #Przyciski { /* IE hack */
									width: 100%;
									height: 12%;
							}
							#Sprawozdanie {top: 4em; bottom: 0em; position: absolute; overflow: auto; width: 99%; z-index: 1;}
							* html #Sprawozdanie { /* IE hack */
								height: 85%;								
								width: 100%;
							}
   	                    </xsl:otherwise>
					</xsl:choose>
				</style>
			</head>
			<body>
				<!-- Modyfikacja na potrzeby edytowania komorek -->
				<form name="SACKomorkiSprawozdania" action="/Pomost/SAC/sprawozdania/komorki/zapisz.do?operacja={$operacja}" method="POST">
					<input type="hidden" name="{$_CSID_CONST}" value="{$_CSID_VAL}"/>
					<xsl:if test="$przyciski = 'true'">
					  <div id="Przyciski">
							<xsl:choose>
								<xsl:when test="$aplikacja = 'gsac'">
									<!--zmiana gsac-->
									<input type="submit" value="Akceptuj"/>
									<xsl:value-of select="' '"/>
									<input type="submit" value="Anuluj"/>
								</xsl:when>
								<xsl:otherwise>
									<a href="javascript:document.forms[0].submit();">
										<img border="0" alt="Akceptuj" src="../../../obrazki/lista/akceptuj.gif"/>
									</a>
									<xsl:value-of select="' '"/>
									<a href="javascript:document.forms[0].action='/Pomost/SAC/sac/scalanieSprawozdan/initial.do'; document.forms[0].submit();">
										<img border="0" alt="Anuluj" src="../../../obrazki/lista/anuluj.gif"/>
									</a>
								</xsl:otherwise>
							</xsl:choose>
				  	</div>
				  </xsl:if>	
					<xsl:if test="$porownanie != 'true'">
            <div id="Sprawozdanie">
              <xsl:apply-templates select="Dożywianie"/>
            </div>
          </xsl:if> 
          <xsl:if test="$porownanie = 'true'">
            <xsl:apply-templates select="Dożywianie"/>
          </xsl:if> 
				</form>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dożywianie">
		<xsl:apply-templates select="Metryczka"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Dział_I"/>
		<xsl:apply-templates select="Dział_II"/>
		<xsl:apply-templates select="Dział_III"/>
		<xsl:apply-templates select="Dział_IV"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<!-- Modyfikacja na potrzeby edytowania komorek porownywanie-->
		<xsl:choose>
			<xsl:when test="$porownanie = 'false'">
				<xsl:if test="Opis and Opis != ''">
					<div class="reason">
						<xsl:value-of select="Opis"/>
						<br/>
						<br/>
					</div>
				</xsl:if>
				<table border="2" cellspacing="0" cellpadding="8">
					<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
					<thead>
						<tr>
							<th colspan="3">
								<span style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO PRACY I POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5, 00-513 Warszawa
						</span>
							</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td width="300">
								<span style="font-size: 11px; text-align: left;">
							Nazwa i adres jednostki sprawozdawczej:<br/>
								</span>
								<center>
									<xsl:for-each select="Nadawca">
										<table cellspacing="0" cellpadding="0">
											<tr>
												<td class="stamp" colspan="2">
													<xsl:value-of select="Pełna-nazwa"/>
												</td>
											</tr>
											<xsl:for-each select="Adres-pocztowy">
												<tr>
													<td class="stamp" colspan="2">
														<xsl:value-of select="Ulica-i-numer"/>
													</td>
												</tr>
												<tr>
													<td class="stamp" colspan="2">
														<xsl:value-of select="Kod-i-poczta"/>
													</td>
												</tr>
											</xsl:for-each>
											<tr>
												<td colspan="2" class="stamp" style="font-size: 11px; text-align: left">
													<xsl:for-each select="Telefon">
                         	        					           Tel. <xsl:apply-templates/> &#160;
								                        </xsl:for-each>
												</td>
											</tr>
											<tr>
												<td colspan="2" class="stamp" style="font-size: 11px; text-align: left">
													<xsl:for-each select="Faks">
						                                           Fax <xsl:apply-templates/> &#160;
											</xsl:for-each>
												</td>
											</tr>
										</table>
									</xsl:for-each>
								</center>
							</td>
							<td rowspan="2" style="text-align: center; font-weight: bold;">
								<p style="font-size: 18px">
									<span style="font-size: 22px">Sprawozdanie</span>
									<br/>z realizacji programu<br/>"POMOC PAŃSTWA W ZAKRESIE DOŻYWIANIA"
						</p>
						za
						<xsl:choose>
									<xsl:when test="Za-okres/Kwartał = 'I'">I-III</xsl:when>
									<xsl:when test="Za-okres/Kwartał = 'II'">I-VI</xsl:when>
									<xsl:when test="Za-okres/Kwartał = 'III'">I-IX</xsl:when>
									<xsl:otherwise>I-XII</xsl:otherwise>
								</xsl:choose>
								<xsl:value-of select="concat(' ', Za-okres/Rok, ' r.')"/>
							</td>
							<td width="300">
								<span style="font-size: 11px; text-align: left;">
							Adresat:<br/>
								</span>
								<div class="stamp">
									<xsl:value-of select="Odbiorca/Pełna-nazwa"/>
								</div>
							</td>
						</tr>
						<tr>
							<td>
								<xsl:choose>
									<xsl:when test="$kod_wojewodztwa = 'false'">
										<span style="font-size: 11px; text-align: left;">
									Numer identyfikacyjny REGON:<br/>
										</span>
										<div style="font-weight: bold; text-align: center;">
											<xsl:value-of select="Nadawca/@Kod-REGON"/>
										</div>
									</xsl:when>
									<xsl:otherwise>
										<table>
											<tbody>
												<tr>
													<td>
														<span style="font-size: 11px; text-align: left;">
												Numer identyfikacyjny REGON:
											   </span>
													</td>
													<td>
														<span style="font-weight: bold; text-align: center;">
															<xsl:value-of select="Nadawca/@Kod-REGON"/>
														</span>
													</td>
												</tr>
												<tr>
													<td>
														<span style="font-size: 11px; text-align: left;">
												Kod województwa:
												</span>
													</td>
													<td>
														<span style="font-weight: bold; text-align: center;">
															<xsl:value-of select="substring(Nadawca/@Kod-KESO, 3, 2)"/>
														</span>
													</td>
												</tr>
											</tbody>
										</table>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td>
								<div style="font-weight: bold; font-size: 13px; text-align: center;">
							Przekazać w terminie do
							<xsl:choose>
										<xsl:when test="../Nagłówek/Województwo">
									30
								</xsl:when>
										<xsl:otherwise>
									15
								</xsl:otherwise>
									</xsl:choose>
							dnia miesiąca<br/>następującego po okresie sprawozdawczym<sup>1)</sup>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
				<br/>
				<table class="wide" border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td colspan="4" class="stars">
							<sup>1)</sup>
							<font class="remark">Jeśli termin przekazania sprawozdania wypada na dzień wolny od pracy, to obowiązuje data pierwszego dnia roboczego po tym dniu.</font>
						</td>
					</tr>
				</table>
				<br/>
				<br/>
				<br/>
				<br/>
				<br/>
			</xsl:when>
			<xsl:otherwise>
				<table class="wide" border="1" cellspacing="0" cellpadding="0" width="100%">
					<thead>
						<tr>
							<th colspan="2">
								<span style="font-size: 18px; font-weight: bold;">
			                  Porównanie zawartości komórek sprawozdań o symbolu <xsl:value-of select="$FrmSymbol"/>
								</span>
							</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td width="50%">
								<table>
									<tr>
										<td>
											<B>Sprawozdanie za okres:</B>
											<xsl:value-of select="$ZaOkres1"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Nadawca:</B>
											<xsl:value-of select="$Nadawca1"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Odbiorca:</B>
											<xsl:value-of select="$Odbiorca1"/>
										</td>
									</tr>
									<xsl:if test="$WersjaZ1 != ''">
										<tr>
											<td>
												<B>Wersja z:</B> dnia <xsl:value-of select="$WersjaZ1"/>
											</td>
										</tr>
									</xsl:if>
								</table>
							</td>
							<td width="50%">
								<table>
									<tr>
										<td>
											<B>Sprawozdanie za okres:</B>
											<xsl:value-of select="$ZaOkres2"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Nadawca:</B>
											<xsl:value-of select="$Nadawca2"/>
										</td>
									</tr>
									<tr>
										<td>
											<B>Odbiorca:</B>
											<xsl:value-of select="$Odbiorca2"/>
										</td>
									</tr>
									<xsl:if test="$WersjaZ2 != ''">
										<tr>
											<td>
												<B>Wersja z:</B> dnia <xsl:value-of select="$WersjaZ2"/>
											</td>
										</tr>
									</xsl:if>
								</table>
							</td>
						</tr>
					</tbody>
				</table>
				<br/>
				<font size="-1">pola oznaczone kolorem <font color="orange">pomarańczowym</font> zawierają wartości różniących się komórek oraz procentowy przyrost wartości pierwszego sprawozdania względem drugiego</font>
				<br/>
				<br/>
				<br/>
			</xsl:otherwise>
		</xsl:choose>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek porownywanie-->
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<xsl:choose>
			<xsl:when test=" $porownanie = 'false' ">
				<table width="280">
					<caption>Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
					<tr>
						<td colspan="2">Imię i nazwisko: <b>
								<xsl:value-of select="$kto/Imię-i-nazwisko"/>
							</b>
						</td>
						<td colspan="2"/>
					</tr>
					<tr>
						<td colspan="2">Telefon: <b>
								<xsl:value-of select="$kto/Telefon"/>
							</b>
						</td>
						<td colspan="2"/>
					</tr>
					<tr>
						<td colspan="2">Data wykonania: <b>
								<xsl:value-of select="$kto/Data-wykonania"/>
							</b>
						</td>
						<td colspan="2"/>
					</tr>
				</table>
			</xsl:when>
			<xsl:otherwise>
				<table class="wide" border="1" cellspacing="0" cellpadding="0" width="100%">
				<thead>
					<tr>
						<th colspan="2" style="font-size:14px; font-weight: bold">Osoba sporządzająca</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td width="50%">
							<table>
								<tr>
									<td>
										<B>Imię i nazwisko: </B>
										<xsl:value-of select="$ImieNazwisko1" />
									</td>
								</tr>
								<tr>
									<td>
										<B>Telefon: </B>
										<xsl:value-of select="$Telefon1" />
									</td>
								</tr>
								<tr>
									<td>
										<B>Data wykonania: </B>
										<xsl:value-of select="$DataWykonania1" />
									</td>
								</tr>
							</table>
						</td>
						<td width="50%">
							<table>
								<tr>
									<td>
										<B>Imię i nazwisko: </B>
										<xsl:value-of select="$ImieNazwisko2" />
									</td>
								</tr>
								<tr>
									<td>
										<B>Telefon: </B>
										<xsl:value-of select="$Telefon2" />
									</td>
								</tr>
								<tr>
									<td>
										<B>Data wykonania: </B>
										<xsl:value-of select="$DataWykonania2" />
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</tbody>
				</table>
			</xsl:otherwise>
		</xsl:choose>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr/>
			<tr>
				<td colspan="2" class="xslt_ver" style="text-align: left;">
					Wersja szablonu XSLT: <xsl:value-of select="$wersja"/>
				</td>
				<td colspan="2" class="xslt_ver" style="text-align: right;">
					<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
					<!--xsl:if test="system-property('msxsl:version')">
						<xsl:value-of select="concat(', MSXML: ', system-property('msxsl:version'))"/>
					</xsl:if-->
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="In-line-remarks">
		<sup>
			<xsl:choose>
				<xsl:when test="./@Pozycja='_I_02'"> 1)</xsl:when>
				<xsl:when test="./@Pozycja='_I_07'"> 2)</xsl:when>
				<xsl:when test="./@Pozycja='_I_20'"> 3)</xsl:when>
				<xsl:when test="./@Pozycja='_II_05'"> 1)</xsl:when>
				<xsl:when test="./@Pozycja='_III_09'"> 3)</xsl:when>
				<xsl:when test="./@Pozycja='_III_13'"> 4)</xsl:when>
			</xsl:choose>
		</sup>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Row-description">
		<xsl:param name="level"/>
		<xsl:param name="prefix"/>
		<xsl:variable name="topbot" select="'margin-top: 4px; margin-bottom: 4px; margin-left: '"/>
		<xsl:variable name="indent" select="25"/>
		<xsl:variable name="row_clas">
			<!--zmina gsac -->
			<xsl:choose>
				<xsl:when test="$aplikacja = 'gsac'">
					<xsl:value-of select="'cw5'"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'cw5 row_descr'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<td class="{$row_clas}">
			<xsl:if test="not(preceding-sibling::*) and ../@Prefiks">
				<p>
					<xsl:attribute name="style"><xsl:value-of select="concat($topbot, string($indent * ($level - 1)), 'px;')"/></xsl:attribute>
					<xsl:value-of select="../@Prefiks"/>
					<br/>
				</p>
			</xsl:if>
			<p>
				<xsl:if test="$level &gt;= 0">
					<xsl:attribute name="style"><xsl:value-of select="concat($topbot, string($indent * $level), 'px;')"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="contains(@Opis, $suma)">
						<xsl:value-of select="substring-before(@Opis, $suma)"/>
						<br/>
						<span style="margin-top: 0.6em; font-size: 0.6em;">
							<xsl:value-of select="concat($suma, substring-after(@Opis, $suma))"/>
						</span>
					</xsl:when>
					<xsl:when test="contains(@Opis, $iloraz)">
						<xsl:value-of select="substring-before(@Opis, $iloraz)"/>
						<br/>
						<span style="margin-top: 0.6em; font-size: 0.6em;">
							<xsl:value-of select="concat($iloraz, substring-after(@Opis, $iloraz))"/>
						</span>
					</xsl:when>
					<xsl:when test="contains(@Opis, $ogółem)">
						<xsl:value-of select="substring-before(@Opis, $ogółem)"/>
						<xsl:call-template name="In-line-remarks"/>
						<br/>
						<span style="margin-top: 0.6em; font-size: 0.6em;">
							<xsl:value-of select="concat($ogółem, substring-before(substring-after(@Opis, $ogółem),'('))"/>
						</span>
						<br/>
						<span style="margin-top: 0.6em; font-size: 0.6em;">
							<xsl:value-of select="concat('(', substring-after(@Opis, ') ('))"/>
						</span>
					</xsl:when>
					<xsl:when test="not (./@Opis)">
						<xsl:value-of select="concat('uruchomione w ', /Dożywianie/Metryczka/Za-okres/Rok, ' r.')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@Opis"/>
						<xsl:call-template name="In-line-remarks"/>
					</xsl:otherwise>
				</xsl:choose>
			</p>
		</td>
		<td class="tab_row_no" style="width: 15px;">
			<xsl:value-of select="count(preceding::*[starts-with(@Pozycja, $prefix)])+
								  count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)])"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="with_format_check">
		<xsl:param name="contents"/>
		<xsl:param name="format"/>
		<xsl:choose>
			<xsl:when test="contains($contents, '.') and $format != $grosze">
				<td class="totals" style="background-color: red">
					<center>
						<xsl:value-of select="'Format!'"/>
					</center>
					<br/>
					<xsl:value-of select="format-number($contents, $grosze)"/>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($contents, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="sumuj">
		<xsl:param name="wynik"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma"/>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<xsl:choose>
			<xsl:when test="$suma!=''">
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="substring-after($suma,'+')"/>
					<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka" select="$komorka"/>
					<xsl:with-param name="blad" select="$blad"/>
					<xsl:with-param name="edit" select="$edit"/>
					<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string(number($wynik)) = 'NaN'">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$blad='true'">
						                                    blad
						                </xsl:when>
										<xsl:otherwise>
						                                    pole
						                </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$edit='true'">
										<td class="totals" style="background-color: red">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="'suma: NaN'"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<center>X</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals" style="background-color: red">
											<center>X</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:when test="string(number($contents)) != 'NaN'">
						<xsl:choose>
							<xsl:when test="$contents != $wynik">
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$komorka!='' and $komorka!='NaN'">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$contents"/>
										</xsl:variable>
										<xsl:variable name="class">
											<xsl:choose>
												<xsl:when test="$blad='true'">
						                                    blad
						                            </xsl:when>
												<xsl:otherwise>
						                                    pole
						                            </xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$edit='true'">
												<td class="contents" style="background-color: red">
													<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
													<br/>
													<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents" style="background-color: red">
													<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
													<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
													<br/>
													<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$porownanie = 'true'">
												<xsl:choose>
													<xsl:when test="$blad='true'">
														<td class="contents" style="background-color: orange">
															<xsl:value-of select="$contents"/>
														</td>
													</xsl:when>
													<xsl:otherwise>
														<td class="totals">
															<xsl:value-of select="$contents"/>
														</td>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents" style="background-color: red">
													<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
													<br/>
													<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:when>
							<xsl:otherwise>
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$komorka!='' and $komorka!='NaN'">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$contents"/>
										</xsl:variable>
										<xsl:variable name="class">
											<xsl:choose>
												<xsl:when test="$blad='true'">
						                                    blad
						                            </xsl:when>
												<xsl:otherwise>
						                                    pole
						                            </xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$edit='true'">
												<td class="totals">
													<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$porownanie = 'true'">
												<xsl:choose>
													<xsl:when test="$blad='true'">
														<td class="contents" style="background-color: orange">
															<xsl:value-of select="$contents"/>
														</td>
													</xsl:when>
													<xsl:otherwise>
														<td class="totals">
															<xsl:value-of select="$contents"/>
														</td>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="with_format_check">
													<xsl:with-param name="format" select="$format"/>
													<xsl:with-param name="contents" select="$contents"/>
												</xsl:call-template>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$komorka!='' and $komorka!='NaN'">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$contents"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$blad='true'">
						                                    blad
						                </xsl:when>
										<xsl:otherwise>
						                                    pole
						                </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$edit='true'">
										<td class="totals">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<input type="edit" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="$contents"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="$contents"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="with_format_check">
											<xsl:with-param name="format" select="$format"/>
											<xsl:with-param name="contents" select="$wynik"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_I">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_II">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_III">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_IV">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Dział">
		<xsl:param name="chapter" select="substring-after(name(.), '_')"/>
		<div>
			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:value-of select="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('DZIAŁ ', $chapter, '.&#160;&#160;',@Opis)"/>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:choose><xsl:when test="Inf-dot-kosztów">'600'</xsl:when><xsl:when test="Inf-dot-świadczeń">'750'</xsl:when><xsl:otherwise>'$width'</xsl:otherwise></xsl:choose></xsl:attribute>
			<thead>
				<tr>
					<th>
						<xsl:attribute name="colspan"><xsl:choose><xsl:when test="Inf-dot-kosztów">4</xsl:when><xsl:when test="Inf-dot-świadczeń">6</xsl:when><xsl:otherwise>10</xsl:otherwise></xsl:choose></xsl:attribute>
						PROGRAM "POMOC PAŃSTWA W ZAKRESIE DOŻYWIANIA"
					</th>
				</tr>
				<tr>
					<th class="cw0" colspan="2">
						<xsl:attribute name="rowspan"><xsl:choose><xsl:when test="Inf-ogółem">3</xsl:when><xsl:when test="Inf-dot-posiłków">4</xsl:when><xsl:when test="Inf-dot-świadczeń">2</xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose></xsl:attribute>
						WYSZCZEGÓLNIENIE
					</th>
					<xsl:choose>
						<xsl:when test="Inf-ogółem">
							<th class="cw4" rowspan="3">OGÓŁEM</th>
							<th class="cw4" rowspan="3">w tym na wsi</th>
							<th class="cw2" colspan="6">w tym:</th>
						</xsl:when>
						<xsl:when test="Inf-dot-posiłków">
							<th colspan="8">POSIŁEK <sup>1) 2)</sup>
							</th>
						</xsl:when>
						<xsl:when test="Inf-dot-świadczeń">
							<th class="cw3" colspan="2">ZASIŁEK CELOWY</th>
							<th class="cw3" colspan="2">ŚWIADCZENIE RZECZOWE</th>
						</xsl:when>
						<xsl:otherwise>
							<th class="cw4">OGÓŁEM<br/>(w&#160;zł)&#160;<sup>1)</sup>
							</th>
							<th class="cw4">w tym na wsi<br/>(w&#160;zł)&#160;<sup>1)</sup>
							</th>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
				<xsl:if test="Inf-dot-posiłków">
					<th class="cw4" rowspan="3">OGÓŁEM</th>
					<th class="cw4" rowspan="3">w tym na wsi</th>
					<th class="cw2" colspan="6">w tym:</th>
				</xsl:if>
				<xsl:if test="not (Inf-dot-kosztów)">
					<xsl:if test="Inf-ogółem or Inf-dot-posiłków">
						<tr>
							<th class="cw3" colspan="2">dzieci do 7 roku życia</th>
							<th class="cw3" colspan="2">uczniowie do czasu ukończenia szkoły ponadgimnazjalnej</th>
							<th class="cw3" colspan="2">pozostałe osoby otrzymujące pomoc na podstawie art. 7 ustawy o&#160;pomocy społecznej</th>
						</tr>
					</xsl:if>
					<tr>
						<xsl:if test="not (Inf-dot-świadczeń)">
							<th class="cw4">OGÓŁEM</th>
							<th class="cw4">w tym na wsi</th>
						</xsl:if>
						<!--th class="cw4">OGÓŁEM</th>
						<th class="cw4">w tym na wsi</th-->
						<th class="cw4">OGÓŁEM</th>
						<th class="cw4">w tym na wsi</th>
						<th class="cw4">OGÓŁEM</th>
						<th class="cw4">w tym na wsi</th>
					</tr>
				</xsl:if>
				<tr>
					<td class="tab_col_no" colspan="2">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<xsl:if test="not (Inf-dot-kosztów)">
						<td class="tab_col_no">4</td>
						<td class="tab_col_no">5</td>
						<xsl:if test="not (Inf-dot-świadczeń)">
							<td class="tab_col_no">6</td>
							<td class="tab_col_no">7</td>
							<td class="tab_col_no">8</td>
							<td class="tab_col_no">9</td>
						</xsl:if>
					</xsl:if>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Inf-ogółem">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Inf-dot-świadczeń">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Inf-dot-posiłków">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Inf-dot-kosztów">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
			</tbody>
		</table>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<xsl:choose>
				<xsl:when test="Inf-ogółem">
					<tr>
						<td colspan="4" class="stars">1) <font class="remark">należy uwzględnić również liczbę osób korzystających z posiłku z częściową odpłatnością.</font>
						</td>
					</tr>
					<tr>
						<td colspan="4" class="stars">2) <font class="remark">kwotę należy podać w zaokrągleniu do 1 zł.</font>
						</td>
					</tr>
					<tr>
						<td colspan="4" class="stars">3) <font class="remark">liczbę placówek wykazuje tylko ta gmina, na terenie której znajduje się placówka.</font>
						</td>
					</tr>
				</xsl:when>
				<xsl:when test="Inf-dot-posiłków">
					<tr>
						<td colspan="4" class="stars">1) <font class="remark">w przypadku posiłku informacje z decyzji należy skorygować o faktyczną realizację tego świadczenia.</font>
						</td>
					</tr>
					<tr>
						<td colspan="4" class="stars">2) <font class="remark">należy uwzględnić również informacje dotyczące osób korzystających z posiłku z częściową odpłatnością.</font>
						</td>
					</tr>
					<tr>
						<td colspan="4" class="stars">3) <font class="remark">przyznane decyzją całodzienne wyżywienie realizowane np. w przedszkolu należy traktować jako jedno świadczenie.</font>
						</td>
					</tr>
					<tr>
						<td colspan="4" class="stars">4) <font class="remark">koszt posiłków należy podać w zaokrągleniu do 1 zł.</font>
						</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td colspan="4" class="stars">1) <font class="remark">kwotę należy podać w zaokrągleniu do 1 zł.</font>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-ogółem">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_I_'"/>
			</xsl:call-template>
			<xsl:call-template name="_III_contents"/>
		</tr>
		<xsl:apply-templates select="*/Inf-ogółem">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-dot-świadczeń">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_II_'"/>
			</xsl:call-template>
			<xsl:call-template name="_II_contents"/>
		</tr>
		<xsl:apply-templates select="*/Inf-dot-świadczeń">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-dot-posiłków">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_III_'"/>
			</xsl:call-template>
			<xsl:call-template name="_III_contents"/>
		</tr>
		<xsl:apply-templates select="*/Inf-dot-posiłków">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-dot-kosztów">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_IV_'"/>
			</xsl:call-template>
			<xsl:call-template name="_III_contents"/>
		</tr>
		<xsl:apply-templates select="*/Inf-dot-kosztów">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Rozbicie">
		<xsl:param name="format"/>
		<xsl:param name="subtree" select="name(.)"/>
		<xsl:choose>
			<xsl:when test="./@xsi:nil = 'true'">
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="_2_level">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="'Ogółem'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
				<xsl:call-template name="_2_level">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="'Na-wsi'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_II_contents">
		<xsl:param name="format">
			<xsl:choose>
				<xsl:when test="@Grosze='false'">
					<xsl:value-of select="$złote"/>
				</xsl:when>
				<xsl:when test="@Grosze='true'">
					<xsl:value-of select="$grosze"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$liczba"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<xsl:for-each select="Dane/*">
			<xsl:call-template name="_0_level">
				<xsl:with-param name="subtree" select="name(.)"/>
				<xsl:with-param name="column" select="'Ogółem'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
			<xsl:call-template name="_0_level">
				<xsl:with-param name="subtree" select="name(.)"/>
				<xsl:with-param name="column" select="'Na-wsi'"/>
				<xsl:with-param name="format" select="$format"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_III_contents">
		<xsl:param name="subtree" select="'Dane'"/>
		<xsl:param name="format">
			<xsl:choose>
				<xsl:when test="@Grosze='false'">
					<xsl:value-of select="$złote"/>
				</xsl:when>
				<xsl:when test="@Grosze='true'">
					<xsl:value-of select="$grosze"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$liczba"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="Dane/Ogółem">
				<xsl:call-template name="_1_level">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="'Ogółem'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
				<xsl:call-template name="_1_level">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="'Na-wsi'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="Dane/Rozbicie/@xsi:nil='true'">
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
				<td class="contents">
					<center>X</center>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="Dane/Rozbicie/*">
					<xsl:call-template name="Rozbicie">
						<xsl:with-param name="format" select="$format"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_level">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="../../../Z-tego and not($item/@xsi:nil)">
				<xsl:call-template name="_2_totals">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka">
						<xsl:value-of select="$item/@Komorka"/>
					</xsl:with-param>
					<xsl:with-param name="blad">
						<xsl:value-of select="$item/@Blad"/>
					</xsl:with-param>
					<xsl:with-param name="edit">
						<xsl:value-of select="$item/@Edit"/>
					</xsl:with-param>
					<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="contains($contents, '.') and $format != $grosze">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                        blad
						                </xsl:when>
										<xsl:otherwise>
						                        pole
						                </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents" style="background-color: red">
											<center>
												<xsl:value-of select="'Format!'"/>
											</center>
											<br/>
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<center>
												<xsl:value-of select="'Format!'"/>
											</center>
											<br/>
											<xsl:value-of select="format-number($contents, $grosze)"/>
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<center>
												<xsl:value-of select="'Format!'"/>
											</center>
											<br/>
											<xsl:value-of select="format-number($contents, $grosze)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:when test="../../../@Pozycja = '_II_11'">
						<xsl:choose>
							<xsl:when test="../../../../*[@Pozycja='_II_04']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] = 0">
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$item/@Komorka">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$item/@Komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$item"/>
										</xsl:variable>
										<xsl:variable name="class">
											<xsl:choose>
												<xsl:when test="$item/@Blad='true'">
						                                  blad
						                    </xsl:when>
												<xsl:otherwise>
						                                pole
						                    </xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$item/@Edit='true'">
												<td class="totals">
													<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
													<center>
														<xsl:value-of select="'???'"/>
													</center>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$porownanie = 'true'">
												<xsl:choose>
													<xsl:when test="$item/@Blad='true'">
														<td class="contents" style="background-color: orange">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:when>
													<xsl:otherwise>
														<td class="totals">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<center>
														<xsl:value-of select="'???'"/>
													</center>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:when>
							<xsl:when test="format-number($item, $format) !=
									format-number(round(100 * (../../../../*[@Pozycja='_II_08']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] div
															 ../../../../*[@Pozycja='_II_04']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column])) div 100, $format)">
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$item/@Komorka">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$item/@Komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$item"/>
										</xsl:variable>
										<xsl:variable name="class">
											<xsl:choose>
												<xsl:when test="$item/@Blad='true'">
						                                blad
						                            </xsl:when>
												<xsl:otherwise>
						                                pole
						                            </xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$item/@Edit='true'">
												<td class="contents" style="background-color: red">
													<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
													<br/>
													<xsl:value-of select="concat('8/4: ', format-number(round(100 * (../../../../*[@Pozycja='_II_08']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] div
																                                            ../../../../*[@Pozycja='_II_04']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column])) div 100, $format))"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents" style="background-color: red">
													<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
													<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
													<br/>
													<xsl:value-of select="concat('8/4: ', format-number(round(100 * (../../../../*[@Pozycja='_II_08']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] div
																                                            ../../../../*[@Pozycja='_II_04']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column])) div 100, $format))"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$porownanie = 'true'">
												<xsl:choose>
													<xsl:when test="$item/@Blad='true'">
														<td class="contents" style="background-color: orange">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:when>
													<xsl:otherwise>
														<td class="totals">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents" style="background-color: red">
													<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
													<br/>
													<xsl:value-of select="concat('8/4: ', format-number(round(100 * (../../../../*[@Pozycja='_II_08']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] div
																                                        ../../../../*[@Pozycja='_II_04']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column])) div 100, $format))"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:when>
							<xsl:otherwise>
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$item/@Komorka">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$item/@Komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$item"/>
										</xsl:variable>
										<xsl:variable name="class">
											<xsl:choose>
												<xsl:when test="$item/@Blad='true'">
						                                blad
						                            </xsl:when>
												<xsl:otherwise>
						                                pole
						                            </xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$item/@Edit='true'">
												<td class="totals">
													<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
													<xsl:value-of select="format-number($contents, $format)"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$porownanie = 'true'">
												<xsl:choose>
													<xsl:when test="$item/@Blad='true'">
														<td class="contents" style="background-color: orange">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:when>
													<xsl:otherwise>
														<td class="totals">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="format-number($contents, $format)"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="../../../@Pozycja = '_III_16'">
						<xsl:choose>
							<xsl:when test="../../../../*[@Pozycja='_III_08']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] = 0">
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$item/@Komorka">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$item/@Komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$item"/>
										</xsl:variable>
										<xsl:variable name="class">
											<xsl:choose>
												<xsl:when test="$item/@Blad='true'">
						                                  blad
						                    </xsl:when>
												<xsl:otherwise>
						                                pole
						                    </xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$item/@Edit='true'">
												<td class="totals">
													<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
													<center>
														<xsl:value-of select="'???'"/>
													</center>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$porownanie = 'true'">
												<xsl:choose>
													<xsl:when test="$item/@Blad='true'">
														<td class="contents" style="background-color: orange">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:when>
													<xsl:otherwise>
														<td class="totals">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<center>
														<xsl:value-of select="'???'"/>
													</center>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:when>
							<xsl:when test="format-number($item, $format) !=
									format-number(round(100 * (../../../../*[@Pozycja='_III_13']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] div
												  ../../../../*[@Pozycja='_III_08']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column])) div 100, $format)">
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$item/@Komorka">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$item/@Komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$item"/>
										</xsl:variable>
										<xsl:variable name="class">
											<xsl:choose>
												<xsl:when test="$item/@Blad='true'">
						                                blad
						                            </xsl:when>
												<xsl:otherwise>
						                                pole
						                            </xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$item/@Edit='true'">
												<td class="contents" style="background-color: red">
													<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
													<br/>
													<xsl:value-of select="concat('13/8: ',
											                                            format-number(round(100 * (../../../../*[@Pozycja='_III_13']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] div
														                                              ../../../../*[@Pozycja='_III_08']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column])) div 100, $format))"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents" style="background-color: red">
													<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
													<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
													<br/>
													<xsl:value-of select="concat('13/8: ',
											                                            format-number(round(100 * (../../../../*[@Pozycja='_III_13']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] div
														                                              ../../../../*[@Pozycja='_III_08']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column])) div 100, $format))"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$porownanie = 'true'">
												<xsl:choose>
													<xsl:when test="$item/@Blad='true'">
														<td class="contents" style="background-color: orange">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:when>
													<xsl:otherwise>
														<td class="totals">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents" style="background-color: red">
													<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
													<br/>
													<xsl:value-of select="concat('13/8: ',
											                                            format-number(round(100 * (../../../../*[@Pozycja='_III_13']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column] div
														                                              ../../../../*[@Pozycja='_III_08']/Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column])) div 100, $format))"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:when>
							<xsl:otherwise>
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$item/@Komorka">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$item/@Komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$item"/>
										</xsl:variable>
										<xsl:variable name="class">
											<xsl:choose>
												<xsl:when test="$item/@Blad='true'">
						                                  blad
						                    </xsl:when>
												<xsl:otherwise>
						                                pole
						                    </xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$item/@Edit='true'">
												<td class="totals">
													<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
													<xsl:value-of select="format-number($contents, $format)"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$porownanie = 'true'">
												<xsl:choose>
													<xsl:when test="$item/@Blad='true'">
														<td class="contents" style="background-color: orange">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:when>
													<xsl:otherwise>
														<td class="totals">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="format-number($contents, $format)"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                                blad
						                            </xsl:when>
										<xsl:otherwise>
						                                pole
						                            </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="totals">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_totals">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="../../../Z-tego/*">
				<xsl:call-template name="_2_add_trees">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
			<!-- Modyfikacja na potrzeby edytowania komorek -->
			<xsl:with-param name="komorka" select="$komorka"/>
			<xsl:with-param name="blad" select="$blad"/>
			<xsl:with-param name="edit" select="$edit"/>
			<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_add_trees">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents" select="Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_2_add_trees">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_1_level">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="Z-tego and not($item/@xsi:nil)">
				<xsl:choose>
					<xsl:when test="@Pozycja = '_I_07'">
						<xsl:choose>
							<xsl:when test="format-number($item, $format) !=
											format-number(sum(../../*/*[@Pozycja=  '_II_05']/*/*/*[name(.) = $column]) +
																			 ../../*/*[@Pozycja= '_III_13']/*/*[name(.) = $column] +
																			 ../../*/*[@Pozycja='_IV_01']/*/*[name(.) = $column], $format)">
								<!-- Modyfikacja na potrzeby edytowania komorek -->
								<xsl:choose>
									<xsl:when test="$item/@Komorka">
										<xsl:variable name="nazwa">
											<xsl:value-of select="$item/@Komorka"/>
										</xsl:variable>
										<xsl:variable name="wartosc">
											<xsl:value-of select="$item"/>
										</xsl:variable>
										<xsl:variable name="class">
											<xsl:choose>
												<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
												<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$item/@Edit='true'">
												<td class="contents" style="background-color: red">
													<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
													<br/>
													<xsl:value-of select="concat('II+III+IV: ',
											                                                 format-number(sum(../../*/*[@Pozycja=  '_II_05']/*/*/*[name(.) = $column]) +
																			                                   ../../*/*[@Pozycja= '_III_13']/*/*[name(.) = $column] +
																			                                   ../../*/*[@Pozycja='_IV_01']/*/*[name(.) = $column], $format))"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents" style="background-color: red">
													<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
													<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
													<br/>
													<xsl:value-of select="concat('II+III+IV: ',
											                                                 format-number(sum(../../*/*[@Pozycja=  '_II_05']/*/*/*[name(.) = $column]) +
																			                                   ../../*/*[@Pozycja= '_III_13']/*/*[name(.) = $column] +
																			                                   ../../*/*[@Pozycja='_IV_01']/*/*[name(.) = $column], $format))"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="$porownanie = 'true'">
												<xsl:choose>
													<xsl:when test="$item/@Blad='true'">
														<td class="contents" style="background-color: orange">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:when>
													<xsl:otherwise>
														<td class="contents">
															<xsl:value-of select="$item"/>
														</td>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents" style="background-color: red">
													<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
													<br/>
													<xsl:value-of select="concat('II+III+IV: ',
											                                                 format-number(sum(../../*/*[@Pozycja=  '_II_05']/*/*/*[name(.) = $column]) +
																			                                   ../../*/*[@Pozycja= '_III_13']/*/*[name(.) = $column] +
																			                                   ../../*/*[@Pozycja='_IV_01']/*/*[name(.) = $column], $format))"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="_1_totals">
									<xsl:with-param name="subtree" select="$subtree"/>
									<xsl:with-param name="column" select="$column"/>
									<xsl:with-param name="contents" select="$contents"/>
									<xsl:with-param name="format" select="$format"/>
									<!-- Modyfikacja na potrzeby edytowania komorek -->
									<xsl:with-param name="komorka">
										<xsl:value-of select="$item/@Komorka"/>
									</xsl:with-param>
									<xsl:with-param name="blad">
										<xsl:value-of select="$item/@Blad"/>
									</xsl:with-param>
									<xsl:with-param name="edit">
										<xsl:value-of select="$item/@Edit"/>
									</xsl:with-param>
									<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="_1_totals">
							<xsl:with-param name="subtree" select="$subtree"/>
							<xsl:with-param name="column" select="$column"/>
							<xsl:with-param name="contents" select="$contents"/>
							<xsl:with-param name="format" select="$format"/>
							<!-- Modyfikacja na potrzeby edytowania komorek -->
							<xsl:with-param name="komorka">
								<xsl:value-of select="$item/@Komorka"/>
							</xsl:with-param>
							<xsl:with-param name="blad">
								<xsl:value-of select="$item/@Blad"/>
							</xsl:with-param>
							<xsl:with-param name="edit">
								<xsl:value-of select="$item/@Edit"/>
							</xsl:with-param>
							<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="contains($contents, '.') and $format != $grosze">
				<!-- Modyfikacja na potrzeby edytowania komorek -->
				<xsl:choose>
					<xsl:when test="$item/@Komorka">
						<xsl:variable name="nazwa">
							<xsl:value-of select="$item/@Komorka"/>
						</xsl:variable>
						<xsl:variable name="wartosc">
							<xsl:value-of select="$item"/>
						</xsl:variable>
						<xsl:variable name="class">
							<xsl:choose>
								<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
								<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$item/@Edit='true'">
								<td class="contents" style="background-color: red">
									<center>
										<xsl:value-of select="'Format!'"/>
									</center>
									<br/>
									<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="contents" style="background-color: red">
									<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
									<center>
										<xsl:value-of select="'Format!'"/>
									</center>
									<br/>
									<xsl:value-of select="format-number($contents, $grosze)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$porownanie = 'true'">
								<xsl:choose>
									<xsl:when test="$item/@Blad='true'">
										<td class="contents" style="background-color: orange">
											<xsl:value-of select="$item"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="$item"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<td class="contents" style="background-color: red">
									<center>
										<xsl:value-of select="'Format!'"/>
									</center>
									<br/>
									<xsl:value-of select="format-number($contents, $grosze)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</xsl:when>
			<xsl:when test="@Pozycja = '_I_04'">
				<xsl:choose>
					<xsl:when test="format-number($item, $format) !=
							format-number(../../../../*/*[@Pozycja='_II_03']/*/Zasiłek-celowy/*[name(.) = $column], $format)">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents" style="background-color: red">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="concat('w II: ',
									                              format-number(../../../../*/*[@Pozycja='_II_03']/*/Zasiłek-celowy/*[name(.) = $column], $format))"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('w II: ',
									                              format-number(../../../../*/*[@Pozycja='_II_03']/*/Zasiłek-celowy/*[name(.) = $column], $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('w II: ',
									                              format-number(../../../../*/*[@Pozycja='_II_03']/*/Zasiłek-celowy/*[name(.) = $column], $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="totals">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@Pozycja = '_I_05'">
				<xsl:choose>
					<xsl:when test="format-number($item, $format) !=
							format-number(../../../../*/*[@Pozycja='_II_03']/*/Świadczenie-rzeczowe/*[name(.) = $column], $format)">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents" style="background-color: red">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="concat('w II: ',
									                              format-number(../../../../*/*[@Pozycja='_II_03']/*/Świadczenie-rzeczowe/*[name(.) = $column], $format))"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('w II: ',
									                              format-number(../../../../*/*[@Pozycja='_II_03']/*/Świadczenie-rzeczowe/*[name(.) = $column], $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('w II: ',
									                              format-number(../../../../*/*[@Pozycja='_II_03']/*/Świadczenie-rzeczowe/*[name(.) = $column], $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="totals">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@Pozycja = '_I_08'">
				<xsl:choose>
					<xsl:when test="format-number($item, $format) !=
									format-number(sum(../../../../*/*/*/*[@Pozycja=  '_II_06']/*/*/*[name(.) = $column]) +
																	 ../../../../*/*/*/*[@Pozycja= '_III_14']/*/*[name(.) = $column] +
																	 ../../../../*/*/*/*[@Pozycja='_IV_02']/*/*[name(.) = $column], $format)">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents" style="background-color: red">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="concat('II+III+IV: ',
									                              format-number(sum(../../../../*/*/*/*[@Pozycja=  '_II_06']/*/*/*[name(.) = $column]) +
																	                ../../../../*/*/*/*[@Pozycja= '_III_14']/*/*[name(.) = $column] +
																	                ../../../../*/*/*/*[@Pozycja='_IV_02']/*/*[name(.) = $column], $format))"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('II+III+IV: ',
									                              format-number(sum(../../../../*/*/*/*[@Pozycja=  '_II_06']/*/*/*[name(.) = $column]) +
																	                ../../../../*/*/*/*[@Pozycja= '_III_14']/*/*[name(.) = $column] +
																	                ../../../../*/*/*/*[@Pozycja='_IV_02']/*/*[name(.) = $column], $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('II+III+IV: ',
									                              format-number(sum(../../../../*/*/*/*[@Pozycja=  '_II_06']/*/*/*[name(.) = $column]) +
																	                ../../../../*/*/*/*[@Pozycja= '_III_14']/*/*[name(.) = $column] +
																	                ../../../../*/*/*/*[@Pozycja='_IV_02']/*/*[name(.) = $column], $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="totals">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@Pozycja = '_I_09'">
				<xsl:choose>
					<xsl:when test="format-number($item, $format) !=
									format-number(sum(../../../../*/*/*/*[@Pozycja=  '_II_07']/*/*/*[name(.) = $column]) +
																	 ../../../../*/*/*/*[@Pozycja= '_III_15']/*/*[name(.) = $column] +
																	 ../../../../*/*/*/*[@Pozycja='_IV_03']/*/*[name(.) = $column], $format)">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents" style="background-color: red">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="concat('II+III+IV: ',
									                              format-number(sum(../../../../*/*/*/*[@Pozycja=  '_II_07']/*/*/*[name(.) = $column]) +
																	                ../../../../*/*/*/*[@Pozycja= '_III_15']/*/*[name(.) = $column] +
																	                ../../../../*/*/*/*[@Pozycja='_IV_03']/*/*[name(.) = $column], $format))"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('II+III+IV: ',
									                              format-number(sum(../../../../*/*/*/*[@Pozycja=  '_II_07']/*/*/*[name(.) = $column]) +
																	                ../../../../*/*/*/*[@Pozycja= '_III_15']/*/*[name(.) = $column] +
																	                ../../../../*/*/*/*[@Pozycja='_IV_03']/*/*[name(.) = $column], $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('II+III+IV: ',
									                              format-number(sum(../../../../*/*/*/*[@Pozycja=  '_II_07']/*/*/*[name(.) = $column]) +
																	                ../../../../*/*/*/*[@Pozycja= '_III_15']/*/*[name(.) = $column] +
																	                ../../../../*/*/*/*[@Pozycja='_IV_03']/*/*[name(.) = $column], $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="totals">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@Pozycja = '_III_16'">
				<xsl:choose>
					<xsl:when test="../*[@Pozycja='_III_08']/Dane/*[name(.) = $column] = 0">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="totals">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<center>
												<xsl:value-of select="'???'"/>
											</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<center>
												<xsl:value-of select="'???'"/>
											</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:when test="format-number($item, $format) !=
									format-number(../*[@Pozycja='_III_13']/Dane/*[name(.) = $column] div
															 ../*[@Pozycja='_III_08']/Dane/*[name(.) = $column], $format)">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents" style="background-color: red">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="concat('13/8: ',
											                      format-number(../*[@Pozycja='_III_13']/Dane/*[name(.) = $column] div
																	            ../*[@Pozycja='_III_08']/Dane/*[name(.) = $column], $format))"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('13/8: ',
											                      format-number(../*[@Pozycja='_III_13']/Dane/*[name(.) = $column] div
																	            ../*[@Pozycja='_III_08']/Dane/*[name(.) = $column], $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('13/8: ',
											                      format-number(../*[@Pozycja='_III_13']/Dane/*[name(.) = $column] div
																	            ../*[@Pozycja='_III_08']/Dane/*[name(.) = $column], $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="totals">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string($item/@xsi:nil) = 'true'">
						<td class="contents">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_totals">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="Z-tego/*">
				<xsl:call-template name="_1_add_trees">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
			<!-- Modyfikacja na potrzeby edytowania komorek -->
			<xsl:with-param name="komorka" select="$komorka"/>
			<xsl:with-param name="blad" select="$blad"/>
			<xsl:with-param name="edit" select="$edit"/>
			<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_add_trees">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_1_add_trees">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_0_level">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="../../Z-tego">
				<xsl:call-template name="_0_totals">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka">
						<xsl:value-of select="$item/@Komorka"/>
					</xsl:with-param>
					<xsl:with-param name="blad">
						<xsl:value-of select="$item/@Blad"/>
					</xsl:with-param>
					<xsl:with-param name="edit">
						<xsl:value-of select="$item/@Edit"/>
					</xsl:with-param>
					<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="contains($contents, '.') and $format != $grosze">
				<!-- Modyfikacja na potrzeby edytowania komorek -->
				<xsl:choose>
					<xsl:when test="$item/@Komorka">
						<xsl:variable name="nazwa">
							<xsl:value-of select="$item/@Komorka"/>
						</xsl:variable>
						<xsl:variable name="wartosc">
							<xsl:value-of select="$item"/>
						</xsl:variable>
						<xsl:variable name="class">
							<xsl:choose>
								<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
								<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$item/@Edit='true'">
								<td class="contents" style="background-color: red">
									<center>
										<xsl:value-of select="'Format!'"/>
									</center>
									<br/>
									<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="contents" style="background-color: red">
									<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
									<center>
										<xsl:value-of select="'Format!'"/>
									</center>
									<br/>
									<xsl:value-of select="format-number($contents, $grosze)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$porownanie = 'true'">
								<xsl:choose>
									<xsl:when test="$item/@Blad='true'">
										<td class="contents" style="background-color: orange">
											<xsl:value-of select="$item"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="$item"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<td class="contents" style="background-color: red">
									<center>
										<xsl:value-of select="'Format!'"/>
									</center>
									<br/>
									<xsl:value-of select="format-number($contents, $grosze)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</xsl:when>
			<xsl:when test="../../@Pozycja = '_II_08'">
				<xsl:choose>
					<xsl:when test="string(@xsi:nil) = 'true'">
						<td class="contents">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:when test="../../../*[@Pozycja='_II_04']/Dane/*[name(.) = $subtree]/*[name(.) = $column] = 0">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="totals">
											<center>
												<xsl:value-of select="'Format!'"/>
											</center>
											<br/>
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<center>
												<xsl:value-of select="'???'"/>
											</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<center>
												<xsl:value-of select="'???'"/>
											</center>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:when test="format-number($item, $format) !=
							format-number(../../../*[@Pozycja='_II_05']/Dane/*[name(.) = $subtree]/*[name(.) = $column] div
													 ../../../*[@Pozycja='_II_04']/Dane/*[name(.) = $subtree]/*[name(.) = $column], $format)">
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents" style="background-color: red">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
											<br/>
											<xsl:value-of select="concat('5/4: ',
									                                                format-number(../../../*[@Pozycja='_II_05']/Dane/*[name(.) = $subtree]/*[name(.) = $column] div
															                                      ../../../*[@Pozycja='_II_04']/Dane/*[name(.) = $subtree]/*[name(.) = $column], $format))"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('5/4: ',
									                                                format-number(../../../*[@Pozycja='_II_05']/Dane/*[name(.) = $subtree]/*[name(.) = $column] div
															                                      ../../../*[@Pozycja='_II_04']/Dane/*[name(.) = $subtree]/*[name(.) = $column], $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents" style="background-color: red">
											<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
											<br/>
											<xsl:value-of select="concat('5/4: ',
									                                                format-number(../../../*[@Pozycja='_II_05']/Dane/*[name(.) = $subtree]/*[name(.) = $column] div
															                                      ../../../*[@Pozycja='_II_04']/Dane/*[name(.) = $subtree]/*[name(.) = $column], $format))"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="totals">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="totals">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string(@xsi:nil) = 'true'">
						<td class="contents">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<!-- Modyfikacja na potrzeby edytowania komorek -->
						<xsl:choose>
							<xsl:when test="$item/@Komorka">
								<xsl:variable name="nazwa">
									<xsl:value-of select="$item/@Komorka"/>
								</xsl:variable>
								<xsl:variable name="wartosc">
									<xsl:value-of select="$item"/>
								</xsl:variable>
								<xsl:variable name="class">
									<xsl:choose>
										<xsl:when test="$item/@Blad='true'">
						                            blad
						                        </xsl:when>
										<xsl:otherwise>
						                            pole
						                        </xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="$item/@Edit='true'">
										<td class="contents">
											<input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$porownanie = 'true'">
										<xsl:choose>
											<xsl:when test="$item/@Blad='true'">
												<td class="contents" style="background-color: orange">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="contents">
													<xsl:value-of select="$item"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<td class="contents">
											<xsl:value-of select="format-number($contents, $format)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_0_totals">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="../../Z-tego/*">
				<xsl:call-template name="_0_add_trees">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
		<xsl:param name="edit"/>
		<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
			<!-- Modyfikacja na potrzeby edytowania komorek -->
			<xsl:with-param name="komorka" select="$komorka"/>
			<xsl:with-param name="blad" select="$blad"/>
			<xsl:with-param name="edit" select="$edit"/>
			<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_0_add_trees">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents" select="Dane/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_0_add_trees">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
