<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:msxsl="urn:schemas-microsoft-com:xslt">
    <!-- 
    =============================================================================================
    -->
    <xsl:param name="operacja">przegladanie</xsl:param>
    <xsl:param name="przyciski">false</xsl:param>
    <xsl:param name="porownanie">false</xsl:param>
    <xsl:param name="formatowanie_kwota">###&#160;###&#160;###&#160;##0</xsl:param>
    <xsl:param name="formatowanie_liczba">##&#160;###&#160;##0</xsl:param>
    <xsl:param name="FrmSymbol"/>
    <xsl:param name="ZaOkres1"/>
    <xsl:param name="Nadawca1"/>
    <xsl:param name="Odbiorca1"/>
    <xsl:param name="WersjaZ1"/>
    <xsl:param name="ZaOkres2"/>
    <xsl:param name="Nadawca2"/>
    <xsl:param name="Odbiorca2"/>
    <xsl:param name="WersjaZ2"/>
    <xsl:param name="aplikacja">gmina</xsl:param>
    <!--zmiana gmina-->
    <xsl:param name="kod_wojewodztwa">false</xsl:param>
    <!--
	=============================================================================================
	-->
    <xsl:variable name="wersja" select="'1.1'"/>
    <xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
    <xsl:variable name="kwota" select="$formatowanie_kwota"/>
    <xsl:variable name="liczba" select="$formatowanie_liczba"/>
    <xsl:variable name="suma" select="'(w. '"/>
    <xsl:variable name="width">
        <xsl:choose>
            <xsl:when test="$aplikacja = 'gmina'">
                <xsl:value-of select="'727'"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="'944'"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!--
	=============================================================================================
	-->
    <xsl:template match="/">
        <html>
            <head>
                <style type="text/css">
                            .blad           {background-color: red; text-align: right}
				            .pole           {background-color: white; text-align: right}
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								                font-weight: bold; text-align: center; border-width: 0px;
                                 				width: <xsl:value-of select="$width"/>px; padding: 5px;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: normal; text-align: left; border-width: 0px;
                                				}
                            .stamp_foot    	{color: #000000; font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: normal; text-align: left;  border-width: 0px;
                                 				padding-left: 5px;
                                				}
                            
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; margin-left: 1.0em; border-width: 0px;
                                 				padding-left: 10px; padding: 5px;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-align: center; border-width: 0px;
                                 				width: <xsl:value-of select="$width"/>px; padding-top: 20px;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                            .table_no_border     {border-color: black; border-width:0px; border-style: solid;
                                                }
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>px; padding-top: 6px;
                                				}
                    
					.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
								font-family: Tahoma, Verdana; font-size: 10px;
								font-weight: normal;
								}
					.tab_row_no {padding: 5px;
								color: #000000; font-family: Tahoma, Verdana; font-size: 10px;
								text-align: left; vertical-align: middle; font-weight: normal;
								}
					.tab_header {padding: 5px;
								color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
								text-align: center; vertical-align: middle; font-weight: bold;
								}
					.tab_header_2 {padding: 5px;
								color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
								text-align: left; vertical-align: middle; font-weight: bold;
								}			
				
                   			 .contents	{height: 2.5em;
                   			 			padding: 5px;
                                 				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: normal;
                                				}
                   			 .totals     	{height: 2.5em;
                   			 			padding: 5px;
                                 				font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: normal;
                                				}
                    		.row_descr	{padding: 5px;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: left; vertical-align: middle; font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: baseline;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 			     font-weight: normal; border-width: 0px;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: baseline;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal; border-width: 0px;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; padding-top: 24px;
                                				}
                    		.empty		{border: 0 0 0 0;}
                    		#Przyciski {top: 1em; position: absolute; overflow: auto; width: 99%; z-index: 2; cursor: default;}
							* html #Przyciski { /* IE hack */
									width: 100%;
									height: 12%;
							}
							#Sprawozdanie {top: 4em; bottom: 0em; position: absolute; overflow: auto; width: 99%; z-index: 1;}
							* html #Sprawozdanie { /* IE hack */
								height: 85%;								
								width: 100%;
							}
				</style>
            </head>
            <body>
                <!-- Modyfikacja na potrzeby edytowania komorek -->
                <form name="SACKomorkiSprawozdania" action="/Pomost/SAC/sprawozdania/komorki/zapisz.do?operacja={$operacja}" method="POST">
                    <div id="Przyciski">
                        <xsl:if test="$przyciski = 'true'">
                            <xsl:choose>
                                <xsl:when test="$aplikacja = 'gmina'">
                                    <!--zmiana gmina-->
                                    <input type="submit" value="Akceptuj"/>
                                    <input type="submit" value="Waliduj"/>
                                    <input type="submit" value="Odswiez"/>
                                    <xsl:value-of select="' '"/>
                                    <input type="submit" value="Anuluj"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <a href="javascript:document.forms[0].submit();" accesskey="B">
                                        <img border="0" alt="Akceptuj (ALT+B)" src="../../../obrazki/lista/akceptuj.gif"/>
                                    </a>
                                    <xsl:value-of select="' '"/>
                                    <a href="javascript:document.forms[0].action='/Pomost/SAC/scalanieSprawozdan/initial.do'; document.forms[0].submit();" accesskey="K">
                                        <img border="0" alt="Anuluj (ALT+K)" src="../../../obrazki/lista/anuluj.gif"/>
                                    </a>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:if>
                    </div>
                    <div id="Sprawozdanie">
                        <xsl:apply-templates select="WRiSPZ-P"/>
                    </div>
                </form>
                <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
            </body>
        </html>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="WRiSPZ-P">
        <xsl:apply-templates select="Metryczka"/>
        <a id="tabela_a" name="tabela_a"/>
        <xsl:apply-templates select="Tabela_A"/>
        <a id="tabela_b" name="tabela_b"/>
        <xsl:apply-templates select="Tabela_B"/>
        <a id="tabela_c" name="tabela_c"/>
        <xsl:apply-templates select="Tabela_C"/>
        <a id="tabela_d" name="tabela_d"/>
        <xsl:apply-templates select="Tabela_D"/>
        <a id="tabela_e" name="tabela_e"/>
        <xsl:apply-templates select="Tabela_E"/>
        <a id="tabela_f" name="tabela_f"/>
        <xsl:apply-templates select="Tabela_F"/>
        <a id="tabela_g" name="tabela_g"/>
        <xsl:apply-templates select="Tabela_G"/>
        <a id="tabela_h" name="tabela_h"/>
        <xsl:apply-templates select="Tabela_H"/>
        <a id="tabela_i" name="tabela_i"/>
        <xsl:apply-templates select="Tabela_I"/>
        <a id="tabela_j" name="tabela_j"/>
        <xsl:apply-templates select="Tabela_J"/>
        <a id="tabela_k" name="tabela_k"/>
        <xsl:apply-templates select="Tabela_K"/>
        <a id="tabela_l" name="tabela_l"/>
        <xsl:apply-templates select="Tabela_L"/>
        
        <xsl:call-template name="Stopka"/>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Tabela_A">
        <xsl:call-template name="Tabela_A"/>
    </xsl:template>
    <xsl:template match="Tabela_B">
        <xsl:call-template name="Tabela_B"/>
    </xsl:template>
    <xsl:template match="Tabela_C">
        <xsl:call-template name="Tabela_C"/>
    </xsl:template>
    <xsl:template match="Tabela_D">
        <xsl:call-template name="Tabela_D"/>
    </xsl:template>
    <xsl:template match="Tabela_E">
        <xsl:call-template name="Tabela_E"/>
    </xsl:template>
    <xsl:template match="Tabela_F">
        <xsl:call-template name="Tabela_F"/>
    </xsl:template>
    <xsl:template match="Tabela_G">
        <xsl:call-template name="Tabela_G"/>
    </xsl:template>
    <xsl:template match="Tabela_H">
        <xsl:call-template name="Tabela_H"/>
    </xsl:template>
    <xsl:template match="Tabela_I">
        <xsl:call-template name="Tabela_I"/>
    </xsl:template>
    <xsl:template match="Tabela_J">
        <xsl:call-template name="Tabela_J"/>
    </xsl:template>
    <xsl:template match="Tabela_K">
        <xsl:call-template name="Tabela_K"/>
    </xsl:template>
    <xsl:template match="Tabela_L">
        <xsl:call-template name="Tabela_L"/>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Tabela_A">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table border="1" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="2000"/>
            </xsl:attribute>
            <xsl:call-template name="A_header"/>
            <tbody>
                <xsl:if test="Świadczenie">
                    <xsl:apply-templates select="Świadczenie">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="1100"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Tabela_B">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table border="1" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="1075"/>
            </xsl:attribute>
            <xsl:call-template name="B_header"/>
            <tbody>
                <xsl:if test="Wynagrodzenie">
                    <xsl:apply-templates select="Wynagrodzenie">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Tabela_C">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table border="1" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="1075"/>
            </xsl:attribute>
            <xsl:call-template name="C_header"/>
            <tbody>
                <xsl:if test="Instytucjonalna-piecza-zastepcza">
                    <xsl:apply-templates select="Instytucjonalna-piecza-zastepcza">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Tabela_D">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table border="1" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="1075"/>
            </xsl:attribute>
            <xsl:call-template name="D_header"/>
            <tbody>
                <xsl:if test="Rodzaj-rz">
                    <xsl:apply-templates select="Rodzaj-rz">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Tabela_E">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table border="1" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="1075"/>
            </xsl:attribute>
            <xsl:call-template name="E_header"/>
            <tbody>
                <xsl:if test="Informacja-statystyczna">
                    <xsl:apply-templates select="Informacja-statystyczna">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!-- 
    ==============================================================================================
    -->
    <xsl:template name="Tabela_F">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table border="1" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="1075"/>
            </xsl:attribute>
            <xsl:call-template name="F_header"/>
            <tbody>
                <xsl:if test="Piecza-zastępcza">
                    <xsl:apply-templates select="Piecza-zastępcza">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!-- 
    ==============================================================================================
    -->
    <xsl:template name="Tabela_G">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table border="1" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="1500"/>
            </xsl:attribute>
            <xsl:call-template name="G_header"/>
            <tbody>
                <xsl:if test="Dzieci_G">
                    <xsl:apply-templates select="Dzieci_G">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="1100"/>
        </xsl:call-template>
    </xsl:template>
    <!-- 
    ==============================================================================================
    -->
    <xsl:template name="Tabela_H">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table border="1" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="1075"/>
            </xsl:attribute>
            <xsl:call-template name="H_header"/>
            <tbody>
                <xsl:if test="Dzieci_H">
                    <xsl:apply-templates select="Dzieci_H">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!-- 
    ==============================================================================================
    -->
    <xsl:template name="Tabela_I">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table border="1" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="1075"/>
            </xsl:attribute>
            <xsl:call-template name="I_header"/>
            <tbody>
                <xsl:if test="Dzieci_I">
                    <xsl:apply-templates select="Dzieci_I">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!-- 
    ==============================================================================================
    -->
    <xsl:template name="Tabela_J">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table border="1" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="1075"/>
            </xsl:attribute>
            <xsl:call-template name="J_header"/>
            <tbody>
                <xsl:if test="Organizacja-pieczy">
                    <xsl:apply-templates select="Organizacja-pieczy">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!-- 
    ==============================================================================================
    -->
    <xsl:template name="Tabela_K">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table border="1" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="1075"/>
            </xsl:attribute>
            <xsl:call-template name="K_header"/>
            <tbody>
                <xsl:if test="Placówka">
                    <xsl:apply-templates select="Placówka">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!-- 
    ==============================================================================================
    -->
    <xsl:template name="Tabela_L">
        <xsl:call-template name="Table-caption">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        <table border="1" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="1075"/>
            </xsl:attribute>
            <xsl:call-template name="L_header"/>
            <tbody>
                <xsl:if test="Szkolenie">
                    <xsl:apply-templates select="Szkolenie">
                        <xsl:with-param name="margin" select="0"/>
                    </xsl:apply-templates>
                </xsl:if>
            </tbody>
        </table>
        <xsl:call-template name="Table-description">
            <xsl:with-param name="width" select="975"/>
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Metryczka">
        <!-- Modyfikacja na potrzeby edytowania komorek porownywanie-->
        <xsl:choose>
            <xsl:when test="$porownanie = 'false'">
                <table class="table_no_border" cellspacing="4" cellpadding="0">
                    <xsl:attribute name="width">
                        <xsl:number value="$width"/>
                    </xsl:attribute>
                    <tr>
                        <td class="auth_name" colspan="2"> Organ sporządzający sprawozdanie </td>
                    </tr>
                    <xsl:call-template name="Poziom"/>
                    <tr>
                        <td class="stamp" width="70px">Adres:</td>
                        <td class="stamp">
                            <xsl:for-each select="Nadawca/Adres-pocztowy">
                                <xsl:value-of select="Ulica-i-numer"/>, <xsl:value-of
                                    select="Kod-i-poczta"/>
                            </xsl:for-each>
                        </td>
                    </tr>
                    <tr>
                        <td class="heading_1" colspan="2"> Sprawozdanie rzeczowo-finansowe z
                            wykonywania przez gminę zadań z zakresu wspierania rodziny i systemu
                            pieczy zastępczej za okres <xsl:for-each select="Za-okres">
                                <xsl:for-each select="Data-początku"> od <xsl:apply-templates/>
                                </xsl:for-each>
                                <xsl:for-each select="Data-końca"> do <xsl:apply-templates/>
                                </xsl:for-each>
                            </xsl:for-each>
                        </td>
                    </tr>
                </table>
                <br/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Porównanie sprawozdań -->
                <!-- Naglowkowa tabella porownania -->
                <table class="wide" border="1" cellspacing="0" cellpadding="0" width="100%">
                    <thead>
                        <tr>
                            <th colspan="2">
                                <span style="font-size: 18px; font-weight: bold;"> Porównanie
                                    zawartości komórek sprawozdań o symbolu <xsl:value-of
                                        select="$FrmSymbol"/>
                                </span>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td width="50%">
                                <table>
                                    <tr>
                                        <td>
                                            <B>Sprawozdanie za okres:</B>
                                            <xsl:value-of select="$ZaOkres1"/>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <B>Nadawca:</B>
                                            <xsl:value-of select="$Nadawca1"/>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <B>Odbiorca:</B>
                                            <xsl:value-of select="$Odbiorca1"/>
                                        </td>
                                    </tr>
                                    <xsl:if test="$WersjaZ1 != ''">
                                        <tr>
                                            <td>
                                                <B>Wersja po modyfikacji z:</B> dnia <xsl:value-of
                                                    select="$WersjaZ1"/>
                                            </td>
                                        </tr>
                                    </xsl:if>
                                </table>
                            </td>
                            <td width="50%">
                                <table>
                                    <tr>
                                        <td>
                                            <B>Sprawozdanie za okres:</B>
                                            <xsl:value-of select="$ZaOkres2"/>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <B>Nadawca:</B>
                                            <xsl:value-of select="$Nadawca2"/>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <B>Odbiorca:</B>
                                            <xsl:value-of select="$Odbiorca2"/>
                                        </td>
                                    </tr>
                                    <xsl:if test="$WersjaZ2 != ''">
                                        <tr>
                                            <td>
                                                <B>Wersja po modyfikacji z:</B> dnia <xsl:value-of
                                                    select="$WersjaZ2"/>
                                            </td>
                                        </tr>
                                    </xsl:if>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <br/>
                <font size="-1">pola oznaczone kolorem <font color="orange">pomarańczowym</font>
                    zawierają wartości różniących się komórek oraz procentowy przyrost wartości
                    pierwszego sprawozdania względem drugiego</font>
                <br/>
                <!-- Koniec naglowkowa tabella porownania -->
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Stopka">
        <xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
        <table class="table_no_border" width="700">
            <tr>
                <th class="stamp_foot" colspan="2" align="left">Osoba&#160;sporządzająca&#160;sprawozdanie:</th>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">imię i nazwisko:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="$kto/Imię-i-nazwisko"/>
                </td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">telefon:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="$kto/Telefon"/>
                </td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">e-mail:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="$kto/E-mail"/>
                </td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">podpis:</td>
                <td class="stamp_foot"></td>
            </tr>
            <tr>
                <td class="stamp_foot" width="140">data:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="$kto/Data-wykonania"/>
                </td>
            </tr>
	    <tr>
                <td class="stamp_foot" width="140">Uwagi:</td>
                <td class="stamp_foot">
                    <xsl:value-of select="Metryczka/Opis"/>
                </td>
            </tr>
        </table>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Poziom">
        <tr>
        <xsl:for-each select="../Nagłówek">
            <xsl:for-each select="Wojewoda">
                <td class="stamp" width="70px" >Wojewoda:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
            <!-- W przypadku tego sprawozdania gmina i powiat zawsze mają Powiat -->
            <xsl:for-each select="Gmina">
                <td class="stamp" width="70px">Powiat:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
            <xsl:for-each select="Powiat">
                <td class="stamp" width="70px">Powiat:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
            <xsl:for-each select="Marzałek">
                <td class="stamp" width="70px">Samorząd województwa:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
            <xsl:for-each select="Ministerstwo">
                <td class="stamp" width="70px">Polska:</td><td class="stamp"><xsl:apply-templates /></td>
            </xsl:for-each>
        </xsl:for-each>
        </tr>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Table-caption">
        <xsl:param name="width"/>
        <div>
            <xsl:attribute name="style">
                font-family: Tahoma, Verdana; font-size: 14px; font-weight: bold; margin-bottom: 0.4em; margin-top: 1.2em;
                width: <xsl:number value="$width"/>px
            </xsl:attribute>
            <xsl:value-of select="concat('Tabela ', substring-after(name(.), '_'), '. ')"/><xsl:value-of select="@Opis"/>
        </div>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Table-description">
        <xsl:param name="width"/>
        <table class="table_no_border" border="0" cellspacing="0" cellpadding="0">
            <xsl:attribute name="width">
                <xsl:number value="$width"/>
            </xsl:attribute>
            <xsl:for-each select="*[@Indeks != '']">
                <tr>
                    <td class="stars" width="1%">
                        <sup>
                            <xsl:choose>
                                <xsl:when test="substring(@Indeks,string-length(@Indeks),1) = ':'">                            
                                    <xsl:value-of select="substring-before(@Indeks,':')"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="@Indeks"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </sup>
                    </td>
                    <td class="remark">
                        <xsl:value-of select="@Indeks_opis"/>
                    </td>
                </tr>
            </xsl:for-each>
        </table>
        <br/>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="A_header">
        <thead>
            <tr>
                <th class="tab_header" rowspan="3" style="padding: 3px;" width="30px">Lp.</th>
                <th class="tab_header" rowspan="3" style="padding: 3px;" width="10%">Wyszczególnienie</th>
                <th class="tab_header" colspan="3" style="padding: 3px;">Rodziny zastępcze spokrewnione</th>
                <th class="tab_header" colspan="3" style="padding: 3px;">Rodziny zastępcze niezawodowe</th>
                <th class="tab_header" colspan="3" style="padding: 3px;">Rodziny zastępcze zawodowe</th>
                <th class="tab_header" colspan="3" style="padding: 3px;">Rodzinny dom dziecka</th>
                <th class="tab_header" colspan="3" style="padding: 3px;">Rodziny pomocowe</th>
            </tr>
            <tr>
                <th class="tab_header" colspan="2" style="padding: 3px;">Liczba świadczeń</th>
                <th class="tab_header" rowspan="2" style="padding: 3px;">Wydatki w zł</th>
                
                <th class="tab_header" colspan="2" style="padding: 3px;">Liczba świadczeń</th>
                <th class="tab_header" rowspan="2" style="padding: 3px;">Wydatki w zł</th>
                
                <th class="tab_header" colspan="2" style="padding: 3px;">Liczba świadczeń</th>
                <th class="tab_header" rowspan="2" style="padding: 3px;">Wydatki w zł</th>
                
                <th class="tab_header" colspan="2" style="padding: 3px;">Liczba świadczeń</th>
                <th class="tab_header" rowspan="2" style="padding: 3px;">Wydatki w zł</th>
                
                <th class="tab_header" colspan="2" style="padding: 3px;">Liczba świadczeń</th>
                <th class="tab_header" rowspan="2" style="padding: 3px;">Wydatki w zł</th>
            </tr>
            <tr>
                <th class="tab_header" style="padding: 3px;">ogółem</th>
                <th class="tab_header_2" style="padding: 3px;">w tym podwyższone</th>
                
                <th class="tab_header" style="padding: 3px;">ogółem</th>
                <th class="tab_header_2" style="padding: 3px;">w tym<br/>podwyższone</th>
                
                <th class="tab_header" style="padding: 3px;">ogółem</th>
                <th class="tab_header_2" style="padding: 3px;">w tym podwyższone</th>
                
                <th class="tab_header" style="padding: 3px;">ogółem</th>
                <th class="tab_header_2" style="padding: 3px;">w tym podwyższone</th>
                
                <th class="tab_header" style="padding: 3px;">ogółem</th>
                <th class="tab_header_2" style="padding: 3px;">w tym podwyższone</th>
            </tr>    
            <tr>
                <td class="tab_col_no" style="padding: 3px;">1</td>
                <td class="tab_col_no" style="padding: 3px;">2</td>
                <td class="tab_col_no" style="padding: 3px;">3</td>
                <td class="tab_col_no" style="padding: 3px;">4</td>
                <td class="tab_col_no" style="padding: 3px;">5</td>
                <td class="tab_col_no" style="padding: 3px;">6</td>
                <td class="tab_col_no" style="padding: 3px;">7</td>
                <td class="tab_col_no" style="padding: 3px;">8</td>
                <td class="tab_col_no" style="padding: 3px;">9</td>
                <td class="tab_col_no" style="padding: 3px;">10</td>
                <td class="tab_col_no" style="padding: 3px;">11</td>
                <td class="tab_col_no" style="padding: 3px;">12</td>
                <td class="tab_col_no" style="padding: 3px;">13</td>
                <td class="tab_col_no" style="padding: 3px;">14</td>
                <td class="tab_col_no" style="padding: 3px;">15</td>
                <td class="tab_col_no" style="padding: 3px;">16</td>
                <td class="tab_col_no" style="padding: 3px;">17</td>
            </tr>
        </thead>
    </xsl:template>
    <!-- 
    =============================================================================================
    -->
    <xsl:template name="B_header">
        <thead>
            <tr>
                <th class="tab_header" rowspan="2" width="40px" style="padding: 3px;">Lp.</th>
                <th class="tab_header" rowspan="2" width="460px" style="padding: 3px;">Wyszczególnienie</th>
                <th class="tab_header" colspan="2" width="280px" style="padding: 3px;">Liczba wypłaconych wynagrodzeń/świadczeń</th>
                <th class="tab_header" rowspan="2" width="140px" style="padding: 3px;">Wydatki w zł</th>
            </tr>
            <tr>
                <th class="tab_header" width="140px" style="padding: 3px;">ogółem</th>
                <th class="tab_header" width="140px" style="padding: 3px;">w tym podwyższone</th>
            </tr>    
            <tr>
                <td class="tab_col_no" style="padding: 3px;">1</td>
                <td class="tab_col_no" style="padding: 3px;">2</td>
                <td class="tab_col_no" style="padding: 3px;">3</td>
                <td class="tab_col_no" style="padding: 3px;">4</td>
                <td class="tab_col_no" style="padding: 3px;">5</td>
            </tr>
        </thead>
        
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="C_header">
        <thead>
            <tr>
                <th class="tab_header" rowspan="2" width="40px" style="padding: 3px;">Lp.</th>
                <th class="tab_header" rowspan="2" width="290px" style="padding: 3px;">Wyszczególnienie</th>
                <th class="tab_header" colspan="3" style="padding: 3px;">Liczba świadczeń</th>
                <th class="tab_header" colspan="2" style="padding: 3px;">Wydatki w zł<sup>1)</sup></th>
            </tr>
            <tr>
                <th class="tab_header" width="190px" style="padding: 3px;">ogółem</th>
                <th class="tab_header" width="115px" style="padding: 3px;">w tym w placówkach prowadzonych na zlecenie powiatu</th>
                <th class="tab_header" width="140px" style="padding: 3px;">w tym podwyższone</th>
                <th class="tab_header" width="190px" style="padding: 3px;">ogółem</th>
                <th class="tab_header" width="90px" style="padding: 3px;">w tym w placówkach prowadzonych na zlecenie powiatu</th>
            </tr>
            <tr>
                <td class="tab_col_no" style="padding: 3px;">1</td>
                <td class="tab_col_no" style="padding: 3px;">2</td>
                <td class="tab_col_no" style="padding: 3px;">3</td>
                <td class="tab_col_no" style="padding: 3px;">4</td>
                <td class="tab_col_no" style="padding: 3px;">5</td>
                <td class="tab_col_no" style="padding: 3px;">6</td>
                <td class="tab_col_no" style="padding: 3px;">7</td>
            </tr>
        </thead>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="D_header">
        <thead>
            <tr>
                <th class="tab_header" rowspan="2" width="40px" style="padding: 3px;">Lp.</th>
                <th class="tab_header" rowspan="2" width="460px" style="padding: 3px;">Wyszczególnienie</th>
                <th class="tab_header" colspan="3" style="padding: 3px;">Liczba rodzin zastępczych/rodzinnych domów dziecka</th>
            </tr>
            <tr>
                <th class="tab_header" width="140px" style="padding: 3px;">ogółem</th>
                <th class="tab_header" width="140px" style="padding: 3px;">powstałe w okresie sprawozdawczym</th>
                <th class="tab_header" width="140px" style="padding: 3px;">Rozwiązane w okresie sprawozdawczym</th>
            </tr>
            <tr>
                <td class="tab_col_no" style="padding: 3px;">1</td>
                <td class="tab_col_no" style="padding: 3px;">2</td>
                <td class="tab_col_no" style="padding: 3px;">3</td>
                <td class="tab_col_no" style="padding: 3px;">4</td>
                <td class="tab_col_no" style="padding: 3px;">5</td>
            </tr>
        </thead>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="E_header">
        <thead>
            <tr>
                <th class="tab_header" width="40px" style="padding: 3px;">Lp.</th>
                <th class="tab_header" width="611px" style="padding: 3px;">Wyszczególnienie</th>
                <th class="tab_header" width="140px" style="padding: 3px;">Ogółem</th>
                <th class="tab_header" width="140px" style="padding: 3px;">w tym placówki prowadzone na zlecenie powiatu</th>
            </tr>
            <tr>
                <td class="tab_col_no" style="padding: 3px;">1</td>
                <td class="tab_col_no" style="padding: 3px;">2</td>
                <td class="tab_col_no" style="padding: 3px;">3</td>
                <td class="tab_col_no" style="padding: 3px;">4</td>
            </tr>
        </thead>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="F_header">
        <thead>
            <tr>
                <th class="tab_header" rowspan="2" width="40px" style="padding: 3px;">Lp.</th>
                <th class="tab_header" rowspan="2" width="286px" style="padding: 3px;">Wyszczególnienie</th>
                <th class="tab_header" colspan="7" style="padding: 3px;">Liczba dzieci przebywających w pieczy zastępczej</th>
            </tr>
            <tr>
                <th class="tab_header" width="130px" style="padding: 3px;">dzieci umieszczone w pieczy zastępczej ogółem</th>
                <th class="tab_header" width="70px" style="padding: 3px;">do 3 miesięcy</th>
                <th class="tab_header" width="70px" style="padding: 3px;">powyżej 3 do 6 miesięcy</th>
                <th class="tab_header" width="70px" style="padding: 3px;">powyżej 6 do 12 miesięcy</th>
                <th class="tab_header" width="70px" style="padding: 3px;">powyżej 1 roku do 2 lat</th>
                <th class="tab_header" width="70px" style="padding: 3px;">powyżej 2 lat do 3 lat</th>
                <th class="tab_header" width="70px" style="padding: 3px;">powyżej 3 lat</th>
            </tr>
            <tr>
                <td class="tab_col_no" style="padding: 3px;">1</td>
                <td class="tab_col_no" style="padding: 3px;">2</td>
                <td class="tab_col_no" style="padding: 3px;">3</td>
                <td class="tab_col_no" style="padding: 3px;">4</td>
                <td class="tab_col_no" style="padding: 3px;">5</td>
                <td class="tab_col_no" style="padding: 3px;">6</td>
                <td class="tab_col_no" style="padding: 3px;">7</td>
                <td class="tab_col_no" style="padding: 3px;">8</td>
                <td class="tab_col_no" style="padding: 3px;">9</td>
            </tr>
        </thead>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="G_header">
        <thead>
            <tr>
                <th class="tab_header" rowspan="3" width="30px" style="padding: 3px;">Lp.</th>
                <th class="tab_header" rowspan="3" width="80px" style="padding: 3px;">Wyszczególnienie</th>
                <th class="tab_header" colspan="11" style="padding: 3px;">Liczba dzieci</th>
            </tr>
            <tr>
                <th class="tab_header" rowspan="2" width="75px" style="padding: 3px;">w rodzinach zastępczych spokrewnionych</th>
                <th class="tab_header" rowspan="2" width="75px" style="padding: 3px;">w rodzinach zastępczych niezawodowych</th>
                <th class="tab_header" colspan="3" style="padding: 3px;">w rodzinach zastępczych zawodowych</th>
                <th class="tab_header" rowspan="2" width="65px" style="padding: 3px;">w rodzinnych domach dziecka</th>
                <th class="tab_header" colspan="5" style="padding: 3px;">w placówkach opiekuńczo-wychowawczych</th>
            </tr>
            <tr>
                <th class="tab_header" width="93px" style="padding: 3px;">ogółem</th>
                <th class="tab_header" width="70px" style="padding: 3px;">w tym pełniących funkcję pogotowia rodzinnego</th>
                <th class="tab_header" width="75px" style="padding: 3px;">w tym pełniących funkcję specjalistyczną</th>
                
                <th class="tab_header" width="93px" style="padding: 3px;">ogółem</th>
                <th class="tab_header" width="60px" style="padding: 3px;">typu socjalizacyjnego</th>
                <th class="tab_header" width="60px" style="padding: 3px;">typu interwencyjnego</th>
                <th class="tab_header" width="100px" style="padding: 3px;">typu specjalistyczno-terapeutycznego</th>
                <th class="tab_header" width="63px" style="padding: 3px;">typu rodzinnego</th>
            </tr>
            <tr>
                <td class="tab_col_no" style="padding: 3px;">1</td>
                <td class="tab_col_no" style="padding: 3px;">2</td>
                <td class="tab_col_no" style="padding: 3px;">3</td>
                <td class="tab_col_no" style="padding: 3px;">4</td>
                <td class="tab_col_no" style="padding: 3px;">5</td>
                <td class="tab_col_no" style="padding: 3px;">6</td>
                <td class="tab_col_no" style="padding: 3px;">7</td>
                <td class="tab_col_no" style="padding: 3px;">8</td>
                <td class="tab_col_no" style="padding: 3px;">9</td>
                <td class="tab_col_no" style="padding: 3px;">10</td>
                <td class="tab_col_no" style="padding: 3px;">11</td>
                <td class="tab_col_no" style="padding: 3px;">12</td>
                <td class="tab_col_no" style="padding: 3px;">13</td>
            </tr>
        </thead>
    </xsl:template>
    <!-- 
    =============================================================================================
    -->
    <xsl:template name="H_header">
        <thead>
            <tr>
                <th class="tab_header" rowspan="2" width="40px" style="padding: 3px;">Lp.</th>
                <th class="tab_header" rowspan="2" width="283px" style="padding: 3px;">Wyszczególnienie</th>
                <th class="tab_header" colspan="5" style="padding: 3px;">Liczba dzieci</th>
            </tr>
            <tr>
                <th class="tab_header" width="115px" style="padding: 3px;">w rodzinach zastępczych spokrewnionych</th>
                <th class="tab_header" width="115px" style="padding: 3px;">w rodzinach zastępczych niezawodowych</th>
                <th class="tab_header" width="115px" style="padding: 3px;">w rodzinach zastępczych zawodowych</th>
                <th class="tab_header" width="115px" style="padding: 3px;">w rodzinnych domach dziecka</th>
                <th class="tab_header" width="115px" style="padding: 3px;">w instytucjonalnej pieczy zastępczej</th>
            </tr>
            <tr>
                <td class="tab_col_no" style="padding: 3px;">1</td>
                <td class="tab_col_no" style="padding: 3px;">2</td>
                <td class="tab_col_no" style="padding: 3px;">3</td>
                <td class="tab_col_no" style="padding: 3px;">4</td>
                <td class="tab_col_no" style="padding: 3px;">5</td>
                <td class="tab_col_no" style="padding: 3px;">6</td>
                <td class="tab_col_no" style="padding: 3px;">7</td>
            </tr>
        </thead>
    </xsl:template>
    <!-- 
    =============================================================================================
    -->
    <xsl:template name="I_header">
        <thead>
            <tr>
                <th class="tab_header" rowspan="2" width="40px" style="padding: 3px;">Lp.</th>
                <th class="tab_header" rowspan="2" width="283px" style="padding: 3px;">Wyszczególnienie</th>
                <th class="tab_header" colspan="5" style="padding: 3px;">Liczba dzieci z poprzednich okresów, które ubyły w okresie sprawozdawczym, z tego:</th>
            </tr>
            <tr>
                <th class="tab_header" width="115px" style="padding: 3px;">z rodzin zastępczych spokrewnionych</th>
                <th class="tab_header" width="115px" style="padding: 3px;">z rodzin zastępczych niezawodowych</th>
                <th class="tab_header" width="115px" style="padding: 3px;">z rodzin zastępczych zawodowych</th>
                <th class="tab_header" width="115px" style="padding: 3px;">z rodzinnych domów dziecka</th>
                <th class="tab_header" width="115px" style="padding: 3px;">z instytucjonalnej pieczy zastępczej</th>
            </tr>
            <tr>
                <td class="tab_col_no" style="padding: 3px;">1</td>
                <td class="tab_col_no" style="padding: 3px;">2</td>
                <td class="tab_col_no" style="padding: 3px;">3</td>
                <td class="tab_col_no" style="padding: 3px;">4</td>
                <td class="tab_col_no" style="padding: 3px;">5</td>
                <td class="tab_col_no" style="padding: 3px;">6</td>
                <td class="tab_col_no" style="padding: 3px;">7</td>
            </tr>
        </thead>
    </xsl:template>
    <!-- 
    =============================================================================================
    -->
    <xsl:template name="J_header">
        <thead>
            <tr>
                <th class="tab_header" width="40px" style="padding: 3px;">Lp.</th>
                <th class="tab_header" style="padding: 3px;">Wyszczególnienie</th>
                <th class="tab_header" width="200px" style="padding: 3px;">Wykonanie</th>
            </tr>
            <tr>
                <td class="tab_col_no" style="padding: 3px;">1</td>
                <td class="tab_col_no" style="padding: 3px;">2</td>
                <td class="tab_col_no" style="padding: 3px;">3</td>
            </tr>
        </thead>
    </xsl:template>
    <!-- 
    =============================================================================================
    -->
    <xsl:template name="K_header">
        <thead>
            <tr>
                <th class="tab_header" width="40px" style="padding: 3px;">Lp.</th>
                <th class="tab_header" style="padding: 3px;">Wyszczególnienie</th>
                <th class="tab_header" width="140px" style="padding: 3px;">Ogółem</th>
                <th class="tab_header" width="250px" style="padding: 3px;">w tym placówek/w placówkach prowadzonych przez inne podmioty niż powiat</th>
            </tr>
            <tr>
                <td class="tab_col_no" style="padding: 3px;">1</td>
                <td class="tab_col_no" style="padding: 3px;">2</td>
                <td class="tab_col_no" style="padding: 3px;">3</td>
                <td class="tab_col_no" style="padding: 3px;">4</td>
            </tr>
        </thead>
    </xsl:template>
    <!-- 
    =============================================================================================
    -->
    <xsl:template name="L_header">
        <thead>
            <tr>
                <th class="tab_header" width="40px" style="padding: 3px;">Lp.</th>
                <th class="tab_header" style="padding: 3px;">Szkolenie dla:</th>
                <th class="tab_header" width="150px" style="padding: 3px;">Liczba osób przeszkolonych</th>
                <th class="tab_header" width="150px" style="padding: 3px;">Wydatki na przeprowadzone szkolenia (w zł)</th>
            </tr>
            <tr>
                <td class="tab_col_no" style="padding: 3px;">1</td>
                <td class="tab_col_no" style="padding: 3px;">2</td>
                <td class="tab_col_no" style="padding: 3px;">3</td>
                <td class="tab_col_no" style="padding: 3px;">4</td>
            </tr>
        </thead>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Świadczenie">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_A_'"/>
            </xsl:call-template>
            <xsl:call-template name="_A_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Świadczenie">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Wynagrodzenie">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_B_'"/>
            </xsl:call-template>
            <xsl:call-template name="_B_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Wynagrodzenie">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Instytucjonalna-piecza-zastepcza">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_C_'"/>
            </xsl:call-template>
            <xsl:call-template name="_C_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Instytucjonalna-piecza-zastepcza">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Rodzaj-rz">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_D_'"/>
            </xsl:call-template>
            <xsl:call-template name="_D_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Rodzaj-rz">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Informacja-statystyczna">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_E_'"/>
            </xsl:call-template>
            <xsl:call-template name="_E_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Informacja-statystyczna">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Piecza-zastępcza">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_F_'"/>
            </xsl:call-template>
            <xsl:call-template name="_F_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Piecza-zastępcza">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Dzieci_G">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_G_'"/>
            </xsl:call-template>
            <xsl:call-template name="_G_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Dzieci_G">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Dzieci_H">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_H_'"/>
            </xsl:call-template>
            <xsl:call-template name="_H_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Dzieci_H">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Dzieci_I">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_I_'"/>
            </xsl:call-template>
            <xsl:call-template name="_H_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Dzieci_I">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Organizacja-pieczy">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_J_'"/>
            </xsl:call-template>
            <xsl:call-template name="_J_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Organizacja-pieczy">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Placówka">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_K_'"/>
            </xsl:call-template>
            <xsl:call-template name="_K_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Placówka">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template match="Szkolenie">
        <xsl:param name="margin"/>
        <tr>
            <xsl:call-template name="Row-description">
                <xsl:with-param name="level" select="$margin"/>
                <xsl:with-param name="prefix" select="'_L_'"/>
            </xsl:call-template>
            <xsl:call-template name="_L_contents"/>
        </tr>
        
        <xsl:apply-templates select="*/Szkolenie">
            <xsl:with-param name="margin" select="$margin + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_A_contents">
        <xsl:for-each select="Rodzaje-rz">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZS-Liczba-świadczeń-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZS-Liczba-świadczeń-podwyższone'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZS-Wydatki'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZN-Liczba-świadczeń-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZN-Liczba-świadczeń-podwyższone'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZN-Wydatki'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZZ-Liczba-świadczeń-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZZ-Liczba-świadczeń-podwyższone'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZZ-Wydatki'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RDD-Liczba-świadczeń-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RDD-Liczba-świadczeń-podwyższone'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RDD-Wydatki'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RP-Liczba-świadczeń-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RP-Liczba-świadczeń-podwyższone'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RP-Wydatki'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_B_contents">
        <xsl:for-each select="Składniki-tabela-B">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-podwyższone'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Wydatki'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_C_contents">
        <xsl:for-each select="Świadczenia-wydatki">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-zlecenie-powiatu'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-podwyższone'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Wydatki-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Wydatki-zlecenie-powiatu'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_D_contents">
        <xsl:for-each select="Liczba-rodzin">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Powstałe-w-okresie'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Rozwiązane-w-okresie'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_E_contents">
        <xsl:for-each select="Składniki-tabela-E">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-zlecenie-powiatu'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_F_contents">
        <xsl:for-each select="Liczba-dzieci">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-do-3-mc'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-3-6-mc'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-6-12-mc'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-1-2-lat'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-2-3-lat'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-3-wiecej-lat'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_G_contents">
        <xsl:for-each select="Liczba-dzieci">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZ-spokrewnione'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZ-niezawodowych'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZ-zawodowe-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZ-zawodowe-pogotowie'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZ-zawodowe-specjalistyczne'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Rodzinne-domy-dziecka'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'POW-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'POW-socjalizacyjne'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'POW-interwencyjne'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'POW-specjalistyczno-terapeutyczny'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'POW-rodzinna'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	==============================================================================================
	-->
    <xsl:template name="_H_contents">
        <xsl:for-each select="Liczba-dzieci">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZ-spokrewnione'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZ-niezawodowych'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'RZ-zawodowe'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Rodzinne-domy-dziecka'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Instytucjonalna-piecza-zastępcza'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!-- 
    =============================================================================================
    -->
    <xsl:template name="_J_contents">
        <xsl:for-each select="Liczba-wydatek">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Wykonanie'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!-- 
    =============================================================================================
    -->
    <xsl:template name="_K_contents">
        <xsl:for-each select="Składniki-tabela-K">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-ogółem'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-inne-podmioty-niż-powiat'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!-- 
    =============================================================================================
    -->
    <xsl:template name="_L_contents">
        <xsl:for-each select="Składniki-tabela-L">
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Liczba-osób'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
            <xsl:call-template name="_ABC_column">
                <xsl:with-param name="subtree" select="name(.)"/>
                <xsl:with-param name="column" select="'Wydatki'"/>
                <xsl:with-param name="format" select="$liczba"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="_ABC_column">
        <xsl:param name="subtree"/>
        <xsl:param name="column"/> 
        <xsl:param name="format"/>
        <xsl:param name="item" select="*[name(.) = $column]"/>
        <xsl:param name="contents">
            <xsl:value-of select="$item"/>
        </xsl:param>
        <xsl:choose>
            <xsl:when test="../Z-tego and not($item/@xsi:nil)">
                <xsl:call-template name="_ABC_total">
                    <xsl:with-param name="subtree" select="$subtree"/>
                    <xsl:with-param name="column" select="$column"/>
                    <xsl:with-param name="contents" select="$contents"/>
                    <xsl:with-param name="format" select="$format"/>
                    <!-- Modyfikacja na potrzeby edytowania komorek -->
                    <xsl:with-param name="komorka" select="$item/@Komorka"/>
                    <xsl:with-param name="blad" select="$item/@Blad"/>
                    <xsl:with-param name="edit" select="$item/@Edit"/>
                    <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
                    <!-- Modyfikacja na potrzeby analizy-->
                    <xsl:with-param name="analiza" select="$item/@Analiza"/>
                    <!-- Koniec modyfikacja na potrzeby analizy-->
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="string($item/@xsi:nil) = 'true'">
                            <td class="contents">
                                <center>X</center>
                            </td>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- Modyfikacja na potrzeby edytowania komorek -->
                            <xsl:choose>
                                <xsl:when test="$item/@Komorka">
                                    <xsl:variable name="nazwa" select="$item/@Komorka"/>
                                    <xsl:variable name="wartosc" select="$item"/>
                                    <xsl:variable name="class">
                                        <xsl:choose>
                                            <xsl:when test="$item/@Blad='true'"> blad </xsl:when>
                                            <xsl:otherwise> pole </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:variable>
                                    <xsl:choose>
                                        <xsl:when test="$item/@Edit='true'">
                                            <td class="contents">
                                                <!--Modyfikacja na potrzeby analizy -->
                                                <xsl:choose>
                                                    <xsl:when test="$item/@Analiza='true'">
                                                        <input type="submit" value="K{$nazwa}"/>
                                                    </xsl:when>
                                                </xsl:choose>
                                                <!--Koniec Modyfikacja na potrzeby analizy -->
                                                <input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
                                            </td>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <td class="contents">
                                                <input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
                                                <xsl:value-of select="format-number($contents, $format)"/>
                                            </td>    
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:choose>
                                        <xsl:when test="$porownanie = 'true'">
                                            <xsl:choose>
                                                <xsl:when test="$item/@Blad='true'">
                                                    <td class="contents"
                                                        style="background-color: orange">
                                                        <xsl:value-of select="$item"/>
                                                    </td>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <td class="contents">
                                                        <xsl:value-of select="$item"/>
                                                    </td>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <td class="contents">
                                                <xsl:value-of select="format-number($contents, $format)"/>
                                            </td>
                                        </xsl:otherwise>
                                    </xsl:choose>    
                                </xsl:otherwise>
                            </xsl:choose>
                            <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
                        </xsl:otherwise>
                    </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="_ABC_total">
        <xsl:param name="subtree"/>
        <xsl:param name="column"/>
        <xsl:param name="format"/> <xsl:param name="contents"/>
        <!-- Modyfikacja na potrzeby edytowania komorek -->
        <xsl:param name="komorka"/>
        <xsl:param name="blad"/>
        <xsl:param name="edit"/>
        <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
        <!-- Modyfikacja na potrzeby analizy-->
        <xsl:param name="analiza"/>
        <!-- Koniec modyfikacja na potrzeby analizy-->
        <xsl:param name="suma">
            <xsl:for-each select="../Z-tego/*">
                <xsl:call-template name="_ABC_add_tree">
                    <xsl:with-param name="subtree" select="$subtree"/>
                    <xsl:with-param name="column" select="$column"/>
                </xsl:call-template>
            </xsl:for-each>
        </xsl:param>
        <xsl:call-template name="sumuj">
            <xsl:with-param name="wynik" select="0"/>
            <xsl:with-param name="format" select="$format"/>
            <xsl:with-param name="contents" select="$contents"/>
            <xsl:with-param name="suma" select="$suma"/>
            <!-- Modyfikacja na potrzeby edytowania komorek -->
            <xsl:with-param name="komorka" select="$komorka"/>
            <xsl:with-param name="blad" select="$blad"/>
            <xsl:with-param name="edit" select="$edit"/>
            <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
            <!-- Modyfikacje na potrzeby analizy -->
            <xsl:with-param name="analiza" select="$analiza"/>
            <!-- Koniec modyfikacje na potrzeby analizy -->
        </xsl:call-template>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    
    <xsl:template name="_ABC_add_tree">
        <xsl:param name="subtree"/>
        <xsl:param name="column"/>
        <xsl:param name="contents" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
        <xsl:choose>
            <xsl:when test="Z-tego and not($contents/@xsi:nil)">
                <xsl:for-each select="Z-tego/*">
                    <xsl:call-template name="_ABC_add_tree">
                        <xsl:with-param name="subtree" select="$subtree"/>
                        <xsl:with-param name="column" select="$column"/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$contents/@xsi:nil">
                        0 
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$contents"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="'+'"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="Row-description">
        <xsl:param name="level"/>
        <xsl:param name="prefix"/>
        <td class="tab_row_no">
            <xsl:number count="*[starts-with(@Pozycja, $prefix)]" level="multiple" format="1.1" />.
        </td>
        <td class="row_descr" style="padding: 3px;">
            <xsl:value-of select="@Opis"/>
            <sup>
                <xsl:choose>
                    <xsl:when test="substring(@Indeks,string-length(@Indeks),1) = ':'">                            
                        <xsl:value-of select="substring-before(@Indeks,':')"/>:
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="@Indeks"/>
                    </xsl:otherwise>
                </xsl:choose>    
            </sup>
        </td>
    </xsl:template>
    <!--
	=============================================================================================
	-->
    <xsl:template name="sumuj">
        <xsl:param name="wynik"/>
        <xsl:param name="format"/>
        <xsl:param name="contents"/>
        <xsl:param name="suma"/>
        <!-- Modyfikacja na potrzeby edytowania komorek -->
        <xsl:param name="komorka"/>
        <xsl:param name="blad"/>
        <xsl:param name="edit"/>
        <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
        <!-- Modyfikacje na potrzeby analizy -->
        <xsl:param name="analiza"/>
        <!-- Koniec modyfikacje na potrzeby analizy -->
        <xsl:choose>
            <xsl:when test="$suma!=''">
                <xsl:call-template name="sumuj">
                    <xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
                    <xsl:with-param name="format" select="$format"/>
                    <xsl:with-param name="contents" select="$contents"/>
                    <xsl:with-param name="suma" select="substring-after($suma,'+')"/>
                    <!-- Modyfikacja na potrzeby edytowania komorek -->
                    <xsl:with-param name="komorka" select="$komorka"/>
                    <xsl:with-param name="blad" select="$blad"/>
                    <xsl:with-param name="edit" select="$edit"/>
                    <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
                    <!-- Modyfikacje na potrzeby analizy -->
                    <xsl:with-param name="analiza" select="$analiza"/>
                    <!-- Koniec modyfikacje na potrzeby analizy -->
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="string(number($wynik)) = 'NaN'">
                        <!-- Modyfikacja na potrzeby edytowania komorek -->
                        <xsl:choose>
                            <xsl:when test="$komorka!='' and $komorka!='NaN'">
                                <xsl:variable name="nazwa" select="$komorka"/>
                                <xsl:variable name="wartosc" select="$contents"/>
                                <xsl:variable name="class">
                                    <xsl:choose>
                                        <xsl:when test="$blad='true'">blad</xsl:when>
                                        <xsl:otherwise>pole</xsl:otherwise>
                                    </xsl:choose>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$edit='true'">
                                        <td class="totals" style="background-color: red">
                                            <!--Modyfikacja na potrzeby analizy -->
                                            <xsl:choose>
                                                <xsl:when test="$analiza='true'">
                                                    <input type="submit" value="K{$nazwa}"/>
                                                </xsl:when>
                                            </xsl:choose>
                                            <!--Koniec Modyfikacja na potrzeby analizy -->
                                            <input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
                                            <br/>
                                            <xsl:value-of select="'suma: NaN'"/>
                                        </td>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <td class="totals" style="background-color: red">
                                            <input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
                                            <center>X</center>
                                        </td>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:choose>
                                    <xsl:when test="$porownanie = 'true'">
                                        <xsl:choose>
                                            <xsl:when test="$blad='true'">
                                                <td class="totals" style="background-color: orange">
                                                    <xsl:value-of select="$contents"/>
                                                </td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="totals">
                                                    <xsl:value-of select="$contents"/>
                                                </td>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <td class="totals" style="background-color: red">
                                            <center>X</center>
                                        </td>
                                    </xsl:otherwise>
                                </xsl:choose>    
                            </xsl:otherwise>
                        </xsl:choose>
                        <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
                    </xsl:when>
                    <xsl:when test="string(number($contents)) != 'NaN'">
                        <xsl:choose>
                            <xsl:when test="$contents != $wynik">
                                <!-- Modyfikacja na potrzeby edytowania komorek -->
                                <xsl:choose>
                                    <xsl:when test="$komorka!='' and $komorka!='NaN'">
                                        <xsl:variable name="nazwa" select="$komorka"/>
                                        <xsl:variable name="wartosc" select="$contents"/>
                                        <xsl:variable name="class">
                                            <xsl:choose>
                                                <xsl:when test="$blad='true'">blad</xsl:when>
                                                <xsl:otherwise>pole</xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:variable>
                                        <xsl:choose>
                                            <xsl:when test="$edit='true'">
                                                <td class="contents" style="background-color: red">
                                                    <!--Modyfikacja na potrzeby analizy -->
                                                    <xsl:choose>
                                                        <xsl:when test="$analiza='true'">
                                                            <input type="submit" value="K{$nazwa}"/>
                                                        </xsl:when>
                                                    </xsl:choose>
                                                    <!--Koniec Modyfikacja na potrzeby analizy -->
                                                    <input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/><br/>
                                                    <xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
                                                </td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="contents" style="background-color: red">
                                                    <input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
                                                    <xsl:value-of select="concat('jest: ', format-number($contents, $format))"/><br/>
                                                    <xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
                                                </td>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:choose>
                                            <xsl:when test="$porownanie = 'true'">
                                                <xsl:choose>
                                                    <xsl:when test="$blad='true'">
                                                        <td class="contents" style="background-color: orange">
                                                            <xsl:value-of select="$contents"/>
                                                        </td>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <td class="contents">
                                                            <xsl:value-of select="$contents"/>
                                                        </td>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="contents" style="background-color: red">
                                                    <xsl:value-of select="concat('jest: ', format-number($contents, $format))"/><br/>
                                                    <xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
                                                </td>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:otherwise>
                                </xsl:choose>
                                <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
                            </xsl:when>
                            <xsl:otherwise>
                                <!-- Modyfikacja na potrzeby edytowania komorek -->
                                <xsl:choose>
                                    <xsl:when test="$komorka!='' and $komorka!='NaN'">
                                        <xsl:variable name="nazwa" select="$komorka"/>
                                        <xsl:variable name="wartosc" select="$contents"/>
                                        <xsl:variable name="class">
                                            <xsl:choose>
                                                <xsl:when test="$blad='true'">blad</xsl:when>
                                                <xsl:otherwise>pole</xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:variable>
                                        <xsl:choose>
                                            <xsl:when test="$edit='true'">
                                                <td class="totals">
                                                    <!--Modyfikacja na potrzeby analizy -->
                                                    <xsl:choose>
                                                        <xsl:when test="$analiza='true'">
                                                            <input type="submit" value="K{$nazwa}"/>
                                                        </xsl:when>
                                                    </xsl:choose>
                                                    <!--Koniec Modyfikacja na potrzeby analizy -->
                                                    <input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
                                                </td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="totals">
                                                    <input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
                                                    <xsl:value-of select="format-number($wynik, $format)"/>
                                                </td>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:choose>
                                            <xsl:when test="$porownanie = 'true'">
                                                <xsl:choose>
                                                    <xsl:when test="$blad='true'">
                                                        <td class="totals">
                                                            <xsl:value-of select="$contents"/>
                                                        </td>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <td class="totals">
                                                            <xsl:value-of select="$contents"/>
                                                        </td>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="totals">
                                                    <xsl:value-of select="format-number($wynik, $format)"/>
                                                </td>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:otherwise>
                                </xsl:choose>
                                <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- Modyfikacja na potrzeby edytowania komorek -->
                        <xsl:choose>
                            <xsl:when test="$komorka!='' and $komorka!='NaN'">
                                <xsl:variable name="nazwa" select="$komorka"/>
                                <xsl:variable name="wartosc" select="$contents"/>
                                <xsl:variable name="class">
                                    <xsl:choose>
                                        <xsl:when test="$blad='true'"> blad </xsl:when>
                                        <xsl:otherwise> pole </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$edit='true'">
                                        <td class="totals">
                                            <!--Modyfikacja na potrzeby analizy -->
                                            <xsl:choose>
                                                <xsl:when test="$analiza='true'">
                                                    <input type="submit" value="K{$nazwa}"/>
                                                </xsl:when>
                                            </xsl:choose>
                                            <!--Koniec Modyfikacja na potrzeby analizy -->
                                            <input class="{$class}" type="text" name="{$nazwa}" value="{$wartosc}" size="10"/>
                                        </td>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <td class="totals">
                                            <input type="hidden" name="{$nazwa}" value="{$wartosc}"/>
                                            <xsl:value-of select="format-number($wynik, $format)"/>
                                        </td>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:choose>
                                    <xsl:when test="$porownanie = 'true'">
                                        <xsl:choose>
                                            <xsl:when test="$blad='true'">
                                                <td class="totals">
                                                    <xsl:value-of select="$contents"/>
                                                </td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="totals">
                                                    <xsl:value-of select="$contents"/>
                                                </td>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <td class="totals">
                                            <xsl:value-of select="format-number($wynik, $format)"/>
                                        </td>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                        <!-- Koniec modyfikacja na potrzeby edytowania komorek -->
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
