package pl.topteam.pomost.sprawozdania.mrips;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.threeten.extra.Quarter;

import pl.topteam.common.text.ExtraFormats;

public final class KwartałAdapter extends XmlAdapter<String, Quarter> {
	@Override
	public Quarter unmarshal(String v) throws Exception {
		return v == null ? null : Quarter.of(ExtraFormats.ROMAN.parse(v).intValue());
	}

	@Override
	public String marshal(Quarter v) throws Exception {
		return v == null ? null : ExtraFormats.ROMAN.format(v.getValue());
	}
}
