<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt">


    <!--
	=============================================================================================
	-->
    <xsl:param name="FrmSymbol"></xsl:param>
    <xsl:param name="FrmWersja"></xsl:param>
    <xsl:param name="KomEdyt">false</xsl:param>
    <xsl:param name="DataOd"></xsl:param>
    <xsl:param name="DataDo"></xsl:param>
    <xsl:param name="przyciskiKomorek">false</xsl:param>
	<xsl:param name="formatowanie_kwota">###&#160;###&#160;###&#160;##0</xsl:param>
	<xsl:param name="formatowanie_liczba">##&#160;###&#160;##0</xsl:param>
	<xsl:param name="FCN_WYBRANA_KOMORKA">addTextToEditor</xsl:param>
	<xsl:param name="GRAFIKA_PREFIX"/>
    <!--
	=============================================================================================
	-->
	<xsl:variable name="suma" select="'(sum'"/>
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator="," />
	<xsl:variable name="grosze" select="'###&#160;###&#160;###&#160;##0,00'" />
	<xsl:variable name="złote" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="$formatowanie_liczba"/>
	<xsl:variable name="width" select="'1044px'"/>
	<xsl:variable name="iloraz" select="'(ilor'"/>
	<!--
	=============================================================================================
	-->
	<xsl:include href="lib_KOM_EDIT.xslt"/>
	<!--
	=============================================================================================
	-->

	<xsl:template match="/">

		<html>
			<head>
				<style type="text/css">
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>; padding-top: 6px;
                                				}

                    		.cw0		{width:  250px;}
                    		.cw1		{width:  786px;}
                    		.cw2		{width:  656px;}
                    		.cw3		{width:  130px;}
                    		.cw4		{width:    60px;}
                    		.cw5		{width:  235px;}
                    		.cw6		{width:    15px;}

                    		.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
                                 				font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.tab_row_no	{padding-left: 3px; text-align: center; vertical-align: middle;
                                 					color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 					font-weight: normal;
                                					}
                   			 .contents	{height: 2.0em; padding-right: 2px; text-align: right;
                                 				vertical-align: middle; color: #000000; font-family: Tahoma,
                                 				Verdana; font-size: 11px; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.0em; padding-right: 2px;
                                 				text-align: right; vertical-align: middle;
                                 				background-color: silver; font-family: Tahoma, Verdana;
                                 				font-size: 11px; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; text-align: left; vertical-align: middle;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>;
                                				}
                    		.empty		{border: 0 0 0 0;}
                				</style>
				<xsl:call-template name="KomEditScriptTemplate"/>

				<link rel="stylesheet">
					<xsl:attribute name="href"><xsl:value-of select="$GRAFIKA_PREFIX"/>css/common/komunikat.css</xsl:attribute>
				</link>

			</head>
			<body onload="setCheckedValue(document.forms[0].KOA,getQueryStringValue('czyZakres'));refreshKOAPosition();" onResize="refreshKOAPosition();" onScroll="refreshKOAPosition();"><div id="MAIN_DIV_ID">
<!-- Modyfikacja na potrzeby edytowania komorek -->
                 <form name="SACKomorkiSprawozdania" action="" method="POST">
				<xsl:call-template name="KomEditHtmlTemplate"/>
                    <xsl:apply-templates select="Posiłek-dla-potrzebujących"/>
                </form>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</div></body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Posiłek-dla-potrzebujących">
		<xsl:apply-templates select="Metryczka"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Dział_I"/>
		<xsl:apply-templates select="Dział_II"/>
		<xsl:apply-templates select="Dział_III"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<table border="2" cellspacing="0" cellpadding="8">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th colspan="3">
						<span  style="font-size: 18px; font-weight: bold;">
							MINISTERSTWO POLITYKI SPOŁECZNEJ, ul. Nowogrodzka 1/3/5, 00-513 Warszawa
						</span>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td style="text-align: center; font-weight: bold;">
						<span style="font-size: large;">
                            Komórki dla formularza o symbolu: <xsl:value-of select="$FrmSymbol"/>
						</span><br/>
					</td>
				</tr>
			</tbody>
		</table>
		<br/> <br/> <br/> <br/> <br/>

	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table width="280" style="float: left">
			<caption>Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td>Imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td>Telefon:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td>Data wykonania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
		</table>
		<div class="xslt_ver">
			<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
			<!--xsl:if test="system-property('msxsl:version')">
				<xsl:value-of select="concat(', MSXML: ', system-property('msxsl:version'))"/>
			</xsl:if-->
		</div>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Row-description">
		<xsl:param name="level"/><xsl:param name="prefix"/>
		<xsl:variable name="topbot" select="'margin-top: 4px; margin-bottom: 4px; margin-left: '"/>
		<xsl:variable name="indent" select="25"/>
		<td class="cw5 row_descr">
			<xsl:if test="not(preceding-sibling::*) and ../@Prefiks">
		 	        <p>
 					  <xsl:attribute name="style">
 						 <xsl:value-of select="concat($topbot, string($indent * ($level - 1)), 'px;')" />
					   </xsl:attribute>
					   <xsl:value-of select="../@Prefiks"/><br/>
				    </p>
			</xsl:if>
			<p>
				<xsl:if test="$level &gt;= 0">
					<xsl:attribute name="style">
						<xsl:value-of select="concat($topbot, string($indent * $level), 'px;')" />
					</xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="contains(@Opis, $suma)">
						<xsl:value-of select="substring-before(@Opis, $suma)"/>
						<br/>
						<span style="margin-top: 0.6em; font-size: 0.6em;">
							<xsl:value-of select="concat($suma, substring-after(@Opis, $suma))"/>
						</span>
					</xsl:when>
					<xsl:when test="contains(@Opis, $iloraz)">
						<xsl:value-of select="substring-before(@Opis, $iloraz)"/>
						<br/>
						<span style="margin-top: 0.6em; font-size: 0.6em;">
							<xsl:value-of select="concat($iloraz, substring-after(@Opis, $iloraz))"/>
						</span>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@Opis"/>
					</xsl:otherwise>
				</xsl:choose>
			</p>
		</td>
		<!--td class="cw6 tab_row_no"-->
		<td class="tab_row_no" style="width: 15px;">
			<xsl:value-of select="count(preceding::*[starts-with(@Pozycja, $prefix)])+
								  count(ancestor-or-self::*[starts-with(@Pozycja, $prefix)])"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="with_format_check">
		<xsl:param name="contents"/>
		<xsl:param name="format"/>
		<xsl:choose>
			<xsl:when test="contains($contents, '.') and $format != $grosze">
				<td class="totals" style="background-color: red">
					<center><xsl:value-of select="'Format!'"/></center>
					<br/>
					<xsl:value-of select="format-number($contents, $grosze)"/>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($contents, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="sumuj">
		<xsl:param name="wynik"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma"/>
<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"></xsl:param>
		<xsl:param name="blad"></xsl:param>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<xsl:choose>
			<xsl:when test="$suma!=''">
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="substring-after($suma,'+')"/>
<!-- Modyfikacja na potrzeby edytowania komorek -->
					<xsl:with-param name="komorka" select="$komorka"/>
					<xsl:with-param name="blad" select="$blad"/>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
<!-- Modyfikacja na potrzeby edytowania komorek -->
                            <xsl:choose>
						        <xsl:when test="$komorka!='' and $komorka!='NaN'">
						            <xsl:variable name="nazwa"><xsl:value-of select="$komorka"/></xsl:variable>
						            <xsl:choose>
						                <xsl:when test="$przyciskiKomorek = 'true'">
                                            <td class="totals">
					                	        <center>
					                	            <xsl:choose>
						                                <xsl:when test="$FrmWersja = '' and $KomEdyt = 'false'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.{$FCN_WYBRANA_KOMORKA}('K{$nazwa}');"/>
                                                        </xsl:when>
                                                        <xsl:when test="$KomEdyt = 'true'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:updateField('{$nazwa}');"/>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.addInnaToEditor('{$FrmSymbol}', '{$FrmWersja}', '{$DataOd}', '{$DataDo}', 'K{$nazwa}');"/>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
						                        </center>
					                        </td>
					                    </xsl:when>
					                    <xsl:otherwise>
					                        <td class="totals">
					                            <center><B>K<xsl:value-of select='$nazwa'/></B></center>
					                        </td>
					                    </xsl:otherwise>
					                </xsl:choose>
						        </xsl:when>
						        <xsl:otherwise>
                                    <td class="totals">
						                <center>X</center>
                                    </td>
						        </xsl:otherwise>
						    </xsl:choose>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Dział_I">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_II">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Dział_III">
		<xsl:call-template name="Dział"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Dział">
		<xsl:param name="chapter" select="substring-after(name(.), '_')"/>
		<div>
 			<xsl:attribute name="style">
 				page-break-before: always;
 				font-size: medium; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:value-of select="$width"/>px
			</xsl:attribute>
			<xsl:value-of select="concat('DZIAŁ ', $chapter, '.&#160;&#160;',@Opis)"/>
		</div>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:value-of select="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th class="cw0" colspan="2" rowspan="4">WYSZCZEGÓLNIENIE</th>
					<th class="cw1" colspan="12">Rządowy program "Posiłek dla potrzebujących"</th>
				</tr>
				<tr>
					<th class="cw4" rowspan="3">OGÓŁEM <!--span style="font-size: 8px;">(4+6+8+10+12)</span--></th>
					<th class="cw4" rowspan="3">w tym na wsi <!--span style="font-size: 8px;">(5+7+9+11+13)</span--></th>
					<th class="cw2" colspan="10">w tym:</th>
				</tr>
				<tr>
					<th class="cw3" colspan="2">dzieci 0-7 lat</th>
					<th class="cw3" colspan="2">uczniowie szkół podstawowych i&#160;gimnazjów</th>
					<th class="cw3" colspan="2">uczniowie szkół ponadgimnazjalnych</th>
					<th class="cw3" colspan="2">osoby stare, chore, niepełnosprawne</th>
					<th class="cw3" colspan="2">inne osoby</th>
				</tr>
				<tr>
					<th class="cw4">ogółem</th>
					<th class="cw4">w tym na wsi</th>
					<th class="cw4">ogółem</th>
					<th class="cw4">w tym na wsi</th>
					<th class="cw4">ogółem</th>
					<th class="cw4">w tym na wsi</th>
					<th class="cw4">ogółem</th>
					<th class="cw4">w tym na wsi</th>
					<th class="cw4">ogółem</th>
					<th class="cw4">w tym na wsi</th>
				</tr>
				<tr>
					<td class="tab_col_no" colspan="2">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
					<td class="tab_col_no">7</td>
					<td class="tab_col_no">8</td>
					<td class="tab_col_no">9</td>
					<td class="tab_col_no">10</td>
					<td class="tab_col_no">11</td>
					<td class="tab_col_no">12</td>
					<td class="tab_col_no">13</td>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="Inf-ogółem">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Inf-dot-posiłków">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="Inf-dot-zasiłków">
					<xsl:with-param name="margin" select="0"/>
				</xsl:apply-templates>
			</tbody>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-ogółem">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_I_'"/>
			</xsl:call-template>

			<xsl:call-template name="_III_contents"/>
		</tr>

		<xsl:apply-templates select="*/Inf-ogółem">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-dot-posiłków">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_II_'"/>
			</xsl:call-template>

			<xsl:call-template name="_III_contents"/>
		</tr>

		<xsl:apply-templates select="*/Inf-dot-posiłków">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Inf-dot-zasiłków">
		<xsl:param name="margin"/>
		<tr>
			<xsl:call-template name="Row-description">
				<xsl:with-param name="level" select="$margin"/>
				<xsl:with-param name="prefix" select="'_III_'"/>
			</xsl:call-template>

			<xsl:call-template name="_III_contents"/>
		</tr>

		<xsl:apply-templates select="*/Inf-dot-zasiłków">
			<xsl:with-param name="margin" select="$margin + 1"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Rozbicie">
				<xsl:param name="format"/>
				<xsl:param name="subtree" select="name(.)"/>
				<xsl:call-template name="_2_level">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="'Ogółem'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
				<xsl:call-template name="_2_level">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="'Na-wsi'"/>
					<xsl:with-param name="format" select="$format"/>
				</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_III_contents">
		<xsl:param name="subtree" select="'Dane'"/>
		<xsl:param name="format">
			<xsl:choose>
				<xsl:when test="@Grosze='false'">
					<xsl:value-of select="$złote"/>
				</xsl:when>
				<xsl:when test="@Grosze='true'">
					<xsl:value-of select="$grosze"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$liczba"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<xsl:call-template name="_1_level">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Ogółem'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_1_level">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Na-wsi'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:choose>
			<xsl:when test="Dane/Rozbicie/@xsi:nil='true'">
				<td class="contents"><center>X</center></td><td class="contents"><center>X</center></td>
				<td class="contents"><center>X</center></td><td class="contents"><center>X</center></td>
				<td class="contents"><center>X</center></td><td class="contents"><center>X</center></td>
				<td class="contents"><center>X</center></td><td class="contents"><center>X</center></td>
				<td class="contents"><center>X</center></td><td class="contents"><center>X</center></td>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="Dane/Rozbicie/*">
					<xsl:call-template name="Rozbicie">
						<xsl:with-param name="format" select="$format"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_level">
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="../../../Z-tego and not($item/@xsi:nil)">
				<xsl:call-template name="_2_totals">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
<!-- Modyfikacja na potrzeby edytowania komorek -->
                    <xsl:with-param name="komorka">
                        <xsl:value-of select="$item/@Komorka"/>
                    </xsl:with-param>
                    <xsl:with-param name="blad">
                        <xsl:value-of select="$item/@Blad"/>
                    </xsl:with-param>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="../../../@Pozycja = '_II_17'  or ../../../@Pozycja = '_II_18'">
<!-- Modyfikacja na potrzeby edytowania komorek -->
                            <xsl:choose>
						        <xsl:when test="$item/@Komorka!='' and $item/@Komorka!='NaN'">
						            <xsl:variable name="nazwa"><xsl:value-of select="$item/@Komorka"/></xsl:variable>
						            <xsl:choose>
						                <xsl:when test="$przyciskiKomorek = 'true'">
                                            <td class="totals">
					                	        <center>
					                	            <xsl:choose>
						                                <xsl:when test="$FrmWersja = '' and $KomEdyt = 'false'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.{$FCN_WYBRANA_KOMORKA}('K{$nazwa}');"/>
                                                        </xsl:when>
                                                        <xsl:when test="$KomEdyt = 'true'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:updateField('{$nazwa}');"/>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.addInnaToEditor('{$FrmSymbol}', '{$FrmWersja}', '{$DataOd}', '{$DataDo}', 'K{$nazwa}');"/>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
						                        </center>
					                        </td>
					                    </xsl:when>
					                    <xsl:otherwise>
					                        <td class="totals">
					                            <center><B>K<xsl:value-of select='$nazwa'/></B></center>
					                        </td>
					                    </xsl:otherwise>
					                </xsl:choose>
						        </xsl:when>
						        <xsl:otherwise>
                                    <td class="contents">
						                <center>X</center>
                                    </td>
						        </xsl:otherwise>
						    </xsl:choose>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</xsl:when>
			<xsl:otherwise>
<!-- Modyfikacja na potrzeby edytowania komorek -->
                            <xsl:choose>
						        <xsl:when test="$item/@Komorka!='' and $item/@Komorka!='NaN'">
						            <xsl:variable name="nazwa"><xsl:value-of select="$item/@Komorka"/></xsl:variable>
						            <xsl:choose>
						                <xsl:when test="$przyciskiKomorek = 'true'">
                                            <td class="contents">
					                	        <center>
					                	            <xsl:choose>
						                                <xsl:when test="$FrmWersja = '' and $KomEdyt = 'false'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.{$FCN_WYBRANA_KOMORKA}('K{$nazwa}');"/>
                                                        </xsl:when>
                                                        <xsl:when test="$KomEdyt = 'true'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:updateField('{$nazwa}');"/>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.addInnaToEditor('{$FrmSymbol}', '{$FrmWersja}', '{$DataOd}', '{$DataDo}', 'K{$nazwa}');"/>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
						                        </center>
					                        </td>
					                    </xsl:when>
					                    <xsl:otherwise>
					                        <td class="contents">
					                            <center><B>K<xsl:value-of select='$nazwa'/></B></center>
					                        </td>
					                    </xsl:otherwise>
					                </xsl:choose>
						        </xsl:when>
						        <xsl:otherwise>
                                    <td class="contents">
						                <center>X</center>
                                    </td>
						        </xsl:otherwise>
						    </xsl:choose>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_totals">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="../../../Z-tego/*">
				<xsl:call-template name="_2_add_trees">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
<!-- Modyfikacja na potrzeby edytowania komorek -->
		<xsl:param name="komorka"/>
		<xsl:param name="blad"/>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
<!-- Modyfikacja na potrzeby edytowania komorek -->
			<xsl:with-param name="komorka" select="$komorka"/>
			<xsl:with-param name="blad" select="$blad"/>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_2_add_trees">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="contents" select="Dane/Rozbicie/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_2_add_trees">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_1_level">
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="Z-tego and not($item/@xsi:nil)">
				<xsl:call-template name="_1_totals">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
<!-- Modyfikacja na potrzeby edytowania komorek -->
                    <xsl:with-param name="komorka">
                        <xsl:value-of select="$item/@Komorka"/>
                    </xsl:with-param>
                    <xsl:with-param name="blad">
                        <xsl:value-of select="$item/@Blad"/>
                    </xsl:with-param>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="@Pozycja = '_II_17'  or @Pozycja = '_II_18'">
<!-- Modyfikacja na potrzeby edytowania komorek -->
                            <xsl:choose>
						        <xsl:when test="$item/@Komorka!='' and $item/@Komorka!='NaN'">
						            <xsl:variable name="nazwa"><xsl:value-of select="$item/@Komorka"/></xsl:variable>
						            <xsl:choose>
						                <xsl:when test="$przyciskiKomorek = 'true'">
                                            <td class="totals">
					                	        <center>
					                	            <xsl:choose>
						                                <xsl:when test="$FrmWersja = '' and $KomEdyt = 'false'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.{$FCN_WYBRANA_KOMORKA}('K{$nazwa}');"/>
                                                        </xsl:when>
                                                        <xsl:when test="$KomEdyt = 'true'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:updateField('{$nazwa}');"/>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.addInnaToEditor('{$FrmSymbol}', '{$FrmWersja}', '{$DataOd}', '{$DataDo}', 'K{$nazwa}');"/>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
						                        </center>
					                        </td>
					                    </xsl:when>
					                    <xsl:otherwise>
					                        <td class="totals">
					                            <center><B>K<xsl:value-of select='$nazwa'/></B></center>
					                        </td>
					                    </xsl:otherwise>
					                </xsl:choose>
						        </xsl:when>
						        <xsl:otherwise>
                                    <td class="contents">
						                <center>X</center>
                                    </td>
						        </xsl:otherwise>
						    </xsl:choose>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</xsl:when>
			<xsl:otherwise>
<!-- Modyfikacja na potrzeby edytowania komorek -->
                            <xsl:choose>
						        <xsl:when test="$item/@Komorka!='' and $item/@Komorka!='NaN'">
						            <xsl:variable name="nazwa"><xsl:value-of select="$item/@Komorka"/></xsl:variable>
						            <xsl:choose>
						                <xsl:when test="$przyciskiKomorek = 'true'">
                                            <td class="contents">
					                	        <center>
					                	            <xsl:choose>
						                                <xsl:when test="$FrmWersja = '' and $KomEdyt = 'false'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.{$FCN_WYBRANA_KOMORKA}('K{$nazwa}');"/>
                                                        </xsl:when>
                                                        <xsl:when test="$KomEdyt = 'true'">
						                                    <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:updateField('{$nazwa}');"/>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <input type="button" name="K{$nazwa}" value="K{$nazwa}"
                                                            onClick="javascript:window.opener.addInnaToEditor('{$FrmSymbol}', '{$FrmWersja}', '{$DataOd}', '{$DataDo}', 'K{$nazwa}');"/>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
						                        </center>
					                        </td>
					                    </xsl:when>
					                    <xsl:otherwise>
					                        <td class="contents">
					                            <center><B>K<xsl:value-of select='$nazwa'/></B></center>
					                        </td>
					                    </xsl:otherwise>
					                </xsl:choose>
						        </xsl:when>
						        <xsl:otherwise>
                                    <td class="contents">
						                <center>X</center>
                                    </td>
						        </xsl:otherwise>
						    </xsl:choose>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_totals">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="Z-tego/*">
				<xsl:call-template name="_1_add_trees">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
<!-- Modyfikacja na potrzeby edytowania komorek -->
        <xsl:param name="komorka"/>
        <xsl:param name="blad"/>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
<!-- Modyfikacja na potrzeby edytowania komorek -->
			<xsl:with-param name="komorka" select="$komorka"/>
			<xsl:with-param name="blad" select="$blad"/>
<!-- Koniec modyfikacja na potrzeby edytowania komorek -->
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_1_add_trees">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="contents" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="Z-tego and not($contents/@xsi:nil)">
				<xsl:for-each select="Z-tego/*">
					<xsl:call-template name="_1_add_trees">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>