package pl.gov.mpips.zbc.v20090722;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W01ValidatorSO implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
	@Override
	public void validate(SytuacjaOsoby target, SytuacjaRodziny context, BasicErrors errors) {
		require(target, context, errors, "dataUrodzenia",                 SytuacjaOsoby::getDataUrodzenia,                 ImmutableSet.of("01", "02", "06", "11", "13"));
		require(target, context, errors, "kodStanuCywilnego",             SytuacjaOsoby::getKodStanuCywilnego,             ImmutableSet.of("01", "02", "06", "11", "13"));
		require(target, context, errors, "kodRoliWRodzinie",              SytuacjaOsoby::getKodRoliWRodzinie,              ImmutableSet.of("01", "02", "06", "11", "13"));
		require(target, context, errors, "kodPokrewienstwaZGlowaRodziny", SytuacjaOsoby::getKodPokrewienstwaZGlowaRodziny, ImmutableSet.of("01", "02", "06", "11", "13"));
		require(target, context, errors, "kodRodzajuWyksztalcenia",       SytuacjaOsoby::getKodRodzajuWyksztalcenia,       ImmutableSet.of("01", "02", "06", "11", "13"));
		require(target, context, errors, "kodPozycjiNaRynkuPracy",        SytuacjaOsoby::getKodPozycjiNaRynkuPracy,        ImmutableSet.of("01", "02", "13"));
		require(target, context, errors, "kodStanuZdrowia",               SytuacjaOsoby::getKodStanuZdrowia,               ImmutableSet.of("01", "02", "06", "11", "13"));
		require(target, context, errors, "czyNiepelnosprawny",            SytuacjaOsoby::getCzyNiepelnosprawny,            ImmutableSet.of("01", "02", "13"));
		require(target, context, errors, "czyUstalonaGrupaInwalidzka",    SytuacjaOsoby::getCzyUstalonaGrupaInwalidzka,    ImmutableSet.of("01", "02", "13"));
	}
	
	private void require(SytuacjaOsoby target, SytuacjaRodziny context, BasicErrors errors, String field, Function<SytuacjaOsoby, Object> getter, Set<String> codes) {
		String kod = context.getKodRodzajuOpisuSytuacji();
		if (codes.contains(kod)) {
			Object wartosc = getter.apply(target);
			if (isEmpty(wartosc)) {
				errors.rejectValue(field, "W01", "Pole jest wymagane dla wybranego kodu rodzaju opisu sytuacji");
			}
		}
	}
	
	private boolean isEmpty(Object value) {
		if (value instanceof String) {
			return Strings.isNullOrEmpty((String) value);
		} else {
			return Objects.isNull(value);
		}
	}
}
