package pl.gov.mpips.zbc.v20090722;

import java.util.Objects;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;

import pl.gov.mpips.zbc.v20090722.SytuacjaOsoby.Dochody;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W03aValidator implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
	private static final ImmutableSet<String> DOCHODY_WYMAGANE = ImmutableSet.of("01", "02", "06", "11", "13");
	
	@Override
	public void validate(SytuacjaOsoby sytuacjaOsoby, SytuacjaRodziny context, BasicErrors errors) {
		String kodRodzajuOpisuSytuacji = context.getKodRodzajuOpisuSytuacji();
		if (DOCHODY_WYMAGANE.contains(kodRodzajuOpisuSytuacji)) {
			Dochody dochody = sytuacjaOsoby.getDochody();
			if (Strings.isNullOrEmpty(dochody.getZrodlo1())) {
				errors.rejectValue("dochody.zrodlo1", "W03a", "Pole wymagane ze względu na kod rodzaju opisu sytuacji rodziny");
			}
			if (Objects.isNull(dochody.getKwotaMiesiecznie1())) {
				errors.rejectValue("dochody.kwotaMiesiecznie1", "W03a", "Pole wymagane ze względu na kod rodzaju opisu sytuacji rodziny");
			}
		}
	}
}
