package pl.gov.mpips.zbc.v20090722;

import java.util.List;
import java.util.Objects;

import pl.gov.mpips.zbc.v20090722.SwiadczenieSprawozdawcze.CzlonekRodziny;
import pl.gov.mpips.zbc.v20090722.SwiadczenieSprawozdawcze.Problemy;
import pl.gov.mpips.zbc.v20090722.narzedzia.Listy;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W12Validator implements ComplexValidator<Problemy, SwiadczenieSprawozdawcze> {
	@Override
	public void validate(Problemy target, SwiadczenieSprawozdawcze context, BasicErrors errors) {
		List<String> kody = Listy.kody(target);
		for (int i = 0; i < kody.size(); i++) {
			if (kodProblemuWskazujeNaNiepelnosprawnosc(kody.get(i)) && !sytuacjaWskazujeNaNiepelnosprawnosc(context)) {
				errors.rejectValue("kod" + (i + 1), "W12", "Wskazano problem niepełnosprawności mimo braku w składzie rodziny osób niepełnosprawnych");
			}
		}
	}
	
	private boolean sytuacjaWskazujeNaNiepelnosprawnosc(SwiadczenieSprawozdawcze context) {
		List<CzlonekRodziny> czlonkowieRodziny = context.getCzlonkowieRodziny();
		return czlonkowieRodziny != null && czlonkowieRodziny.stream()
			.filter(Objects::nonNull)
			.map(CzlonekRodziny::getSytuacjaOsoby)
			.filter(Objects::nonNull)
			.map(SytuacjaOsoby::getCzyNiepelnosprawny)
			.filter(Objects::nonNull)
			.anyMatch(Boolean.TRUE::equals);
	}
	
	private boolean kodProblemuWskazujeNaNiepelnosprawnosc(String kod) {
		return Objects.equals(kod, "060");
	}
}
