package pl.gov.mpips.zbc.v20090722;

import java.time.LocalDate;

import com.google.common.base.Objects;

import pl.topteam.common.temporal.ExtraChronoUnit;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W15Validator implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
	@Override
	public void validate(SytuacjaOsoby sytuacjaOsoby, SytuacjaRodziny context, BasicErrors errors) {
		if (zaWczesnieNaPrace(sytuacjaOsoby, context) && !biernyZawodowo(sytuacjaOsoby)) {
			errors.rejectValue("kodPozycjiNaRynkuPracy", "W15", "Osoby młodsze niż 15 lat powinny być bierne zawodowo");
		}
	}
	
	private boolean zaWczesnieNaPrace(SytuacjaOsoby target, SytuacjaRodziny context) {
		LocalDate dataUrodzenia = target.getDataUrodzenia();
		if (dataUrodzenia == null) return false;
		LocalDate dataOpisuSytuacji = context.getDataOpisuSytuacji();
		if (dataOpisuSytuacji == null) return false;
		//
		return ExtraChronoUnit.LEGAL_YEARS.between(dataUrodzenia, dataOpisuSytuacji) < 15;
	}
	
	private boolean biernyZawodowo(SytuacjaOsoby sytuacjaOsoby) {
		String kodPozycjiNaRynkuPracy = sytuacjaOsoby.getKodPozycjiNaRynkuPracy();
		return Objects.equal(kodPozycjiNaRynkuPracy, "3");
	}
}
