package pl.gov.mpips.zbc.v20090722;

import java.time.LocalDate;
import java.util.List;

import com.google.common.collect.ImmutableSet;

import pl.gov.mpips.zbc.v20090722.SytuacjaOsoby.Dochody;
import pl.gov.mpips.zbc.v20090722.narzedzia.Listy;
import pl.topteam.common.temporal.ExtraChronoUnit;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W18Validator implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
	private static final ImmutableSet<String> ZRODLA_ZAROBKOWE = ImmutableSet.of(
		"01", "02", "03", "04", "06", "07", "10", "11", "12", "13", "14", "17", "18"
	);
	
	@Override
	public void validate(SytuacjaOsoby target, SytuacjaRodziny context, BasicErrors errors) {
		Dochody dochody = target.getDochody();
		List<String> zrodla = Listy.zrodla(dochody);
		for (int z = 0; z < 4; z++) {
			if (wymagaPracy(zrodla.get(z)) && zbytMlodyZebyPracowac(target, context)) {
				errors.rejectValue("dochody.zrodlo" + (z + 1), "W18", "Wybrane źródło dochodu jest niedozwolone dla osób młodszych niż 15 lat");
			}
		}
	}
	
	private boolean zbytMlodyZebyPracowac(SytuacjaOsoby sytuacjaOsoby, SytuacjaRodziny kontekst) {
		LocalDate dataOpisuSytuacji = kontekst.getDataOpisuSytuacji();
		LocalDate dataUrodzenia = sytuacjaOsoby.getDataUrodzenia();
		return dataOpisuSytuacji != null && dataUrodzenia != null
			&& ExtraChronoUnit.LEGAL_YEARS.between(dataUrodzenia, dataOpisuSytuacji) < 15;
	}
	
	private boolean wymagaPracy(String zrodlo) {
		return ZRODLA_ZAROBKOWE.contains(zrodlo);
	}
}
