package pl.gov.mpips.zbc.v20090722;

import java.math.BigDecimal;
import java.util.Set;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;

import pl.gov.mpips.zbc.v20090722.SytuacjaOsoby.Dochody;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W03Validator implements SimpleValidator<Dochody> {
	private static final Set<String> DOCHOD_ZEROWY = ImmutableSet.of(
		"22", "33"
	);
	
	private static final Set<String> DOCHOD_NIEZEROWY = ImmutableSet.of(
		"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "12", "13", "14", "15", "16", "17", "18", "19",
		"20", "21", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "99"
	);
	
	@Override
	public void validate(Dochody target, BasicErrors errors) {
		validate(target.getZrodlo1(), target.getKwotaMiesiecznie1(), 1, errors);
		validate(target.getZrodlo2(), target.getKwotaMiesiecznie2(), 2, errors);
		validate(target.getZrodlo3(), target.getKwotaMiesiecznie3(), 3, errors);
		validate(target.getZrodlo4(), target.getKwotaMiesiecznie4(), 4, errors);
	}
	
	private void validate(String zrodlo, BigDecimal kwota, int numer, BasicErrors bledy) {
		validateA(zrodlo, kwota, numer, bledy);
		validateB(zrodlo, kwota, numer, bledy);
		validateC(zrodlo, kwota, numer, bledy);
	}
	
	private void validateA(String zrodlo, BigDecimal kwota, int numer, BasicErrors bledy) {
		boolean wymaganeZrodlo = kwota != null && kwota.signum() != 0;
		boolean brakZrodla = Strings.isNullOrEmpty(zrodlo);
		if (wymaganeZrodlo && brakZrodla) {
			bledy.rejectValue("zrodlo" + numer, "W03", "Podanie kodu źródła dochodu jest wymagane, jeśli dochód jest niezerowy");
		}
	}
	
	private void validateB(String zrodlo, BigDecimal kwota, int numer, BasicErrors bledy) {
		boolean wymaganyDochodNiezerowy = DOCHOD_NIEZEROWY.contains(zrodlo);
		boolean brakLubZerowyDochod = kwota == null || kwota.signum() == 0;
		if (wymaganyDochodNiezerowy && brakLubZerowyDochod) {
			bledy.rejectValue("zrodlo" + numer, "W03", "Dochód musi być niezerowy dla wybranego kodu źródła dochodu");
		}
	}
	
	private void validateC(String zrodlo, BigDecimal kwota, int numer, BasicErrors bledy) {
		boolean wymaganyDochodZerowy = DOCHOD_ZEROWY.contains(zrodlo);
		boolean brakLubNiezerowyDochod = kwota == null || kwota.signum() != 0;
		if (wymaganyDochodZerowy && brakLubNiezerowyDochod) {
			bledy.rejectValue("zrodlo" + numer, "W03", "Dochód musi być zerowy dla wybranego kodu źródła dochodu");
		}
	}
}
