package pl.gov.mpips.zbc.v20090722;

import java.util.Objects;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W34Validator implements SimpleValidator<SytuacjaOsoby> {
	private static final String DZIECKO_NIEPELNOSPRAWNE = "11";
	
	@Override
	public void validate(SytuacjaOsoby target, BasicErrors errors) {
		if (wymaganeUstalenieGrupyInwalidzkiej(target)) {
			if (!czyUstalonaGrupaInwalidzka(target)) {
				errors.rejectValue("czyUstalonaGrupaInwalidzka", "W34", "Wartość niezgodna z kodem orzeczenia o niepełnosprawności");
			}
		}
	}
	
	private boolean wymaganeUstalenieGrupyInwalidzkiej(SytuacjaOsoby sytuacjaOsoby) {
		String kodOrzeczeniaONiepelnosprawnosci = sytuacjaOsoby.getKodOrzeczeniaONiepelnosprawnosci();
		if (kodOrzeczeniaONiepelnosprawnosci == null) return false;
		return !kodOrzeczeniaONiepelnosprawnosci.equals(DZIECKO_NIEPELNOSPRAWNE);
	}
	
	private boolean czyUstalonaGrupaInwalidzka(SytuacjaOsoby sytuacjaOsoby) {
		Boolean czyUstalonaGrupaInwalidzka = sytuacjaOsoby.getCzyUstalonaGrupaInwalidzka();
		return Objects.equals(czyUstalonaGrupaInwalidzka, Boolean.TRUE);
	}
}
