package pl.gov.mpips.zbc.v20200306;

import java.util.List;
import java.util.Objects;
import java.util.Set;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;

import pl.gov.mpips.zbc.Kody;
import pl.gov.mpips.zbc.v20200306.SprawozdawczaDecyzjaOdmowna.PowodyOdmowy;
import pl.gov.mpips.zbc.v20200306.SprawozdawczaDecyzjaOdmowna.SwiadczeniaOdmowione;
import pl.gov.mpips.zbc.v20200306.narzedzia.Listy;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W14Validator implements SimpleValidator<SprawozdawczaDecyzjaOdmowna> {
	private static final ImmutableSetMultimap<String, String> RODZAJE_SWIADCZEN = ImmutableSetMultimap.<String, String>builder()
		.putAll("09", ImmutableList.of("130", "212", "213000", "214", "330", "41611", "430"))
		.putAll("10", ImmutableList.of("41601", "41604", "417"))
		.putAll("12", ImmutableList.of("416"))
		.putAll("13", ImmutableList.of("416"))
		.putAll("14", ImmutableList.of("416"))
		.build();
	
	@Override
	public void validate(SprawozdawczaDecyzjaOdmowna target, BasicErrors errors) {
		PowodyOdmowy powodyOdmowy = target.getPowodyOdmowy();
		SwiadczeniaOdmowione swiadczeniaOdmowione = target.getSwiadczeniaOdmowione();
		List<String> kodyPowodow = Listy.kodyPowodow(MoreObjects.firstNonNull(powodyOdmowy, new PowodyOdmowy()));
		List<String> kodyRodzaju = Listy.kodyRodzaju(MoreObjects.firstNonNull(swiadczeniaOdmowione, new SwiadczeniaOdmowione()));
		for (String kodPowodu : kodyPowodow) {
			Set<String> rodzajeSwiadczen = RODZAJE_SWIADCZEN.get(kodPowodu);
			if (!rodzajeSwiadczen.isEmpty()) {
				if (kodyRodzaju.stream().filter(Objects::nonNull).noneMatch(kodRodzaju -> Kody.prefiksy(kodRodzaju).anyMatch(rodzajeSwiadczen::contains))) {
					errors.rejectValue(null, "W14", "Nie wskazano świadczenia zgodnego z podanym kodem powodu odmowy");
				}
			}
		}
	}
}
