package pl.gov.mpips.zbc.v20200306;

import java.util.Objects;
import java.util.Set;

import com.google.common.collect.ImmutableSet;

import pl.gov.mpips.zbc.Kody;
import pl.gov.mpips.zbc.v20200306.SprawozdawczaDecyzjaOdmowna.PowodyOdmowy;
import pl.gov.mpips.zbc.v20200306.SprawozdawczaDecyzjaOdmowna.SwiadczeniaOdmowione;
import pl.gov.mpips.zbc.v20200306.narzedzia.Listy;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W14aValidator implements SimpleValidator<SprawozdawczaDecyzjaOdmowna> {
	@Override
	public void validate(SprawozdawczaDecyzjaOdmowna target, BasicErrors errors) {
		validate1(target, errors);
		validate2(target, errors);
		validate3(target, errors);
	}
	
	private void validate1(SprawozdawczaDecyzjaOdmowna target, BasicErrors errors) {
		Set<String> kodyPowodow = ImmutableSet.of("09", "20", "21", "22", "23");
		Set<String> kodyRodzaju = ImmutableSet.of("130", "212000", "213000", "214", "330", "41611", "430");
		PowodyOdmowy powodyOdmowy = target.getPowodyOdmowy();
		SwiadczeniaOdmowione swiadczeniaOdmowione = target.getSwiadczeniaOdmowione();
		if (powodyOdmowy != null && Listy.kodyPowodow(powodyOdmowy).stream().anyMatch(kodyPowodow::contains)) {
			if (swiadczeniaOdmowione == null || Listy.kodyRodzaju(swiadczeniaOdmowione).stream().filter(Objects::nonNull).noneMatch(kodRodzaju -> Kody.prefiksy(kodRodzaju).anyMatch(kodyRodzaju::contains))) {
				errors.rejectValue(null, "W14a", "Nie wskazano świadczenia zgodnego z podanym kodem powodu odmowy");
			}
		}
	}
	
	private void validate2(SprawozdawczaDecyzjaOdmowna target, BasicErrors errors) {
		Set<String> kodyRodzaju = ImmutableSet.of("416");
		PowodyOdmowy powodyOdmowy = target.getPowodyOdmowy();
		SwiadczeniaOdmowione swiadczeniaOdmowione = target.getSwiadczeniaOdmowione();
		if (powodyOdmowy != null && Listy.kodyPowodowUsamodzielnienie(powodyOdmowy).stream().anyMatch(Objects::nonNull)) {
			if (swiadczeniaOdmowione == null || Listy.kodyRodzaju(swiadczeniaOdmowione).stream().filter(Objects::nonNull).noneMatch(kodRodzaju -> Kody.prefiksy(kodRodzaju).anyMatch(kodyRodzaju::contains))) {
				errors.rejectValue(null, "W14a", "Nie wskazano świadczenia zgodnego z podanym kodem nierealizowania pomocy - usamodzielnienie");
			}
		}
	}
	
	private void validate3(SprawozdawczaDecyzjaOdmowna target, BasicErrors errors) {
		Set<String> kodyRodzaju = ImmutableSet.of("62x", "62a", "62b");
		PowodyOdmowy powodyOdmowy = target.getPowodyOdmowy();
		String kodRodzajuBeneficjenta = target.getKodRodzajuBeneficjenta();
		if (powodyOdmowy != null && Listy.kodyPowodowCudzoziemcy(powodyOdmowy).stream().anyMatch(Objects::nonNull)) {
			if (!kodyRodzaju.contains(kodRodzajuBeneficjenta)) {
				errors.rejectValue(null, "W14a", "Nie wskazano kodu rodzaju beneficjenta mimo uzupełnienia kodu nierealizowania pomocy - cudzoziemiec");
			}
		}
	}
}
