/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20200306;

import com.google.common.base.Objects;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import pl.gov.mpips.zbc.v20200306.SytuacjaOsoby;
import pl.gov.mpips.zbc.v20200306.SytuacjaRodziny;
import pl.topteam.common.temporal.ExtraChronoUnit;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W15Validator
implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
    @Override
    public void validate(SytuacjaOsoby sytuacjaOsoby, SytuacjaRodziny context, BasicErrors errors) {
        if (this.zaWczesnieNaPrace(sytuacjaOsoby, context) && !this.biernyZawodowo(sytuacjaOsoby)) {
            errors.rejectValue("kodPozycjiNaRynkuPracy", "W15", "Osoby m\u0142odsze ni\u017c 15 lat powinny by\u0107 bierne zawodowo");
        }
    }

    private boolean zaWczesnieNaPrace(SytuacjaOsoby target, SytuacjaRodziny context) {
        LocalDate dataUrodzenia = target.getDataUrodzenia();
        if (dataUrodzenia == null) {
            return false;
        }
        LocalDate dataOpisuSytuacji = context.getDataOpisuSytuacji();
        if (dataOpisuSytuacji == null) {
            return false;
        }
        return ExtraChronoUnit.LEGAL_YEARS.between((Temporal)dataUrodzenia, (Temporal)dataOpisuSytuacji) < 15L;
    }

    private boolean biernyZawodowo(SytuacjaOsoby sytuacjaOsoby) {
        String kodPozycjiNaRynkuPracy = sytuacjaOsoby.getKodPozycjiNaRynkuPracy();
        return Objects.equal((Object)kodPozycjiNaRynkuPracy, (Object)"3");
    }
}

