/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20200306;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSortedMap;
import java.time.LocalDate;
import java.util.NavigableMap;
import org.threeten.extra.YearQuarter;
import pl.gov.mpips.zbc.v20200306.ZbiorCentralny;
import pl.topteam.common.collect.ExtraMaps;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W23Validator
implements SimpleValidator<ZbiorCentralny> {
    private static final ImmutableRangeMap<LocalDate, Integer> DYSTRYBUCJE_SLOWNIKOW = ExtraMaps.toImmutableRangeMap((NavigableMap)ImmutableSortedMap.naturalOrder().put((Object)LocalDate.parse("2016-10-03"), (Object)63).put((Object)LocalDate.parse("2018-09-24"), (Object)64).put((Object)LocalDate.parse("2018-11-14"), (Object)65).put((Object)LocalDate.parse("2019-01-08"), (Object)66).put((Object)LocalDate.parse("2019-05-08"), (Object)67).put((Object)LocalDate.parse("2020-05-12"), (Object)68).put((Object)LocalDate.parse("2021-05-11"), (Object)69).put((Object)LocalDate.parse("2021-12-15"), (Object)70).put((Object)LocalDate.parse("2022-01-11"), (Object)71).build());

    @Override
    public void validate(ZbiorCentralny target, BasicErrors errors) {
        YearQuarter okres = target.getOkres();
        if (okres == null) {
            return;
        }
        Integer numerZestawuSlownikow = target.getNumerZestawuSlownikow();
        if (numerZestawuSlownikow == null) {
            return;
        }
        Integer dystrybucjaSlownikow = (Integer)DYSTRYBUCJE_SLOWNIKOW.get((Comparable)okres.atDay(1).minusDays(1L));
        if (dystrybucjaSlownikow == null) {
            return;
        }
        if (numerZestawuSlownikow < dystrybucjaSlownikow) {
            errors.rejectValue("numerZestawuSlownikow", "W23", "Numer zestawu s\u0142ownik\u00f3w nie mo\u017ce by\u0107 ni\u017cszy ni\u017c numer ostatniego zestawu wydystrybuowanego przed pierwszym dniem okresu za kt\u00f3ry przesy\u0142any jest zbi\u00f3r");
        }
    }
}

