<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
		xmlns:xs="http://www.w3.org/2001/XMLSchema"
		version="1.0">
	<xsl:output doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" indent="no" method="html"/>

	<xsl:decimal-format name="pln" decimal-separator="," grouping-separator=" "/>

	<xsl:key name="decOdmowneSwiadczeniaWgDaty" match="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Decyzje_Odmowne/Dec_Odmowna" use="concat(substring(Data_Podjecia, 1, 4), substring(Data_Podjecia, 6, 2), substring(Data_Podjecia, 9, 2))"/>

	<xsl:key name="swiadczeniaWgKodu" match="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie" use="Kod_Swiad"/>
	<xsl:key name="swiadczeniaWgSrodkow" match="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Swiadczenia/Swiadczenie" use="substring(Kod_Swiad, 1, 1)"/>

	<xsl:key name="sytuacjaOsobyWgPozycjiRynekPracy" match="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Sytuacje_Osob/Syt_Osoby" use="Kod_Poz_Ryn_Pr"/>
	<xsl:key name="sytuacjaOsobyWgStanuZdrowia" match="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Sytuacje_Osob/Syt_Osoby" use="Kod_Stanu_Zdr"/>
	<xsl:key name="sytuacjaOsobyWgNiepelnosprawnosci" match="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Sytuacje_Osob/Syt_Osoby" use="Czy_Niepelnosp"/>
	<xsl:key name="sytuacjaOsobyWgStoptniaNiepelnosprawnosci" match="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Sytuacje_Osob/Syt_Osoby" use="Kod_Orz_O_Niep"/>
	
	<xsl:key name="sytuacjaRodzinyWgKoduOpisu" match="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Sytuacje_Rodzin/Syt_Rodz" use="Kod_Rodz_Opisu_Syt"/>
	<xsl:key name="sytuacjaRodzinyWgKoduSkladu" match="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Sytuacje_Rodzin/Syt_Rodz" use="Kod_Skladu"/>
	<xsl:key name="sytuacjaRodzinyWgWielkosci" match="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Sytuacje_Rodzin/Syt_Rodz" use="Wielkosc"/>

	<xsl:key name="wniosekWgTypu" match="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek" use="Kod_Typu"/>
	<xsl:key name="wniosekWgDatyWplyniecia" match="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek" use="concat(substring(Data_Wplyn, 1, 4), substring(Data_Wplyn, 6, 2), substring(Data_Wplyn, 9, 2))"/>
	<xsl:key name="wniosekWgRodzajuWnioskodawcy" match="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny/Wnioski/Wniosek" use="Kod_Rodz_Wnioskod"/>

	<xsl:variable name="SL_Grup_Kodow_Rodzaju_Swiadczenia" select="document('./slowniki/SL_Grup_Kodow_Rodzaju_Swiadczenia.xml')/properties/entry" />
	<xsl:variable name="SL_Kod_Pozycji_Rynek_Pracy" select="document('./slowniki/SL_Kod_Pozycji_Rynek_Pracy.xml')/properties/entry" />
	<xsl:variable name="SL_Kod_Rodzaju_Swiadczenia" select="document('./slowniki/SL_Kod_Rodzaju_Swiadczenia.xml')/properties/entry" />
	<xsl:variable name="SL_Kod_Rodzaju_Wnioskodawcy" select="document('./slowniki/SL_Kod_Rodzaju_Wnioskodawcy.xml')/properties/entry" />
	<xsl:variable name="SL_Kod_Skladu_Rodziny" select="document('./slowniki/SL_Kod_Skladu_Rodziny.xml')/properties/entry" />
	<xsl:variable name="SL_Kod_Stanu_Zdrowia" select="document('./slowniki/SL_Kod_Stanu_Zdrowia.xml')/properties/entry" />
	<xsl:variable name="SL_Kod_Stopnia_Niepelnosprawnosci" select="document('./slowniki/SL_Kod_Stopnia_Niepelnosprawnosci.xml')/properties/entry" />
	<xsl:variable name="SL_Kod_Typu_Wniosku" select="document('./slowniki/SL_Kod_Typu_Wniosku.xml')/properties/entry" />
	<xsl:variable name="SL_Rodzaj_Opisu_Sytuacji" select="document('./slowniki/SL_Rodzaj_Opisu_Sytuacji.xml')/properties/entry" />

	<xsl:template match="/">
		<div class="container-fluid">
			<xsl:text> </xsl:text>
		</div>
		<div class="container-fluid">
			<xsl:call-template name="Zbiory"/>
		</div>
		<div class="container-fluid">
			<xsl:text> </xsl:text>
		</div>
		<script type="text/javascript">
		<![CDATA[
			function tab(name) {
				var i;
				var x = document.getElementsByClassName("tab-content");
				for (i = 0; i < x.length; i++) {
					x[i].style.display = "none";
				}
				document.getElementById(name).style.display = "block";
			}
		]]>
		</script>
	</xsl:template>

	<xsl:template name="Zbiory">
		<xsl:for-each select="/P_ZBRCEN/Zbiory_Centralne/Zbior_Centralny">
			<div class="container-fluid col-md-offset-2 col-md-8">
			<form name="zbiory">
				<fieldset>
					<legend>Dane zbioru centralnego</legend>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">za kwartał</label>
						<div class="col-md-5">
							<xsl:value-of select="Za_Okres/Rok"/>Q<xsl:value-of select="Za_Okres/Kwartal"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">nr wykonania</label>
						<div class="col-md-5">
							<xsl:value-of select="Nr_Wykonania_Zbc"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">wymagania</label>
						<div class="col-md-5">
							<xsl:value-of select="/P_ZBRCEN/@Wersja_Wymagan"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">formularz</label>
						<div class="col-md-5">
							<xsl:value-of select="/P_ZBRCEN/@Wersja_Formularza"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">data utworzenia</label>
						<div class="col-md-5">
							<xsl:value-of select="Data_Utworzenia"/>
						</div>
					</div>
				</fieldset>
				<fieldset>
					<legend>Dane jednostki utworzenia</legend>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">KESO</label>
						<div class="col-md-5">
							<xsl:value-of select="/P_ZBRCEN/Metryczka/Nadawca/@Kod_KESO"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">nazwa</label>
						<div class="col-md-5">
							<xsl:value-of select="/P_ZBRCEN/Metryczka/Nadawca/Pelna_Nazwa"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">aplikacja</label>
						<div class="col-md-5">
							<xsl:value-of select="/P_ZBRCEN/@Kod_Aplikacji"/> (<xsl:value-of select="/P_ZBRCEN/@Wersja_Aplikacji"/>)
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">zestaw słowników</label>
						<div class="col-md-5">
							<xsl:value-of select="Nr_Zestawu_Slownikow"/>
						</div>
					</div>
				</fieldset>
				<fieldset>
					<legend>Zawartość</legend>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">
							liczba rodzin
							<br/><small>(w bazie PS)</small>
						</label>
						<div class="col-md-5">
							<xsl:value-of select="Liczba_Rodzin_W_Systemie"/>
						</div>
					</div>
					<div class="row form-group">
						<label class="control-label col-md-2 text-right">
							liczba wywiadów
							<br/><small>(w bazie PS)</small>
						</label>
						<div class="col-md-5">
							<xsl:value-of select="Liczba_Utworzonych_Wywiadow"/>
						</div>
					</div>
					<div class="row form-group">
						<table class="table table-bordered table-hover" style="width: 95%; margin-left: auto; margin-right: auto;">
							<thead>
								<tr>
									<th style="width: 28%;">Informacja</th>
									<th style="width: 18%;">Kwartał 1</th>
									<th style="width: 18%;">Kwartał 2</th>
									<th style="width: 18%;">Kwartał 3</th>
									<th style="width: 18%;">Kwartał 4</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td>Wartość świadczeń POMOST</td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/POMOST/Kw1, '0,00', 'pln')"/></td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/POMOST/Kw2, '0,00', 'pln')"/></td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/POMOST/Kw3, '0,00', 'pln')"/></td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/POMOST/Kw4, '0,00', 'pln')"/></td>
								</tr>
								<tr>
									<td>Wartość świadczeń RB28-S</td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/RB28-S/Kw1, '0,00', 'pln')"/></td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/RB28-S/Kw2, '0,00', 'pln')"/></td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/RB28-S/Kw3, '0,00', 'pln')"/></td>
									<td class="text-right"><xsl:value-of select="format-number(Wartosc_Swiadczen/RB28-S/Kw4, '0,00', 'pln')"/></td>
								</tr>
								<tr>
									<td>Procent zgodności</td>
									<td class="text-right"><xsl:value-of select="Procent_Zgodnosci/Kw1"/></td>
									<td class="text-right"><xsl:value-of select="Procent_Zgodnosci/Kw2"/></td>
									<td class="text-right"><xsl:value-of select="Procent_Zgodnosci/Kw3"/></td>
									<td class="text-right"><xsl:value-of select="Procent_Zgodnosci/Kw4"/></td>
								</tr>
							</tbody>
						</table>
					</div>
				</fieldset>
				<div>
					<button onclick="event.preventDefault(); tab('swiadczenia')">Świadczenia</button>
					<xsl:text> </xsl:text>
					<button onclick="event.preventDefault(); tab('wydatki-srodkow')">Wydatki środków</button>
					<xsl:text> </xsl:text>
					<button onclick="event.preventDefault(); tab('decyzje-odmowne')">Decyzje odmowne</button>
					<xsl:text> </xsl:text>
					<button onclick="event.preventDefault(); tab('wnioski')">Wnioski</button>
					<xsl:text> </xsl:text>
					<button onclick="event.preventDefault(); tab('sytuacje-rodzin')">Sytaucje rodzin</button>
					<xsl:text> </xsl:text>
					<button onclick="event.preventDefault(); tab('sytuacje-osob')">Sytaucje osób</button>
					<br/><br/>
					<div id="swiadczenia" class="tab-content">
						<xsl:call-template name="Swiadczenia">
							 <xsl:with-param name="dane" select="Swiadczenia"/>
						</xsl:call-template>
					</div>
					<div id="wydatki-srodkow"  class="tab-content" style="display:none;">
						<xsl:call-template name="Wydatki-srodkow">
							<xsl:with-param name="dane" select="Wydatki_Srodkow"/>
						</xsl:call-template>
					</div>
					<div id="decyzje-odmowne"  class="tab-content" style="display:none;">
						<xsl:call-template name="Decyzje-odmowne">
							<xsl:with-param name="dane" select="Decyzje_Odmowne"/>
						</xsl:call-template>
					</div>
					<div id="wnioski"  class="tab-content" style="display:none;">
						<xsl:call-template name="Wnioski">
							<xsl:with-param name="dane" select="Wnioski"/>
						</xsl:call-template>
					</div>
					<div id="sytuacje-rodzin" class="tab-content" style="display:none;">
						<xsl:call-template name="Sytuacje-rodzin">
							<xsl:with-param name="dane" select="Sytuacje_Rodzin"/>
						</xsl:call-template>
					</div>
					<div id="sytuacje-osob" class="tab-content" style="display:none;">
						<xsl:call-template name="Sytuacje-osob">
							<xsl:with-param name="dane" select="Sytuacje_Osob"/>
						</xsl:call-template>
					</div>
				</div>
				<div class="hidden-print"><xsl:text> </xsl:text></div>
				<div class="hidden-print text-right">
					<small>
						<xsl:value-of select="system-property('xsl:vendor')"/> (<xsl:value-of select="system-property('xsl:version')"/>)
					</small>
				</div>
				<div class="hidden-print"><xsl:text> </xsl:text></div>
			</form>
			</div>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="Sytuacje-osob">
		<xsl:param name="dane"/>
		<fieldset>
			<legend>Sytuacje osób</legend>
			<div class="row form-group">
				<label class="control-label col-md-2 text-right">liczba opisów</label>
				<div class="col-md-5">
					<xsl:value-of select="count($dane/Syt_Osoby)"/>
				</div>
			</div>
			<xsl:if test="count($dane/Syt_Osoby) > 0">
				<div class="row form-group">
					<label class="control-label col-md-2 text-right">wg pozycji<br/>na rynku pracy</label>
					<div class="col-md-5">
						<table class="table table-bordered table-hover">
							<tbody>
								<xsl:for-each select="$dane/Syt_Osoby">
									<xsl:sort select="Kod_Poz_Ryn_Pr" order="ascending" data-type="text"/>
									<xsl:variable name="current-grouping-key" select="Kod_Poz_Ryn_Pr"/>
									<xsl:variable name="current-group" select="key('sytuacjaOsobyWgPozycjiRynekPracy', $current-grouping-key)"/>
									<xsl:if test="not(preceding-sibling::Syt_Osoby[Kod_Poz_Ryn_Pr=$current-grouping-key])">
										<tr>
											<td class="text-left">
												<xsl:value-of select="$current-grouping-key"></xsl:value-of>
												<br/><small><xsl:value-of select="$SL_Kod_Pozycji_Rynek_Pracy[@key = $current-grouping-key]"></xsl:value-of></small>
											</td>
											<td class="text-right" style="width: 100px;">
												<xsl:value-of select="count(//Syt_Osoby[Kod_Poz_Ryn_Pr = $current-grouping-key])"></xsl:value-of>
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</div>
				<div class="row form-group">
					<label class="control-label col-md-2 text-right">wg stanu zdrowia</label>
					<div class="col-md-5">
						<table class="table table-bordered table-hover">
							<tbody>
								<xsl:for-each select="$dane/Syt_Osoby">
									<xsl:sort select="Kod_Stanu_Zdr" order="ascending" data-type="text"/>
									<xsl:variable name="current-grouping-key" select="Kod_Stanu_Zdr"/>
									<xsl:variable name="current-group" select="key('sytuacjaOsobyWgStanuZdrowia', $current-grouping-key)"/>
									<xsl:if test="not(preceding-sibling::Syt_Osoby[Kod_Stanu_Zdr=$current-grouping-key])">
										<tr>
											<td class="text-left">
												<xsl:value-of select="$current-grouping-key"></xsl:value-of>
												<br/><small><xsl:value-of select="$SL_Kod_Stanu_Zdrowia[@key = $current-grouping-key]"></xsl:value-of></small>
											</td>
											<td class="text-right" style="width: 100px;">
												<xsl:value-of select="count(//Syt_Osoby[Kod_Stanu_Zdr = $current-grouping-key])"></xsl:value-of>
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</div>
				<div class="row form-group">
					<label class="control-label col-md-2 text-right">wg niepełnosprawności</label>
					<div class="col-md-5">
						<table class="table table-bordered table-hover">
							<tbody>
								<xsl:for-each select="$dane/Syt_Osoby">
									<xsl:sort select="Czy_Niepelnosp" order="ascending" data-type="text"/>
									<xsl:variable name="current-grouping-key" select="Czy_Niepelnosp"/>
									<xsl:variable name="current-group" select="key('sytuacjaOsobyWgNiepelnosprawnosci', $current-grouping-key)"/>
									<xsl:if test="not(preceding-sibling::Syt_Osoby[Czy_Niepelnosp=$current-grouping-key])">
										<tr>
											<td class="text-left">
												<xsl:value-of select="translate($current-grouping-key, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"></xsl:value-of>
											</td>
											<td class="text-right" style="width: 100px;">
												<xsl:value-of select="count(//Syt_Osoby[Czy_Niepelnosp = $current-grouping-key])"></xsl:value-of>
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</div>
				<div class="row form-group">
					<label class="control-label col-md-2 text-right">wg stopnia niepełnosprawności</label>
					<div class="col-md-5">
						<table class="table table-bordered table-hover">
							<tbody>
								<xsl:for-each select="$dane/Syt_Osoby">
									<xsl:sort select="Kod_Orz_O_Niep" order="ascending" data-type="text"/>
									<xsl:variable name="current-grouping-key" select="Kod_Orz_O_Niep"/>
									<xsl:variable name="current-group" select="key('sytuacjaOsobyWgStoptniaNiepelnosprawnosci', $current-grouping-key)"/>
									<xsl:if test="$current-grouping-key != '' and not(preceding-sibling::Syt_Osoby[Kod_Orz_O_Niep=$current-grouping-key])">
										<tr>
											<td class="text-left">
												<xsl:value-of select="$current-grouping-key"></xsl:value-of>
												<br/><small><xsl:value-of select="$SL_Kod_Stopnia_Niepelnosprawnosci[@key = $current-grouping-key]"></xsl:value-of></small>
											</td>
											<td class="text-right" style="width: 100px;">
												<xsl:value-of select="count(//Syt_Osoby[Kod_Orz_O_Niep = $current-grouping-key])"></xsl:value-of>
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</div>
			</xsl:if>
		</fieldset>
	</xsl:template>
	<xsl:template name="Sytuacje-rodzin">
		<xsl:param name="dane"/>
		<fieldset>
			<legend>Sytuacje rodzin</legend>
			<div class="row form-group">
				<label class="control-label col-md-2 text-right">liczba opisów</label>
				<div class="col-md-5">
					<xsl:value-of select="count($dane/Syt_Rodz)"/>
				</div>
			</div>
			<xsl:if test="count($dane/Syt_Rodz) > 0">
				<div class="row form-group">
					<label class="control-label col-md-2 text-right">wg typu opisu</label>
					<div class="col-md-5">
						<table class="table table-bordered table-hover">
							<tbody>
								<xsl:for-each select="$dane/Syt_Rodz">
									<xsl:sort select="Kod_Rodz_Opisu_Syt" order="ascending" data-type="text"/>
									<xsl:variable name="current-grouping-key" select="Kod_Rodz_Opisu_Syt"/>
									<xsl:variable name="current-group" select="key('sytuacjaRodzinyWgKoduOpisu', $current-grouping-key)"/>
									<xsl:if test="not(preceding-sibling::Syt_Rodz[Kod_Rodz_Opisu_Syt=$current-grouping-key])">
										<tr>
											<td class="text-left">
												<xsl:value-of select="$current-grouping-key"></xsl:value-of>
												<br/><small><xsl:value-of select="$SL_Rodzaj_Opisu_Sytuacji[@key = $current-grouping-key]"></xsl:value-of></small>
											</td>
											<td class="text-right" style="width: 100px;">
												<xsl:value-of select="count(//Syt_Rodz[Kod_Rodz_Opisu_Syt = $current-grouping-key])"></xsl:value-of>
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</div>
				<div class="row form-group">
					<label class="control-label col-md-2 text-right">wg składu rodziny</label>
					<div class="col-md-5">
						<table class="table table-bordered table-hover">
							<tbody>
								<xsl:for-each select="$dane/Syt_Rodz">
									<xsl:sort select="Kod_Skladu" order="ascending" data-type="text"/>
									<xsl:variable name="current-grouping-key" select="Kod_Skladu"/>
									<xsl:variable name="current-group" select="key('sytuacjaRodzinyWgKoduSkladu', $current-grouping-key)"/>
									<xsl:if test="not(preceding-sibling::Syt_Rodz[Kod_Skladu=$current-grouping-key])">
										<tr>
											<td class="text-left">
												<xsl:value-of select="$current-grouping-key"></xsl:value-of>
												<br/><small><xsl:value-of select="$SL_Kod_Skladu_Rodziny[@key = $current-grouping-key]"></xsl:value-of></small>
											</td>
											<td class="text-right" style="width: 100px;">
												<xsl:value-of select="count(//Syt_Rodz[Kod_Skladu = $current-grouping-key])"></xsl:value-of>
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</div>
				<div class="row form-group">
					<label class="control-label col-md-2 text-right">wg wielkości</label>
					<div class="col-md-5">
						<table class="table table-bordered table-hover">
							<tbody>
								<xsl:for-each select="$dane/Syt_Rodz">
									<xsl:sort select="Wielkosc" order="ascending" data-type="number"/>
									<xsl:variable name="current-grouping-key" select="Wielkosc"/>
									<xsl:variable name="current-group" select="key('sytuacjaRodzinyWgWielkosci', $current-grouping-key)"/>
									<xsl:if test="not(preceding-sibling::Syt_Rodz[Wielkosc=$current-grouping-key])">
										<tr>
											<td class="text-left">
												<xsl:value-of select="$current-grouping-key"></xsl:value-of>
											</td>
											<td class="text-right" style="width: 100px;">
												<xsl:value-of select="count(//Syt_Rodz[Wielkosc = $current-grouping-key])"></xsl:value-of>
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</div>
			</xsl:if>
		</fieldset>
	</xsl:template>
	<xsl:template name="Wnioski">
		<xsl:param name="dane"/>
		<fieldset>
			<legend>Wnioski</legend>
			<div class="row form-group">
				<label class="control-label col-md-2 text-right">liczba wniosków</label>
				<div class="col-md-5">
					<xsl:value-of select="count($dane/Wniosek)"/>
				</div>
			</div>
			<xsl:if test="count($dane/Wniosek) > 0">
				<div class="row form-group">
					<label class="control-label col-md-2 text-right">wg typu</label>
					<div class="col-md-5">
						<table class="table table-bordered table-hover">
							<tbody>
								<xsl:for-each select="$dane/Wniosek">
									<xsl:sort select="Kod_Typu" order="ascending" data-type="number"/>
									<xsl:variable name="current-grouping-key" select="Kod_Typu"/>
									<xsl:variable name="current-group" select="key('wniosekWgTypu', $current-grouping-key)"/>
									<xsl:if test="not(preceding-sibling::Wniosek[Kod_Typu=$current-grouping-key])">
										<tr>
											<td class="text-left">
												<xsl:value-of select="$current-grouping-key"></xsl:value-of>
												<br/><small><xsl:value-of select="$SL_Kod_Typu_Wniosku[@key = $current-grouping-key]"></xsl:value-of></small>
											</td>
											<td class="text-right" style="width: 100px;">
												<xsl:value-of select="count(//Wniosek[Kod_Typu=$current-grouping-key])"></xsl:value-of>
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</div>
				<div class="row form-group">
					<label class="control-label col-md-2 text-right">wg rodzaju wnioskodawcy</label>
					<div class="col-md-5">
						<table class="table table-bordered table-hover">
							<tbody>
								<xsl:for-each select="$dane/Wniosek">
									<xsl:sort select="Kod_Rodz_Wnioskod" order="ascending" data-type="number"/>
									<xsl:variable name="current-grouping-key" select="Kod_Rodz_Wnioskod"/>
									<xsl:variable name="current-group" select="key('wniosekWgRodzajuWnioskodawcy', $current-grouping-key)"/>
									<xsl:if test="not(preceding-sibling::Wniosek[Kod_Rodz_Wnioskod=$current-grouping-key])">
										<tr>
											<td class="text-left">
												<xsl:value-of select="$current-grouping-key"></xsl:value-of>
												<br/><small><xsl:value-of select="$SL_Kod_Rodzaju_Wnioskodawcy[@key = $current-grouping-key]"></xsl:value-of></small>
											</td>
											<td class="text-right" style="width: 100px;">
												<xsl:value-of select="count(//Wniosek[Kod_Rodz_Wnioskod=$current-grouping-key])"></xsl:value-of>
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</div>
				<div class="row form-group">
					<label class="control-label col-md-2 text-right">wg daty wpływu</label>
					<div class="col-md-5">
						<table class="table table-bordered table-hover">
							<tbody>
								<xsl:for-each select="$dane/Wniosek">
									<xsl:sort select="concat(substring(Data_Wplyn, 1, 4), substring(Data_Wplyn, 6, 2), substring(Data_Wplyn, 9, 2))" order="ascending" data-type="number"/>
									<xsl:variable name="current-grouping-key" select="concat(substring(Data_Wplyn, 1, 4), substring(Data_Wplyn, 6, 2), substring(Data_Wplyn, 9, 2))"/>
									<xsl:variable name="current-group" select="key('wniosekWgDatyWplyniecia', $current-grouping-key)"/>
									<xsl:variable name="Data_Wplyn" select="Data_Wplyn"/>
									<xsl:if test="not(preceding-sibling::Wniosek[Data_Wplyn=$Data_Wplyn])">
										<tr>
											<td class="text-left"><xsl:value-of select="Data_Wplyn"></xsl:value-of></td>
											<td class="text-right" style="width: 100px;">
												<xsl:value-of select="count(//Wniosek[Data_Wplyn=$Data_Wplyn])"></xsl:value-of>
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</div>
			</xsl:if>
		</fieldset>
	</xsl:template>
	<xsl:template name="Decyzje-odmowne">
		<xsl:param name="dane"/>
		<fieldset>
			<legend>Decyzje odmowne</legend>
			<div class="row form-group">
				<label class="control-label col-md-2 text-right">liczba decyzji</label>
				<div class="col-md-5">
					<xsl:value-of select="count($dane/Dec_Odmowna)"/>
				</div>
			</div>
			<xsl:if test="count($dane/Dec_Odmowna) > 0">
				<div class="row form-group">
					<label class="control-label col-md-2 text-right">wg daty wpływu</label>
					<div class="col-md-5">
						<table class="table table-bordered table-hover">
							<tbody>
								<xsl:for-each select="$dane/Dec_Odmowna">
									<xsl:sort select="concat(substring(Data_Podjecia, 1, 4), substring(Data_Podjecia, 6, 2), substring(Data_Podjecia, 9, 2))" order="ascending" data-type="number"/>
									<xsl:variable name="current-grouping-key" select="concat(substring(Data_Podjecia, 1, 4), substring(Data_Podjecia, 6, 2), substring(Data_Podjecia, 9, 2))"/>
									<xsl:variable name="current-group" select="key('decOdmowneSwiadczeniaWgDaty', $current-grouping-key)"/>
									<xsl:variable name="Data_Podjecia" select="Data_Podjecia"/>
									<xsl:if test="not(preceding-sibling::Dec_Odmowna[Data_Podjecia=$Data_Podjecia])">
										<tr>
											<td class="text-left"><xsl:value-of select="Data_Podjecia"></xsl:value-of></td>
											<td class="text-right" style="width: 100px;">
												<xsl:value-of select="count(//Dec_Odmowna[Data_Podjecia = $Data_Podjecia])"></xsl:value-of>
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</tbody>
						</table>
					</div>
				</div>
			</xsl:if>
		</fieldset>
	</xsl:template>
	<xsl:template name="Wydatki-srodkow">
		<xsl:param name="dane"/>
		<fieldset>
			<legend>Wydatki środków</legend>
			<div class="row form-group">
				<label class="control-label col-md-2 text-right">liczba wydatków</label>
				<div class="col-md-5">
					<xsl:value-of select="count($dane/Wyd_Srodkow)"/>
				</div>
			</div>
			<xsl:if test="count($dane/Wyd_Srodkow) > 0">
				<table class="table table-bordered table-hover" style="width: 100%;">
					<thead>
						<tr>
							<th rowspan="2">Rodzaj</th>
							<th colspan="2">Miesiąc 1</th>
							<th colspan="2">Miesiąc 2</th>
							<th colspan="2">Miesiąc 3</th>
						</tr>
						<tr>
							<th>Liczba</th>
							<th>Kwota</th>
							<th>Liczba</th>
							<th>Kwota</th>
							<th>Liczba</th>
							<th>Kwota</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td colspan="7" class="text-left">wg kodu:</td>
							<xsl:for-each select="$dane/Wyd_Srodkow">
								<xsl:sort select="Kod_Swiad" order="ascending" data-type="text"/>
								<xsl:variable name="current-key" select="Kod_Swiad"/>
								<tr>
									<td class="text-left">
										<xsl:value-of select="$current-key"></xsl:value-of>
										<br/><small><xsl:value-of select="$SL_Kod_Rodzaju_Swiadczenia[@key = $current-key]" /></small>
									</td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Wyd_Srodkow[Kod_Swiad = $current-key]/Liczba/Mies_1), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Wyd_Srodkow[Kod_Swiad = $current-key]/Wartosc/Mies_1), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Wyd_Srodkow[Kod_Swiad = $current-key]/Liczba/Mies_2), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Wyd_Srodkow[Kod_Swiad = $current-key]/Wartosc/Mies_2), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Wyd_Srodkow[Kod_Swiad = $current-key]/Liczba/Mies_3), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Wyd_Srodkow[Kod_Swiad = $current-key]/Wartosc/Mies_3), '0,00', 'pln')"></xsl:value-of></td>
								</tr>
							</xsl:for-each>
						</tr>
					</tbody>
					<tfoot>
						<tr>
							<td colspan="7" class="text-left">razem:</td>
						</tr>
						<tr>
							<td class="text-left">---</td>
							<td class="text-right"><xsl:value-of select="format-number(sum(//Wyd_Srodkow/Liczba/Mies_1), '0,00', 'pln')"></xsl:value-of></td>
							<td class="text-right"><xsl:value-of select="format-number(sum(//Wyd_Srodkow/Wartosc/Mies_1), '0,00', 'pln')"></xsl:value-of></td>
							<td class="text-right"><xsl:value-of select="format-number(sum(//Wyd_Srodkow/Liczba/Mies_2), '0,00', 'pln')"></xsl:value-of></td>
							<td class="text-right"><xsl:value-of select="format-number(sum(//Wyd_Srodkow/Wartosc/Mies_2), '0,00', 'pln')"></xsl:value-of></td>
							<td class="text-right"><xsl:value-of select="format-number(sum(//Wyd_Srodkow/Liczba/Mies_3), '0,00', 'pln')"></xsl:value-of></td>
							<td class="text-right"><xsl:value-of select="format-number(sum(//Wyd_Srodkow/Wartosc/Mies_3), '0,00', 'pln')"></xsl:value-of></td>
						</tr>
					</tfoot>
				</table>
			</xsl:if>
		</fieldset>
	</xsl:template>
	<xsl:template name="Swiadczenia">
		<xsl:param name="dane"/>
		<fieldset>
			<legend>Świadczenia</legend>
			<div class="row form-group">
				<label class="control-label col-md-2 text-right">liczba świadczeń</label>
				<div class="col-md-5">
					<xsl:value-of select="count($dane/Swiadczenie)"/>
				</div>
			</div>
			<xsl:if test="count($dane/Swiadczenie) > 0">
				<table class="table table-bordered table-hover" style="width: 100%;">
					<thead>
						<tr>
							<th rowspan="2">Rodzaj</th>
							<th colspan="2">Miesiąc 1</th>
							<th colspan="2">Miesiąc 2</th>
							<th colspan="2">Miesiąc 3</th>
						</tr>
						<tr>
							<th>Liczba</th>
							<th>Kwota</th>
							<th>Liczba</th>
							<th>Kwota</th>
							<th>Liczba</th>
							<th>Kwota</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td colspan="7" class="text-left">wg kodu:</td>
						</tr>
						<xsl:for-each select="$dane/Swiadczenie">
							<xsl:sort select="Kod_Swiad" order="ascending" data-type="text"/>
							<xsl:variable name="current-grouping-key" select="Kod_Swiad"/>
							<xsl:variable name="current-group" select="key('swiadczeniaWgKodu', $current-grouping-key)"/>
							<xsl:if test="not(preceding-sibling::Swiadczenie[Kod_Swiad=$current-grouping-key])">
								<tr>
									<td class="text-left">
										<xsl:value-of select="$current-grouping-key"></xsl:value-of>
										<br/><small><xsl:value-of select="$SL_Kod_Rodzaju_Swiadczenia[@key = $current-grouping-key]" /></small>
									</td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie[Kod_Swiad = $current-grouping-key]/Liczba/Mies_1), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie[Kod_Swiad = $current-grouping-key]/Wartosc/Mies_1), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie[Kod_Swiad = $current-grouping-key]/Liczba/Mies_2), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie[Kod_Swiad = $current-grouping-key]/Wartosc/Mies_2), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie[Kod_Swiad = $current-grouping-key]/Liczba/Mies_3), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie[Kod_Swiad = $current-grouping-key]/Wartosc/Mies_3), '0,00', 'pln')"></xsl:value-of></td>
								</tr>
							</xsl:if>
						</xsl:for-each>
					</tbody>
					<tfoot>
						<tr>
							<td colspan="7" class="text-left">wg grup:</td>
						</tr>
						<xsl:for-each select="$dane/Swiadczenie">
							<xsl:sort select="substring(Kod_Swiad, 1, 1)" order="ascending" data-type="number"/>
							<xsl:variable name="current-grouping-key" select="substring(Kod_Swiad, 1, 1)"/>
							<xsl:variable name="current-group" select="key('swiadczeniaWgSrodkow', $current-grouping-key)"/>
							<xsl:if test="not(preceding-sibling::Swiadczenie[substring(Kod_Swiad, 1, 1)=$current-grouping-key])">
								<tr>
									<td class="text-left">
										<xsl:value-of select="$current-grouping-key"></xsl:value-of>
										<br/><small><xsl:value-of select="$SL_Grup_Kodow_Rodzaju_Swiadczenia[@key = $current-grouping-key]" /></small>
									</td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie[substring(Kod_Swiad, 1, 1) = $current-grouping-key]/Liczba/Mies_1), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie[substring(Kod_Swiad, 1, 1) = $current-grouping-key]/Wartosc/Mies_1), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie[substring(Kod_Swiad, 1, 1) = $current-grouping-key]/Liczba/Mies_2), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie[substring(Kod_Swiad, 1, 1) = $current-grouping-key]/Wartosc/Mies_2), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie[substring(Kod_Swiad, 1, 1) = $current-grouping-key]/Liczba/Mies_3), '0,00', 'pln')"></xsl:value-of></td>
									<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie[substring(Kod_Swiad, 1, 1) = $current-grouping-key]/Wartosc/Mies_3), '0,00', 'pln')"></xsl:value-of></td>
								</tr>
							</xsl:if>
						</xsl:for-each>
						<tr>
							<td colspan="7" class="text-left">razem:</td>
						</tr>
						<tr>
							<td class="text-left">---</td>
							<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie/Liczba/Mies_1), '0,00', 'pln')"></xsl:value-of></td>
							<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie/Wartosc/Mies_1), '0,00', 'pln')"></xsl:value-of></td>
							<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie/Liczba/Mies_2), '0,00', 'pln')"></xsl:value-of></td>
							<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie/Wartosc/Mies_2), '0,00', 'pln')"></xsl:value-of></td>
							<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie/Liczba/Mies_3), '0,00', 'pln')"></xsl:value-of></td>
							<td class="text-right"><xsl:value-of select="format-number(sum(//Swiadczenie/Wartosc/Mies_3), '0,00', 'pln')"></xsl:value-of></td>
						</tr>
					</tfoot>
				</table>
			</xsl:if>
		</fieldset>
	</xsl:template>
</xsl:stylesheet>
