package pl.gov.mpips.zbc.v20090722;

import java.time.LocalDate;

import org.threeten.extra.YearQuarter;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W20aValidator2 implements ComplexValidator<SwiadczenieSprawozdawcze, ZbiorCentralny> {
	@Override
	public void validate(SwiadczenieSprawozdawcze target, ZbiorCentralny context, BasicErrors errors) {
		SytuacjaRodziny sytuacjaRodziny = target.getSytuacjaRodziny();
		if (sytuacjaRodziny == null) return;
		LocalDate dataOpisuSytuacji = sytuacjaRodziny.getDataOpisuSytuacji();
		if (dataOpisuSytuacji == null) return;
		YearQuarter okresSprawozdawczy = context.getOkres();
		if (okresSprawozdawczy == null) return;
		//
		if (dataOpisuSytuacji.isAfter(okresSprawozdawczy.atEndOfQuarter())) {
			errors.rejectValue("sytuacjaRodziny.dataOpisuSytuacji", "W20a", "Data opisu sytuacji nie może być późniejsza niż ostatni dzień kwartału za który przesyłamy dane w zbiorze centralnym");
		}
	}
}
