package pl.gov.mpips.zbc.v20200306;

import java.util.List;
import java.util.Objects;

import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze.CzlonekRodziny;
import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze.Problemy;
import pl.gov.mpips.zbc.v20200306.narzedzia.Listy;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W11Validator implements ComplexValidator<Problemy, SwiadczenieSprawozdawcze> {
	@Override
	public void validate(Problemy target, SwiadczenieSprawozdawcze context, BasicErrors errors) {
		List<String> kody = Listy.kody(target);
		for (int i = 0; i < kody.size(); i++) {
			if (kodProblemuWskazujeNaBezrobocie(kody.get(i)) && !sytuacjaWskazujeNaBezrobocie(context)) {
				errors.rejectValue("kod" + (i + 1), "W11", "Wskazano problem bezrobocia mimo braku w składzie rodziny osób bezrobotnych lub biernych zawodowo");
			}
		}
	}
	
	private boolean sytuacjaWskazujeNaBezrobocie(SwiadczenieSprawozdawcze context) {
		List<CzlonekRodziny> czlonkowieRodziny = context.getCzlonkowieRodziny();
		return czlonkowieRodziny != null && czlonkowieRodziny.stream()
			.filter(Objects::nonNull)
			.map(CzlonekRodziny::getSytuacjaOsoby)
			.filter(Objects::nonNull)
			.map(SytuacjaOsoby::getKodPozycjiNaRynkuPracy)
			.filter(Objects::nonNull)
			.anyMatch(this::kodSytuacjiWskazujeNaBezrobocie);
	}
	
	private boolean kodSytuacjiWskazujeNaBezrobocie(String kod) {
		return Objects.equals(kod, "2")  // bezrobotny
			|| Objects.equals(kod, "3"); // bierny zawodowo
	}
	
	private boolean kodProblemuWskazujeNaBezrobocie(String kod) {
		return Objects.equals(kod, "050"); // bezrobocie
	}
}
