package pl.gov.mpips.zbc.v20200306;

import java.time.LocalDate;

import org.threeten.extra.YearQuarter;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSortedMap;

import pl.topteam.common.collect.ExtraMaps;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W23Validator implements SimpleValidator<ZbiorCentralny> {
	private static final ImmutableRangeMap<LocalDate, Integer> DYSTRYBUCJE_SLOWNIKOW = ExtraMaps.toImmutableRangeMap(ImmutableSortedMap.<LocalDate, Integer>naturalOrder()
		.put(LocalDate.parse("2016-10-03"), 63)
		.put(LocalDate.parse("2018-09-24"), 64)
		.put(LocalDate.parse("2018-11-14"), 65)
		.put(LocalDate.parse("2019-01-08"), 66)
		.put(LocalDate.parse("2019-05-08"), 67)
		.put(LocalDate.parse("2020-05-12"), 68)
		.put(LocalDate.parse("2021-05-11"), 69)
		.put(LocalDate.parse("2021-12-15"), 70)
		.put(LocalDate.parse("2022-01-11"), 71)
		.put(LocalDate.parse("2022-03-14"), 72)
		.put(LocalDate.parse("2022-04-06"), 73)
		.put(LocalDate.parse("2022-12-21"), 74)
		.put(LocalDate.parse("2023-01-04"), 75)
		.put(LocalDate.parse("2023-03-31"), 76)
		.put(LocalDate.parse("2023-11-13"), 77)
		// .put(LocalDate.parse("2023-12-28"), 78)
		.put(LocalDate.parse("2023-12-28"), 79)
		.put(LocalDate.parse("2023-12-29"), 80)
		.build()
	);

	@Override
	public void validate(ZbiorCentralny target, BasicErrors errors) {
		YearQuarter okres = target.getOkres();
		if (okres == null) return;
		Integer numerZestawuSlownikow = target.getNumerZestawuSlownikow();
		if (numerZestawuSlownikow == null) return;
		Integer dystrybucjaSlownikow = DYSTRYBUCJE_SLOWNIKOW.get(okres.atDay(1).minusDays(1));
		if (dystrybucjaSlownikow == null) return;
		if (numerZestawuSlownikow < dystrybucjaSlownikow) {
			errors.rejectValue("numerZestawuSlownikow", "W23", ""
				+ "Numer zestawu słowników nie może być niższy "
				+ "niż numer ostatniego zestawu wydystrybuowanego "
				+ "przed pierwszym dniem okresu za który przesyłany jest zbiór"
			);
		}
	}
}
