package pl.gov.mpips.zbc.v20200306;

import java.time.LocalDate;

import com.google.common.collect.ImmutableSet;

import pl.topteam.common.temporal.ExtraChronoUnit;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W36Validator implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
	private static final ImmutableSet<String> WYKSZTALCENIE_WYZSZE = ImmutableSet.of(
		"10", "15"
	);
	
	@Override
	public void validate(SytuacjaOsoby target, SytuacjaRodziny context, BasicErrors errors) {
		if (zaWczesnieNaStudia(target, context) && wyksztalcenieWyzsze(target)) {
			errors.rejectValue("kodRodzajuWyksztalcenia", "W36", "U osób młodszych niż 18 lat nie można wskazać wykształcenia wyższego");
		}
	}
	
	private boolean zaWczesnieNaStudia(SytuacjaOsoby target, SytuacjaRodziny context) {
		LocalDate dataUrodzenia = target.getDataUrodzenia();
		if (dataUrodzenia == null) return false;
		LocalDate dataOpisuSytuacji = context.getDataOpisuSytuacji();
		if (dataOpisuSytuacji == null) return false;
		//
		return ExtraChronoUnit.LEGAL_YEARS.between(dataUrodzenia, dataOpisuSytuacji) < 18;
	}
	
	private boolean wyksztalcenieWyzsze(SytuacjaOsoby sytuacjaOsoby) {
		String kodRodzajuWyksztalcenia = sytuacjaOsoby.getKodRodzajuWyksztalcenia();
		return WYKSZTALCENIE_WYZSZE.contains(kodRodzajuWyksztalcenia);
	}
}
