package pl.topteam.pomost.integracja.zbc.v20200306.adaptery;

import java.time.Year;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.threeten.extra.YearQuarter;

import pl.gov.mpips.zbc.v20200306.ZbiorCentralny.ZaOkres;

public final class ZaOkresAdapter extends XmlAdapter<ZaOkres, YearQuarter> {
	@Override
	public YearQuarter unmarshal(ZaOkres v) throws Exception {
		if (v != null) {
			return YearQuarter.of(
				v.getRok().getValue(),
				v.getKwartal()
			);
		}
		return null;
	}

	@Override
	public ZaOkres marshal(YearQuarter v) throws Exception {
		if (v != null) {
			ZaOkres okres = new ZaOkres();
			okres.setRok(Year.of(v.getYear()));
			okres.setKwartal(v.getQuarter());
			return okres;
		}
		return null;
	}
}
