/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20090722;

import com.google.common.collect.ImmutableSet;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import pl.gov.mpips.zbc.v20090722.SytuacjaOsoby;
import pl.gov.mpips.zbc.v20090722.SytuacjaRodziny;
import pl.topteam.common.temporal.ExtraChronoUnit;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W17Validator
implements ComplexValidator<SytuacjaOsoby, SytuacjaRodziny> {
    @Override
    public void validate(SytuacjaOsoby sytuacjaOsoby, SytuacjaRodziny context, BasicErrors errors) {
        if (this.zaWczesnieNaSlub(sytuacjaOsoby, context) && !this.kawalerLubPanna(sytuacjaOsoby)) {
            errors.rejectValue("kodStanuCywilnego", "W17", "U os\u00f3b m\u0142odszych ni\u017c 16 lat dozwolonymi warto\u015bciami s\u0105 kawaler i panna");
        }
    }

    private boolean zaWczesnieNaSlub(SytuacjaOsoby target, SytuacjaRodziny context) {
        LocalDate dataUrodzenia = target.getDataUrodzenia();
        if (dataUrodzenia == null) {
            return false;
        }
        LocalDate dataOpisuSytuacji = context.getDataOpisuSytuacji();
        if (dataOpisuSytuacji == null) {
            return false;
        }
        return ExtraChronoUnit.LEGAL_YEARS.between((Temporal)dataUrodzenia, (Temporal)dataOpisuSytuacji) < 16L;
    }

    private boolean kawalerLubPanna(SytuacjaOsoby sytuacjaOsoby) {
        String kodStanuCywilnego = sytuacjaOsoby.getKodStanuCywilnego();
        return ImmutableSet.of((Object)"01", (Object)"02").contains((Object)kodStanuCywilnego);
    }
}

