/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20200306;

import com.google.common.collect.ImmutableSet;
import java.time.LocalDate;
import java.time.Period;
import java.time.YearMonth;
import java.util.Collections;
import java.util.List;
import pl.gov.mpips.zbc.Kody;
import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze;
import pl.gov.mpips.zbc.v20200306.SytuacjaRodziny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W20aValidator1
implements ComplexValidator<SytuacjaRodziny, SwiadczenieSprawozdawcze> {
    private static final ImmutableSet<String> WYLACZONE = ImmutableSet.of((Object)"111000", (Object)"115000", (Object)"118000", (Object)"140", (Object)"206000", (Object)"207", (Object[])new String[]{"208", "209x", "214", "214x", "214y", "217000", "320", "408", "409x", "4302", "202040", "202050", "202060", "202061", "190051"});

    @Override
    public void validate(SytuacjaRodziny target, SwiadczenieSprawozdawcze context, BasicErrors errors) {
        Period okresWaznosciOpisuSytuacjiRodziny;
        LocalDate dataOpisuSytuacji = target.getDataOpisuSytuacji();
        if (dataOpisuSytuacji == null) {
            return;
        }
        String kodSwiadczenia = context.getKodSwiadczenia();
        if (kodSwiadczenia == null) {
            return;
        }
        List<YearMonth> przyslugujeZa = context.getPrzyslugujeZa();
        if (przyslugujeZa == null) {
            return;
        }
        List<SwiadczenieSprawozdawcze.CzlonekRodziny> czlonkowieRodziny = context.getCzlonkowieRodziny();
        if (czlonkowieRodziny == null) {
            return;
        }
        if (Kody.prefiksy(kodSwiadczenia).anyMatch(arg_0 -> WYLACZONE.contains(arg_0))) {
            return;
        }
        if (przyslugujeZa.isEmpty()) {
            return;
        }
        YearMonth ostatniMiesiac = Collections.max(przyslugujeZa);
        boolean wszyscySwiadczeniobiorcyPrzebywajaWDPS = czlonkowieRodziny.stream().filter(czlonekRodziny -> Boolean.TRUE.equals(czlonekRodziny.getCzySwiadczeniobiorca())).allMatch(czlonekRodziny -> Boolean.TRUE.equals(czlonekRodziny.getCzyPobytDPS()));
        Period period = okresWaznosciOpisuSytuacjiRodziny = wszyscySwiadczeniobiorcyPrzebywajaWDPS ? Period.ofYears(1) : Period.ofMonths(6);
        if (dataOpisuSytuacji.isBefore(ostatniMiesiac.atDay(1).minus(okresWaznosciOpisuSytuacjiRodziny))) {
            errors.rejectValue("dataOpisuSytuacji", "W20a", "Data opisu sytuacji nie mo\u017ce by\u0107 wcze\u015bniejsza ni\u017c data wcze\u015bniejsza o jeden rok (dla os\u00f3b przebywaj\u0105cych w domu pomocy spo\u0142ecznej) lub o p\u00f3\u0142 roku (dla pozosta\u0142ych os\u00f3b) od pierwszego dnia najp\u00f3\u017aniejszego miesi\u0105ca, za kt\u00f3ry przys\u0142uguje \u015bwiadczenie");
        }
    }
}

